# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': '.'}

packages = \
['frozndict']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'frozndict',
    'version': '1.0.1',
    'description': 'frozndict is a memory efficient immutable dictionary.',
    'long_description': '=========\nfrozndict\n=========\n\n.. image:: https://coveralls.io/repos/z4r/python-coveralls/badge.png?branch=master?style=for-the-badge&logoColor=blue&color=black\n   :target: https://coveralls.io/r/Harmouch101/frozndict\n   :align: left\n   :alt: Coverage Report\n\n.. image:: https://img.shields.io/github/license/Harmouch101/frozndict?style=for-the-badge&logoColor=blue&color=black\n   :target: https://github.com/Harmouch101/frozndict/blob/main/LICENSE\n   :align: left\n   :alt: License\n\n.. image:: https://img.shields.io/pypi/v/frozndict.svg?style=for-the-badge&logoColor=blue&color=black\n   :target: https://pypi.org/project/frozndict/\n   :align: left\n   :alt: pypi version\n\n.. image:: https://results.pre-commit.ci/badge/github/Harmouch101/frozndict/main.svg\n   :target: https://results.pre-commit.ci/latest/github/Harmouch101/frozndict/main\n   :align: left\n   :alt: pre-commit ci status\n\n.. image:: https://circleci.com/gh/Harmouch101/frozndict.svg?style=shield\n   :target: https://circleci.com/gh/Harmouch101/frozndict\n   :alt: Circle ci Build Status\n\n.. image:: https://img.shields.io/github/repo-size/Harmouch101/frozndict?style=for-the-badge&logoColor=blue&color=black\n   :target: https://github.com/Harmouch101/frozndict/\n   :align: left\n   :alt: Repo Size\n\n.. image:: ./assets/pydoc.png\n   :target: https://github.com/Harmouch101/frozndict/\n   :alt: Banner\n\n**frozndict** is a python package that acts as an alternative to frozenset, but for dictionaries.\n\n🛠️ Requirements\n---------------\n\n**frozndict** requires Python 3.9 or above.\n\nTo install Python 3.9, I recommend using `pyenv`_.\n\n.. code-block:: bash\n\n   # install pyenv\n   git clone https://github.com/pyenv/pyenv ~/.pyenv\n\n   # setup pyenv (you should also put these three lines in .bashrc or similar)\n   # if you are using zsh\n   cat << EOF >> ~/.zshrc\n   # pyenv config\n   export PATH="${HOME}/.pyenv/bin:${PATH}"\n   export PYENV_ROOT="${HOME}/.pyenv"\n   eval "$(pyenv init -)"\n   EOF\n\n   # or if you using the default bash shell, do this instead:\n   cat << EOF >> ~/.bashrc\n   # pyenv config\n   export PATH="${HOME}/.pyenv/bin:${PATH}"\n   export PYENV_ROOT="${HOME}/.pyenv"\n   eval "$(pyenv init -)"\n   EOF\n   # Close and open a new shell session\n   # install Python 3.9.10\n   pyenv install 3.9.10\n\n   # make it available globally\n   pyenv global system 3.9.10\n\n\nTo manage the Python 3.9 virtualenv, I recommend using `poetry`_.\n\n.. code-block:: bash\n\n   # install poetry\n   curl -sSL https://install.python-poetry.org | python3 -\n   poetry --version\n   Poetry version 1.1.13\n\n   # Having the python executable in your PATH, you can use it:\n   poetry env use 3.9.10\n\n   # However, you are most likely to get the following issue:\n   Creating virtualenv frozndict-dxc671ba-py3.9 in ~/.cache/pypoetry/virtualenvs\n\n   ModuleNotFoundError\n\n   No module named \'virtualenv.seed.via_app_data\'\n\n   at <frozen importlib._bootstrap>:973 in _find_and_load_unlocked\n\n   # To resolve it, you need to reinstall virtualenv through pip\n   sudo apt remove --purge python3-virtualenv virtualenv\n   python3 -m pip install -U virtualenv\n\n   # Now, you can just use the minor Python version in this case:\n   poetry env use 3.9.10\n   Using virtualenv: ~/.cache/pypoetry/virtualenvs/frozndict-dxc671ba-py3.9\n\n\n🚨 Installation\n---------------\n\nWith :code:`pip`:\n\n.. code-block:: console\n\n   python3.9 -m pip install frozndict\n\nWith `pipx`_:\n\n.. code-block:: console\n\n   python3.9 -m pip install --user pipx\n   pipx install --python python3.9 frozndict\n\n🚸 Usage\n--------\n\n.. code-block:: python3\n\n   >>> from frozndict import frozendict\n\n   # Empty immutable immutable dictionary.\n   >>> frozen_dict = frozendict({})\n   frozendict({})\n\n   # Non empty immutable immutable dictionary.\n   >>> frozen_dict = frozendict({"Greetings": "Hello World!"})\n   >>> frozen_dict\n   frozendict({\'Greetings\': \'Hello World!\'})\n\n   # Get an item.\n   >>> frozen_dict["Greetings"]\n   \'Hello World!\'\n\n   # Copy a dictionary.\n   >>> frozen_dict_copy = frozen_dict.copy()\n   >>> frozen_dict_copy\n   {\'Greetings\': \'Hello World!\'}\n\n   # Nested dictionary.\n   >>> frozen_dict_copy = frozendict({\'x\': 3, \'y\': 4, \'z\': {\'a\': 0, \'b\': [3,1,{4,1},[5,9]]}}, c= 1)\n   >>> print(a.pretty_repr())\n   frozendict({\n       x: 3,\n       y: 4,\n       z: {\n           a: 0,\n           b: [3, 1, {1, 4}, [5, 9]],\n       },\n       c: 1,\n   })\n\n   # Create an immutable dictionary using `fromkeys` method.\n   >>> frozen_dict = frozendict.fromkeys(["x", "y"], "5")\n   >>> frozen_dict\n   frozendict({\'x\': \'5\', \'y\': \'5\'})\n\n   # Test uniqueness: frozendict(a=1,b=2) == frozendict(b=2,a=1)\n   >>> set([frozendict(a=1,b=2), frozendict(a=5), frozendict(b=2,a=1)])\n   {frozendict({\'a\': 5}), frozendict({\'a\': 1, \'b\': 2})}\n\n\n🚀 Similar Projects Comparaison\n-------------------------------\n\nThis project is similar to `frozendict`_ created by `Marco Sulla`_.\n\n.. code-block:: python3\n\n   >>> from frozndict import frozendict as myfrozendict\n   >>> from frozendict import frozendict\n\n   # create instances\n   >>> my_frozen_dict = myfrozendict({\'x\': 3, \'y\': 4, \'z\': {\'a\': 0, \'b\': [3,1,{4,1},[5,9]]}}, c= 1)\n   >>> frozen_dict = frozendict({\'x\': 3, \'y\': 4, \'z\': {\'a\': 0, \'b\': [3,1,{4,1},[5,9]]}}, c= 1)\n   >>> dict = dict({\'x\': 3, \'y\': 4, \'z\': {\'a\': 0, \'b\': [3,1,{4,1},[5,9]]}}, c= 1)\n\n   # comparaison\n   >>> import sys\n   >>> tuple(map(sys.getsizeof, [frozen_dict, my_frozen_dict, dict]))\n   (248, 240, 232)\n\nNotice :code:`my_frozen_dict` takes less space in memory than :code:`frozen_dict`!\n\n🎉 Credits\n----------\n\nThese following projects were used to build and test :code:`frozndict`.\n\n- `python`_\n- `poetry`_\n- `pytest`_\n- `flake8`_\n- `coverage`_\n- `rstcheck`_\n- `mypy`_\n- `pytestcov`_\n- `tox`_\n- `isort`_\n- `black`_\n- `precommit`_\n\n👋 Contribute\n-------------\n\nIf you are looking for a way to contribute to the project, please refer to the `Guideline`_.\n\n📝 License\n----------\n\nThis program and the accompanying materials are made available under the terms and conditions of the `GNU GENERAL PUBLIC LICENSE`_.\n\n.. _GNU GENERAL PUBLIC LICENSE: http://www.gnu.org/licenses/\n.. _frozendict: https://pypi.org/project/frozendict/\n.. _Marco Sulla: https://github.com/Marco-Sulla\n.. _Guideline: https://github.com/Harmouch101/frozndict/blob/main/CONTRIBUTING.rst\n.. _pyenv: https://github.com/pyenv/pyenv\n.. _poetry: https://github.com/python-poetry/poetry\n.. _pipx: https://github.com/pypa/pipx\n.. _python: https://www.python.org/\n.. _pytest: https://docs.pytest.org/en/7.1.x/\n.. _flake8: https://flake8.pycqa.org/en/latest/\n.. _coverage: https://coverage.readthedocs.io/en/6.3.2/\n.. _rstcheck: https://pypi.org/project/rstcheck/\n.. _mypy: https://mypy.readthedocs.io/en/stable/\n.. _pytestcov: https://pytest-cov.readthedocs.io/en/latest/\n.. _tox: https://tox.wiki/en/latest/\n.. _isort: https://github.com/PyCQA/isort\n.. _black: https://black.readthedocs.io/en/stable/\n.. _precommit: https://pre-commit.com/\n',
    'author': 'Mahmoud Harmouch',
    'author_email': 'eng.mahmoudharmouch@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Harmouch101/frozndict',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
