testTxn = {'blockTime': 1720130281, 'meta': {'computeUnitsConsumed': 189542, 'err': None, 'fee': 5001, 'innerInstructions': [{'index': 4, 'instructions': [{'accounts': [0, 8], 'data': '3Bxs3zwhE1jnACsh', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [8], 'data': 'J', 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [0, 7], 'data': '3Bxs3zsXjYXEcY9D', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [7], 'data': '9krTDTC9CyNDTCP9', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [7], 'data': 'SYXsG5gxn13RGVJBuJ66WMvnpkuC3ZXmxCAkmzi1nLhi459e', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [0, 4], 'data': '3Bxs4GxuFmUxu9wu', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [4], 'data': '9krTDE99A3SWNSHd', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [4], 'data': 'SYXsBSQy3GeifSEQSGvTbrPNposbSAiSoh1YA85wcvGKSnYg', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [4, 20], 'data': '19ChVPoZnqqoMPN3PmbNvaGxSxJvxxadnNs9AVtwBNspWSj', 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [0, 5], 'data': '3Bxs4h24hBtQy9rw', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [5], 'data': '9krTDU2LzCSUJuVZ', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [5], 'data': 'SYXsBSQy3GeifSEQSGvTbrPNposbSAiSoh1YA85wcvGKSnYg', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [5, 17, 16, 20], 'data': 2, 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [0, 6], 'data': '3Bxs4h24hBtQy9rw', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [6], 'data': '9krTDU2LzCSUJuVZ', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [6], 'data': 'SYXsBSQy3GeifSEQSGvTbrPNposbSAiSoh1YA85wcvGKSnYg', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [6, 14, 16, 20], 'data': 2, 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [0, 2], 'data': '3Bxs3zw7D1St6MtB', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [2], 'data': '9krTDga1qCiqxLs9', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [2], 'data': 'SYXsG5gxn13RGVJBuJ66WMvnpkuC3ZXmxCAkmzi1nLhi459e', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [0, 3], 'data': '3Bxs4BdXwcxHpZ19', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [3], 'data': '9krTDSXVJqcrnRvf', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [3], 'data': 'SYXsBrTzDsq3kLD1BhH4w6jQTUs6sbwfa7yN5CyH8syhMbj3', 'programIdIndex': 12, 'stackHeight': 2}, {'accounts': [3, 16, 19, 20], 'data': '1PEpEB', 'programIdIndex': 22, 'stackHeight': 2}, {'accounts': [0, 10, 0, 4, 12, 13], 'data': 1, 'programIdIndex': 21, 'stackHeight': 2}, {'accounts': [4], 'data': '84eT', 'programIdIndex': 13, 'stackHeight': 3}, {'accounts': [0, 10], 'data': '11119os1e9qSs2u7TsThXqkBSRVFxhmYaFKFZ1waB2X7armDmvK3p5GmLdUxYdg3h7QSrL', 'programIdIndex': 12, 'stackHeight': 3}, {'accounts': [10], 'data': 'P', 'programIdIndex': 13, 'stackHeight': 3}, {'accounts': [10, 4], 'data': '6UcsSJhCs3Wuhv1AJbesjbG8L6YZo4k5NPzkxwGjXgVQ4', 'programIdIndex': 13, 'stackHeight': 3}, {'accounts': [9, 5, 0], 'data': '3DYSe7c5gcg7', 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [1, 6, 0], 'data': '3Da5xFxdTvym', 'programIdIndex': 13, 'stackHeight': 2}, {'accounts': [4, 10, 16], 'data': '6PMV4vdxAXCs', 'programIdIndex': 13, 'stackHeight': 2}]}], 'loadedAddresses': {'readonly': ['SysvarRent111111111111111111111111111111111', 'ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL', 'srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX'], 'writable': []}, 'logMessages': ['Program ComputeBudget111111111111111111111111111111 invoke [1]', 'Program ComputeBudget111111111111111111111111111111 success', 'Program ComputeBudget111111111111111111111111111111 invoke [1]', 'Program ComputeBudget111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [1]', 'Program 11111111111111111111111111111111 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [1]', 'Program log: Instruction: InitializeAccount', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 3443 of 599550 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 675kPX9MHTjS2zt1qfr1NYHuzeLXfQM9H24wFSUt1Mp8 invoke [1]', 'Program log: initialize2: InitializeInstruction2 { nonce: 254, open_time: 1720130270, init_pc_amount: 30000000000, init_coin_amount: 1000000000000000 }', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: SyncNative', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 3045 of 578728 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: InitializeMint', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 2920 of 548014 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: InitializeAccount', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 4502 of 530512 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: InitializeAccount', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 3445 of 509909 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program 11111111111111111111111111111111 invoke [2]', 'Program 11111111111111111111111111111111 success', 'Program srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX invoke [2]', 'Program srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX consumed 2319 of 485908 compute units', 'Program srmqPvymJeFKQ4zGQed1GFppgkRHL9kaELCbyksJtPX success', 'Program ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL invoke [2]', 'Program log: Create', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [3]', 'Program log: Instruction: GetAccountDataSize', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 1595 of 472045 compute units', 'Program return: TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA pQAAAAAAAAA=', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program 11111111111111111111111111111111 invoke [3]', 'Program 11111111111111111111111111111111 success', 'Program log: Initialize the associated token account', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [3]', 'Program log: Instruction: InitializeImmutableOwner', 'Program log: Please upgrade to SPL Token 2022 for immutable owner support', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 1405 of 465432 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [3]', 'Program log: Instruction: InitializeAccount3', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 4214 of 461550 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL consumed 20389 of 477442 compute units', 'Program ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: Transfer', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 4645 of 454065 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: Transfer', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 4736 of 446462 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [2]', 'Program log: Instruction: MintTo', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 4492 of 429555 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success', 'Program log: ray_log: AN4ah2YAAAAACQYQJwAAAAAAABAnAAAAAAAAAKwj/AYAAAAAgMakfo0DAKawcdH7Oxj5UHsyf2vnacxrgXLy3dohczS4N8mVKYbM', 'Program 675kPX9MHTjS2zt1qfr1NYHuzeLXfQM9H24wFSUt1Mp8 consumed 182734 of 596107 compute units', 'Program 675kPX9MHTjS2zt1qfr1NYHuzeLXfQM9H24wFSUt1Mp8 success', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA invoke [1]', 'Program log: Instruction: CloseAccount', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA consumed 2915 of 413373 compute units', 'Program TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA success'], 'postBalances': [59230073197, 0, 6124800, 23357760, 1461600, 2039280, 30002039280, 16258560, 123676981855438, 2039280, 2039280, 1, 1, 934087680, 583407163818, 1141440, 4224577002, 1461600, 4677120, 3591360, 1009200, 731913600, 1141440], 'postTokenBalances': [{'accountIndex': 5, 'mint': 'Dqoy9sP7v9PDJS55ZJJ1e2tzK9jegvmCN4LfGb5uSPJ1', 'owner': '5Q544fKrFoe6tsEbD7S8EmxGTJYAKtTVhAW5Q5pge4j1', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 1000000000000000, 'decimals': 6, 'uiAmount': 1000000000.0, 'uiAmountString': 1000000000}}, {'accountIndex': 6, 'mint': 'So11111111111111111111111111111111111111112', 'owner': '5Q544fKrFoe6tsEbD7S8EmxGTJYAKtTVhAW5Q5pge4j1', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 30000000000, 'decimals': 9, 'uiAmount': 30.0, 'uiAmountString': 30}}, {'accountIndex': 8, 'mint': 'So11111111111111111111111111111111111111112', 'owner': 'GThUX1Atko4tqhN2NaiTazWSeFWMuiUvfFnyJyUghFMJ', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 123676979816158, 'decimals': 9, 'uiAmount': 123676.979816158, 'uiAmountString': 123676.979816158}}, {'accountIndex': 9, 'mint': 'Dqoy9sP7v9PDJS55ZJJ1e2tzK9jegvmCN4LfGb5uSPJ1', 'owner': '8VAmNVg4kfdseX4nWVgQ7Hgwbeyyezofh5b7Sh3iPLy6', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 0, 'decimals': 6, 'uiAmount': None, 'uiAmountString': 0}}, {'accountIndex': 10, 'mint': '35P8jnjMzAU79BLDioVQ9y1povFQov7gx7WtWwLiBueh', 'owner': '8VAmNVg4kfdseX4nWVgQ7Hgwbeyyezofh5b7Sh3iPLy6', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 5477224575051, 'decimals': 6, 'uiAmount': 5477224.575051, 'uiAmountString': 5477224.575051}}], 'preBalances': [89683398758, 0, 0, 0, 0, 0, 0, 0, 123676581855438, 2039280, 0, 1, 1, 934087680, 583407163818, 1141440, 4224577002, 1461600, 4677120, 3591360, 1009200, 731913600, 1141440], 'preTokenBalances': [{'accountIndex': 8, 'mint': 'So11111111111111111111111111111111111111112', 'owner': 'GThUX1Atko4tqhN2NaiTazWSeFWMuiUvfFnyJyUghFMJ', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 123676579816158, 'decimals': 9, 'uiAmount': 123676.579816158, 'uiAmountString': 123676.579816158}}, {'accountIndex': 9, 'mint': 'Dqoy9sP7v9PDJS55ZJJ1e2tzK9jegvmCN4LfGb5uSPJ1', 'owner': '8VAmNVg4kfdseX4nWVgQ7Hgwbeyyezofh5b7Sh3iPLy6', 'programId': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'uiTokenAmount': {'amount': 1000000000000000, 'decimals': 6, 'uiAmount': 1000000000.0, 'uiAmountString': 1000000000}}], 'rewards': [], 'status': {'Ok': None}}, 'slot': 275704212, 'transaction': {'message': {'accountKeys': ['8VAmNVg4kfdseX4nWVgQ7Hgwbeyyezofh5b7Sh3iPLy6', '22oqM4TNmyxL6dwwdeTW5Zf4WKB5QKTwaGgBxUqLc8cu', '636mNhJUKVAuSsSjJLrDGQ3wUbfjSj6VaH9wr4UjEYXB', '2Ey3GmPkKoD57g74pbmL1B2kLXkaGiUPEeJd3sN43KHN', '35P8jnjMzAU79BLDioVQ9y1povFQov7gx7WtWwLiBueh', '8gr4HRRHCi3f7N2rrVpQ2dyfviXgJqUfADwCNptn7vMY', '5KsKH74NSg42VgszPDtAWTNFxD6BWPHBTzZ9difzSHWp', '7pX6CBu4u2wavMLH56KvttJXEzZ3wrNwZmbRQhVjfP1P', '7YttLkHDoNj9wyDur5pM1ejNaAvT9X4eqaYcHQqtj2G5', '7n5weXu4qiEMBGNUpnc71g9oaUZb7idid3EZ8KeYVLJs', 'CE6thZrLYsydrpF7862JVByE3iPVDEj1USFiozTWVNcb', 'ComputeBudget111111111111111111111111111111', 11111111111111111111111111111111, 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'So11111111111111111111111111111111111111112', '675kPX9MHTjS2zt1qfr1NYHuzeLXfQM9H24wFSUt1Mp8', '5Q544fKrFoe6tsEbD7S8EmxGTJYAKtTVhAW5Q5pge4j1', 'Dqoy9sP7v9PDJS55ZJJ1e2tzK9jegvmCN4LfGb5uSPJ1', '9DCxsMizn3H1hprZ7xWe6LDzeUeZBksYFpBWBtSf1PQX', 'CDgj8Puc51miQUH8c1QpLbeAYv12iYYr5kbiU2ArRN8K'], 'addressTableLookups': [{'accountKey': '2immgwYNHBbyVQKVGCEkgWpi53bLwWNRMB5G2nbgYV17', 'readonlyIndexes': [5, 7, 11], 'writableIndexes': []}], 'header': {'numReadonlySignedAccounts': 0, 'numReadonlyUnsignedAccounts': 9, 'numRequiredSignatures': 1}, 'instructions': [{'accounts': [], 'data': '3DdGGhkhJbjm', 'programIdIndex': 11, 'stackHeight': None}, {'accounts': [], 'data': 'JzwPro', 'programIdIndex': 11, 'stackHeight': None}, {'accounts': [0, 1], 'data': '3ipZWovDEk9bEL333vKz52v7kQ4u92PffF9bNeZKo6YuUm76ypfYXbzbQt9Az8WEiTwYmYpoFqxAU7y8ouGYDAAYAGVezPMhD5HKe9XtwueB8uDtWmquFBkkCnB2jFQ7ekYmTa7nPe1cMG1mN2ZZDJrRiicwF8XTEz2inCTqz', 'programIdIndex': 12, 'stackHeight': None}, {'accounts': [1, 14, 0, 20], 'data': 2, 'programIdIndex': 13, 'stackHeight': None}, {'accounts': [13, 21, 12, 20, 2, 16, 3, 4, 17, 14, 5, 6, 7, 18, 8, 22, 19, 0, 9, 1, 10], 'data': '4YZczxE84emRnT6cexz6WNtF28DmiUcR1ks', 'programIdIndex': 15, 'stackHeight': None}, {'accounts': [1, 0, 0], 'data': 'A', 'programIdIndex': 13, 'stackHeight': None}], 'recentBlockhash': 'F981Zs2mJWPZYv7j4HnbJ7EdHxCSmDPAKfYv3dYf4aD2'}, 'signatures': ['2WSynmJzhFxEjBakDvfYb74eXp36WScsoV3uMVfPuh5Tm2vkKoBpKS3myN8sTNt3eqscaE5ynuSnfdaGWzZbpB7G']}, 'version': 0}
import time,requests,json,struct,os,base58,sys,json
from solana.transaction import AccountMeta, Transaction
from spl.token.instructions import create_associated_token_account, get_associated_token_address, close_account, CloseAccountParams
from solders.pubkey import Pubkey #type: ignore
from solders.instruction import Instruction #type: ignore
from solders.compute_budget import set_compute_unit_limit, set_compute_unit_price #type: ignore
from solana.rpc.types import TokenAccountOpts
from solana.rpc.types import TxOpts
from typing import Optional, Union
from solders.keypair import Keypair
from solders.hash import Hash
from solana.transaction import Transaction
from solana.rpc.api import Client
import base64
from abstract_utilities import get_any_value
from abstract_security import get_env_value
from abstract_solcatcher.abstract_solana_utils.pumpFunKeys import get_pump_fun_data
from abstract_solcatcher.abstract_solana_utils.utils import *
from abstract_solcatcher.pythonFlask.abstract_flask import getLatestBlockHash,getTokenAccountBalance,getTransaction,getTokenAccountByOwner
def load_from_private_key(env_key='AMM_P'):
    env_value = get_env_value(key=env_key)
    if env_value:
        return Keypair.from_base58_string(env_value)

def load_keypair_from_file(filename):
    curr = os.path.join(sys.path[0], 'data',  filename)
    with open(curr, 'r') as file:
        secret = json.load(file)
        secret_key = bytes(secret)
        print(base58.b58encode(secret_key))
        return Keypair.from_bytete_key()
payer_keypair = load_from_private_key()
payer_pubkey = str(payer_keypair.pubkey())
owner=Pubkey.from_string(payer_pubkey)
def get_token_balance(payer,mint_str: str):
    
    response = getTokenAccountBalance(str(payer),str(mint_str))
    response=response.get('value',response)
    ui_amount = get_any_value(response, "uiAmount") or 0
    return float(ui_amount)
def sendTransaction(txn: Transaction, payer_keypair, opts=TxOpts(skip_preflight=True)) -> dict:
    # Sign the transaction
    txn.sign(payer_keypair)
    
    # Serialize the transaction to a base64 string
    txn_base64 = base58.b58encode(txn.serialize()).decode('utf-8')
    
    # Prepare the RPC request payload
    payload = {
        "jsonrpc": "2.0",
        "id": 1,
        "method": "sendTransaction",
        "params": [txn_base64, {"skipPreflight": opts.skip_preflight, "preflightCommitment": "finalized"}]
    }
    
    # Send the transaction
    response = requests.post(
        url="https://rpc.ankr.com/solana/c3b7fd92e298d5682b6ef095eaa4e92160989a713f5ee9ac2693b4da8ff5a370",
        json=payload
    )
    
    # Parse the JSON response
    response_json = response.json()
    
    # Return the result or the entire response in case of error
    return response_json.get('result', response_json)
def get_transaction(signature):

    # Prepare the RPC request payload
    payload = {
        "jsonrpc": "2.0",
        "id": 1,
        "method": "getTransaction",
        "params": [signature, {"maxSupportedTransactionVersion": 0}]
    }
    
    # Send the transaction
    response = requests.post(
        url="https://rpc.ankr.com/solana/c3b7fd92e298d5682b6ef095eaa4e92160989a713f5ee9ac2693b4da8ff5a370",
        json=payload
    )
    
    # Parse the JSON response
    response_json = response.json()
    
    # Return the result or the entire response in case of error
    return response_json.get('result', response_json)
def confirm_txn(txn_sig, max_retries=20, retry_interval=3):
    retries = 0
    txn_res = get_transaction(signature=str(txn_sig))
    
    while retries < max_retries:
        try:
            
            txn_res = get_transaction(signature=str(txn_sig))
            if txn_res:
                break
            txn_json = safe_json_loads(txn_res.get('transaction',{}).get('meta',{}))
            error = txn_json.get('err')
            if error is None:
                print("Transaction confirmed... try count:", retries+1)
                return True
            print("Error: Transaction not confirmed. Retrying...")
            if error:
                print("Transaction failed.")
                return False
        except Exception as e:
            print("Awaiting confirmation... try count:", retries+1)
            retries += 1
            time.sleep(retry_interval)
    print("Max retries reached. Transaction confirmation failed.")
    return None
def getKeys(coin_data,token_account,owner):
        coin_data = get_pump_fun_data(str("AUuZnGApuL2oJr3yLsYN12pE7Mz8sQpPYt268JAepump"))
        MINT = Pubkey.from_string(coin_data['mint'])
        BONDING_CURVE = Pubkey.from_string(coin_data['bonding_curve'])
        ASSOCIATED_BONDING_CURVE = Pubkey.from_string(coin_data['associated_bonding_curve'])
        ASSOCIATED_USER = token_account
        USER = owner
    
        keys = [
            AccountMeta(pubkey=Pubkey.from_string(coin_data.get('global')), is_signer=False, is_writable=False),
            AccountMeta(pubkey=USER, is_signer=False, is_writable=True),

            AccountMeta(pubkey=MINT, is_signer=False, is_writable=False),
            AccountMeta(pubkey=BONDING_CURVE, is_signer=False, is_writable=True),
            AccountMeta(pubkey=ASSOCIATED_BONDING_CURVE, is_signer=False, is_writable=True),
            AccountMeta(pubkey=ASSOCIATED_USER, is_signer=False, is_writable=True),
            AccountMeta(pubkey=USER, is_signer=True, is_writable=True),
            AccountMeta(pubkey=Pubkey.from_string('11111111111111111111111111111111'), is_signer=False, is_writable=False), 
            AccountMeta(pubkey=Pubkey.from_string('TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA'), is_signer=False, is_writable=False),
            AccountMeta(pubkey=Pubkey.from_string('SysvarRent111111111111111111111111111111111'), is_signer=False, is_writable=False),
            AccountMeta(pubkey=Pubkey.from_string(coin_data.get('event_authority')), is_signer=False, is_writable=False),
            AccountMeta(pubkey=Pubkey.from_string(coin_data.get('program')), is_signer=False, is_writable=False)
        ]
        return keys
def get_coin_data(mint_str):
    return get_pump_fun_data(str(mint_str))



def buildTxn(mint, amount, slippage, token_account_pubkey,sol_in,token_account_instructions,buy=True):
    # Get keys for the transaction, pass the token account's pubkey instead of the AccountMeta object
    keys = getKeys(get_coin_data(mint), token_account_pubkey, owner)
    
    if buy:
        # Calculate max_sol_cost
        slippage_adjustment = 1 + (slippage / 100)
        sol_in_with_slippage = sol_in * slippage_adjustment
        max_sol_cost = int(sol_in_with_slippage * LAMPORTS_PER_SOL)
        print("Max Sol Cost:", sol_in_with_slippage)
        hex_data = bytes.fromhex("66063d1201daebea")
        solCost = max_sol_cost
    else:
        # Calculate minimum SOL output
        sol_out = float(token_balance) * float(token_price)
        slippage_adjustment = 1 - (slippage / 100)
        sol_out_with_slippage = sol_out * slippage_adjustment
        min_sol_output = int(sol_out_with_slippage * LAMPORTS_PER_SOL)
        print("Min Sol Output:", sol_out_with_slippage)
        hex_data = bytes.fromhex("33e685a4017f83ad")
        solCost = min_sol_output
    
    data = bytearray()
    data.extend(hex_data)
    data.extend(struct.pack('<Q', amount))
    data.extend(struct.pack('<Q', solCost))
    data = bytes(data)
    swap_instruction = Instruction(PUMP_FUN_PROGRAM, data, keys)
    blockHash = requests.post(url="https://rpc.ankr.com/solana/c3b7fd92e298d5682b6ef095eaa4e92160989a713f5ee9ac2693b4da8ff5a370",data=json.dumps({"id":1,"jsonrpc":"2.0","method":"getLatestBlockhash","params":[{"commitment":"processed"}]}))
    recent_blockhash = get_any_value(blockHash.json(),'blockhash')
    recent_blockhash = Hash.from_string(recent_blockhash)
    txn = Transaction(recent_blockhash=recent_blockhash, fee_payer=owner)
    txn.add(set_compute_unit_price(UNIT_PRICE))
    txn.add(set_compute_unit_limit(UNIT_BUDGET))
    
    if buy:
        if token_account_instructions:
            txn.add(token_account_instructions)
        txn.add(swap_instruction)
    else:
        txn.add(swap_instruction)
        if close_token_account:
            close_account_instructions = close_account(CloseAccountParams(TOKEN_PROGRAM, token_account_pubkey, owner, owner))
            txn.add(close_account_instructions)
    
    txn.sign(payer_keypair)
    # Send and confirm transaction
    txn_sig = sendTransaction(txn, payer_keypair, opts=TxOpts(skip_preflight=True))
    print("Transaction Signature", txn_sig)
    confirm = confirm_txn(txn_sig)
    print(confirm)

def pump_fun_buy(mint_str: str, sol_in: float = 0.001, slippage: int = 25) -> bool:
    mint_str = str(mint_str)
    mint = Pubkey.from_string(mint_str)
    
    # Get coin data
    coin_data = get_coin_data(mint_str)
    print(coin_data)

    if not coin_data:
        print("Failed to retrieve coin data...")
        return False

    token_account_pubkey = None
    try:
        # Attempt to retrieve token account
        account_data = getTokenAccountByOwner(str(owner), str(mint))
        account_data = account_data.get('value', account_data)
        # Assuming account_data is a list or a similar structure containing the account address
        token_account_pubkey = Pubkey.from_string(account_data[0])  # Accessing the first element if it's a list
    except Exception as e:
        print(f"Error retrieving token account: {e}")
        # Create associated token account if it doesn't exist
        token_account_instructions = create_associated_token_account(
            Pubkey.from_bytes(bytes(owner)),
            Pubkey.from_string(str(owner)),
            Pubkey.from_string(str(mint))
        )
        # Extract the pubkey from the instruction
        token_account_pubkey = token_account_instructions.accounts[1].pubkey  # Assuming accounts[1] is the target account

    # Ensure the token_account is a valid Pubkey
    if not isinstance(token_account_pubkey, Pubkey):
        print("Failed to create or retrieve a valid token account Pubkey...")
        return False

    # Calculate amount
    virtual_sol_reserves = coin_data['virtual_sol_reserves']
    virtual_token_reserves = coin_data['virtual_token_reserves']
    sol_in_lamports = sol_in * LAMPORTS_PER_SOL
    amount = int(sol_in_lamports * virtual_token_reserves / virtual_sol_reserves)
    
    # Build the transaction
    buildTxn(mint, amount, slippage, token_account_pubkey,sol_in,token_account_instructions, buy=True)
    return True


def pump_fun_sell(mint_str: str, token_balance: Optional[Union[int, float]] = None,  slippage: int = 25, close_token_account: bool = True) -> bool:
    try:
        # Get coin data
        coin_data = get_coin_data(mint_str)
        print(coin_data)
        if not coin_data:
            print("Failed to retrieve coin data...")
            return
        
        mint=Pubkey.from_string(mint)
        # Get token account
        token_account = get_token_balance(owner, mint)
        # Calculate token price
        sol_decimal = 10**9
        token_decimal = 10**6
        virtual_sol_reserves = coin_data['virtual_sol_reserves'] / sol_decimal
        virtual_token_reserves = coin_data['virtual_token_reserves'] / token_decimal
        token_price = virtual_sol_reserves / virtual_token_reserves
        print(f"Token Price: {token_price:.20f} SOL")

        # Get token balance
        if token_balance == None:
            token_balance = get_token_balance(mint_str)
        print("Token Balance:", token_balance)    
        if token_balance == 0:
            return
        # Calculate amount
        amount = int(token_balance * token_decimal)
        buildTxn(amount,slippage,buy=False)
    except Exception as e:
        print(e)

def get_token_price(mint_str: str) -> float:
    try:
        # Get coin data
        coin_data = get_coin_data(mint_str)
        if not coin_data:
            print("Failed to retrieve coin data...")
            return None
        virtual_sol_reserves = coin_data['virtual_sol_reserves'] / 10**9
        virtual_token_reserves = coin_data['virtual_token_reserves'] / 10**6
        token_price = virtual_sol_reserves / virtual_token_reserves
        print(f"Token Price: {token_price:.20f} SOL")
        return token_price
    except Exception as e:
        print(f"Error calculating token price: {e}")
        return None
pump_fun_buy(mint_str="AUuZnGApuL2oJr3yLsYN12pE7Mz8sQpPYt268JAepump", sol_in=0.001, slippage= 25)
