# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import List, Optional

from onelogin.models.get_user_apps200_response_inner import GetUserApps200ResponseInner
from onelogin.models.user import User

from onelogin.api_client import ApiClient
from onelogin.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UsersV2Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_user2(self, mappings : Annotated[Optional[StrictStr], Field(description="Controls how mappings will be applied to the user on creation. Defaults to async.")] = None, validate_policy : Annotated[Optional[StrictBool], Field(description="Will passwords validate against the User Policy? Defaults to true.")] = None, user : Optional[User] = None, **kwargs) -> User:  # noqa: E501
        """Create User  # noqa: E501

        Create User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user2(mappings, validate_policy, user, async_req=True)
        >>> result = thread.get()

        :param mappings: Controls how mappings will be applied to the user on creation. Defaults to async.
        :type mappings: str
        :param validate_policy: Will passwords validate against the User Policy? Defaults to true.
        :type validate_policy: bool
        :param user:
        :type user: User
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: User
        """
        kwargs['_return_http_data_only'] = True
        return self.create_user2_with_http_info(mappings, validate_policy, user, **kwargs)  # noqa: E501

    @validate_arguments
    def create_user2_with_http_info(self, mappings : Annotated[Optional[StrictStr], Field(description="Controls how mappings will be applied to the user on creation. Defaults to async.")] = None, validate_policy : Annotated[Optional[StrictBool], Field(description="Will passwords validate against the User Policy? Defaults to true.")] = None, user : Optional[User] = None, **kwargs):  # noqa: E501
        """Create User  # noqa: E501

        Create User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user2_with_http_info(mappings, validate_policy, user, async_req=True)
        >>> result = thread.get()

        :param mappings: Controls how mappings will be applied to the user on creation. Defaults to async.
        :type mappings: str
        :param validate_policy: Will passwords validate against the User Policy? Defaults to true.
        :type validate_policy: bool
        :param user:
        :type user: User
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(User, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'mappings',
            'validate_policy',
            'user'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('mappings') is not None:  # noqa: E501
            _query_params.append(('mappings', _params['mappings']))
        if _params.get('validate_policy') is not None:  # noqa: E501
            _query_params.append(('validate_policy', _params['validate_policy']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['user']:
            _body_params = _params['user']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '201': "User",
            '400': "Error",
            '401': "Error",
            '422': "Error",
        }

        return self.api_client.call_api(
            '/api/2/users', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_user2(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], **kwargs) -> None:  # noqa: E501
        """Delete User  # noqa: E501

        Delete User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user2(user_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_user2_with_http_info(user_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_user2_with_http_info(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], **kwargs):  # noqa: E501
        """Delete User  # noqa: E501

        Delete User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user2_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['user_id'] = _params['user_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/2/users/{user_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user2(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], **kwargs) -> User:  # noqa: E501
        """Get User  # noqa: E501

        Get User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user2(user_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: User
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user2_with_http_info(user_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user2_with_http_info(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], **kwargs):  # noqa: E501
        """Get User  # noqa: E501

        Get User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user2_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(User, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['user_id'] = _params['user_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "User",
            '400': "Error",
            '404': "Error",
        }

        return self.api_client.call_api(
            '/api/2/users/{user_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user_apps2(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], ignore_visibility : Annotated[Optional[StrictBool], Field(description="Defaults to `false`. When `true` will show all apps that are assigned to a user regardless of their portal visibility setting.")] = None, **kwargs) -> List[GetUserApps200ResponseInner]:  # noqa: E501
        """Get User Apps  # noqa: E501

        Get User Apps  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_apps2(user_id, ignore_visibility, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param ignore_visibility: Defaults to `false`. When `true` will show all apps that are assigned to a user regardless of their portal visibility setting.
        :type ignore_visibility: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[GetUserApps200ResponseInner]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_apps2_with_http_info(user_id, ignore_visibility, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user_apps2_with_http_info(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], ignore_visibility : Annotated[Optional[StrictBool], Field(description="Defaults to `false`. When `true` will show all apps that are assigned to a user regardless of their portal visibility setting.")] = None, **kwargs):  # noqa: E501
        """Get User Apps  # noqa: E501

        Get User Apps  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_apps2_with_http_info(user_id, ignore_visibility, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param ignore_visibility: Defaults to `false`. When `true` will show all apps that are assigned to a user regardless of their portal visibility setting.
        :type ignore_visibility: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[GetUserApps200ResponseInner], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id',
            'ignore_visibility'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_apps2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['user_id'] = _params['user_id']

        # process the query parameters
        _query_params = []
        if _params.get('ignore_visibility') is not None:  # noqa: E501
            _query_params.append(('ignore_visibility', _params['ignore_visibility']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "List[GetUserApps200ResponseInner]",
            '401': "Error",
            '404': "Error",
        }

        return self.api_client.call_api(
            '/api/2/users/{user_id}/apps', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_users2(self, limit : Annotated[Optional[StrictInt], Field(description="How many items to return at one time (max 100)")] = None, page : Annotated[Optional[StrictInt], Field(description="The page number of results to return.")] = None, cursor : Annotated[Optional[StrictStr], Field(description="Set to the value extracted from Before-Cursor or After-Cursor headers to return the previous or next page.")] = None, created_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users created after a given date & time.")] = None, created_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users created before a given date & time.")] = None, updated_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users updated after a given date & time.")] = None, updated_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users updated before a given date & time.")] = None, last_login_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users that logged in after a given date & time.")] = None, last_login_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users that logged in before a given date & time.")] = None, firstname : Annotated[Optional[StrictStr], Field(description="The first name of the user")] = None, lastname : Annotated[Optional[StrictStr], Field(description="The last name of the user")] = None, email : Annotated[Optional[StrictStr], Field(description="The email address of the user")] = None, username : Annotated[Optional[StrictStr], Field(description="The username for the user")] = None, samaccountname : Annotated[Optional[StrictStr], Field(description="The AD login name for the user")] = None, directory_id : Optional[StrictInt] = None, external_id : Annotated[Optional[StrictStr], Field(description="An external identifier that has been set on the user")] = None, user_ids : Annotated[Optional[StrictStr], Field(description="A comma separated list of OneLogin User IDs")] = None, custom_attributes_attribute_name : Annotated[Optional[StrictStr], Field(description="The short name of a custom attribute. Note that the attribute name is prefixed with custom_attributes.")] = None, fields : Annotated[Optional[StrictStr], Field(description="Optional. Comma delimited list of fields to return.")] = None, **kwargs) -> List[User]:  # noqa: E501
        """List Users  # noqa: E501

        Get a list of users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users2(limit, page, cursor, created_since, created_until, updated_since, updated_until, last_login_since, last_login_until, firstname, lastname, email, username, samaccountname, directory_id, external_id, user_ids, custom_attributes_attribute_name, fields, async_req=True)
        >>> result = thread.get()

        :param limit: How many items to return at one time (max 100)
        :type limit: int
        :param page: The page number of results to return.
        :type page: int
        :param cursor: Set to the value extracted from Before-Cursor or After-Cursor headers to return the previous or next page.
        :type cursor: str
        :param created_since: An ISO8601 timestamp value that returns all users created after a given date & time.
        :type created_since: str
        :param created_until: An ISO8601 timestamp value that returns all users created before a given date & time.
        :type created_until: str
        :param updated_since: An ISO8601 timestamp value that returns all users updated after a given date & time.
        :type updated_since: str
        :param updated_until: An ISO8601 timestamp value that returns all users updated before a given date & time.
        :type updated_until: str
        :param last_login_since: An ISO8601 timestamp value that returns all users that logged in after a given date & time.
        :type last_login_since: str
        :param last_login_until: An ISO8601 timestamp value that returns all users that logged in before a given date & time.
        :type last_login_until: str
        :param firstname: The first name of the user
        :type firstname: str
        :param lastname: The last name of the user
        :type lastname: str
        :param email: The email address of the user
        :type email: str
        :param username: The username for the user
        :type username: str
        :param samaccountname: The AD login name for the user
        :type samaccountname: str
        :param directory_id:
        :type directory_id: int
        :param external_id: An external identifier that has been set on the user
        :type external_id: str
        :param user_ids: A comma separated list of OneLogin User IDs
        :type user_ids: str
        :param custom_attributes_attribute_name: The short name of a custom attribute. Note that the attribute name is prefixed with custom_attributes.
        :type custom_attributes_attribute_name: str
        :param fields: Optional. Comma delimited list of fields to return.
        :type fields: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[User]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_users2_with_http_info(limit, page, cursor, created_since, created_until, updated_since, updated_until, last_login_since, last_login_until, firstname, lastname, email, username, samaccountname, directory_id, external_id, user_ids, custom_attributes_attribute_name, fields, **kwargs)  # noqa: E501

    @validate_arguments
    def list_users2_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="How many items to return at one time (max 100)")] = None, page : Annotated[Optional[StrictInt], Field(description="The page number of results to return.")] = None, cursor : Annotated[Optional[StrictStr], Field(description="Set to the value extracted from Before-Cursor or After-Cursor headers to return the previous or next page.")] = None, created_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users created after a given date & time.")] = None, created_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users created before a given date & time.")] = None, updated_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users updated after a given date & time.")] = None, updated_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users updated before a given date & time.")] = None, last_login_since : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users that logged in after a given date & time.")] = None, last_login_until : Annotated[Optional[StrictStr], Field(description="An ISO8601 timestamp value that returns all users that logged in before a given date & time.")] = None, firstname : Annotated[Optional[StrictStr], Field(description="The first name of the user")] = None, lastname : Annotated[Optional[StrictStr], Field(description="The last name of the user")] = None, email : Annotated[Optional[StrictStr], Field(description="The email address of the user")] = None, username : Annotated[Optional[StrictStr], Field(description="The username for the user")] = None, samaccountname : Annotated[Optional[StrictStr], Field(description="The AD login name for the user")] = None, directory_id : Optional[StrictInt] = None, external_id : Annotated[Optional[StrictStr], Field(description="An external identifier that has been set on the user")] = None, user_ids : Annotated[Optional[StrictStr], Field(description="A comma separated list of OneLogin User IDs")] = None, custom_attributes_attribute_name : Annotated[Optional[StrictStr], Field(description="The short name of a custom attribute. Note that the attribute name is prefixed with custom_attributes.")] = None, fields : Annotated[Optional[StrictStr], Field(description="Optional. Comma delimited list of fields to return.")] = None, **kwargs):  # noqa: E501
        """List Users  # noqa: E501

        Get a list of users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users2_with_http_info(limit, page, cursor, created_since, created_until, updated_since, updated_until, last_login_since, last_login_until, firstname, lastname, email, username, samaccountname, directory_id, external_id, user_ids, custom_attributes_attribute_name, fields, async_req=True)
        >>> result = thread.get()

        :param limit: How many items to return at one time (max 100)
        :type limit: int
        :param page: The page number of results to return.
        :type page: int
        :param cursor: Set to the value extracted from Before-Cursor or After-Cursor headers to return the previous or next page.
        :type cursor: str
        :param created_since: An ISO8601 timestamp value that returns all users created after a given date & time.
        :type created_since: str
        :param created_until: An ISO8601 timestamp value that returns all users created before a given date & time.
        :type created_until: str
        :param updated_since: An ISO8601 timestamp value that returns all users updated after a given date & time.
        :type updated_since: str
        :param updated_until: An ISO8601 timestamp value that returns all users updated before a given date & time.
        :type updated_until: str
        :param last_login_since: An ISO8601 timestamp value that returns all users that logged in after a given date & time.
        :type last_login_since: str
        :param last_login_until: An ISO8601 timestamp value that returns all users that logged in before a given date & time.
        :type last_login_until: str
        :param firstname: The first name of the user
        :type firstname: str
        :param lastname: The last name of the user
        :type lastname: str
        :param email: The email address of the user
        :type email: str
        :param username: The username for the user
        :type username: str
        :param samaccountname: The AD login name for the user
        :type samaccountname: str
        :param directory_id:
        :type directory_id: int
        :param external_id: An external identifier that has been set on the user
        :type external_id: str
        :param user_ids: A comma separated list of OneLogin User IDs
        :type user_ids: str
        :param custom_attributes_attribute_name: The short name of a custom attribute. Note that the attribute name is prefixed with custom_attributes.
        :type custom_attributes_attribute_name: str
        :param fields: Optional. Comma delimited list of fields to return.
        :type fields: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[User], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page',
            'cursor',
            'created_since',
            'created_until',
            'updated_since',
            'updated_until',
            'last_login_since',
            'last_login_until',
            'firstname',
            'lastname',
            'email',
            'username',
            'samaccountname',
            'directory_id',
            'external_id',
            'user_ids',
            'custom_attributes_attribute_name',
            'fields'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))
        if _params.get('cursor') is not None:  # noqa: E501
            _query_params.append(('cursor', _params['cursor']))
        if _params.get('created_since') is not None:  # noqa: E501
            _query_params.append(('created_since', _params['created_since']))
        if _params.get('created_until') is not None:  # noqa: E501
            _query_params.append(('created_until', _params['created_until']))
        if _params.get('updated_since') is not None:  # noqa: E501
            _query_params.append(('updated_since', _params['updated_since']))
        if _params.get('updated_until') is not None:  # noqa: E501
            _query_params.append(('updated_until', _params['updated_until']))
        if _params.get('last_login_since') is not None:  # noqa: E501
            _query_params.append(('last_login_since', _params['last_login_since']))
        if _params.get('last_login_until') is not None:  # noqa: E501
            _query_params.append(('last_login_until', _params['last_login_until']))
        if _params.get('firstname') is not None:  # noqa: E501
            _query_params.append(('firstname', _params['firstname']))
        if _params.get('lastname') is not None:  # noqa: E501
            _query_params.append(('lastname', _params['lastname']))
        if _params.get('email') is not None:  # noqa: E501
            _query_params.append(('email', _params['email']))
        if _params.get('username') is not None:  # noqa: E501
            _query_params.append(('username', _params['username']))
        if _params.get('samaccountname') is not None:  # noqa: E501
            _query_params.append(('samaccountname', _params['samaccountname']))
        if _params.get('directory_id') is not None:  # noqa: E501
            _query_params.append(('directory_id', _params['directory_id']))
        if _params.get('external_id') is not None:  # noqa: E501
            _query_params.append(('external_id', _params['external_id']))
        if _params.get('user_ids') is not None:  # noqa: E501
            _query_params.append(('user_ids', _params['user_ids']))
        if _params.get('custom_attributes_attribute_name') is not None:  # noqa: E501
            _query_params.append(('custom_attributes.{attribute_name}', _params['custom_attributes_attribute_name']))
        if _params.get('fields') is not None:  # noqa: E501
            _query_params.append(('fields', _params['fields']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "List[User]",
            '400': "Error",
            '401': "Error",
            '422': "Error",
        }

        return self.api_client.call_api(
            '/api/2/users', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_user2(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], mappings : Annotated[Optional[StrictStr], Field(description="Controls how mappings will be applied to the user on creation. Defaults to async.")] = None, validate_policy : Annotated[Optional[StrictBool], Field(description="Will passwords validate against the User Policy? Defaults to true.")] = None, user : Optional[User] = None, **kwargs) -> User:  # noqa: E501
        """Update User  # noqa: E501

        Update User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user2(user_id, mappings, validate_policy, user, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param mappings: Controls how mappings will be applied to the user on creation. Defaults to async.
        :type mappings: str
        :param validate_policy: Will passwords validate against the User Policy? Defaults to true.
        :type validate_policy: bool
        :param user:
        :type user: User
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: User
        """
        kwargs['_return_http_data_only'] = True
        return self.update_user2_with_http_info(user_id, mappings, validate_policy, user, **kwargs)  # noqa: E501

    @validate_arguments
    def update_user2_with_http_info(self, user_id : Annotated[StrictInt, Field(..., description="Set to the id of the user that you want to return.")], mappings : Annotated[Optional[StrictStr], Field(description="Controls how mappings will be applied to the user on creation. Defaults to async.")] = None, validate_policy : Annotated[Optional[StrictBool], Field(description="Will passwords validate against the User Policy? Defaults to true.")] = None, user : Optional[User] = None, **kwargs):  # noqa: E501
        """Update User  # noqa: E501

        Update User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user2_with_http_info(user_id, mappings, validate_policy, user, async_req=True)
        >>> result = thread.get()

        :param user_id: Set to the id of the user that you want to return. (required)
        :type user_id: int
        :param mappings: Controls how mappings will be applied to the user on creation. Defaults to async.
        :type mappings: str
        :param validate_policy: Will passwords validate against the User Policy? Defaults to true.
        :type validate_policy: bool
        :param user:
        :type user: User
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(User, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_id',
            'mappings',
            'validate_policy',
            'user'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_id']:
            _path_params['user_id'] = _params['user_id']

        # process the query parameters
        _query_params = []
        if _params.get('mappings') is not None:  # noqa: E501
            _query_params.append(('mappings', _params['mappings']))
        if _params.get('validate_policy') is not None:  # noqa: E501
            _query_params.append(('validate_policy', _params['validate_policy']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['user']:
            _body_params = _params['user']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "User",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '422': "Error",
        }

        return self.api_client.call_api(
            '/api/2/users/{user_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
