# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class AppParametersValue(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    user_attribute_mappings: Optional[StrictStr] = Field(None, description="A user attribute to map values from For custom attributes prefix the name of the attribute with `custom_attribute_`. e.g. To get the value for custom attribute `employee_id` use `custom_attribute_employee_id`.")
    user_attribute_macros: Optional[StrictStr] = Field(None, description="When `user_attribute_mappings` is set to `_macro_` this macro will be used to assign the parameter value.")
    label: Optional[StrictStr] = Field(None, description="The can only be set when creating a new parameter. It can not be updated.")
    include_in_saml_assertion: Optional[StrictBool] = Field(None, description="When true, this parameter will be included in a SAML assertion payload.")
    __properties = ["user_attribute_mappings", "user_attribute_macros", "label", "include_in_saml_assertion"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AppParametersValue:
        """Create an instance of AppParametersValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if user_attribute_mappings (nullable) is None
        if self.user_attribute_mappings is None:
            _dict['user_attribute_mappings'] = None

        # set to None if user_attribute_macros (nullable) is None
        if self.user_attribute_macros is None:
            _dict['user_attribute_macros'] = None

        # set to None if label (nullable) is None
        if self.label is None:
            _dict['label'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AppParametersValue:
        """Create an instance of AppParametersValue from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AppParametersValue.parse_obj(obj)

        _obj = AppParametersValue.parse_obj({
            "user_attribute_mappings": obj.get("user_attribute_mappings"),
            "user_attribute_macros": obj.get("user_attribute_macros"),
            "label": obj.get("label"),
            "include_in_saml_assertion": obj.get("include_in_saml_assertion")
        })
        return _obj

