# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class AuthFactor(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    factor_id: Optional[StrictInt] = Field(None, description="The identifier of the factor to enroll the user with.")
    display_name: Optional[StrictStr] = Field(None, description="Authentication factor display name as it appears to users, as defined in the admininstrative interface at Settings > Authentication Factors.")
    number: Optional[StrictStr] = Field(None, description="The phone number of the user in E.164 format.")
    verified: Optional[StrictBool] = Field(None, description="Defaults to false. Some factors like SMS or Voice require that a user recieve a token and then that token is supplied to the Verify endpoint before the device is considered active. You can set verfied to `true` which indicates the the users phone number is pre verified and the device can be immediately activated.        ")
    type_display_name: Optional[StrictStr] = Field(None, description="Authentication factor display name as it appears to users upon initial registration, as defined by admins at Settings > Authentication Factors.")
    active: Optional[StrictBool] = Field(None, description="`true` = enabled (used successfully for authentication at least once). `false` = pending (registered but never used).")
    user_display_name: Optional[StrictStr] = Field(None, description="Authentication factor display name assigned by users when they register the device.")
    default: Optional[StrictBool] = Field(None, description="`true` = is user’s default MFA device for OneLogin.")
    phone_number: Optional[StrictStr] = Field(None, description="For OTP codes sent via SMS, the phone number receiving the SMS message.")
    auth_factor_name: Optional[StrictStr] = Field(None, description="\"Official\" authentication factor name, as it appears to administrators in OneLogin.")
    id: Optional[StrictInt] = Field(None, description="MFA device identifier.")
    needs_trigger: Optional[StrictBool] = Field(None, description="`true`: You MUST Activate this Factor to trigger an SMS or Push notification before Verifying the OTP code. `false`: No Activation required. You can Verify the OTP immediately. MFA factors that provide both push notifications (user accepts notification) and pull code submission (user initiates code submission from device or enters it manually) should appear twice; once with `needs_trigger: true` and once with `needs_trigger: false`.")
    __properties = ["factor_id", "display_name", "number", "verified", "type_display_name", "active", "user_display_name", "default", "phone_number", "auth_factor_name", "id", "needs_trigger"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuthFactor:
        """Create an instance of AuthFactor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "factor_id",
                            "phone_number",
                            "auth_factor_name",
                            "id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuthFactor:
        """Create an instance of AuthFactor from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AuthFactor.parse_obj(obj)

        _obj = AuthFactor.parse_obj({
            "factor_id": obj.get("factor_id"),
            "display_name": obj.get("display_name"),
            "number": obj.get("number"),
            "verified": obj.get("verified"),
            "type_display_name": obj.get("type_display_name"),
            "active": obj.get("active"),
            "user_display_name": obj.get("user_display_name"),
            "default": obj.get("default"),
            "phone_number": obj.get("phone_number"),
            "auth_factor_name": obj.get("auth_factor_name"),
            "id": obj.get("id"),
            "needs_trigger": obj.get("needs_trigger")
        })
        return _obj

