# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from onelogin.models.generic_app import GenericApp
from onelogin.models.oidc_app import OidcApp
from onelogin.models.saml_app import SamlApp
from typing import Any, List
from pydantic import StrictStr, Field

CREATEAPPREQUEST_ONE_OF_SCHEMAS = ["GenericApp", "OidcApp", "SamlApp"]

class CreateAppRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: OidcApp
    __oneof_schema_1: Optional[OidcApp] = None
    # data type: SamlApp
    __oneof_schema_2: Optional[SamlApp] = None
    # data type: GenericApp
    __oneof_schema_3: Optional[GenericApp] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(CREATEAPPREQUEST_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: OidcApp
        if type(v) is not OidcApp:
            error_messages.append(f"Error! Input type `{type(v)}` is not `OidcApp`")
        else:
            match += 1

        # validate data type: SamlApp
        if type(v) is not SamlApp:
            error_messages.append(f"Error! Input type `{type(v)}` is not `SamlApp`")
        else:
            match += 1

        # validate data type: GenericApp
        if type(v) is not GenericApp:
            error_messages.append(f"Error! Input type `{type(v)}` is not `GenericApp`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CreateAppRequest with oneOf schemas: GenericApp, OidcApp, SamlApp. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CreateAppRequest with oneOf schemas: GenericApp, OidcApp, SamlApp. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAppRequest:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> CreateAppRequest:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into OidcApp
        try:
            instance.actual_instance = OidcApp.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into SamlApp
        try:
            instance.actual_instance = SamlApp.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into GenericApp
        try:
            instance.actual_instance = GenericApp.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CreateAppRequest with oneOf schemas: GenericApp, OidcApp, SamlApp. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CreateAppRequest with oneOf schemas: GenericApp, OidcApp, SamlApp. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





