# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from onelogin.models.configuration_oidc import ConfigurationOidc
from onelogin.models.configuration_saml import ConfigurationSaml
from typing import Any, List
from pydantic import StrictStr, Field

GENERICAPPCONFIGURATION_ONE_OF_SCHEMAS = ["ConfigurationOidc", "ConfigurationSaml"]

class GenericAppConfiguration(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: ConfigurationOidc
    __oneof_schema_1: Optional[ConfigurationOidc] = None
    # data type: ConfigurationSaml
    __oneof_schema_2: Optional[ConfigurationSaml] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(GENERICAPPCONFIGURATION_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: ConfigurationOidc
        if type(v) is not ConfigurationOidc:
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConfigurationOidc`")
        else:
            match += 1

        # validate data type: ConfigurationSaml
        if type(v) is not ConfigurationSaml:
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConfigurationSaml`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into GenericAppConfiguration with oneOf schemas: ConfigurationOidc, ConfigurationSaml. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GenericAppConfiguration with oneOf schemas: ConfigurationOidc, ConfigurationSaml. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> GenericAppConfiguration:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> GenericAppConfiguration:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into ConfigurationOidc
        try:
            instance.actual_instance = ConfigurationOidc.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into ConfigurationSaml
        try:
            instance.actual_instance = ConfigurationSaml.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into GenericAppConfiguration with oneOf schemas: ConfigurationOidc, ConfigurationSaml. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GenericAppConfiguration with oneOf schemas: ConfigurationOidc, ConfigurationSaml. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





