# coding: utf-8

"""
    OneLogin API

    OpenAPI Specification for OneLogin  # noqa: E501

    The version of the OpenAPI document: 3.1.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class GetAuthenticationDevices200ResponseInner(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    device_id: Optional[StrictStr] = Field(None, description="MFA device identifier.")
    user_display_name: Optional[StrictStr] = Field(None, description="Authentication factor display name assigned by users when they register the device.")
    type_display_name: Optional[StrictStr] = Field(None, description="Authentication factor display name as it appears to users upon initial registration, as defined by admins at Settings > Authentication Factors.")
    auth_factor_name: Optional[StrictStr] = Field(None, description="Authentication factor name, as it appears to administrators in OneLogin.")
    default: Optional[StrictBool] = Field(False, description="true = is user’s default MFA device for OneLogin.")
    __properties = ["device_id", "user_display_name", "type_display_name", "auth_factor_name", "default"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetAuthenticationDevices200ResponseInner:
        """Create an instance of GetAuthenticationDevices200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetAuthenticationDevices200ResponseInner:
        """Create an instance of GetAuthenticationDevices200ResponseInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetAuthenticationDevices200ResponseInner.parse_obj(obj)

        _obj = GetAuthenticationDevices200ResponseInner.parse_obj({
            "device_id": obj.get("device_id"),
            "user_display_name": obj.get("user_display_name"),
            "type_display_name": obj.get("type_display_name"),
            "auth_factor_name": obj.get("auth_factor_name"),
            "default": obj.get("default") if obj.get("default") is not None else False
        })
        return _obj

