r"""
BiliDown: 哔哩哔哩命令行下载器

By Nemo2011<yimoxia@outlook.com>
"""

__license__ = """
                    GNU GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <https://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The GNU General Public License is a free, copyleft license for
software and other kinds of works.

  The licenses for most software and other practical works are designed
to take away your freedom to share and change the works.  By contrast,
the GNU General Public License is intended to guarantee your freedom to
share and change all versions of a program--to make sure it remains free
software for all its users.  We, the Free Software Foundation, use the
GNU General Public License for most of our software; it applies also to
any other work released this way by its authors.  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
them if you wish), that you receive source code or can get it if you
want it, that you can change the software or use pieces of it in new
free programs, and that you know you can do these things.

  To protect your rights, we need to prevent others from denying you
these rights or asking you to surrender the rights.  Therefore, you have
certain responsibilities if you distribute copies of the software, or if
you modify it: responsibilities to respect the freedom of others.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must pass on to the recipients the same
freedoms that you received.  You must make sure that they, too, receive
or can get the source code.  And you must show them these terms so they
know their rights.

  Developers that use the GNU GPL protect your rights with two steps:
(1) assert copyright on the software, and (2) offer you this License
giving you legal permission to copy, distribute and/or modify it.

  For the developers' and authors' protection, the GPL clearly explains
that there is no warranty for this free software.  For both users' and
authors' sake, the GPL requires that modified versions be marked as
changed, so that their problems will not be attributed erroneously to
authors of previous versions.

  Some devices are designed to deny users access to install or run
modified versions of the software inside them, although the manufacturer
can do so.  This is fundamentally incompatible with the aim of
protecting users' freedom to change the software.  The systematic
pattern of such abuse occurs in the area of products for individuals to
use, which is precisely where it is most unacceptable.  Therefore, we
have designed this version of the GPL to prohibit the practice for those
products.  If such problems arise substantially in other domains, we
stand ready to extend this provision to those domains in future versions
of the GPL, as needed to protect the freedom of users.

  Finally, every program is threatened constantly by software patents.
States should not allow patents to restrict development and use of
software on general-purpose computers, but in those that do, we wish to
avoid the special danger that patents applied to a free program could
make it effectively proprietary.  To prevent this, the GPL assures that
patents cannot be used to render the program non-free.

  The precise terms and conditions for copying, distribution and
modification follow.

                       TERMS AND CONDITIONS

  0. Definitions.

  "This License" refers to version 3 of the GNU General Public License.

  "Copyright" also means copyright-like laws that apply to other kinds of
works, such as semiconductor masks.

  "The Program" refers to any copyrightable work licensed under this
License.  Each licensee is addressed as "you".  "Licensees" and
"recipients" may be individuals or organizations.

  To "modify" a work means to copy from or adapt all or part of the work
in a fashion requiring copyright permission, other than the making of an
exact copy.  The resulting work is called a "modified version" of the
earlier work or a work "based on" the earlier work.

  A "covered work" means either the unmodified Program or a work based
on the Program.

  To "propagate" a work means to do anything with it that, without
permission, would make you directly or secondarily liable for
infringement under applicable copyright law, except executing it on a
computer or modifying a private copy.  Propagation includes copying,
distribution (with or without modification), making available to the
public, and in some countries other activities as well.

  To "convey" a work means any kind of propagation that enables other
parties to make or receive copies.  Mere interaction with a user through
a computer network, with no transfer of a copy, is not conveying.

  An interactive user interface displays "Appropriate Legal Notices"
to the extent that it includes a convenient and prominently visible
feature that (1) displays an appropriate copyright notice, and (2)
tells the user that there is no warranty for the work (except to the
extent that warranties are provided), that licensees may convey the
work under this License, and how to view a copy of this License.  If
the interface presents a list of user commands or options, such as a
menu, a prominent item in the list meets this criterion.

  1. Source Code.

  The "source code" for a work means the preferred form of the work
for making modifications to it.  "Object code" means any non-source
form of a work.

  A "Standard Interface" means an interface that either is an official
standard defined by a recognized standards body, or, in the case of
interfaces specified for a particular programming language, one that
is widely used among developers working in that language.

  The "System Libraries" of an executable work include anything, other
than the work as a whole, that (a) is included in the normal form of
packaging a Major Component, but which is not part of that Major
Component, and (b) serves only to enable use of the work with that
Major Component, or to implement a Standard Interface for which an
implementation is available to the public in source code form.  A
"Major Component", in this context, means a major essential component
(kernel, window system, and so on) of the specific operating system
(if any) on which the executable work runs, or a compiler used to
produce the work, or an object code interpreter used to run it.

  The "Corresponding Source" for a work in object code form means all
the source code needed to generate, install, and (for an executable
work) run the object code and to modify the work, including scripts to
control those activities.  However, it does not include the work's
System Libraries, or general-purpose tools or generally available free
programs which are used unmodified in performing those activities but
which are not part of the work.  For example, Corresponding Source
includes interface definition files associated with source files for
the work, and the source code for shared libraries and dynamically
linked subprograms that the work is specifically designed to require,
such as by intimate data communication or control flow between those
subprograms and other parts of the work.

  The Corresponding Source need not include anything that users
can regenerate automatically from other parts of the Corresponding
Source.

  The Corresponding Source for a work in source code form is that
same work.

  2. Basic Permissions.

  All rights granted under this License are granted for the term of
copyright on the Program, and are irrevocable provided the stated
conditions are met.  This License explicitly affirms your unlimited
permission to run the unmodified Program.  The output from running a
covered work is covered by this License only if the output, given its
content, constitutes a covered work.  This License acknowledges your
rights of fair use or other equivalent, as provided by copyright law.

  You may make, run and propagate covered works that you do not
convey, without conditions so long as your license otherwise remains
in force.  You may convey covered works to others for the sole purpose
of having them make modifications exclusively for you, or provide you
with facilities for running those works, provided that you comply with
the terms of this License in conveying all material for which you do
not control copyright.  Those thus making or running the covered works
for you must do so exclusively on your behalf, under your direction
and control, on terms that prohibit them from making any copies of
your copyrighted material outside their relationship with you.

  Conveying under any other circumstances is permitted solely under
the conditions stated below.  Sublicensing is not allowed; section 10
makes it unnecessary.

  3. Protecting Users' Legal Rights From Anti-Circumvention Law.

  No covered work shall be deemed part of an effective technological
measure under any applicable law fulfilling obligations under article
11 of the WIPO copyright treaty adopted on 20 December 1996, or
similar laws prohibiting or restricting circumvention of such
measures.

  When you convey a covered work, you waive any legal power to forbid
circumvention of technological measures to the extent such circumvention
is effected by exercising rights under this License with respect to
the covered work, and you disclaim any intention to limit operation or
modification of the work as a means of enforcing, against the work's
users, your or third parties' legal rights to forbid circumvention of
technological measures.

  4. Conveying Verbatim Copies.

  You may convey verbatim copies of the Program's source code as you
receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy an appropriate copyright notice;
keep intact all notices stating that this License and any
non-permissive terms added in accord with section 7 apply to the code;
keep intact all notices of the absence of any warranty; and give all
recipients a copy of this License along with the Program.

  You may charge any price or no price for each copy that you convey,
and you may offer support or warranty protection for a fee.

  5. Conveying Modified Source Versions.

  You may convey a work based on the Program, or the modifications to
produce it from the Program, in the form of source code under the
terms of section 4, provided that you also meet all of these conditions:

    a) The work must carry prominent notices stating that you modified
    it, and giving a relevant date.

    b) The work must carry prominent notices stating that it is
    released under this License and any conditions added under section
    7.  This requirement modifies the requirement in section 4 to
    "keep intact all notices".

    c) You must license the entire work, as a whole, under this
    License to anyone who comes into possession of a copy.  This
    License will therefore apply, along with any applicable section 7
    additional terms, to the whole of the work, and all its parts,
    regardless of how they are packaged.  This License gives no
    permission to license the work in any other way, but it does not
    invalidate such permission if you have separately received it.

    d) If the work has interactive user interfaces, each must display
    Appropriate Legal Notices; however, if the Program has interactive
    interfaces that do not display Appropriate Legal Notices, your
    work need not make them do so.

  A compilation of a covered work with other separate and independent
works, which are not by their nature extensions of the covered work,
and which are not combined with it such as to form a larger program,
in or on a volume of a storage or distribution medium, is called an
"aggregate" if the compilation and its resulting copyright are not
used to limit the access or legal rights of the compilation's users
beyond what the individual works permit.  Inclusion of a covered work
in an aggregate does not cause this License to apply to the other
parts of the aggregate.

  6. Conveying Non-Source Forms.

  You may convey a covered work in object code form under the terms
of sections 4 and 5, provided that you also convey the
machine-readable Corresponding Source under the terms of this License,
in one of these ways:

    a) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by the
    Corresponding Source fixed on a durable physical medium
    customarily used for software interchange.

    b) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by a
    written offer, valid for at least three years and valid for as
    long as you offer spare parts or customer support for that product
    model, to give anyone who possesses the object code either (1) a
    copy of the Corresponding Source for all the software in the
    product that is covered by this License, on a durable physical
    medium customarily used for software interchange, for a price no
    more than your reasonable cost of physically performing this
    conveying of source, or (2) access to copy the
    Corresponding Source from a network server at no charge.

    c) Convey individual copies of the object code with a copy of the
    written offer to provide the Corresponding Source.  This
    alternative is allowed only occasionally and noncommercially, and
    only if you received the object code with such an offer, in accord
    with subsection 6b.

    d) Convey the object code by offering access from a designated
    place (gratis or for a charge), and offer equivalent access to the
    Corresponding Source in the same way through the same place at no
    further charge.  You need not require recipients to copy the
    Corresponding Source along with the object code.  If the place to
    copy the object code is a network server, the Corresponding Source
    may be on a different server (operated by you or a third party)
    that supports equivalent copying facilities, provided you maintain
    clear directions next to the object code saying where to find the
    Corresponding Source.  Regardless of what server hosts the
    Corresponding Source, you remain obligated to ensure that it is
    available for as long as needed to satisfy these requirements.

    e) Convey the object code using peer-to-peer transmission, provided
    you inform other peers where the object code and Corresponding
    Source of the work are being offered to the general public at no
    charge under subsection 6d.

  A separable portion of the object code, whose source code is excluded
from the Corresponding Source as a System Library, need not be
included in conveying the object code work.

  A "User Product" is either (1) a "consumer product", which means any
tangible personal property which is normally used for personal, family,
or household purposes, or (2) anything designed or sold for incorporation
into a dwelling.  In determining whether a product is a consumer product,
doubtful cases shall be resolved in favor of coverage.  For a particular
product received by a particular user, "normally used" refers to a
typical or common use of that class of product, regardless of the status
of the particular user or of the way in which the particular user
actually uses, or expects or is expected to use, the product.  A product
is a consumer product regardless of whether the product has substantial
commercial, industrial or non-consumer uses, unless such uses represent
the only significant mode of use of the product.

  "Installation Information" for a User Product means any methods,
procedures, authorization keys, or other information required to install
and execute modified versions of a covered work in that User Product from
a modified version of its Corresponding Source.  The information must
suffice to ensure that the continued functioning of the modified object
code is in no case prevented or interfered with solely because
modification has been made.

  If you convey an object code work under this section in, or with, or
specifically for use in, a User Product, and the conveying occurs as
part of a transaction in which the right of possession and use of the
User Product is transferred to the recipient in perpetuity or for a
fixed term (regardless of how the transaction is characterized), the
Corresponding Source conveyed under this section must be accompanied
by the Installation Information.  But this requirement does not apply
if neither you nor any third party retains the ability to install
modified object code on the User Product (for example, the work has
been installed in ROM).

  The requirement to provide Installation Information does not include a
requirement to continue to provide support service, warranty, or updates
for a work that has been modified or installed by the recipient, or for
the User Product in which it has been modified or installed.  Access to a
network may be denied when the modification itself materially and
adversely affects the operation of the network or violates the rules and
protocols for communication across the network.

  Corresponding Source conveyed, and Installation Information provided,
in accord with this section must be in a format that is publicly
documented (and with an implementation available to the public in
source code form), and must require no special password or key for
unpacking, reading or copying.

  7. Additional Terms.

  "Additional permissions" are terms that supplement the terms of this
License by making exceptions from one or more of its conditions.
Additional permissions that are applicable to the entire Program shall
be treated as though they were included in this License, to the extent
that they are valid under applicable law.  If additional permissions
apply only to part of the Program, that part may be used separately
under those permissions, but the entire Program remains governed by
this License without regard to the additional permissions.

  When you convey a copy of a covered work, you may at your option
remove any additional permissions from that copy, or from any part of
it.  (Additional permissions may be written to require their own
removal in certain cases when you modify the work.)  You may place
additional permissions on material, added by you to a covered work,
for which you have or can give appropriate copyright permission.

  Notwithstanding any other provision of this License, for material you
add to a covered work, you may (if authorized by the copyright holders of
that material) supplement the terms of this License with terms:

    a) Disclaiming warranty or limiting liability differently from the
    terms of sections 15 and 16 of this License; or

    b) Requiring preservation of specified reasonable legal notices or
    author attributions in that material or in the Appropriate Legal
    Notices displayed by works containing it; or

    c) Prohibiting misrepresentation of the origin of that material, or
    requiring that modified versions of such material be marked in
    reasonable ways as different from the original version; or

    d) Limiting the use for publicity purposes of names of licensors or
    authors of the material; or

    e) Declining to grant rights under trademark law for use of some
    trade names, trademarks, or service marks; or

    f) Requiring indemnification of licensors and authors of that
    material by anyone who conveys the material (or modified versions of
    it) with contractual assumptions of liability to the recipient, for
    any liability that these contractual assumptions directly impose on
    those licensors and authors.

  All other non-permissive additional terms are considered "further
restrictions" within the meaning of section 10.  If the Program as you
received it, or any part of it, contains a notice stating that it is
governed by this License along with a term that is a further
restriction, you may remove that term.  If a license document contains
a further restriction but permits relicensing or conveying under this
License, you may add to a covered work material governed by the terms
of that license document, provided that the further restriction does
not survive such relicensing or conveying.

  If you add terms to a covered work in accord with this section, you
must place, in the relevant source files, a statement of the
additional terms that apply to those files, or a notice indicating
where to find the applicable terms.

  Additional terms, permissive or non-permissive, may be stated in the
form of a separately written license, or stated as exceptions;
the above requirements apply either way.

  8. Termination.

  You may not propagate or modify a covered work except as expressly
provided under this License.  Any attempt otherwise to propagate or
modify it is void, and will automatically terminate your rights under
this License (including any patent licenses granted under the third
paragraph of section 11).

  However, if you cease all violation of this License, then your
license from a particular copyright holder is reinstated (a)
provisionally, unless and until the copyright holder explicitly and
finally terminates your license, and (b) permanently, if the copyright
holder fails to notify you of the violation by some reasonable means
prior to 60 days after the cessation.

  Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

  Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, you do not qualify to receive new licenses for the same
material under section 10.

  9. Acceptance Not Required for Having Copies.

  You are not required to accept this License in order to receive or
run a copy of the Program.  Ancillary propagation of a covered work
occurring solely as a consequence of using peer-to-peer transmission
to receive a copy likewise does not require acceptance.  However,
nothing other than this License grants you permission to propagate or
modify any covered work.  These actions infringe copyright if you do
not accept this License.  Therefore, by modifying or propagating a
covered work, you indicate your acceptance of this License to do so.

  10. Automatic Licensing of Downstream Recipients.

  Each time you convey a covered work, the recipient automatically
receives a license from the original licensors, to run, modify and
propagate that work, subject to this License.  You are not responsible
for enforcing compliance by third parties with this License.

  An "entity transaction" is a transaction transferring control of an
organization, or substantially all assets of one, or subdividing an
organization, or merging organizations.  If propagation of a covered
work results from an entity transaction, each party to that
transaction who receives a copy of the work also receives whatever
licenses to the work the party's predecessor in interest had or could
give under the previous paragraph, plus a right to possession of the
Corresponding Source of the work from the predecessor in interest, if
the predecessor has it or can get it with reasonable efforts.

  You may not impose any further restrictions on the exercise of the
rights granted or affirmed under this License.  For example, you may
not impose a license fee, royalty, or other charge for exercise of
rights granted under this License, and you may not initiate litigation
(including a cross-claim or counterclaim in a lawsuit) alleging that
any patent claim is infringed by making, using, selling, offering for
sale, or importing the Program or any portion of it.

  11. Patents.

  A "contributor" is a copyright holder who authorizes use under this
License of the Program or a work on which the Program is based.  The
work thus licensed is called the contributor's "contributor version".

  A contributor's "essential patent claims" are all patent claims
owned or controlled by the contributor, whether already acquired or
hereafter acquired, that would be infringed by some manner, permitted
by this License, of making, using, or selling its contributor version,
but do not include claims that would be infringed only as a
consequence of further modification of the contributor version.  For
purposes of this definition, "control" includes the right to grant
patent sublicenses in a manner consistent with the requirements of
this License.

  Each contributor grants you a non-exclusive, worldwide, royalty-free
patent license under the contributor's essential patent claims, to
make, use, sell, offer for sale, import and otherwise run, modify and
propagate the contents of its contributor version.

  In the following three paragraphs, a "patent license" is any express
agreement or commitment, however denominated, not to enforce a patent
(such as an express permission to practice a patent or covenant not to
sue for patent infringement).  To "grant" such a patent license to a
party means to make such an agreement or commitment not to enforce a
patent against the party.

  If you convey a covered work, knowingly relying on a patent license,
and the Corresponding Source of the work is not available for anyone
to copy, free of charge and under the terms of this License, through a
publicly available network server or other readily accessible means,
then you must either (1) cause the Corresponding Source to be so
available, or (2) arrange to deprive yourself of the benefit of the
patent license for this particular work, or (3) arrange, in a manner
consistent with the requirements of this License, to extend the patent
license to downstream recipients.  "Knowingly relying" means you have
actual knowledge that, but for the patent license, your conveying the
covered work in a country, or your recipient's use of the covered work
in a country, would infringe one or more identifiable patents in that
country that you have reason to believe are valid.

  If, pursuant to or in connection with a single transaction or
arrangement, you convey, or propagate by procuring conveyance of, a
covered work, and grant a patent license to some of the parties
receiving the covered work authorizing them to use, propagate, modify
or convey a specific copy of the covered work, then the patent license
you grant is automatically extended to all recipients of the covered
work and works based on it.

  A patent license is "discriminatory" if it does not include within
the scope of its coverage, prohibits the exercise of, or is
conditioned on the non-exercise of one or more of the rights that are
specifically granted under this License.  You may not convey a covered
work if you are a party to an arrangement with a third party that is
in the business of distributing software, under which you make payment
to the third party based on the extent of your activity of conveying
the work, and under which the third party grants, to any of the
parties who would receive the covered work from you, a discriminatory
patent license (a) in connection with copies of the covered work
conveyed by you (or copies made from those copies), or (b) primarily
for and in connection with specific products or compilations that
contain the covered work, unless you entered into that arrangement,
or that patent license was granted, prior to 28 March 2007.

  Nothing in this License shall be construed as excluding or limiting
any implied license or other defenses to infringement that may
otherwise be available to you under applicable patent law.

  12. No Surrender of Others' Freedom.

  If conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot convey a
covered work so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you may
not convey it at all.  For example, if you agree to terms that obligate you
to collect a royalty for further conveying from those to whom you convey
the Program, the only way you could satisfy both those terms and this
License would be to refrain entirely from conveying the Program.

  13. Use with the GNU Affero General Public License.

  Notwithstanding any other provision of this License, you have
permission to link or combine any covered work with a work licensed
under version 3 of the GNU Affero General Public License into a single
combined work, and to convey the resulting work.  The terms of this
License will continue to apply to the part which is the covered work,
but the special requirements of the GNU Affero General Public License,
section 13, concerning interaction through a network will apply to the
combination as such.

  14. Revised Versions of this License.

  The Free Software Foundation may publish revised and/or new versions of
the GNU General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

  Each version is given a distinguishing version number.  If the
Program specifies that a certain numbered version of the GNU General
Public License "or any later version" applies to it, you have the
option of following the terms and conditions either of that numbered
version or of any later version published by the Free Software
Foundation.  If the Program does not specify a version number of the
GNU General Public License, you may choose any version ever published
by the Free Software Foundation.

  If the Program specifies that a proxy can decide which future
versions of the GNU General Public License can be used, that proxy's
public statement of acceptance of a version permanently authorizes you
to choose that version for the Program.

  Later license versions may give you additional or different
permissions.  However, no additional obligations are imposed on any
author or copyright holder as a result of your choosing to follow a
later version.

  15. Disclaimer of Warranty.

  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY
OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

  16. Limitation of Liability.

  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

  17. Interpretation of Sections 15 and 16.

  If the disclaimer of warranty and limitation of liability provided
above cannot be given local legal effect according to their terms,
reviewing courts shall apply local law that most closely approximates
an absolute waiver of all civil liability in connection with the
Program, unless a warranty or assumption of liability accompanies a
copy of the Program in return for a fee.

                     END OF TERMS AND CONDITIONS

            How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
state the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

Also add information on how to contact you by electronic and paper mail.

  If the program does terminal interaction, make it output a short
notice like this when it starts in an interactive mode:

    <program>  Copyright (C) <year>  <name of author>
    This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, your program's commands
might be different; for a GUI interface, you would use an "about box".

  You should also get your employer (if you work as a programmer) or school,
if any, to sign a "copyright disclaimer" for the program, if necessary.
For more information on this, and how to apply and follow the GNU GPL, see
<https://www.gnu.org/licenses/>.

  The GNU General Public License does not permit incorporating your program
into proprietary programs.  If your program is a subroutine library, you
may consider it more useful to permit linking proprietary applications with
the library.  If this is what you want to do, use the GNU Lesser General
Public License instead of this License.  But first, please read
<https://www.gnu.org/licenses/why-not-lgpl.html>.
"""
__version__ = "1.1.0"
__author__ = "Nemo2011"

import copy
import json
import os
import sys
import time
from typing import List, Union

import httpx
import keyboard
import requests
from colorama import Back, Fore, Style, init

from bilibili_api import *

PROXY = None
PATH = "#default"
PATHS = []
RPATH = ""
DIC = "."
FFMPEG = "ffmpeg"
DEFAULT_SETTINGS = False
VIDEO_QUALITY = {
    126: "杜比视界",
    125: "真彩 HDR",
    120: "超清 4K",
    116: "高清 1080P60",
    112: "高清 1080P+",
    80: "高清 1080P",
    64: "高清 720P60",
    32: "清晰 480P",
    16: "流畅 360P",
}
VIDEO_CODECS = {"hev": "HEVC(H.265)", "avc": "AVC(H.264)", "av01": "AV1"}
AUDIO_QUALITY = {30280: "高品质", 30232: "中等品质", 30216: "低品质"}
CREDENTIAL = Credential()
DOWNLOAD_DANMAKUS = "ask"  # (true|false|only)
DOWNLOAD_LIST = False
BANNER = r"""
                                         _____
________   ___   ___        ___          |   |
|\   __  \ |\  \ |\  \      |\  \        |   |
\ \  \|\ /_\ \  \\ \  \     \ \  \       |   |
 \ \   __  \\ \  \\ \  \     \ \  \    --     --
  \ \  \|\  \\ \  \\ \  \____ \ \  \   \       /
   \ \_______\\ \__\\ \_______\\ \__\   \     /
    \|_______| \|__| \|_______| \|__|    \   /
                                          \_/
"""
DEBUG = False
DEFAULT_SETTINGS = {
    "on": False,
    "p": "",
    "vq": "",
    "vc": "",
    "aq": "",
    "at": "",
    "rt": "",
}


init(autoreset=True)


def _ask_settings_download(question: str):
    global DEFAULT_SETTINGS, DOWNLOAD_LIST
    if "下载的分 P" in question and DOWNLOAD_LIST:
        return "all"
    if DEFAULT_SETTINGS["on"]:
        if "下载的分 P" in question:
            return DEFAULT_SETTINGS["p"]
        if "请选择清晰度对应数字" in question:
            return DEFAULT_SETTINGS["vq"]
        if "请选择视频编码" in question:
            return DEFAULT_SETTINGS["vc"]
        if "请选择音质" in question:
            return DEFAULT_SETTINGS["aq"]
        if "请输入想要下载的格式" in question:
            return DEFAULT_SETTINGS["at"]
        if "下载的资源" in question:
            return DEFAULT_SETTINGS["rt"]
        return ""
    else:
        return input(question)


def _download(url: str, out: str, description: str):
    """
    下载函数
    """
    global PROXY
    resp = requests.get(
        url,
        headers={"User-Agent": "Mozilla/5.0", "Referer": "https://www.bilibili.com"},
        proxies={"all://": PROXY},
        stream=True,
    )
    resp.raise_for_status()

    if os.path.exists(out):
        os.remove(out)

    parent = os.path.dirname(out)
    if not os.path.exists(parent):
        os.mkdir(parent)

    print(Fore.MAGENTA + f"DWN: 开始下载 {description} 至 {out}")

    all_length = int(resp.headers["Content-Length"])
    parts = all_length // 1024 + (1 if all_length % 1024 != 0 else 0)
    cnt = 0
    start_time = time.perf_counter()
    print(Fore.MAGENTA + "DWN: " + str(cnt) + "\r", end="")

    with open(out, "wb") as f:
        for chunk in resp.iter_content(1024):
            cnt += 1
            print(
                Fore.MAGENTA
                + "DWN: "
                + str(int(time.perf_counter() - start_time))
                + "s. Done "
                + str(cnt)
                + " parts. All "
                + str(parts)
                + " parts. (1 part = 1024 bytes)"
                + "\r",
                end="",
            )
            f.write(chunk)
    print()
    print(Fore.MAGENTA + "DWN: 完成下载")
    return out


def _require_file_type(filename: str, filetype: str):
    """
    自动修改文件后缀
    """
    if filename == "#default":
        return filename
    if filename.rstrip(filetype) == filename:
        print(Fore.YELLOW + f"WRN: 识别到您的输出文件类型可能有误 (提供的文件名 {filename} 目标{filetype})")
        print(Fore.YELLOW + f"WRN: 您可以使用参数 --disable-filetype-check 忽略")
        repair = input(Fore.BLUE + f"Y/N: 是否自动修复(默认为修复): ")
        if repair.upper() == "N":
            return filename
        else:
            if len(filename.split(".")) == 1:
                print(Fore.YELLOW + f"WRN: 自动添加成 {filename + filetype}")
                return filename + filetype
            now_name = "".join(filename.split(".")[:-1]) + filetype
            print(Fore.YELLOW + f"WRN: 自动替换成 {now_name}")
            return now_name
    else:
        return filename


def _require_ass_for_danmakus(filename: str):
    global DOWNLOAD_DANMAKUS
    if DOWNLOAD_DANMAKUS.upper() == "ONLY":
        return _require_file_type(filename, ".ass")
    else:
        if len(filename.split(".")) == 1:
            return filename + ".ass"
        if filename == filename.rstrip(".ass"):
            now_name = "".join(filename.split(".")[:-1]) + ".ass"
            return now_name
    return filename


def _help():
    """
    显示帮助
    """
    print()
    print('使用方法: bilidown "https://bilibili.com/.../"')
    print(Fore.RED + '注意: 链接为第一个参数, 允许多个链接, 请使用 "|" 隔开每一个链接' + Fore.RESET)
    print(
        '参数:   --out/-o                  文件名(默认为 "#default")                                   "a.mp4"'
    )
    print(Fore.RED + '注意: 允许多个输出文件名, 请使用 "|" 隔开每一个输出文件名' + Fore.RESET)
    print(
        '参数:   --dic/-d                  下载至文件夹(默认为 "default")                              "~/Desktop"'
    )
    print(
        '参数:   --proxy                   代理                                                        "https://user:password@your-proxy.com"'
    )
    print(
        '参数:   --ffmpeg                  ffmpeg 地址(如果没有 ffmpeg 可以使用 "#none")               "ffmpeg"'
    )
    print(
        '参数:   --sessdata                Cookies 中 SESSDATA 的值, 用于下载会员专享、高清晰度        "SECRET绝密SECRET绝密"'
    )
    print(
        "参数:   --danmakus-settings       是否下载弹幕"
        + '                                                "true"'
    )
    print(Fore.RED + "注意: ( true 下载 | false 不下载 | only 只下载弹幕 ) ")
    print(
        f'参数:   --default-settings        下载时的默认设置                                            "128|hev|30216|markdown|1"'
    )
    print(Fore.RED + f"注意: 格式为      (视频清晰度 | 视频编码 | 音频清晰度 | 专栏格式 | 用户空间下载资源)")
    print(
        Fore.RED
        + f"注意: 视频分辨率  (16 (360P) | 32 (480P) | 64 (720P60) | 80 (1080P) | 112 (1080P+) | 116 (1080P60) | 120 (4K) | 125 (HDR) | 126 (杜比视界))) 可以为空{Fore.RESET}"
    )
    print(
        Fore.RED
        + f"注意: 视频编码    (hev HEVC(H.265) | avc AVC(H.264) ｜ av01 AV1)) 可以为空{Fore.RESET}"
    )
    print(
        Fore.RED + f"注意: 音频音质编码(30216 低品质 | 30232 中等品质 ｜ 30280 高品质)) 可以为空{Fore.RESET}"
    )
    print(Fore.RED + f"注意: 专栏格式    (Markdown | JSON)) 可以为空{Fore.RESET}")
    print(Fore.RED + f"注意: 空间资源编码(1 视频 | 2 音频 ｜ 3 专栏)) 可以为空{Fore.RESET}")
    print("参数:   --disable-filetype-check  忽略自动检查文件后缀")
    print("参数:   --download-list           下载视频、音频对应的列表(番剧所有剧集、视频所有分 P、歌单所有音频)")
    print("参数:   --dump-message            将下载的信息输出到文件 bilidown.json")
    print("参数:   --debug                   显示错误详细信息")
    print("参数:   --license                 显示 LICENSE")
    print("参数:   -v                        版本")
    print("参数:   -h                        帮助")
    print()
    print(
        Fore.LIGHTRED_EX
        + "参数 --out/-o 允许使用自定义格式, 如 "
        + Fore.GREEN
        + '"{title} - {bvid} - P{p} - {owner} - {uid}"'
        + Fore.RED
        + " 请务必使用小写"
    )
    print(
        "| {bvid}         -> BVID            | {aid}             -> AID            | {title}          -> 标题             | {p}             -> 分 P        |"
    )
    print(
        "| {owner}        -> UP              | {uid}             -> UP uid         | {bangumi_epid}   -> 番剧 epid        | {bangumi_name}  -> 番剧名      |"
    )
    print(
        "| {bangumi_ep}   -> 番剧第几集      | {cheese_epid}     -> 课程 epid      | {cheese_name}    -> 课程名           | {cheese_ep}     -> 课程第几集  |"
    )
    print(
        "| {bangumi_id}   -> 番剧 season_id  | {cheese_id}       -> 课程 season_id | {cvid}           -> 专栏 cvid        | {live_id}       -> 直播间 id   |"
    )
    print(
        "| {auid}         -> 音频 auid       | {audio_list_name} -> 歌单名         | {audio_list_cnt} -> 歌单的第几个音频 | {audio_list_id} -> 歌单 auid   |"
    )
    print(Fore.LIGHTRED_EX + '在参数最后加上 "#" 表示所有视频均使用此格式, 如 ' + Fore.GREEN + '"{bvid}#"')
    print(Fore.LIGHTRED_EX + '使用 "{#" 和 "}#" 表示 "{" 和 "}"')

    exit()


def _print_banner():
    global BANNER
    print(BANNER)


def _download_video(obj: video.Video, now_file_name: str):
    """
    下载视频
    """
    global VIDEO_QUALITY, VIDEO_CODECS, AUDIO_QUALITY, DIC, RPATH
    print(Fore.GREEN + "INF: 视频 AID: ", obj.get_aid())
    pages_data = sync(obj.get_pages())
    print(Fore.GREEN + "INF: 视频分 P 数: ", len(pages_data))
    if len(pages_data) > 1:
        download_p1 = None
        while download_p1 == None:
            p = _ask_settings_download(
                Fore.BLUE
                + "NUM: 请输入想要下载的分 P 【默认全部下载(输入 all), 或者在数字两边扩上括号，获取此分 P 的信息，如 P(2)】: P"
            )
            if p == "":
                download_p1 = -1
                continue
            if p.upper() == "ALL":
                download_p1 = -1
                continue
            if (p[0] == "(" or p[0] == "（") and (p[-1] == ")" or p[-1] == "）"):
                p = (
                    p.replace("(", "")
                    .replace(")", "")
                    .replace("）", "")
                    .replace("（", "")
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
                data = pages_data[int(p) - 1]
                print(f"INF: P{int(p)}", ": ", data["part"])
            else:
                try:
                    download_p1 = int(p)
                except:
                    pass
        if download_p1 == -1:
            print(Fore.GREEN + f"INF: 已选择所有分 P")
        else:
            print(Fore.GREEN + f"INF: 已选择 {p}, 分 p 编号 {sync(obj.get_cid(int(p) - 1))}")
    else:
        download_p1 = 0
    if download_p1 > -1:
        r = [download_p1]
    else:
        r = range(len(pages_data))
    for download_p in r:
        print(Fore.GREEN + f"INF: 正在获取下载地址(P{download_p + 1})")
        download_url = sync(obj.get_download_url(download_p))
        vinfo = sync(obj.get_info())
        if FFMPEG != "#none":
            if "dash" in download_url.keys():
                now_file_name = _require_file_type(now_file_name, ".mp4")

                data = download_url["dash"]

                videos_data = data["video"]
                video_qualities = []
                video_codecs = []
                for video_data in videos_data:
                    if not video_data["id"] in video_qualities:
                        video_qualities.append(video_data["id"])
                    for codename, description in VIDEO_CODECS.items():
                        if codename in video_data["codecs"]:
                            if not codename in video_codecs:
                                video_codecs.append(codename)
                print(Fore.GREEN + "INF: 视频清晰度：", end="|")
                for q in video_qualities:
                    print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
                print()
                qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
                VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
                print(Fore.GREEN + "INF: 视频编码：", end="|")
                for c in video_codecs:
                    for codename, description in VIDEO_CODECS.items():
                        if codename in c:
                            print(f"  {codename}: {description}", "  |", end="")
                print()
                CODECS = _ask_settings_download(
                    Fore.BLUE + f'STR: 请选择视频编码对应的号码(默认为 "{video_codecs[0]}"): '
                )
                if CODECS == "":
                    CODECS = video_codecs[0]

                audios_data = data["audio"]
                audio_qualities = []
                for audio_data in audios_data:
                    if not audio_data["id"] in audio_qualities:
                        audio_qualities.append(audio_data["id"])
                print(Fore.GREEN + "INF: 音频音质：", end="|")
                for q in audio_qualities:
                    print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
                print()
                qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
                AUDIO_QUALITY_NUMBER = (
                    int(qnuma) if qnuma != "" else max(audio_qualities)
                )

                try:
                    print(
                        Fore.GREEN
                        + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                    )
                    print(
                        Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})"
                    )
                    print(
                        Fore.GREEN
                        + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                    )
                except KeyError:
                    print(Fore.RED + "ERR: 没有目标清晰度/编码/音质")
                    continue
                except Exception as e:
                    raise e

                print()
                download_url = sync(obj.get_download_url(download_p))
                video_url = None
                audio_url = None
                for video_data in download_url["dash"]["video"]:
                    if (
                        video_data["id"] == VIDEO_QUALITY_NUMBER
                        and CODECS in video_data["codecs"]
                    ):
                        video_url = video_data["baseUrl"]
                for audio_data in download_url["dash"]["audio"]:
                    if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                        audio_url = audio_data["baseUrl"]
                if video_url == None:
                    print(Fore.RED + "ERR: 没有目标视频下载链接")
                    exit()
                if audio_url == None:
                    print(Fore.RED + "ERR: 没有目标音频下载链接")
                    exit()
                print(Fore.GREEN + f"INF: 开始下载视频(P{download_p + 1})")
                video_path = _download(
                    video_url,
                    "./video_temp.m4s",
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}) - 视频",
                )
                print(Fore.GREEN + f"INF: 开始下载音频(P{download_p + 1})")
                audio_path = _download(
                    audio_url,
                    "./audio_temp.m4s",
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}) - 音频",
                )
                print(Fore.GREEN + "INF: 下载视频完成 开始混流")
                print(Fore.RESET)
                if now_file_name == "#default":
                    RNAME = (
                        vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}).mp4"
                    )
                else:
                    RNAME = (
                        now_file_name.replace("{bvid}", obj.get_bvid())
                        .replace("{aid}", str(obj.get_aid()))
                        .replace("{owner}", vinfo["owner"]["name"])
                        .replace("{uid}", str(vinfo["owner"]["mid"]))
                        .replace("{title}", vinfo["title"])
                        .replace("{#", "{")
                        .replace("#}", "}")
                    )
                RPATH = os.path.join(DIC, RNAME)
                if not os.path.exists(DIC):
                    os.mkdir(DIC)
                if os.path.exists(RPATH):
                    os.remove(RPATH)
                print(Fore.MAGENTA)
                os.system(
                    f'{FFMPEG} -i ./video_temp.m4s -i ./audio_temp.m4s -vcodec copy -acodec copy "{RPATH}"'
                )
                os.remove("./video_temp.m4s")
                os.remove("./audio_temp.m4s")
                print(Fore.GREEN + f"INF: 混流完成(或用户手动取消)")
                PATHS.append(RPATH)
            elif "durl" in download_url.keys():
                now_file_name = _require_file_type(now_file_name, ".mp4")

                new_download_url = sync(obj.get_download_url(download_p))
                video_audio_url = new_download_url["durl"][0]["url"]
                if now_file_name == "#default":
                    RNAME = (
                        vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}).mp4"
                    )
                else:
                    RNAME = (
                        now_file_name.replace("{bvid}", obj.get_bvid())
                        .replace("{aid}", str(obj.get_aid()))
                        .replace("{owner}", vinfo["owner"]["name"])
                        .replace("{uid}", str(vinfo["owner"]["mid"]))
                        .replace("{title}", vinfo["title"])
                        .replace("{#", "{")
                        .replace("#}", "}")
                    )
                RPATH = os.path.join(DIC, RNAME)
                if not os.path.exists(DIC):
                    os.mkdir(DIC)
                PATH_FLV = RPATH.rstrip(".mp4") + ".flv"
                print(Fore.GREEN + f"INF: 开始下载视频(P{download_p + 1})")
                video_path = _download(
                    video_audio_url,
                    PATH_FLV,
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1})",
                )
                turn_format = _ask_settings_download(
                    Fore.BLUE + "Y/N: 是否转换成 MP4 视频(默认转换): "
                )
                if turn_format.upper() == "N":
                    PATHS.append(PATH_FLV)
                else:
                    print(Fore.GREEN + "INF: 下载视频完成 正在转换格式")
                    if os.path.exists(RPATH):
                        os.remove(RPATH)
                    print(Fore.MAGENTA)
                    os.system(f'{FFMPEG} -i "{PATH_FLV}" "{RPATH}"')
                    print(Fore.GREEN + "INF: 格式转换完成(或用户手动取消)")
                    delete_flv = _ask_settings_download(
                        Fore.BLUE + "Y/N: 是否删除 FLV 文件(默认删除): "
                    )
                    if delete_flv.upper() == "N":
                        PATHS.append(PATH_FLV)
                    else:
                        os.remove(PATH_FLV)
                    PATHS.append(RPATH)
        else:
            if "dash" in download_url.keys():
                now_file_name = _require_file_type(now_file_name, ".mp4")

                data = download_url["dash"]

                videos_data = data["video"]
                video_qualities = []
                video_codecs = []
                for video_data in videos_data:
                    if not video_data["id"] in video_qualities:
                        video_qualities.append(video_data["id"])
                    if not video_data["codecs"] in video_codecs:
                        video_codecs.append(video_data["codecs"])
                print(Fore.GREEN + "INF: 视频清晰度：", end="|")
                for q in video_qualities:
                    print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
                print()
                qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
                VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
                print(Fore.GREEN + "INF: 视频编码：", end="|")
                for c in video_codecs:
                    for codename, description in VIDEO_CODECS.items():
                        if codename in c:
                            print(f"  {codename}: {description}", "  |", end="")
                print()
                CODECS = _ask_settings_download(
                    Fore.BLUE + 'STR: 请选择视频编码对应的号码(默认为 "hev"): '
                )
                if CODECS == "":
                    CODECS = "hev"

                audios_data = data["audio"]
                audio_qualities = []
                for audio_data in audios_data:
                    if not audio_data["id"] in audio_qualities:
                        audio_qualities.append(audio_data["id"])
                print(Fore.GREEN + "INF: 音频音质：", end="|")
                for q in audio_qualities:
                    print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
                print()
                qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
                AUDIO_QUALITY_NUMBER = (
                    int(qnuma) if qnuma != "" else max(audio_qualities)
                )

                print()
                try:
                    print(
                        Fore.GREEN
                        + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                    )
                    print(
                        Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})"
                    )
                    print(
                        Fore.GREEN
                        + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                    )
                except KeyError:
                    print(Fore.RED, "ERR: 没有目标清晰度/编码/音质")
                    exit()
                except Exception as e:
                    raise e

                print()
                download_url = sync(obj.get_download_url(download_p))
                video_url = None
                audio_url = None
                for video_data in download_url["dash"]["video"]:
                    if (
                        video_data["id"] == VIDEO_QUALITY_NUMBER
                        and CODECS in video_data["codecs"]
                    ):
                        video_url = video_data["baseUrl"]
                for audio_data in download_url["dash"]["audio"]:
                    if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                        audio_url = audio_data["baseUrl"]
                if video_url == None:
                    print(Fore.RED + "ERR: 没有目标视频下载链接")
                    exit()
                if audio_url == None:
                    print(Fore.RED + "ERR: 没有目标音频下载链接")
                    exit()
                if now_file_name == "#default":
                    RNAME = (
                        vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}).mp4"
                    )
                else:
                    RNAME = (
                        now_file_name.replace("{bvid}", obj.get_bvid())
                        .replace("{aid}", str(obj.get_aid()))
                        .replace("{owner}", vinfo["owner"]["name"])
                        .replace("{uid}", str(vinfo["owner"]["mid"]))
                        .replace("{title}", vinfo["title"])
                        .replace("{#", "{")
                        .replace("#}", "}")
                    )
                if not os.path.exists(DIC):
                    os.mkdir(DIC)
                print(Fore.GREEN + f"INF: 开始下载视频(P{download_p + 1})")
                video_path = _download(
                    video_url,
                    os.path.join(DIC, "视频 - " + RNAME),
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}) - 视频",
                )
                print(Fore.GREEN + f"INF: 开始下载音频(P{download_p + 1})")
                audio_path = _download(
                    audio_url,
                    os.path.join(DIC, "音频 - " + RNAME),
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}) - 音频",
                )
                PATHS.append(os.path.join(DIC, "视频 - " + RNAME))
                PATHS.append(os.path.join(DIC, "音频 - " + RNAME))
            elif "durl" in download_url.keys():
                now_file_name = _require_file_type(now_file_name, ".flv")

                new_download_url = sync(obj.get_download_url(download_p))
                video_audio_url = new_download_url["durl"][0]["url"]
                if now_file_name == "#default":
                    RNAME = (
                        vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}).flv"
                    )
                else:
                    RNAME = (
                        now_file_name.replace("{bvid}", obj.get_bvid())
                        .replace("{aid}", str(obj.get_aid()))
                        .replace("{owner}", vinfo["owner"]["name"])
                        .replace("{uid}", str(vinfo["owner"]["mid"]))
                        .replace("{title}", vinfo["title"])
                        .replace("{#", "{")
                        .replace("#}", "}")
                    )
                RPATH = os.path.join(DIC, RNAME)
                if not os.path.exists(DIC):
                    os.mkdir(DIC)
                print(Fore.GREEN + f"INF: 开始下载视频(P{download_p + 1})")
                video_path = _download(
                    video_audio_url,
                    RPATH,
                    vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1})",
                )
        print(Fore.GREEN + "INF: ---完成分 P---")
    return download_p1


def _download_episode(obj: bangumi.Episode, now_file_name: str):
    global VIDEO_CODECS, VIDEO_QUALITY, AUDIO_QUALITY, DIC, RPATH
    print(Fore.GREEN + "INF: 视频 AID: ", obj.get_aid())
    title = sync(obj.get_bangumi().get_meta())["media"]["title"]
    vinfo = {"title": sync(obj.get_episode_info())["h1Title"]}
    epcnt = 0
    for ep in sync(obj.get_episode_info())["mediaInfo"]["episodes"]:
        if ep["id"] == obj.get_epid():
            epcnt = int(ep["title"])
    vtitle = vinfo["title"]
    print(Fore.GREEN + f"INF: {title} 第{epcnt}集 {vtitle}")
    print(Fore.GREEN + f"INF: 正在获取下载地址")
    download_url = sync(obj.get_download_url())

    if FFMPEG != "#none":
        if "dash" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            data = download_url["dash"]

            videos_data = data["video"]
            video_qualities = []
            video_codecs = []
            for video_data in videos_data:
                if not video_data["id"] in video_qualities:
                    video_qualities.append(video_data["id"])
                for codename, description in VIDEO_CODECS.items():
                    if codename in video_data["codecs"]:
                        if not codename in video_codecs:
                            video_codecs.append(codename)
            print(Fore.GREEN + "INF: 视频清晰度：", end="|")
            for q in video_qualities:
                print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
            print()
            qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
            VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
            print(Fore.GREEN + "INF: 视频编码：", end="|")
            for c in video_codecs:
                for codename, description in VIDEO_CODECS.items():
                    if codename in c:
                        print(f"  {codename}: {description}", "  |", end="")
            print()
            CODECS = _ask_settings_download(
                Fore.BLUE
                + f'STR: 请选择视频编码对应的号码(avc|av01|hev)(默认为 "{video_codecs[0]}"): '
            )
            CODECS = CODECS.lower()
            if CODECS == "":
                CODECS = video_codecs[0]

            audios_data = data["audio"]
            audio_qualities = []
            for audio_data in audios_data:
                if not audio_data["id"] in audio_qualities:
                    audio_qualities.append(audio_data["id"])
            print(Fore.GREEN + "INF: 音频音质：", end="|")
            for q in audio_qualities:
                print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
            print()
            qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
            AUDIO_QUALITY_NUMBER = int(qnuma) if qnuma != "" else max(audio_qualities)

            try:
                print(
                    Fore.GREEN
                    + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                )
                print(Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})")
                print(
                    Fore.GREEN
                    + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                )
            except KeyError:
                print(Fore.RED, "ERR: 没有目标清晰度/编码/音质")
                exit()
            except Exception as e:
                raise e

            print()
            download_url = sync(obj.get_download_url())
            video_url = None
            audio_url = None
            for video_data in download_url["dash"]["video"]:
                if (
                    video_data["id"] == VIDEO_QUALITY_NUMBER
                    and CODECS in video_data["codecs"]
                ):
                    video_url = video_data["baseUrl"]
            for audio_data in download_url["dash"]["audio"]:
                if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                    audio_url = audio_data["baseUrl"]
            if video_url == None:
                print(Fore.RED + "ERR: 没有目标视频下载链接")
                exit()
            if audio_url == None:
                print(Fore.RED + "ERR: 没有目标音频下载链接")
                exit()
            print(Fore.GREEN + f"INF: 开始下载视频({title} 第{epcnt}集)")
            video_path = _download(
                video_url,
                "./video_temp.m4s",
                vinfo["title"] + f" - {title}(第{epcnt}集) - 视频",
            )
            print(Fore.GREEN + f"INF: 开始下载音频({title} 第{epcnt}集)")
            audio_path = _download(
                audio_url,
                "./audio_temp.m4s",
                vinfo["title"] + f" - {title}(第{epcnt}集) - 音频",
            )
            print(Fore.GREEN + "INF: 下载视频完成 开始混流")
            print(Fore.RESET)
            if now_file_name == "#default":
                RNAME = vinfo["title"] + f" - 番剧 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{title}", vinfo["title"])
                    .replace("{bangumi_id}", str(obj.get_bangumi().get_season_id()))
                    .replace(
                        "{bangumi_name}",
                        sync(obj.get_bangumi().get_meta())["media"]["title"],
                    )
                    .replace("{bangumi_ep}", str(epcnt))
                    .replace("{bangumi_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            if os.path.exists(RPATH):
                os.remove(RPATH)
            print(Fore.MAGENTA)
            os.system(
                f'{FFMPEG} -i ./video_temp.m4s -i ./audio_temp.m4s -vcodec copy -acodec copy "{RPATH}"'
            )
            os.remove("./video_temp.m4s")
            os.remove("./audio_temp.m4s")
            print(Fore.GREEN + f"INF: 混流完成(或用户手动取消)")
            PATHS.append(RPATH)
        elif "durl" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            new_download_url = sync(obj.get_download_url())
            video_audio_url = new_download_url["durl"][0]["url"]
            if now_file_name == "#default":
                RNAME = vinfo["title"] + f" - 番剧 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{title}", vinfo["title"])
                    .replace("{bangumi_id}", str(obj.get_bangumi().get_season_id()))
                    .replace(
                        "{bangumi_name}",
                        sync(obj.get_bangumi().get_meta())["media"]["title"],
                    )
                    .replace("{bangumi_ep}", str(epcnt))
                    .replace("{bangumi_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} 第{epcnt}集)")
            video_path = _download(
                video_audio_url,
                PATH,
                vinfo["title"] + f" - {title}(第{epcnt}集)",
            )
            PATHS.append(RPATH)
    else:
        if "dash" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            data = download_url["dash"]

            videos_data = data["video"]
            video_qualities = []
            video_codecs = []
            for video_data in videos_data:
                if not video_data["id"] in video_qualities:
                    video_qualities.append(video_data["id"])
                for codename, description in VIDEO_CODECS.items():
                    if codename in video_data["codecs"]:
                        if not codename in video_codecs:
                            video_codecs.append(codename)
            print(Fore.GREEN + "INF: 视频清晰度：", end="|")
            for q in video_qualities:
                print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
            print()
            qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
            VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
            print(Fore.GREEN + "INF: 视频编码：", end="|")
            for c in video_codecs:
                for codename, description in VIDEO_CODECS.items():
                    if codename in c:
                        print(f"  {codename}: {description}", "  |", end="")
            print()
            CODECS = _ask_settings_download(
                Fore.BLUE
                + f'STR: 请选择视频编码对应的号码(avc|av01|hev)(默认为 "{video_codecs[0]}"): '
            )
            CODECS = CODECS.lower()
            if CODECS == "":
                CODECS = video_codecs[0]

            audios_data = data["audio"]
            audio_qualities = []
            for audio_data in audios_data:
                if not audio_data["id"] in audio_qualities:
                    audio_qualities.append(audio_data["id"])
            print(Fore.GREEN + "INF: 音频音质：", end="|")
            for q in audio_qualities:
                print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
            print()
            qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
            AUDIO_QUALITY_NUMBER = int(qnuma) if qnuma != "" else max(audio_qualities)

            print()
            try:
                print(
                    Fore.GREEN
                    + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                )
                print(Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})")
                print(
                    Fore.GREEN
                    + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                )
            except KeyError:
                print(Fore.RED, "ERR: 没有目标清晰度/编码/音质")
                exit()
            except Exception as e:
                raise e

            print()
            download_url = sync(obj.get_download_url())
            video_url = None
            audio_url = None
            for video_data in download_url["dash"]["video"]:
                if (
                    video_data["id"] == VIDEO_QUALITY_NUMBER
                    and CODECS in video_data["codecs"]
                ):
                    video_url = video_data["baseUrl"]
            for audio_data in download_url["dash"]["audio"]:
                if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                    audio_url = audio_data["baseUrl"]
            if video_url == None:
                print(Fore.RED + "ERR: 没有目标视频下载链接")
                exit()
            if audio_url == None:
                print(Fore.RED + "ERR: 没有目标音频下载链接")
                exit()
            if now_file_name == "#default":
                RNAME = vinfo["title"] + f" - 番剧 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{title}", vinfo["title"])
                    .replace("{bangumi_id}", str(obj.get_bangumi().get_season_id()))
                    .replace(
                        "{bangumi_name}",
                        sync(obj.get_bangumi().get_meta())["media"]["title"],
                    )
                    .replace("{bangumi_ep}", str(epcnt))
                    .replace("{bangumi_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} 第{epcnt}集)")
            video_path = _download(
                video_url,
                os.path.join(DIC, "视频 - " + RNAME),
                vinfo["title"] + f" - {obj.get_bvid()}({title} 第{epcnt}集) - 视频",
            )
            print(Fore.GREEN + f"INF: 开始下载音频({title} 第{epcnt}集)")
            audio_path = _download(
                audio_url,
                os.path.join(DIC, "音频 - " + RNAME),
                vinfo["title"] + f" - {obj.get_bvid()}({title} 第{epcnt}集) - 音频",
            )
            PATHS.append(os.path.join(DIC, "视频 - " + RNAME))
            PATHS.append(os.path.join(DIC, "音频 - " + RNAME))
        elif "durl" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            new_download_url = sync(obj.get_download_url())
            video_audio_url = new_download_url["durl"][0]["url"]
            if now_file_name == "#default":
                RNAME = vinfo["title"] + f" - 番剧 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{title}", vinfo["title"])
                    .replace("{bangumi_id}", str(obj.get_bangumi().get_season_id()))
                    .replace(
                        "{bangumi_name}",
                        sync(obj.get_bangumi().get_meta())["media"]["title"],
                    )
                    .replace("{bangumi_ep}", str(epcnt))
                    .replace("{bangumi_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} 第{epcnt}集)")
            video_path = _download(
                video_audio_url,
                RPATH,
                vinfo["title"] + f" - {obj.get_bvid()}({title} 第{epcnt}集)",
            )


def _download_cheese_video(obj: cheese.CheeseVideo, now_file_name: str):
    global VIDEO_CODECS, VIDEO_QUALITY, AUDIO_QUALITY, DIC, RPATH
    print(Fore.GREEN + "INF: 视频 AID: ", obj.get_aid())
    vinfo = sync(obj.get_cheese().get_meta())
    vmeta = obj.get_meta()
    vtitle = vmeta["title"]
    title = vinfo["title"]
    epcnt = (
        f"第{str(obj.get_meta()['index'] - 1)}课"
        if obj.get_meta()["index"] != 1
        else "宣导片"
    )
    print(Fore.GREEN + f"INF: {title} {epcnt} {vtitle}")
    print(Fore.GREEN + f"INF: 正在获取下载地址")
    download_url = sync(obj.get_download_url())

    if FFMPEG != "#none":
        if "dash" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            data = download_url["dash"]

            videos_data = data["video"]
            video_qualities = []
            video_codecs = []
            for video_data in videos_data:
                if not video_data["id"] in video_qualities:
                    video_qualities.append(video_data["id"])
                for codename, description in VIDEO_CODECS.items():
                    if codename in video_data["codecs"]:
                        if not codename in video_codecs:
                            video_codecs.append(codename)
            for q in video_qualities:
                print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
            print()
            qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
            VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
            print(Fore.GREEN + "INF: 视频编码：", end="|")
            for c in video_codecs:
                for codename, description in VIDEO_CODECS.items():
                    if codename in c:
                        print(f"  {codename}: {description}", "  |", end="")
            print()
            CODECS = _ask_settings_download(
                Fore.BLUE
                + f'STR: 请选择视频编码对应的号码(avc|av01|hev)(默认为 "{video_codecs[0]}"): '
            )
            CODECS = CODECS.lower()
            if CODECS == "":
                CODECS = video_codecs[0]

            audios_data = data["audio"]
            audio_qualities = []
            for audio_data in audios_data:
                if not audio_data["id"] in audio_qualities:
                    audio_qualities.append(audio_data["id"])
            print(Fore.GREEN + "INF: 音频音质：", end="|")
            for q in audio_qualities:
                print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
            print()
            qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
            AUDIO_QUALITY_NUMBER = int(qnuma) if qnuma != "" else max(audio_qualities)

            try:
                print(
                    Fore.GREEN
                    + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                )
                print(Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})")
                print(
                    Fore.GREEN
                    + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                )
            except KeyError:
                print(Fore.RED, "ERR: 没有目标清晰度/编码/音质")
                exit()
            except Exception as e:
                raise e

            print()
            download_url = sync(obj.get_download_url())
            video_url = None
            audio_url = None
            for video_data in download_url["dash"]["video"]:
                if (
                    video_data["id"] == VIDEO_QUALITY_NUMBER
                    and CODECS in video_data["codecs"]
                ):
                    video_url = video_data["base_url"]
            for audio_data in download_url["dash"]["audio"]:
                if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                    audio_url = audio_data["base_url"]
            if video_url == None:
                print(Fore.RED + "ERR: 没有目标视频下载链接")
                exit()
            if audio_url == None:
                print(Fore.RED + "ERR: 没有目标音频下载链接")
                exit()
            print(Fore.GREEN + f"INF: 开始下载视频({title} {epcnt})")
            video_path = _download(
                video_url,
                "./video_temp.m4s",
                vmeta["title"] + f" - {title}({epcnt}) - 视频",
            )
            print(Fore.GREEN + f"INF: 开始下载音频({title} {epcnt})")
            audio_path = _download(
                audio_url,
                "./audio_temp.m4s",
                vmeta["title"] + f" - {title}({epcnt}) - 音频",
            )
            print(Fore.GREEN + "INF: 下载视频完成 开始混流")
            print(Fore.RESET)
            if now_file_name == "#default":
                RNAME = vmeta["title"] + f" - 课程 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{owner}", vinfo["up_info"]["uname"])
                    .replace("{uid}", str(vinfo["up_info"]["mid"]))
                    .replace("{title}", vmeta["title"])
                    .replace("{cheese_id}", str(obj.get_bangumi().get_season_id()))
                    .replace("{cheese_name}", vinfo["title"])
                    .replace("{cheese_ep}", str(epcnt))
                    .replace("{cheese_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            if os.path.exists(RPATH):
                os.remove(RPATH)
            print(Fore.MAGENTA)
            os.system(
                f'{FFMPEG} -i ./video_temp.m4s -i ./audio_temp.m4s -vcodec copy -acodec copy "{RPATH}"'
            )
            os.remove("./video_temp.m4s")
            os.remove("./audio_temp.m4s")
            print(Fore.GREEN + f"INF: 混流完成(或用户手动取消)")
            PATHS.append(RPATH)
        elif "durl" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            new_download_url = sync(obj.get_download_url())
            video_audio_url = new_download_url["durl"][0]["url"]
            if now_file_name == "#default":
                RNAME = vmeta["title"] + f" - 课程 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{owner}", vinfo["up_info"]["uname"])
                    .replace("{uid}", str(vinfo["up_info"]["mid"]))
                    .replace("{title}", vmeta["title"])
                    .replace("{cheese_id}", str(obj.get_bangumi().get_season_id()))
                    .replace("{cheese_name}", vinfo["title"])
                    .replace("{cheese_ep}", str(epcnt))
                    .replace("{cheese_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} {epcnt})")
            video_path = _download(
                video_audio_url,
                RPATH,
                vmeta["title"] + f" - {title}({epcnt})",
            )
            PATHS.append(RPATH)
    else:
        if "dash" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            data = download_url["dash"]

            videos_data = data["video"]
            video_qualities = []
            video_codecs = []
            for video_data in videos_data:
                if not video_data["id"] in video_qualities:
                    video_qualities.append(video_data["id"])
                for codename, description in VIDEO_CODECS.items():
                    if codename in video_data["codecs"]:
                        if not codename in video_codecs:
                            video_codecs.append(codename)
            print(Fore.GREEN + "INF: 视频清晰度：", end="|")
            for q in video_qualities:
                print(f"  {q}: {VIDEO_QUALITY[q]}", "  |", end="")
            print()
            qnum = _ask_settings_download(Fore.BLUE + "NUM: 请选择清晰度对应数字(默认为最大清晰度): ")
            VIDEO_QUALITY_NUMBER = int(qnum) if qnum != "" else max(video_qualities)
            print(Fore.GREEN + "INF: 视频编码：", end="|")
            for c in video_codecs:
                for codename, description in VIDEO_CODECS.items():
                    if codename in c:
                        print(f"  {codename}: {description}", "  |", end="")
            print()
            CODECS = _ask_settings_download(
                Fore.BLUE
                + f'STR: 请选择视频编码对应的号码(avc|av01|hev)(默认为 "{video_codecs[0]}"): '
            )
            CODECS = CODECS.lower()
            if CODECS == "":
                CODECS = video_codecs[0]

            audios_data = data["audio"]
            audio_qualities = []
            for audio_data in audios_data:
                if not audio_data["id"] in audio_qualities:
                    audio_qualities.append(audio_data["id"])
            print(Fore.GREEN + "INF: 音频音质：", end="|")
            for q in audio_qualities:
                print(f"  {q}: {AUDIO_QUALITY[q]}", "  |", end="")
            print()
            qnuma = _ask_settings_download(Fore.BLUE + "NUM: 请选择音质对应数字(默认为最好音质): ")
            AUDIO_QUALITY_NUMBER = int(qnuma) if qnuma != "" else max(audio_qualities)

            print()
            try:
                print(
                    Fore.GREEN
                    + f"INF: 选择的视频清晰度 {VIDEO_QUALITY[VIDEO_QUALITY_NUMBER]} | ({VIDEO_QUALITY_NUMBER})"
                )
                print(Fore.GREEN + f"INF: 选择的视频编码 {VIDEO_CODECS[CODECS]} | ({CODECS})")
                print(
                    Fore.GREEN
                    + f"INF: 选择的音频音质 {AUDIO_QUALITY[AUDIO_QUALITY_NUMBER]} | ({AUDIO_QUALITY_NUMBER})"
                )
            except KeyError:
                print(Fore.RED, "ERR: 没有目标清晰度/编码/音质")
                exit()
            except Exception as e:
                raise e

            print()
            download_url = sync(obj.get_download_url())
            video_url = None
            audio_url = None
            for video_data in download_url["dash"]["video"]:
                if (
                    video_data["id"] == VIDEO_QUALITY_NUMBER
                    and CODECS in video_data["codecs"]
                ):
                    video_url = video_data["base_url"]
            for audio_data in download_url["dash"]["audio"]:
                if audio_data["id"] == AUDIO_QUALITY_NUMBER:
                    audio_url = audio_data["base_url"]
            if video_url == None:
                print(Fore.RED + "ERR: 没有目标视频下载链接")
                exit()
            if audio_url == None:
                print(Fore.RED + "ERR: 没有目标音频下载链接")
                exit()
            if now_file_name == "#default":
                RNAME = vmeta["title"] + f" - 课程 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{owner}", vinfo["up_info"]["uname"])
                    .replace("{uid}", str(vinfo["up_info"]["mid"]))
                    .replace("{title}", vmeta["title"])
                    .replace("{cheese_id}", str(obj.get_bangumi().get_season_id()))
                    .replace("{cheese_name}", vinfo["title"])
                    .replace("{cheese_ep}", str(epcnt))
                    .replace("{cheese_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} {epcnt})")
            video_path = _download(
                video_url,
                os.path.join(DIC, "视频 - " + RNAME),
                vinfo["title"] + f" - {obj.get_bvid()}({title} {epcnt}) - 视频",
            )
            print(Fore.GREEN + f"INF: 开始下载音频({title} {epcnt})")
            audio_path = _download(
                audio_url,
                os.path.join(DIC, "音频 - " + RNAME),
                vinfo["title"] + f" - {obj.get_bvid()}({title} {epcnt}) - 音频",
            )
            PATHS.append(os.path.join(DIC, "视频 - " + RNAME))
            PATHS.append(os.path.join(DIC, "音频 - " + RNAME))
        elif "durl" in download_url.keys():
            now_file_name = _require_file_type(now_file_name, ".mp4")

            new_download_url = sync(obj.get_download_url())
            video_audio_url = new_download_url["durl"][0]["url"]
            if now_file_name == "#default":
                RNAME = vmeta["title"] + f" - 课程 EP{obj.get_epid()}({title}).mp4"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{owner}", vinfo["up_info"]["uname"])
                    .replace("{uid}", str(vinfo["up_info"]["mid"]))
                    .replace("{title}", vmeta["title"])
                    .replace("{cheese_id}", str(obj.get_bangumi().get_season_id()))
                    .replace("{cheese_name}", vinfo["title"])
                    .replace("{cheese_ep}", str(epcnt))
                    .replace("{cheese_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            RPATH = os.path.join(DIC, RNAME)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            print(Fore.GREEN + f"INF: 开始下载视频({title} {epcnt})")
            video_path = _download(
                video_audio_url,
                RPATH,
                vmeta["title"] + f" - {title}({epcnt})",
            )
            PATHS.append(RPATH)


def _download_danmakus(
    obj: Union[video.Video, bangumi.Episode, cheese.CheeseVideo],
    now_file_name: str,
    download_p1: int = -1,
):
    global PATHS, DOWNLOAD_DANMAKUS
    if DOWNLOAD_DANMAKUS == "ask":
        download_danmakus = input(Fore.BLUE + "Y/N: 此资源支持下载弹幕, 是否下载: ")
    else:
        if DOWNLOAD_DANMAKUS.upper() == "FALSE":
            download_danmakus = "N"
        else:
            download_danmakus = "Y"
    if download_danmakus.upper() == "N":
        return
    else:
        if isinstance(obj, bangumi.Episode):
            title = sync(obj.get_bangumi().get_meta())["media"]["title"]
            epcnt = 0
            vinfo = {"title": sync(obj.get_episode_info())["h1Title"]}
            for ep in sync(obj.get_episode_info())["mediaInfo"]["episodes"]:
                if ep["id"] == obj.get_epid():
                    epcnt = int(ep["title"])
            if now_file_name == "#default":
                RNAME = vinfo["title"] + f" - 番剧 EP{obj.get_epid()}({title}).ass"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{title}", vinfo["title"])
                    .replace("{bangumi_id}", str(obj.get_bangumi().get_season_id()))
                    .replace(
                        "{bangumi_name}",
                        sync(obj.get_bangumi().get_meta())["media"]["title"],
                    )
                    .replace("{bangumi_ep}", str(epcnt))
                    .replace("{bangumi_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            now_name = _require_ass_for_danmakus(RNAME)
            RPATH = os.path.join(DIC, now_name)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            if os.path.exists(RPATH):
                os.remove(RPATH)
            print(Fore.GREEN + f"INF: 开始下载弹幕 " + vinfo["title"])
            sync(ass.make_ass_file_danmakus_xml(obj, out=RPATH))
            print(Fore.GREEN + f"INF: 下载弹幕完成")
            PATHS.append(RPATH)
        elif isinstance(obj, video.Video):
            pages_data = sync(obj.get_pages())
            if download_p1 > -1:
                r = [download_p1]
            else:
                r = range(len(pages_data))
            vinfo = sync(obj.get_info())
            for download_p in r:
                if now_file_name == "#default":
                    RNAME = (
                        vinfo["title"] + f" - {obj.get_bvid()}(P{download_p + 1}).ass"
                    )
                else:
                    RNAME = (
                        now_file_name.replace("{bvid}", obj.get_bvid())
                        .replace("{aid}", str(obj.get_aid()))
                        .replace("{owner}", vinfo["owner"]["name"])
                        .replace("{uid}", str(vinfo["owner"]["mid"]))
                        .replace("{title}", vinfo["title"])
                        .replace("{#", "{")
                        .replace("#}", "}")
                    )
                now_name = _require_ass_for_danmakus(RNAME)
                RPATH = os.path.join(DIC, now_name)
                if not os.path.exists(DIC):
                    os.mkdir(DIC)
                if os.path.exists(RPATH):
                    os.remove(RPATH)
                print(Fore.GREEN + f"INF: 开始下载弹幕(P{download_p + 1}) " + vinfo["title"])
                sync(ass.make_ass_file_danmakus_xml(obj, download_p, out=RPATH))
                print(Fore.GREEN + f"INF: 下载弹幕完成")
                PATHS.append(RPATH)
        elif isinstance(obj, cheese.CheeseVideo):
            vinfo = sync(obj.get_cheese().get_meta())
            vmeta = obj.get_meta()
            title = vinfo["title"]
            if now_file_name == "#default":
                RNAME = vmeta["title"] + f" - 课程 EP{obj.get_epid()}({title}).ass"
            else:
                RNAME = (
                    now_file_name.replace("{bvid}", obj.get_bvid())
                    .replace("{aid}", str(obj.get_aid()))
                    .replace("{owner}", vinfo["up_info"]["uname"])
                    .replace("{uid}", str(vinfo["up_info"]["mid"]))
                    .replace("{title}", vmeta["title"])
                    .replace("{cheese_id}", str(obj.get_bangumi().get_season_id()))
                    .replace("{cheese_name}", vinfo["title"])
                    .replace("{cheese_ep}", str(epcnt))
                    .replace("{cheese_epid}", str(obj.get_epid()))
                    .replace("{#", "{")
                    .replace("#}", "}")
                )
            now_name = _require_ass_for_danmakus(RNAME)
            RPATH = os.path.join(DIC, now_name)
            if not os.path.exists(DIC):
                os.mkdir(DIC)
            if os.path.exists(RPATH):
                os.remove(RPATH)
            print(Fore.GREEN + f"INF: 开始下载弹幕 " + vmeta["title"])
            sync(ass.make_ass_file_danmakus_xml(obj, out=RPATH))
            print(Fore.GREEN + f"INF: 下载弹幕完成")
            PATHS.append(RPATH)


def _download_bangumi(obj: bangumi.Bangumi, now_file_name: str):
    def __download_one_episode(obj: bangumi.Episode, now_file_name: str):
        try:
            if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                _download_episode(obj, now_file_name)
            _download_danmakus(obj, now_file_name)
        except Exception as e:
            print(Fore.RED + f"ERR: {str(e)}")

    ep_list = sync(obj.get_episode_list())["main_section"]["episodes"]
    print(Fore.GREEN + f"INF: 番剧 media_id {obj.get_media_id()}")
    print(Fore.GREEN + f"INF: 番剧共 {len(ep_list)} 集")
    print()
    for ep in ep_list:
        epid = ep["id"]
        __download_one_episode(bangumi.Episode(epid, obj.credential), now_file_name)
        print()


def _download_cheese(obj: cheese.CheeseList, now_file_name: str):
    def __download_one_cheese(obj: cheese.CheeseVideo, now_file_name: str):
        if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
            _download_cheese_video(obj, now_file_name)
        _download_danmakus(obj, now_file_name)

    print(Fore.GREEN + f"INF: 课程 season_id {obj.get_season_id()}")
    course_cnt = sync(obj.get_meta())["ep_count"]
    print(Fore.GREEN + f"INF: 课程共 {course_cnt} 课时")
    cheeses: List[cheese.CheeseVideo]
    cheeses = sync(obj.get_list())
    for c in cheeses:
        try:
            __download_one_cheese(c, now_file_name)
        except Exception as e:
            print(Fore.RED + "ERR: " + str(e))
        print()


def _download_audio(obj: audio.Audio, now_file_name: str):
    global PATHS, DIC
    now_file_name = _require_file_type(now_file_name, ".mp3")
    print(Fore.GREEN + f"INF: 音频 auid {obj.get_auid()}")
    print()
    print(Fore.GREEN + "INF: 正在获取下载地址")
    download_url = sync(obj.get_download_url())["cdns"][0]
    ainfo = sync(obj.get_info())
    title = ainfo["title"]
    print(Fore.GREEN + f"INF: 开始下载 {title}(au{obj.get_auid()})")
    if now_file_name == "#default":
        RNAME = title + " -  au" + str(obj.get_auid()) + ".mp3"
    else:
        RNAME = (
            now_file_name.replace("{auid}", str(obj.get_auid()))
            .replace("{title}", ainfo["title"])
            .replace("{owner}", ainfo["uname"])
            .replace("{uid}", str(ainfo["uid"]))
            .replace("{#", "{")
            .replace("#}", "}")
        )
        if "bvid" in ainfo.keys():
            RNAME = RNAME.replace("{aid}", str(ainfo["aid"])).replace(
                "{bvid}", str(ainfo["bvid"])
            )
    RPATH = os.path.join(DIC, RNAME)
    _download(download_url, RPATH, f"{title} - 音频 au{obj.get_auid()}")
    PATHS.append(RPATH)


def _download_audio_list(obj: audio.AudioList, now_file_name: str):
    cnt = 0
    print(Fore.GREEN + "INF: 歌单 amid: " + str(obj.amid))
    print()
    song_list = sync(obj.get_song_list())
    name = sync(obj.get_info())["title"]
    pageCount = song_list["pageCount"]
    for page in range(1, pageCount + 1):
        songs = sync(obj.get_song_list(page))
        for song in songs["data"]:
            cnt += 1
            new_now_file_name = (
                now_file_name.replace("{audio_list_name}", name)
                .replace("{audio_list_cnt}", str(cnt))
                .replace("{audio_list_id}", str(obj.amid))
                .replace("{#", "{")
                .replace("#}", "}")
            )
            _download_audio(audio.Audio(song["id"], obj.credential), new_now_file_name)
            print()


def _download_favorite_list(obj: favorite_list.FavoriteList, now_file_name: str):
    def __download_one_video(obj: video.Video, now_file_name: str):
        try:
            global DOWNLOAD_DANMAKUS
            if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                video_download_p = _download_video(obj, now_file_name)
            else:
                video_download_p = -1
            _download_danmakus(obj, now_file_name, video_download_p)
        except Exception as e:
            print(Fore.RED + f"ERR: {str(e)}")

    if obj.is_video_favorite_list():
        video_list: List[video.Video] = []
        cnt = 1
        videos = sync(obj.get_content(cnt))
        print(Fore.GREEN + "INF: 此收藏夹有 " + str(videos["info"]["media_count"]) + " 个视频")
        for v in videos["medias"]:
            video_list.append(video.Video(bvid=v["bvid"]))
        next_page = videos["has_more"]
        while next_page:
            cnt += 1
            videos = sync(obj.get_content(cnt))
            for v in videos["medias"]:
                video_list.append(
                    video.Video(bvid=v["bvid"], credential=obj.credential)
                )
            next_page = videos["has_more"]
        print()
        for v in video_list:
            __download_one_video(v, now_file_name)
            print()
    elif obj.get_favorite_list_type() == favorite_list.FavoriteListType.CHEESE:
        cheese_list: List[cheese.CheeseList] = []
        cheeses = sync(obj.get_content())
        pages = cheeses["page"]["total"]
        for page in range(1, pages + 1):
            cheeses = sync(obj.get_content(page))
            for item in cheeses["items"]:
                cheese_list.append(
                    cheese.CheeseList(
                        season_id=item["season_id"], credential=obj.credential
                    )
                )
        print(Fore.GREEN + f"INF: 此收藏夹有 {len(cheese_list)} 个课程")
        for c in cheese_list:
            _download_cheese(c, now_file_name)
            print()
    elif obj.get_favorite_list_type() == favorite_list.FavoriteListType.ARTICLE:
        article_list: List[article.Article] = []
        articles = sync(obj.get_content())
        pages = articles["page"]["total"]
        for page in range(1, pages + 1):
            articles = sync(obj.get_content(page))
            for item in articles["favorites"]:
                article_list.append(
                    article.Article(item["id"], credential=obj.credential)
                )
        print(Fore.GREEN + f"INF: 此收藏夹有 {len(article_list)} 个专栏")
        for a in article_list:
            _download_article(a, now_file_name)


async def _download_liveroom_stream(obj: live.LiveRoom, now_file_name: str):
    global FFMPEG, DIC, PATHS, PROXY
    if FFMPEG == "#none":
        now_file_name = _require_file_type(now_file_name, ".flv")
    else:
        now_file_name = _require_file_type(now_file_name, ".mp4")
    room = obj
    stream_info = await room.get_room_play_url()
    rinfo = (await room.get_room_info())["room_info"]
    url = stream_info["durl"][0]["url"]

    if now_file_name == "#default":
        if FFMPEG == "#none":
            RNAME = rinfo["title"] + " " + str(room.room_display_id) + ".flv"
        else:
            RNAME = rinfo["title"] + " " + str(room.room_display_id) + ".mp4"
    else:
        RNAME = (
            now_file_name.replace(
                "{uid}",
                str(rinfo["uid"]),
            )
            .replace("{owner}", (await user.User(rinfo["uid"]).get_user_info())["name"])
            .replace("{live_id}", str(room.room_display_id))
            .replace("{title}", rinfo["title"])
            .replace("{#", "{")
            .replace("#}", "}")
        )

    print(Fore.GREEN + f"直播间房号: {room.room_display_id}")
    print(Fore.GREEN + f"如果想要停止下载请长按 ESC 键")
    RPATH = os.path.join(DIC, RNAME)

    out = RPATH
    if os.path.exists(out):
        os.remove(out)

    parent = os.path.dirname(out)
    if not os.path.exists(parent):
        os.mkdir(parent)

    byte_cnt = 0
    start_time = time.perf_counter()

    if FFMPEG != "#none":
        RPATH_MP4 = copy.copy(RPATH)
        RPATH = RPATH.rstrip(".mp4") + ".flv"

    resp = requests.get(url, proxies={"all://": PROXY}, headers=HEADERS, stream=True)

    with open(RPATH, "ab") as f:
        for chunk in resp.iter_content(1024):
            byte_cnt += len(chunk)
            if not chunk:
                print(Fore.YELLOW + "WRN: 无更多数据")
                break
            print(
                Fore.MAGENTA
                + f"DWN: "
                + str(int(time.perf_counter() - start_time))
                + f"s. 接收到数据 {byte_cnt}B\r",
                end="",
            )
            f.write(chunk)
            if keyboard.is_pressed("esc"):
                print()
                print(Fore.YELLOW + "WRN: 用户手动停止")
                break

    if FFMPEG == "#none":
        PATHS.append(RPATH)
    else:
        print(Fore.GREEN + "INF: 正在转换格式")
        os.system(f'{FFMPEG} -i "{RPATH}" "{RPATH_MP4}"')
        os.remove(RPATH)
        PATHS.append(RPATH_MP4)


def _download_article(obj: article.Article, now_file_name: str):
    global DIC
    arinfo = sync(obj.get_info())
    artitle = arinfo["title"]
    arowner = arinfo["author_name"]
    armid = arinfo["mid"]
    arcvid = obj.cvid
    print(Fore.GREEN + "INF: 专栏 cv 号 " + str(arcvid))
    print()
    print(Fore.GREEN + "INF: 专栏支持下载为 MarkDown 文件或 JSON 文件")
    filetype = _ask_settings_download(
        Fore.BLUE + "STR: 请输入想要下载的格式(markdown|json)【默认 markdown】: "
    )
    MARKDOWN = True
    if filetype.upper() == "JSON":
        MARKDOWN = False
    print()
    print(Fore.GREEN + "INF: 准备下载专栏({} 格式)".format("Markdown" if MARKDOWN else "JSON"))
    if now_file_name == "#default":
        RNAME = artitle + (".md" if MARKDOWN else ".json")
    else:
        now_file_name = _require_file_type(
            now_file_name, (".md" if MARKDOWN else ".json")
        )
        RNAME = (
            now_file_name.replace("{cvid}", str(arcvid))
            .replace("{mid}", str(armid))
            .replace("{owner}", str(arowner))
            .replace("{title}", str(artitle))
            .replace("{#", "{")
            .replace("#}", "}")
        )
    RPATH = os.path.join(DIC, RNAME)
    if not os.path.exists(DIC):
        os.mkdir(DIC)
    if MARKDOWN:
        with open(RPATH, "w", encoding="utf-8") as f:
            sync(obj.fetch_content())
            f.write(obj.markdown())
    else:
        sync(obj.fetch_content())
        json.dump(obj.json(), open(RPATH, "w", encoding="utf-8"))
    PATHS.append(RPATH)


def _download_user_space(obj: user.User, now_file_name: str):
    def __download_one_video(obj: video.Video, now_file_name: str):
        try:
            global DOWNLOAD_DANMAKUS
            if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                video_download_p = _download_video(obj, now_file_name)
            else:
                video_download_p = -1
            _download_danmakus(obj, now_file_name, video_download_p)
        except Exception as e:
            print(Fore.RED + f"ERR: {str(e)}")

    uinfo = sync(obj.get_user_info())
    uname = uinfo["name"]
    ulevel = uinfo["level"]
    print(Fore.RESET + f"{uname} [LV{ulevel}]")
    print()
    download_type = _ask_settings_download(
        Fore.BLUE + "NUM: 请选择想要下载的资源(1 视频 | 2 音频 ｜ 3 专栏 | 默认下载视频): "
    )

    def get_pages(total, size):
        return total // size + (0 if (total % size == 0) else 1)

    if download_type == "":
        all_videos: List[video.Video] = []
        user_videos = sync(obj.get_videos(ps=30))
        pages = get_pages(user_videos["page"]["count"], user_videos["page"]["ps"])
        for p in range(1, pages + 1):
            user_videos = sync(obj.get_videos(pn=p, ps=30))
            for v in user_videos["list"]["vlist"]:
                all_videos.append(
                    video.Video(bvid=v["bvid"], credential=obj.credential)
                )
        print(Fore.GREEN + f"INF: 用户共有 {len(all_videos)} 个视频")
        print(Fore.GREEN + f"INF: 开始下载")
        print()
        for v in all_videos:
            __download_one_video(v, now_file_name)
            print()
    elif download_type == "1":
        all_videos: List[video.Video] = []
        user_videos = sync(obj.get_videos(ps=30))
        pages = get_pages(user_videos["page"]["count"], user_videos["page"]["ps"])
        for p in range(1, pages + 1):
            user_videos = sync(obj.get_videos(pn=p, ps=30))
            for v in user_videos["list"]["vlist"]:
                all_videos.append(
                    video.Video(bvid=v["bvid"], credential=obj.credential)
                )
        print(Fore.GREEN + f"INF: 用户共有 {len(all_videos)} 个视频")
        print(Fore.GREEN + f"INF: 开始下载")
        print()
        for v in all_videos:
            __download_one_video(v, now_file_name)
            print()
    elif download_type == "2":
        all_audios: List[audio.Audio] = []
        user_audios = sync(obj.get_audios(ps=30))
        pages = user_audios["pageCount"]
        for p in range(1, pages + 1):
            user_audios = sync(obj.get_audios(pn=p, ps=30))
            for a in user_audios["data"]:
                all_audios.append(audio.Audio(a["id"], credential=obj.credential))
        print(Fore.GREEN + f"INF: 用户共有 {len(all_audios)} 个音频")
        print(Fore.GREEN + f"INF: 开始下载")
        print()
        for a in all_audios:
            _download_audio(a, now_file_name)
            print()
    elif download_type == "3":
        all_articles: List[article.Article] = []
        user_articles = sync(obj.get_articles(pn=1, ps=30))
        pages = get_pages(user_articles["count"], 30)
        for p in range(1, pages + 1):
            user_articles = sync(obj.get_articles(pn=p, ps=30))
            for ar in user_articles["articles"]:
                all_articles.append(
                    article.Article(ar["id"], credential=obj.credential)
                )
        print(Fore.GREEN + f"INF: 用户共有 {len(all_articles)} 个专栏")
        print(Fore.GREEN + f"INF: 开始下载")
        print()
        for ar in all_articles:
            _download_article(ar, now_file_name)
            print()


def _parse_args():
    global _require_file_type, DIC, PATH, CREDENTIAL, FFMPEG, PROXY, DEFAULT_SETTINGS, DOWNLOAD_DANMAKUS, DOWNLOAD_LIST

    if "-v" in sys.argv:
        print(__version__)

    if "--license" in sys.argv:
        print(__license__)
        exit()

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--default-settings":
            DEFAULT_SETTINGS["on"] = True
            try:
                settings_string = sys.argv[i + 1]
            except:
                print(Fore.GREEN + f"INF: 识别到下载时的用户默认设置 全部使用自动设置")
            else:
                if settings_string[0] == "-":
                    print(Fore.GREEN + f"INF: 识别到下载时的用户默认设置 全部使用自动设置")
                else:
                    print(Fore.GREEN + f"INF: 识别到下载时的用户默认设置 {settings_string}")
                    setting_s = settings_string.split("|")
                    try:
                        DEFAULT_SETTINGS["vq"] = setting_s[0]
                    except IndexError:
                        DEFAULT_SETTINGS["vq"] = ""
                    try:
                        DEFAULT_SETTINGS["vc"] = setting_s[1]
                    except IndexError:
                        DEFAULT_SETTINGS["vc"] = ""
                    try:
                        DEFAULT_SETTINGS["aq"] = setting_s[2]
                    except IndexError:
                        DEFAULT_SETTINGS["aq"] = ""
                    try:
                        DEFAULT_SETTINGS["at"] = setting_s[3]
                    except IndexError:
                        DEFAULT_SETTINGS["at"] = ""
                    try:
                        DEFAULT_SETTINGS["rt"] = setting_s[4]
                    except IndexError:
                        DEFAULT_SETTINGS["rt"] = ""

    if "--download-list" in sys.argv:
        DOWNLOAD_LIST = True
        print(Fore.GREEN + "INF: 已开启下载全部列表的模式")

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--danmakus-settings":
            DOWNLOAD_DANMAKUS = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 识别到弹幕下载设置为 " + DOWNLOAD_DANMAKUS)

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--out" or arg == "-o":
            PATH = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 识别到文件名为 ", PATH)
            if PATH[-1] == "#":
                print(Fore.GREEN + "INF: 此为全局文件名设置")
        if arg == "--dic" or arg == "-d":
            DIC = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 识别到文件输出地址为 ", DIC)
            if DIC == "#default":
                DIC = "."

    CREDENTIAL = Credential()
    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--sessdata":
            CREDENTIAL.sessdata = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 识别到 SESSDATA = ", CREDENTIAL.sessdata)
            try:
                user_data = sync(user.get_self_info(CREDENTIAL))
            except ResponseCodeException as e:
                print(Fore.YELLOW + "WRN: SESSDATA 无效 (不影响下载)")
            else:
                print(Fore.GREEN + "INF: 欢迎 " + user_data["name"])
    if "--qrcode-login" in sys.argv:
        if CREDENTIAL.sessdata == None:
            print(Fore.GREEN + "INF: 开始扫描二维码登录")
            CREDENTIAL = login.login_with_qrcode()
        try:
            user_data = sync(user.get_self_info(CREDENTIAL))
        except CredentialNoSessdataException:
            print(Fore.YELLOW + "WRN: 登录失败")
        except ResponseCodeException as e:
            print(Fore.YELLOW + "WRN: 登录失败")
        else:
            print(Fore.GREEN + "INF: 欢迎 " + user_data["name"])

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--ffmpeg":
            FFMPEG = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 识别到 FFmpeg 地址为 ", FFMPEG)
            if FFMPEG == "#none":
                print(Fore.YELLOW + "WRN: 用户选择不使用 FFmpeg, 会导致混流、转换格式无法自动执行")

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--proxy":
            p = sys.argv[i + 1]
            print(Fore.GREEN + "INF: 查找到代理：", p)
            try:
                httpx.get("https://www.baidu.com", proxies={"all://": p}, timeout=1)
            except Exception:
                print(Fore.RED, "ERR: 无法成功连接代理。")
                print()
            else:
                PROXY = p
                print(Fore.GREEN + "INF: 使用代理：", PROXY)
                settings.proxy = PROXY

    for i in range(len(sys.argv)):
        arg = sys.argv[i]
        if arg == "--disable-filetype-check":
            print(Fore.GREEN + "INF: 识别到 disable-filetype-check, 已禁用文件后缀自动检查")
            _require_file_type = lambda x, y: x


def _main():
    global PROXY, FFMPEG, PATH, PATHS, DIC, _require_file_type, CREDENTIAL, DOWNLOAD_DANMAKUS, DOWNLOAD_LIST, DEBUG
    # TODO: INFO
    _print_banner()
    print(Fore.LIGHTMAGENTA_EX + "BiliDown: 哔哩哔哩命令行下载器")
    print(Fore.LIGHTMAGENTA_EX + "Powered by Bilibili API")
    print(Fore.LIGHTMAGENTA_EX + "By Nemo2011<yimoxia@outlook.com>")

    if "-h" in sys.argv:
        _help()

    print("使用 -h 获取帮助。")

    if len(sys.argv) == 1:
        print(Fore.YELLOW + "WRN: 请提供参数")
        exit()

    print()

    # TODO: ARGS
    _parse_args()

    # TODO: START
    print(Fore.CYAN + "----------开始下载----------")
    print()

    links = sys.argv[1].split("|")
    cnt = 0
    nsupport = 0
    nsuccess = 0
    for link in links:
        # TODO: PARSE
        print(Fore.GREEN + "INF: 链接 -> " + Fore.RED + f"{link}")
        print(Fore.GREEN + "INF: 正在获取链接信息")
        try:
            download_object = sync(parse_link(link, credential=CREDENTIAL))
        except Exception as e:
            raise e
        if download_object == -1:
            print(Fore.RED + "ERR: 无法获取链接信息。请检查是否有拼写错误。", Style.RESET_ALL)
            nsupport += 1
            print(Fore.CYAN + "----------完成下载----------")
            cnt += 1
            continue
        obj = download_object[0]
        resource_type = download_object[1]
        if resource_type == ResourceType.VIDEO:
            print(Fore.GREEN + "INF: 解析结果：视频")
        elif resource_type == ResourceType.AUDIO:
            print(Fore.GREEN + "INF: 解析结果：音频")
        elif resource_type == ResourceType.EPISODE:
            print(Fore.GREEN + "INF: 解析结果：番剧剧集")
        elif resource_type == ResourceType.CHEESE_VIDEO:
            print(Fore.GREEN + "INF: 解析结果：课程视频")
        elif resource_type == ResourceType.ARTICLE:
            print(Fore.GREEN + "INF: 解析结果：专栏")
        elif resource_type == ResourceType.LIVE:
            print(Fore.GREEN + "INF: 解析结果：直播间")
        elif resource_type == ResourceType.BANGUMI:
            print(Fore.GREEN + "INF: 解析结果: 番剧")
        elif resource_type == ResourceType.AUDIO_LIST:
            print(Fore.GREEN + "INF: 解析结果: 歌单")
        elif resource_type == ResourceType.FAVORITE_LIST:
            print(Fore.GREEN + "INF: 解析结果: 收藏夹")
        elif resource_type == ResourceType.USER:
            print(Fore.GREEN + "INF: 解析结果: 用户")
        else:
            print(Fore.YELLOW, "WRN: 资源不支持下载。", Style.RESET_ALL)
            cnt += 1
            nsupport += 1
            print(Fore.CYAN + "----------完成下载----------")
            continue
        print()

        # TODO: DOWNLOAD
        try:
            now_file_name = PATH.split("|")[cnt]
        except IndexError:
            now_file_name = "#default"
        if PATH[-1] == "#":
            now_file_name = PATH[:-1]
        if now_file_name == "":
            now_file_name = "#default"
        try:
            if resource_type == ResourceType.VIDEO:
                obj: video.Video
                if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                    video_download_p = _download_video(obj, now_file_name)
                else:
                    video_download_p = -1
                _download_danmakus(obj, now_file_name, video_download_p)
            elif resource_type == ResourceType.EPISODE:
                obj: bangumi.Episode
                if DOWNLOAD_LIST:
                    epcnt = 0
                    for ep in sync(obj.get_episode_info())["mediaInfo"]["episodes"]:
                        if ep["id"] == obj.get_epid():
                            epcnt = int(ep["title"])
                    if epcnt == 0:
                        if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                            _download_episode(obj, now_file_name)
                        _download_danmakus(obj, now_file_name)
                    print(Fore.CYAN + "----------完成下载----------")
                    _download_bangumi(obj.get_bangumi(), now_file_name)
                else:
                    if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                        _download_episode(obj, now_file_name)
                    _download_danmakus(obj, now_file_name)
            elif resource_type == ResourceType.CHEESE_VIDEO:
                obj: cheese.CheeseVideo
                if not DOWNLOAD_LIST:
                    if not DOWNLOAD_DANMAKUS.upper() == "ONLY":
                        _download_cheese_video(obj, now_file_name)
                    _download_danmakus(obj, now_file_name)
                else:
                    _download_cheese(obj.get_cheese(), now_file_name)
            elif resource_type == ResourceType.BANGUMI:
                obj: bangumi.Bangumi
                _download_bangumi(obj, now_file_name)
            elif resource_type == ResourceType.AUDIO:
                obj: audio.Audio
                _download_audio(obj, now_file_name)
            elif resource_type == ResourceType.AUDIO_LIST:
                obj: audio.AudioList
                _download_audio_list(obj, now_file_name)
            elif resource_type == ResourceType.LIVE:
                obj: live.LiveRoom
                sync(_download_liveroom_stream(obj, now_file_name))
            elif resource_type == ResourceType.ARTICLE:
                obj: article.Article
                _download_article(obj, now_file_name)
            elif resource_type == ResourceType.FAVORITE_LIST:
                obj: favorite_list.FavoriteList
                _download_favorite_list(obj, now_file_name)
            elif resource_type == ResourceType.USER:
                obj: user.User
                _download_user_space(obj, now_file_name)
            else:
                print(Fore.YELLOW + "WRN: 资源不支持下载。" + Style.RESET_ALL)
                cnt += 1
                nsupport += 1
                print(Fore.CYAN + "----------完成下载----------")
                continue
        except CredentialNoSessdataException:
            print(Fore.RED + "ERR: 未提供 cookies(--sessdata)")
        except Exception as e:
            nsuccess += 1
            if DEBUG:
                raise e
            else:
                print()
                print(Fore.RED + "ERR: " + str(e))
                print(Fore.RED + "详情请使用 --debug 查看")
                print(Fore.CYAN + "----------完成下载----------")
                cnt += 1
                continue
        print(Fore.CYAN + "----------完成下载----------")
        print()
        cnt += 1
    print()
    print(Fore.BLUE + "BiliDown 下载完成")
    report_data = {
        "all": cnt,
        "done": cnt - nsupport - nsuccess,
        "nsupport": nsupport,
        "error": nsuccess,
        "out": PATHS,
    }
    print(
        Style.RESET_ALL
        + f"共 {cnt} 项, 成功 {Fore.GREEN + str(cnt - nsupport - nsuccess) + Fore.RESET} 项, 失败 {Fore.RED + str(nsuccess) + Fore.RESET} 项, 不支持 {Fore.YELLOW + str(nsupport) + Fore.RESET} 项"
    )
    for p in PATHS:
        print(Fore.RESET + p)
    if "--dump-message" in sys.argv:
        json.dump(report_data, open("bilidown.json", "w"))


def main():
    global DEBUG
    if sys.version_info < (3, 8, 0):
        print(Fore.RED + "不支持的版本  BiliDown 需要 Python 版本大于 3.8.0")
        exit()
    if "--debug" in sys.argv:
        DEBUG = True
        print(Fore.CYAN + Back.BLACK + "DEBUG MODE" + Style.RESET_ALL)
        return _main()
    try:
        _main()
    except Exception as e:
        print(Fore.RED + "ERR: " + str(e))
        print(Fore.RED + "详细信息可以使用 --debug 查询")


if __name__ == "__main__":
    main()
