from simulation.interactables.conditions import avatar_on_cell
from simulation.interactables.effects import InvulnerabilityEffect
from simulation.interactables.interactable import _Interactable


class InvulnerabilityPickup(_Interactable):
    def __init__(self, cell):
        super(InvulnerabilityPickup, self).__init__(cell)
        self.temporary = True

        self.conditions.append(avatar_on_cell)
        self.effects.append(InvulnerabilityEffect)

    def get_targets(self):
        return [self.cell.avatar]

    def __repr__(self):
        return "InvulnerabilityPickup(Location={})".format(self.cell.location)

    def serialize(self):
        return {
            "type": "invulnerability",
            "location": {"x": self.cell.location.x, "y": self.cell.location.y},
        }
