<div align="center">

<a href="https://www.zumolabs.ai/?utm_source=github.com&utm_medium=referral&utm_campaign=zpy"><img src="https://github.com/ZumoLabs/zpy/raw/main/docs/assets/zl_tile_logo.png" width="100px"/></a>

**`zpy`: Synthetic data in Blender.**

<p align="center">
  <a href="https://discord.gg/nXvXweHtG8"><img alt="Discord" title="Discord" src="https://img.shields.io/badge/-ZPY Devs-grey?style=for-the-badge&logo=discord&logoColor=white"/></a>
  <a href="https://twitter.com/ZumoLabs"><img alt="Twitter" title="Twitter" src="https://img.shields.io/badge/-@ZumoLabs-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white"/></a>
  <a href="https://www.youtube.com/channel/UCcU2Z8ArljfDzfq7SOz-ytQ"><img alt="Youtube" title="Youtube" src="https://img.shields.io/badge/-ZumoLabs-red?style=for-the-badge&logo=youtube&logoColor=white"/></a>
  <a href="https://pypi.org/project/zpy-zumo/"><img alt="PyPI" title="PyPI" src="https://img.shields.io/badge/-PyPI-yellow?style=for-the-badge&logo=PyPI&logoColor=white"/></a>
  <a href="https://zumolabs.github.io/zpy/"><img alt="Docs" title="Docs" src="https://img.shields.io/badge/-Docs-black?style=for-the-badge&logo=Read%20the%20docs&logoColor=white"/></a>
</p>

</div>

![Synthetic raspberry pi](https://github.com/ZumoLabs/zpy/raw/main/docs/assets/promo_image.png)

## Abstract

Collecting, labeling, and cleaning data for computer vision is a pain. Jump into the future and create your own data instead! Synthetic data is faster to develop with, effectively infinite, and gives you full control to prevent bias and privacy issues from creeping in. We created `zpy` to make synthetic data easy, by simplifying the simulation (sim) creation process and providing an easy way to generate synthetic data at scale.

Check out our full [**documentation** :bookmark_tabs:](https://zumolabs.github.io/zpy/)

## What's New? :rocket:

- (06/08/21) Blender 2.93 Support is out! Latest features can be found [on blender.org](https://www.blender.org/download/releases/2-93/).
- (05/28/21) Check out our [latest article](https://www.zumolabs.ai/post/self-supervised-visual-transformers) on our blog on self-supervised ViTs
- (05/17/21) A new template sim :package:`package`:package: is available, [check it out](https://zumolabs.github.io/zpy/zpy/example/package/).
- (05/14/21) Check out our new [documentation](https://zumolabs.github.io/zpy/)

## Install [:thinking:](https://zumolabs.github.io/zpy/zpy/install/pip/)

You can install `zpy` with pip:

``` 
pip install zpy-zumo
```

More installation instructions can be found in the docs:

- [Install using pip **(Windows/Mac/Linux)**](https://zumolabs.github.io/zpy/zpy/install/pip/)
- [Install Blender Addon from .zip **(Windows/Mac/Linux)**](https://zumolabs.github.io/zpy/addon/install/)
- [Install from script **(Mac/Linux)**](https://zumolabs.github.io/zpy/zpy/install/script/)
- [Developer mode **(Linux)**](https://zumolabs.github.io/zpy/zpy/install/linux/)
- [Developer mode **(Windows)**](https://zumolabs.github.io/zpy/zpy/install/windows/)

    | OS | Status |
    |:-----------|:-----------|
    | Linux | :heavy_check_mark: |
    | MacOS | :heavy_check_mark: |
    | Windows | [zpy#126](https://github.com/ZumoLabs/zpy/issues/126) |

## Contribute [:busts_in_silhouette:](https://zumolabs.github.io/zpy/overview/contribute/)

We welcome community contributions! Search through the [current issues](https://github.com/ZumoLabs/zpy/issues) or open your own.

## License [:page_facing_up:](https://zumolabs.github.io/zpy/overview/license/)

This release of zpy is under the GPLv3 license, a free copyleft license used by Blender. TLDR: Its free, use it!

## Citation [:writing_hand:](https://zumolabs.github.io/zpy/overview/citation/)

If you use `zpy` in your research, we would appreciate the citation!

```bibtex
@misc{zpy,
  title={zpy: Synthetic data for Blender.},
  author={Ponte, H. and Ponte, N. and Crowder, S.},
  journal={GitHub. Note: https://github.com/ZumoLabs/zpy},
  volume={1},
  year={2021}
}
```
