import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#datacenter_id Lan#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#name Lan#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#pcc Lan#pcc}
    */
    readonly pcc?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#public Lan#public}
    */
    readonly public?: boolean | cdktf.IResolvable;
    /**
    * ip_failover block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#ip_failover Lan#ip_failover}
    */
    readonly ipFailover?: LanIpFailover[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#timeouts Lan#timeouts}
    */
    readonly timeouts?: LanTimeouts;
}
export interface LanIpFailover {
}
export declare function lanIpFailoverToTerraform(struct?: LanIpFailover | cdktf.IResolvable): any;
export interface LanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#create Lan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#default Lan#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#delete Lan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan#update Lan#update}
    */
    readonly update?: string;
}
export declare function lanTimeoutsToTerraform(struct?: LanTimeoutsOutputReference | LanTimeouts | cdktf.IResolvable): any;
export declare class LanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LanTimeouts | undefined;
    set internalValue(value: LanTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan ionoscloud_lan}
*/
export declare class Lan extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_lan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/lan ionoscloud_lan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LanConfig
    */
    constructor(scope: Construct, id: string, config: LanConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _pcc?;
    get pcc(): string;
    set pcc(value: string);
    resetPcc(): void;
    get pccInput(): string | undefined;
    private _public?;
    get public(): boolean | cdktf.IResolvable;
    set public(value: boolean | cdktf.IResolvable);
    resetPublic(): void;
    get publicInput(): boolean | cdktf.IResolvable | undefined;
    private _ipFailover?;
    get ipFailover(): LanIpFailover[] | cdktf.IResolvable;
    set ipFailover(value: LanIpFailover[] | cdktf.IResolvable);
    resetIpFailover(): void;
    get ipFailoverInput(): cdktf.IResolvable | LanIpFailover[] | undefined;
    private _timeouts;
    get timeouts(): LanTimeoutsOutputReference;
    putTimeouts(value: LanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
