# Generated by Django 3.2.4 on 2021-07-06 12:37

import django.db.models.deletion
from django.db import (
    migrations,
    models,
)


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AddrObjDivision',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('parentid', models.BigIntegerField(verbose_name='Родительский ID')),
                ('childid', models.BigIntegerField(verbose_name='Дочерний ID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
            ],
            options={
                'verbose_name': 'Операция переподчинения',
                'verbose_name_plural': 'Операции переподчинения',
            },
        ),
        migrations.CreateModel(
            name='AddrObjTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор записи')),
                ('level', models.IntegerField(verbose_name='Уровень адресного объекта')),
                ('shortname', models.CharField(max_length=50, verbose_name='Краткое наименование типа объекта')),
                ('name', models.CharField(max_length=250, verbose_name='Полное наименование типа объекта')),
                ('desc', models.CharField(blank=True, max_length=250, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Тип адресного объекта',
                'verbose_name_plural': 'Типы адресных объектов',
            },
        ),
        migrations.CreateModel(
            name='ApartmentTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор типа (ключ)')),
                ('name', models.CharField(max_length=50, verbose_name='Наименование')),
                ('shortname', models.CharField(blank=True, max_length=50, null=True, verbose_name='Краткое наименование')),
                ('desc', models.CharField(blank=True, max_length=250, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Тип помещения',
                'verbose_name_plural': 'Типы помещений',
            },
        ),
        migrations.CreateModel(
            name='HouseTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('name', models.CharField(max_length=50, verbose_name='Наименование')),
                ('shortname', models.CharField(blank=True, max_length=50, null=True, verbose_name='Краткое наименование')),
                ('desc', models.CharField(blank=True, max_length=250, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Тип дома',
                'verbose_name_plural': 'Типы домов',
            },
        ),
        migrations.CreateModel(
            name='NormativeDocsKinds',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор записи')),
                ('name', models.CharField(max_length=500, verbose_name='Наименование')),
            ],
            options={
                'verbose_name': 'Вид нормативного документа',
                'verbose_name_plural': 'Виды нормативных документов',
            },
        ),
        migrations.CreateModel(
            name='NormativeDocsTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор записи')),
                ('name', models.CharField(max_length=500, verbose_name='Наименование')),
                ('startdate', models.DateField(verbose_name='Дата начала действия записи')),
                ('enddate', models.DateField(verbose_name='Дата окончания действия записи')),
            ],
            options={
                'verbose_name': 'Тип нормативного документа',
                'verbose_name_plural': 'Типы нормативных документов',
            },
        ),
        migrations.CreateModel(
            name='ObjectLevels',
            fields=[
                ('level', models.IntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле. Номер уровня объекта')),
                ('name', models.CharField(max_length=250, verbose_name='Наименование')),
                ('shortname', models.CharField(blank=True, max_length=50, null=True, verbose_name='Краткое наименование')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
            ],
            options={
                'verbose_name': 'Уровень адресного объекта',
                'verbose_name_plural': 'Уровни адресных объектов',
            },
        ),
        migrations.CreateModel(
            name='OperationTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор статуса (ключ)')),
                ('name', models.CharField(max_length=100, verbose_name='Наименование')),
                ('shortname', models.CharField(blank=True, max_length=100, null=True, verbose_name='Краткое наименование')),
                ('desc', models.CharField(blank=True, max_length=250, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Статус действия',
                'verbose_name_plural': 'Статусы действия',
            },
        ),
        migrations.CreateModel(
            name='ParamTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор типа параметра (ключ)')),
                ('name', models.CharField(max_length=50, verbose_name='Наименование')),
                ('code', models.CharField(max_length=50, verbose_name='Краткое наименование')),
                ('desc', models.CharField(blank=True, max_length=120, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Тип параметра',
                'verbose_name_plural': 'Типы параметров',
            },
        ),
        migrations.CreateModel(
            name='ReestrObjects',
            fields=[
                ('objectid', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор объекта')),
                ('createdate', models.DateField(verbose_name='Дата создания')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('updatedate', models.DateField(verbose_name='Дата обновления')),
                ('objectguid', models.CharField(max_length=36, verbose_name='GUID объекта')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего объекта (1 - действующий, 0 - не действующий)')),
                ('levelid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.objectlevels', verbose_name='Уровень объекта')),
            ],
            options={
                'verbose_name': 'Идентификатор адресного элемента',
                'verbose_name_plural': 'Идентификаторы адресных элементов',
            },
        ),
        migrations.CreateModel(
            name='RoomTypes',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор типа (ключ)')),
                ('name', models.CharField(max_length=100, verbose_name='Наименование')),
                ('shortname', models.CharField(blank=True, max_length=50, null=True, verbose_name='Краткое наименование')),
                ('desc', models.CharField(blank=True, max_length=250, null=True, verbose_name='Описание')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Статус активности')),
            ],
            options={
                'verbose_name': 'Тип комнаты',
                'verbose_name_plural': 'Типы комнат',
            },
        ),
        migrations.CreateModel(
            name='Version',
            fields=[
                ('ver', models.IntegerField(primary_key=True, serialize=False)),
                ('date', models.DateField(blank=True, db_index=True, null=True)),
                ('dumpdate', models.DateField(db_index=True)),
                ('complete_xml_url', models.CharField(max_length=255)),
                ('delta_xml_url', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Steads',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.IntegerField(verbose_name='ID изменившей транзакции')),
                ('number', models.CharField(max_length=250, verbose_name='Номер земельного участка')),
                ('previd', models.IntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.IntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
            ],
            options={
                'verbose_name': 'Земельный участок',
                'verbose_name_plural': 'Земельные участки',
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('table', models.CharField(max_length=25, primary_key=True, serialize=False)),
                ('ver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='m3_gar.version')),
            ],
        ),
        migrations.CreateModel(
            name='Rooms',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('number', models.CharField(max_length=50, verbose_name='Номер комнаты или офиса')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
                ('roomtype', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.roomtypes', verbose_name='Тип комнаты или офиса')),
            ],
            options={
                'verbose_name': 'Комната',
                'verbose_name_plural': 'Комнаты',
            },
        ),
        migrations.CreateModel(
            name='Param',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Идентификатор записи')),
                ('objectid', models.BigIntegerField(verbose_name='Глобальный уникальный идентификатор адресного объекта ')),
                ('changeid', models.BigIntegerField(blank=True, null=True, verbose_name='ID изменившей транзакции')),
                ('changeidend', models.BigIntegerField(verbose_name='ID завершившей транзакции')),
                ('value', models.CharField(max_length=8000, verbose_name='Значение параметра')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Дата начала действия записи')),
                ('enddate', models.DateField(verbose_name='Дата окончания действия записи')),
                ('typeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.paramtypes', verbose_name='Тип параметра')),
            ],
            options={
                'verbose_name': 'Параметр',
                'verbose_name_plural': 'Параметры',
            },
        ),
        migrations.CreateModel(
            name='NormativeDocs',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор документа')),
                ('name', models.CharField(max_length=8000, verbose_name='Наименование документа')),
                ('date', models.DateField(verbose_name='Дата документа')),
                ('number', models.CharField(max_length=150, verbose_name='Номер документа')),
                ('updatedate', models.DateField(verbose_name='Дата обновления')),
                ('orgname', models.CharField(blank=True, max_length=255, null=True, verbose_name='Наименование органа создвшего нормативный документ')),
                ('regnum', models.CharField(blank=True, max_length=100, null=True, verbose_name='Номер государственной регистрации')),
                ('regdate', models.DateField(blank=True, null=True, verbose_name='Дата государственной регистрации')),
                ('accdate', models.DateField(blank=True, null=True, verbose_name='Дата вступления в силу нормативного документа')),
                ('comment', models.CharField(blank=True, max_length=8000, null=True, verbose_name='Комментарий')),
                ('kind', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.normativedocskinds', verbose_name='Вид документа')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.normativedocstypes', verbose_name='Тип документа')),
            ],
            options={
                'verbose_name': 'Нормативный документ',
                'verbose_name_plural': 'Нормативные документы',
            },
        ),
        migrations.CreateModel(
            name='MunHierarchy',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('oktmo', models.CharField(blank=True, max_length=11, null=True, verbose_name='Код ОКТМО')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.OneToOneField(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор адресного объекта ')),
                ('parentobjid', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Идентификатор родительского объекта')),
            ],
            options={
                'verbose_name': 'Иерархия в муниципальном делении',
                'verbose_name_plural': 'Иерархия в муниципальном делении',
            },
        ),
        migrations.CreateModel(
            name='Houses',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('housenum', models.CharField(blank=True, max_length=50, null=True, verbose_name='Основной номер дома')),
                ('addnum1', models.CharField(blank=True, max_length=50, null=True, verbose_name='Дополнительный номер дома 1')),
                ('addnum2', models.CharField(blank=True, max_length=50, null=True, verbose_name='Дополнительный номер дома 1')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('addtype1', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.housetypes', verbose_name='Дополнительный тип дома 1')),
                ('addtype2', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.housetypes', verbose_name='Дополнительный тип дома 2')),
                ('housetype', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.housetypes', verbose_name='Основной тип дома')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
            ],
            options={
                'verbose_name': 'Номер дома',
                'verbose_name_plural': 'Номера домов',
            },
        ),
        migrations.CreateModel(
            name='ChangeHistory',
            fields=[
                ('changeid', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='ID изменившей транзакции')),
                ('objectid', models.BigIntegerField(verbose_name='Уникальный ID объекта')),
                ('adrobjectid', models.CharField(max_length=36, verbose_name='Уникальный ID изменившей транзакции (GUID)')),
                ('ndocid', models.BigIntegerField(blank=True, null=True, verbose_name='ID документа')),
                ('changedate', models.DateField(verbose_name='Дата изменения')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Тип операции')),
            ],
            options={
                'verbose_name': 'История изменений',
                'verbose_name_plural': 'История изменений',
            },
        ),
        migrations.CreateModel(
            name='Carplaces',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('number', models.CharField(max_length=50, verbose_name='Номер машиноместа')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
            ],
            options={
                'verbose_name': 'Машино-место',
                'verbose_name_plural': 'Машино-места',
            },
        ),
        migrations.CreateModel(
            name='Apartments',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('number', models.CharField(max_length=50, verbose_name='Номер комнаты')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('aparttype', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.apartmenttypes', verbose_name='Тип комнаты')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
            ],
            options={
                'verbose_name': 'Помещение',
                'verbose_name_plural': 'Помещения',
            },
        ),
        migrations.CreateModel(
            name='AdmHierarchy',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('regioncode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код региона')),
                ('areacode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код района')),
                ('citycode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код города')),
                ('placecode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код населенного пункта')),
                ('plancode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код ЭПС')),
                ('streetcode', models.CharField(blank=True, max_length=4, null=True, verbose_name='Код улицы')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.OneToOneField(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор объекта')),
                ('parentobjid', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Идентификатор родительского объекта')),
            ],
            options={
                'verbose_name': 'Иерархия в административном делении',
                'verbose_name_plural': 'Иерархия в административном делении',
            },
        ),
        migrations.CreateModel(
            name='AddrObj',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False, verbose_name='Уникальный идентификатор записи. Ключевое поле')),
                ('objectguid', models.CharField(max_length=36, verbose_name='Глобальный уникальный идентификатор адресного объекта типа UUID')),
                ('changeid', models.BigIntegerField(verbose_name='ID изменившей транзакции')),
                ('name', models.CharField(max_length=250, verbose_name='Наименование')),
                ('typename', models.CharField(max_length=50, verbose_name='Краткое наименование типа объекта')),
                ('level', models.CharField(max_length=10, verbose_name='Уровень адресного объекта')),
                ('previd', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с предыдущей исторической записью')),
                ('nextid', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор записи связывания с последующей исторической записью')),
                ('updatedate', models.DateField(verbose_name='Дата внесения (обновления) записи')),
                ('startdate', models.DateField(verbose_name='Начало действия записи')),
                ('enddate', models.DateField(verbose_name='Окончание действия записи')),
                ('isactual', models.BooleanField(verbose_name='Статус актуальности адресного объекта ФИАС')),
                ('isactive', models.BooleanField(verbose_name='Признак действующего адресного объекта')),
                ('objectid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.reestrobjects', verbose_name='Глобальный уникальный идентификатор адресного объекта типа INTEGER')),
                ('opertypeid', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='m3_gar.operationtypes', verbose_name='Статус действия над записью – причина появления записи')),
            ],
            options={
                'verbose_name': 'Адресообразующий элемент',
                'verbose_name_plural': 'Адресообразующие элементы',
            },
        ),
    ]
