# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class MfaPolicyRule(pulumi.CustomResource):
    enroll: pulumi.Output[str]
    """
    Should the user be enrolled the first time they LOGIN, the next time they are CHALLENGEd, or NEVER?
    """
    name: pulumi.Output[str]
    """
    Policy Rule Name
    """
    network_connection: pulumi.Output[str]
    """
    Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    """
    network_excludes: pulumi.Output[list]
    """
    The zones to exclude
    """
    network_includes: pulumi.Output[list]
    """
    The zones to include
    """
    policyid: pulumi.Output[str]
    """
    Policy ID of the Rule
    """
    priority: pulumi.Output[float]
    """
    Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
    invalid priority is provided. API defaults it to the last/lowest if not there.
    """
    status: pulumi.Output[str]
    """
    Policy Rule Status: ACTIVE or INACTIVE.
    """
    users_excludeds: pulumi.Output[list]
    """
    Set of User IDs to Exclude
    """
    def __init__(__self__, resource_name, opts=None, enroll=None, name=None, network_connection=None, network_excludes=None, network_includes=None, policyid=None, priority=None, status=None, users_excludeds=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a MfaPolicyRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] enroll: Should the user be enrolled the first time they LOGIN, the next time they are CHALLENGEd, or NEVER?
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[list] network_excludes: The zones to exclude
        :param pulumi.Input[list] network_includes: The zones to include
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[float] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last/lowest if not there.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[list] users_excludeds: Set of User IDs to Exclude
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['enroll'] = enroll
            __props__['name'] = name
            __props__['network_connection'] = network_connection
            __props__['network_excludes'] = network_excludes
            __props__['network_includes'] = network_includes
            if policyid is None:
                raise TypeError("Missing required property 'policyid'")
            __props__['policyid'] = policyid
            __props__['priority'] = priority
            __props__['status'] = status
            __props__['users_excludeds'] = users_excludeds
        super(MfaPolicyRule, __self__).__init__(
            'okta:deprecated/mfaPolicyRule:MfaPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, enroll=None, name=None, network_connection=None, network_excludes=None, network_includes=None, policyid=None, priority=None, status=None, users_excludeds=None):
        """
        Get an existing MfaPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] enroll: Should the user be enrolled the first time they LOGIN, the next time they are CHALLENGEd, or NEVER?
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[list] network_excludes: The zones to exclude
        :param pulumi.Input[list] network_includes: The zones to include
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[float] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last/lowest if not there.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[list] users_excludeds: Set of User IDs to Exclude
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["enroll"] = enroll
        __props__["name"] = name
        __props__["network_connection"] = network_connection
        __props__["network_excludes"] = network_excludes
        __props__["network_includes"] = network_includes
        __props__["policyid"] = policyid
        __props__["priority"] = priority
        __props__["status"] = status
        __props__["users_excludeds"] = users_excludeds
        return MfaPolicyRule(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

