# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class GetMetadataSamlResult:
    """
    A collection of values returned by getMetadataSaml.
    """
    def __init__(__self__, assertions_signed=None, authn_request_signed=None, encryption_certificate=None, entity_id=None, http_post_binding=None, http_redirect_binding=None, id=None, idp_id=None, metadata=None, signing_certificate=None):
        if assertions_signed and not isinstance(assertions_signed, bool):
            raise TypeError("Expected argument 'assertions_signed' to be a bool")
        __self__.assertions_signed = assertions_signed
        """
        whether assertions are signed.
        """
        if authn_request_signed and not isinstance(authn_request_signed, bool):
            raise TypeError("Expected argument 'authn_request_signed' to be a bool")
        __self__.authn_request_signed = authn_request_signed
        """
        whether authn requests are signed.
        """
        if encryption_certificate and not isinstance(encryption_certificate, str):
            raise TypeError("Expected argument 'encryption_certificate' to be a str")
        __self__.encryption_certificate = encryption_certificate
        """
        SAML request encryption certificate.
        """
        if entity_id and not isinstance(entity_id, str):
            raise TypeError("Expected argument 'entity_id' to be a str")
        __self__.entity_id = entity_id
        """
        Entity URL for instance `https://www.okta.com/saml2/service-provider/sposcfdmlybtwkdcgtuf`.
        """
        if http_post_binding and not isinstance(http_post_binding, str):
            raise TypeError("Expected argument 'http_post_binding' to be a str")
        __self__.http_post_binding = http_post_binding
        """
        urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post location from the SAML metadata.
        """
        if http_redirect_binding and not isinstance(http_redirect_binding, str):
            raise TypeError("Expected argument 'http_redirect_binding' to be a str")
        __self__.http_redirect_binding = http_redirect_binding
        """
        urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect location from the SAML metadata.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if idp_id and not isinstance(idp_id, str):
            raise TypeError("Expected argument 'idp_id' to be a str")
        __self__.idp_id = idp_id
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        __self__.metadata = metadata
        """
        raw IdP metadata.
        """
        if signing_certificate and not isinstance(signing_certificate, str):
            raise TypeError("Expected argument 'signing_certificate' to be a str")
        __self__.signing_certificate = signing_certificate
        """
        SAML request signing certificate.
        """
class AwaitableGetMetadataSamlResult(GetMetadataSamlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetadataSamlResult(
            assertions_signed=self.assertions_signed,
            authn_request_signed=self.authn_request_signed,
            encryption_certificate=self.encryption_certificate,
            entity_id=self.entity_id,
            http_post_binding=self.http_post_binding,
            http_redirect_binding=self.http_redirect_binding,
            id=self.id,
            idp_id=self.idp_id,
            metadata=self.metadata,
            signing_certificate=self.signing_certificate)

def get_metadata_saml(idp_id=None,opts=None):
    """
    Use this data source to retrieve SAML IdP metadata from Okta.

    ## Example Usage



    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.idp.get_metadata_saml(id="<idp id>")
    ```



    :param str idp_id: The id of the IdP to retrieve metadata for.
    """
    __args__ = dict()


    __args__['idpId'] = idp_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:idp/getMetadataSaml:getMetadataSaml', __args__, opts=opts).value

    return AwaitableGetMetadataSamlResult(
        assertions_signed=__ret__.get('assertionsSigned'),
        authn_request_signed=__ret__.get('authnRequestSigned'),
        encryption_certificate=__ret__.get('encryptionCertificate'),
        entity_id=__ret__.get('entityId'),
        http_post_binding=__ret__.get('httpPostBinding'),
        http_redirect_binding=__ret__.get('httpRedirectBinding'),
        id=__ret__.get('id'),
        idp_id=__ret__.get('idpId'),
        metadata=__ret__.get('metadata'),
        signing_certificate=__ret__.get('signingCertificate'))
