import random

import click

from coalescenceml import __version__
from coalescenceml.cli.cli import cli
from coalescenceml.cli.utils import info


ascii_arts = {
    "Big money-se": r"""
     ______             __       __  __
    /      \           |  \     /  \|  \
   |  $$$$$$\  ______  | $$\   /  $$| $$
   | $$   \$$ /      \ | $$$\ /  $$$| $$
   | $$      |  $$$$$$\| $$$$\  $$$$| $$
   | $$   __ | $$  | $$| $$\$$ $$ $$| $$
   | $$__/  \| $$__/ $$| $$ \$$$| $$| $$_____
    \$$    $$ \$$    $$| $$  \$ | $$| $$     \
     \$$$$$$   \$$$$$$  \$$      \$$ \$$$$$$$$
    """,
    "Dancing font": r"""
       ____   U  ___ u  __  __     _
    U /"___|   \/"_ \/U|' \/ '|u  |"|
    \| | u     | | | |\| |\/| |/U | | u
     | |/__.-,_| |_| | | |  | |  \| |/__
      \____|\_)-\___/  |_|  |_|   |_____|
      _// \\      \\   <<,-,,-.    //  \\
     (__)(__)    (__)   (./  \.)  (_")("_)
    """,
    "Ghost": r"""
                             _   .-')
                            ( '.( OO )_
       .-----.  .-'),-----. ,--.   ,--.),--.
      '  .--./ ( OO'  .-.  '|   `.'   | |  |.-')
      |  |('-. /   |  | |  ||         | |  | OO )
     /_) |OO  )\_) |  |\|  ||  |'.'|  | |  |`-' |
     ||  |`-'|   \ |  | |  ||  |   |  |(|  '---.'
    (_'  '--'\    `'  '-'  '|  |   |  | |      |
      `-----'      `-----' `--'   `--' `------'
    """,
    "isometric1": r"""
     ___           ___           ___           ___
    /\  \         /\  \         /\__\         /\__\
   /::\  \       /::\  \       /::|  |       /:/  /
  /:/\:\  \     /:/\:\  \     /:|:|  |      /:/  /
 /:/  \:\  \   /:/  \:\  \   /:/|:|__|__   /:/  /
/:/__/ \:\__\ /:/__/ \:\__\ /:/ |::::\__\ /:/__/
\:\  \  \/__/ \:\  \ /:/  / \/__/~~/:/  / \:\  \
 \:\  \        \:\  /:/  /        /:/  /   \:\  \
  \:\  \        \:\/:/  /        /:/  /     \:\  \
   \:\__\        \::/  /        /:/  /       \:\__\
    \/__/         \/__/         \/__/         \/__/
    """,
}


@cli.command()
def version() -> None:
    """Version of CoalescenceML."""
    chosen_graphic = random.choice(list(ascii_arts.keys()))
    info(ascii_arts[chosen_graphic])
    click.echo(click.style(f"version: {__version__}", bold=True))
