# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ecowitt2mqtt',
 'ecowitt2mqtt.backports',
 'ecowitt2mqtt.helpers',
 'ecowitt2mqtt.helpers.calculator',
 'ecowitt2mqtt.helpers.publisher',
 'ecowitt2mqtt.util']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0',
 'asyncio-mqtt>=0.12.1',
 'colorlog>=6.6.0,<7.0.0',
 'fastapi>=0.89.1,<0.93.0',
 'meteocalc>=1.1.0,<2.0.0',
 'python-multipart>=0.0.5,<0.0.6',
 'rapidfuzz>=2.13.0,<3.0.0',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'uvicorn>=0.19.0',
 'uvloop>=0.17.0,<0.18.0',
 'voluptuous>=0.13.1,<0.14.0']

entry_points = \
{'console_scripts': ['ecowitt2mqtt = ecowitt2mqtt.__main__:main']}

setup_kwargs = {
    'name': 'ecowitt2mqtt',
    'version': '2023.2.1',
    'description': 'A small web server to send data from Ecowitt devices to an MQTT Broker',
    'long_description': '![ecowitt2mqtt][logo]\n\n[![CI][ci-badge]][ci]\n[![PyPI][pypi-badge]][pypi]\n[![Docker Hub][docker-hub-badge]][docker-hub]\n[![Version][version-badge]][version]\n[![License][license-badge]][license]\n[![Code Coverage][codecov-badge]][codecov]\n[![Maintainability][maintainability-badge]][maintainability]\n\n<a href="https://www.buymeacoffee.com/bachya1208P" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-orange.png" alt="Buy Me A Coffee" height="41" width="174"></a>\n\n`ecowitt2mqtt` is a small CLI/web server that can receive data from Fine Offset weather\nstations (and their numerous white-labeled counterparts, like Ecowitt and\nAmbient Weather), adjust that data in numerous ways, and send it on to one or more\nMQTT brokers.\n\n- [Installation](#installation)\n- [Python Versions](#python-versions)\n- [Disclaimer](#disclaimer)\n- [Supported Brands](#supported-brands)\n- [Quick Start](#quick-start)\n- [Configuration](#configuration)\n  - [Command Line Options](#command-line-options)\n  - [Environment Variables](#environment-variables)\n  - [Configuration File](#configuration-file)\n  - [Merging Configuration Options](#merging-configuration-options)\n  - [Input Data Formats](#input-data-formats)\n- [Advanced Usage](#advanced-usage)\n  - [Calculated Sensors](#calculated-sensors)\n  - [Battery Configurations](#battery-configurations)\n  - [Unit Systems](#unit-systems)\n  - [Raw Data](#raw-data)\n  - [Home Assistant](#home-assistant)\n  - [Running in the Background](#running-in-the-background)\n  - [Docker](#docker)\n- [Diagnostics](#diagnostics)\n- [Contributing](#contributing)\n\n# Installation\n\n```bash\npip install ecowitt2mqtt\n```\n\n# Python Versions\n\n`ecowitt2mqtt` is currently supported on:\n\n- Python 3.9\n- Python 3.10\n- Python 3.11\n\n# Disclaimer\n\nThe datapoints within this library and documentation constitute estimates and are\nintended to help informed decision making. They should not replace analysis, advice, or\ndiagnosis from trained professionals. Use this data at your own discretion.\n\n# Supported Brands\n\nDespite the name of the library, `ecowitt2mqtt` should support any weather station/gateway\nthat is produced by [Fine Offset](https://www.foshk.com/). This includes brands that\nwhite-label Fine Offset equipment, such as:\n\n- [Ambient Weather][ambient-weather] (U.S.)\n- [Ecowitt][ecowitt] (China, Hong Kong)\n- [Froggit][froggit] (Germany)\n\n...and many others. For more information on how these brands relate to one another, see\nthis forum post: https://www.wxforum.net/index.php?topic=40730.0\n\nAlthough there are some small differences between how these various branded devices are\nconfigured, `ecowitt2mqtt` endeavors to incorporate them all with minimal effort on the\nuser\'s part.\n\n# Quick Start\n\nFirst, install `ecowitt2mqtt` via `pip`:\n\n```bash\n$ pip install ecowitt2mqtt\n```\n\nNext, if you haven\'t already, install the appropriate mobile app to configure your\ndevice. For example:\n\n- Ambient Weather: awnet ([iOS][awnet-ios]/[Android][awnet-google-play])\n- Ecowitt: WS View ([iOS][ws-view-ios]/[Android][ws-view-google-play])\n\nFind the appropriate location in the mobile app to configure a customized upload target\nfor the station\'s data. This will differ depending on the app, but in general, you\nshould select your device and find a screen entitled "Upload" (or similar).\n\n![The "Upload" screen in the awnet app][awnet-upload-screen]\n![The "Upload" screen in the WS View app][ws-view-upload-screen]\n\nFill out the form with the appropriate values and tap `Save`:\n\n- `Protocol Type Same As`: pick the label that matches your brand (e.g., `Ecowitt` for\n  Ecowitt devices)\n- `Server IP / Hostname`: the IP address/hostname of the device running `ecowitt2mqtt`\n- `Path`: `/data/report/` (the default path used by most mobile apps)\n- `Port`: `8080` (the default port on which `ecowitt2mqtt` is served)\n- `Upload Interval`: 16 (a reasonable short number of seconds between publishes)\n\nThen, on the machine where you installed `ecowitt2mqtt`, run it:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --mqtt-topic=ecowitt2mqtt/device_1\n    --input-data-format=ecowitt\n```\n\nWithin the `Upload Interval`, data should begin to appear in the MQTT broker.\n\n# Configuration\n\n`ecowitt2mqtt` can be configured via command line options, environment variables, or a\n(YAML or JSON) config file.\n\n## Command Line Options\n\n```\nusage: ecowitt2mqtt [-h] [--version]\n                    [--battery-override BATTERY_OVERRIDE] [-c config]\n                    [--default-battery-strategy default_battery_strategy]\n                    [--diagnostics] [--disable-calculated-data]\n                    [-e endpoint] [--hass-discovery]\n                    [--hass-discovery-prefix hass_discovery_prefix]\n                    [--hass-entity-id-prefix hass_entity_id_prefix]\n                    [--input-data-format input_data_format]\n                    [--input-unit-system input_unit_system]\n                    [-b mqtt_broker] [-p mqtt_password]\n                    [--mqtt-port mqtt_port] [--mqtt-retain]\n                    [--mqtt-tls] [-t mqtt_topic] [-u mqtt_username]\n                    [--output-unit-system output_unit_system]\n                    [--output-unit-accumulated-precipitation output_unit_accumulated_precipitation]\n                    [--output-unit-distance output_unit_distance]\n                    [--output-unit-humidity output_unit_humidity]\n                    [--output-unit-illuminance output_unit_illuminance]\n                    [--output-unit-precipitation-rate output_unit_precipitation_rate]\n                    [--output-unit-pressure output_unit_pressure]\n                    [--output-unit-speed output_unit_speed]\n                    [--output-unit-temperature output_unit_temperature]\n                    [--port port] [--precision precision] [--raw-data]\n                    [-v]\n\nSend data from an Ecowitt gateway to an MQTT broker\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --version             show program\'s version number and exit\n  --battery-override BATTERY_OVERRIDE\n                        A battery configuration override (format:\n                        key,value)\n  -c config, --config config\n                        A path to a YAML or JSON config file\n  --default-battery-strategy default_battery_strategy\n                        The default battery config strategy to use\n                        (default: boolean)\n  --diagnostics         Output diagnostics\n  --disable-calculated-data\n                        Disable the output of calculated sensors\n  -e endpoint, --endpoint endpoint\n                        The relative endpoint/path to serve\n                        ecowitt2mqtt on (default: /data/report)\n  --hass-discovery      Publish data in the Home Assistant MQTT\n                        Discovery format\n  --hass-discovery-prefix hass_discovery_prefix\n                        The Home Assistant MQTT Discovery topic prefix\n                        to use (default: homeassistant)\n  --hass-entity-id-prefix hass_entity_id_prefix\n                        The prefix to use for Home Assistant entity IDs\n  --input-data-format input_data_format\n                        The input data format used by the gateway\n                        (default: ecowitt)\n  --input-unit-system input_unit_system\n                        The input unit system used by the gateway\n                        (default: imperial)\n  -b mqtt_broker, --mqtt-broker mqtt_broker\n                        The hostname or IP address of an MQTT broker\n  -p mqtt_password, --mqtt-password mqtt_password\n                        A valid password for the MQTT broker\n  --mqtt-port mqtt_port\n                        The listenting port of the MQTT broker\n                        (default: 1883)\n  --mqtt-retain         Instruct the MQTT broker to retain messages\n  --mqtt-tls            Enable MQTT over TLS\n  -t mqtt_topic, --mqtt-topic mqtt_topic\n                        The MQTT topic to publish device data to\n  -u mqtt_username, --mqtt-username mqtt_username\n                        A valid username for the MQTT broker\n  --output-unit-system output_unit_system\n                        The output unit system used by the gateway\n                        (default: imperial)\n  --output-unit-accumulated-precipitation output_unit_accumulated_precipitation\n                        The output unit to use for accumulated\n                        precipitation data points (default: the default\n                        used by the output unit system)\n  --output-unit-distance output_unit_distance\n                        The output unit to use for distance data points\n                        (default: the default used by the output unit\n                        system)\n  --output-unit-humidity output_unit_humidity\n                        The output unit to use for humidity data points\n                        (default: the default used by the output unit\n                        system)\n  --output-unit-illuminance output_unit_illuminance\n                        The output unit to use for illuminance data\n                        points (default: the default used by the output\n                        unit system)\n  --output-unit-precipitation-rate output_unit_precipitation_rate\n                        The output unit to use for precipitation rate\n                        data points (default: the default used by the\n                        output unit system)\n  --output-unit-pressure output_unit_pressure\n                        The output unit to use for pressure data points\n                        (default: the default used by the output unit\n                        system)\n  --output-unit-speed output_unit_speed\n                        The output unit to use for speed data points\n                        (default: the default used by the output unit\n                        system)\n  --output-unit-temperature output_unit_temperature\n                        The output unit to use for temperature data\n                        points (default: the default used by the output\n                        unit system)\n  --port port           The port to serve ecowitt2mqtt on (default:\n                        8080)\n  --precision precision\n                        The precision to output data points at\n                        (default: no limit)\n  --raw-data            Return raw data (don\'t attempt to translate any\n                        values)\n  -v, --verbose         Increase verbosity of logged output\n```\n\n## Environment Variables\n\n- `ECOWITT2MQTT_BATTERY_OVERRIDE`: a semicolon-delimited list of key=value battery\n  overrides (default: `numeric`)\n- `ECOWITT2MQTT_CONFIG`: a path to a YAML or JSON config file (default: `None`)\n- `ECOWITT2MQTT_DEFAULT_BATTERY_STRATEGY`: the default battery config strategy to use\n  (default: `boolean`)\n- `ECOWITT2MQTT_DIAGNOSTICS`: whether to output diagnostics (default: `false`)\n- `ECOWITT2MQTT_DISABLE_CALCULATED_DATA`: whether to disable the output of calculated\n  sensors (default: `false`)\n- `ECOWITT2MQTT_ENDPOINT`: the relative endpoint/path to serve ecowitt2mqtt on (default:\n  `/data/report`)\n- `ECOWITT2MQTT_HASS_DISCOVERY_PREFIX`: the Home Assistant discovery prefix to use\n  (default: `homeassistant`)\n- `ECOWITT2MQTT_HASS_DISCOVERY`: publish data in the Home Assistant MQTT Discovery format\n  (default: `false`)\n- `ECOWITT2MQTT_HASS_ENTITY_ID_PREFIX`: the prefix to use for Home Assistant entity IDs\n  (default: `""`)\n- `ECOWITT2MQTT_INPUT_DATA_FORMAT`: the input data format used by the gateway (default:\n  `ecowitt`)\n- `ECOWITT2MQTT_INPUT_UNIT_SYSTEM`: the input unit system used by the device (default:\n  `imperial`)\n- `ECOWITT2MQTT_MQTT_BROKER`: the hostname or IP address of an MQTT broker\n- `ECOWITT2MQTT_MQTT_PASSWORD`: a valid password for the MQTT broker\n- `ECOWITT2MQTT_MQTT_PORT`: the listenting port of the MQTT broker (default: `1883`)\n- `ECOWITT2MQTT_MQTT_RETAIN`: whether to instruct the MQTT broker to retain messages\n  (default: `false`)\n- `ECOWITT2MQTT_MQTT_TLS`: publish data via MQTT over TLS (default: `false`)\n- `ECOWITT2MQTT_MQTT_TOPIC`: the MQTT topic to publish device data to\n- `ECOWITT2MQTT_MQTT_USERNAME`: a valid username for the MQTT broker\n- `ECOWITT2MQTT_OUTPUT_UNIT_SYSTEM`: the unit system to use in output (default: `imperial`)\n- `ECOWITT2MQTT_OUTPUT_UNIT_TEMPERATURE`: the output unit to use for temperature data\n  points (default: the default used by the output unit system)\n- `ECOWITT2MQTT_PORT`: the port to serve ecowitt2mqtt on (default: `8080`)\n- `ECOWITT2MQTT_PRECISION`: the precision to output data points at (default: no limit)\n- `ECOWITT2MQTT_RAW_DATA`: return raw data (don\'t attempt to translate any values)\n  (default: `false`)\n- `ECOWITT2MQTT_VERBOSE`: increase verbosity of logged output (default: `false`)\n\n## Configuration File\n\nThe configuration file can be formatted as either YAML:\n\n```yaml\n---\nbattery_override:\n  battery_key1: boolean\ndefault_battery_strategy: numeric\ndiagnostics: false\ndisable_calculated_data: false\nendpoint: /data/report\nhass_discovery: false\nhass_discovery_prefix: homeassistant\nhass_entity_id_prefix: test_prefix\ninput_data_format: ecowitt\ninput_unit_system: imperial\nmqtt_broker: 127.0.0.1\nmqtt_password: password\nmqtt_port: 1883\nmqtt_retain: false\nmqtt_tls: false\nmqtt_topic: Test\nmqtt_username: user\noutput_unit_system: imperial\nport: 8080\nraw_data: false\nverbose: false\n```\n\n...or JSON\n\n```json\n{\n  "battery_override": {\n    "battery_key1": "boolean"\n  },\n  "default_battery_strategy": "numeric",\n  "diagnostics": false,\n  "disable_calculated_data": false,\n  "endpoint": "/data/report",\n  "hass_discovery": false,\n  "hass_discovery_prefix": "homeassistant",\n  "hass_entity_id_prefix": "test_prefix"\n  "input_data_format": "ecowitt",\n  "input_unit_system": "imperial",\n  "mqtt_broker": "127.0.0.1",\n  "mqtt_password": "password",\n  "mqtt_port": 1883,\n  "mqtt_retain": true,\n  "mqtt_tls": false,\n  "mqtt_topic": "Test",\n  "mqtt_username": "user",\n  "output_unit_system": "imperial",\n  "port": 8080,\n  "raw_data": false,\n  "verbose": false\n}\n```\n\n...and makes use of the same config options available to the CLI.\n\n### Multiple Gateways\n\nWhen using the configuration file, it is possible to define specific configuration\nparameters for multiple Ecowitt gateways. This is useful if different gateways should\npublish to different MQTT brokers, in different formats, etc.\n\nFirst, you must determine the unique ID for each gateway. This can be observed in the\nlogs when `verbose` is enabled – look for the `PASSKEY` value that the gateway has:\n\n```\nReceived data from the Ecowitt device: {\'PASSKEY\': \'abcde12345\', ...}\n```\n\nThen, in the configuration file, simply add a `gateways` key that contains a mapping of\nany of the existing configuration options (except for `--verbose` and `--diagnostics`,\nwhich can only be defined once and are applied to _every_ configuration). Options that\nremain at the root level of the file are treated as defaults.\n\nFor example, this YAML configuration file:\n\n```yaml\n---\nmqtt_broker: 127.0.0.1\nmqtt_password: password\nmqtt_topic: Test\nmqtt_username: user\n\ngateways:\n  abcde12345:\n    hass_discovery: true\n```\n\n...defines two gateway definitions:\n\n- One that publishes to the `Test` topic on an MQTT broker at `127.0.0.1`\n- One (with a `PASSKEY` of `abcde12345`) that publishes to the same broker, but in Home\n  Assistant MQTT Discovery format.\n\nIn another example, this JSON configuration file:\n\n```json\n{\n  "mqtt_broker": "127.0.0.1",\n  "mqtt_password": "password",\n  "mqtt_port": 1883,\n  "mqtt_topic": "Test",\n  "mqtt_username": "user",\n  "gateways": {\n    "abcde12345": {\n      "mqtt_broker": "192.168.1.100",\n      "mqtt_retain": true,\n      "output_unit_system": "metric"\n    }\n  }\n}\n```\n\n...defines two gateway definitions:\n\n- One that publishes to the `Test` topic on an MQTT broker at `127.0.0.1`\n- One (with a `PASSKEY` of `abcde12345`) that publishes to a different broker\n  (`192.168.1.100`), outputs the data in metric, and retains the data on the broker\n\n## Merging Configuration Options\n\nWhen parsing configuration options, `ecowitt2mqtt` looks at the configuration sources in\nthe following order:\n\n1. Configuration File (Specific Gateway)\n2. Configuration File (Defaults)\n3. Environment Variables\n4. CLI Options\n\nThis allows you to mix and match sources – for instance, you might have "defaults" in\nthe configuration file and override them via environment variables.\n\n## Input Data Formats\n\n`ecowitt2mqtt` currently supports the following input data formats:\n\n- `ambient_weather`\n- `ecowitt`\n\nProvide the correct one to `---input-data-format` based on which device brand you use.\n\n# Advanced Usage\n\n## Calculated Sensors\n\nIn addition to the data coming from a gateway, `ecowitt2mqtt` will automatically deduce\nand published several additional, calculated data points if the requisite underlying\ndata exists:\n\n- **[Absolute Humidity][absolute-humidity]:** the actual volume of water vapor in the\n  air\n- **[Beaufort Scale][beaufort-scale]:** the empirical measure that relates wind speed to\n  observed conditions at sea or on land\n- **[Dew Point][dew-point]:** the temperature to which air must be cooled to become\n  saturated with water vapor, assuming constant air pressure and water content\n- **[Feels Like][heat-index]:** how hot or how cold the air feels to the human body when\n  factoring in variables such as relative humidity, wind speeds, the amount of sunshine,\n  etc.\n- **[Frost Point][frost-point]:** the temperature below 32°F (0°C) at which moisture in\n  the air will condense as a layer of frost on exposed surfaces that are also at a\n  temperature below the frost point\n- **[Frost Risk][frost-point]:** how likely the formation of frost is (based on the\n  `frostpoint`)\n- **[Heat Index][heat-index]:** how hot the air feels to the human body when factoring\n  in relative humidity (applicable when the apparent temperature is higher than the air\n  temperature)\n- **[Humidex][humidex]:** an index number used by Canadian meteorologists to describe\n  how hot the weather feels to the average person, by combining the effect of heat and\n  humidity\n- **[Humidex Perception][humidex]:** a human-friendly interpretation of the Humidex\n- **Relative Strain Index:** a measure of discomfort resulting from the combined effect\n  of temperature and humidity (applicable to heat stress of manual workers under shelter\n  at various metabolic rates)\n- **Relative Strain Index Perception:** a human-friendly interpretation of the Relative\n  Strain Index\n- **[Safe Exposure Times][safe-exposure-times]:** how long different skin types can be\n  in the sun (unprotected) before burning begins according to the\n  [Fitzpatrick Scale][fitzpatrick-scale]\n- **Solar Radiation (%):** the percentage of detected solar radiation illuminance as\n  perceived by the human eye\n- **[Simmer Index][simmer-index]:** an alternative to heat index that describes how how\n  the air feels to the human body in relatively dry environments\n- **[Simmer Zone][simmer-index]:** a human-friendly interpretation of the Simmer Index\n- **[Thermal Perception][dew-point]:** a human-friendly interpretation of the Dew Point\n- **[Wind Chill][wind-chill]:** how cold the air feels to the human body when factoring\n  in relative humidity, wind speed, etc. (applicable when the apparent temperature is\n  lower than the air temperature)\n\n(Special thanks to the excellent [`thermal_comfort` library][thermal-comfort-library] for\ninspiration on many of these.)\n\nIf you would prefer to not have these sensors calculated and published, you can utilize\nthe `--disable-calculated-data` configuration option.\n\n## Battery Configurations\n\nEcowitt devices report battery levels in three different formats:\n\n- `boolean`: `0` represents `OFF` (i.e., the battery is in normal condition) and `1` represents\n  `ON` (i.e., the battery is low).\n- `numeric`: the raw numeric value is interpreted as the number of volts remaining in the\n  battery.\n- `percentage`: the raw numeric value is interpreted as the percentage of voltage\n  remaining the battery.\n\n`ecowitt2mqtt` provides three mechanisms to handle this complexity:\n\n1. A built-in mapping of all currently known battery types to their assumed strategy\n2. A default battery strategy for unknown battery types\n3. User-defined battery strategy overrides\n\n### Built-in Mapping\n\n`ecowitt2mqtt` contains an internal mapping that should automatically transform all\nknown battery types into their correct format.\n\n### Default Battery Strategy\n\nBy using the `--default-battery-strategy` configuration parameter, users can specify how\nunknown battery types should be treated by default.\n\n### Battery Overrides\n\nIndividual batteries can be overridden and given a new strategy. How this is\naccomplished differs slightly based on the configuration method used:\n\n- Command Line Options: provide one or more `--battery-override "batt1=boolean"` options\n- Environment Variables: provide a `ECOWITT2MQTT_BATTERY_OVERRIDE` variable that is a\n  semicolon-delimited pair of "key=value" strings (e.g.,\n  `ECOWITT2MQTT_BATTERY_OVERRIDE="batt1=boolean;batt2=numeric"`)\n- Config File: include a dictionary of key/value pairs in either YAML or JSON format\n\nThese overrides work on both known and unknown battery types; that said, if you should\nfind the need to override a known battery type because `ecowitt2mqtt` has an incorrect\ninternal interpretation, submit an issue to get it corrected!\n\n### Example\n\nIn this example, a user mostly has batteries that should be treated as `boolean`, but\nalso has one – `wh60_batt1` – that should be treated as numeric.\n\n#### Command Line Options\n\n```\n$ ecowitt2mqtt --default-battery-strategy boolean --battery-override="wh60_batt1=numeric"\n```\n\n#### Environment Variables\n\n```\n$ ECOWITT2MQTT_DEFAULT_BATTERY_STRATEGY=boolean \\\n  ECOWITT2MQTT_BATTERY_OVERRIDE="wh60_batt1=numeric" \\\n  ecowitt2mqtt\n```\n\n#### Config File\n\nIn YAML:\n\n```yaml\n---\ndefault_battery_strategy: boolean\nbattery_override:\n  wh60_batt1: numeric\n```\n\n...or JSON\n\n```json\n{\n  "default_battery_strategy": "boolean",\n  "battery_override": {\n    "wh60_batt1": "numeric"\n  }\n}\n```\n\n## Unit Systems\n\n### Input and Output\n\n`ecowitt2mqtt` allows you to specify both the input and output unit systems for a device\nvia the `--input-unit-system` and `--output-unit-system` config options, respectively.\nThese are fairly self-explanatory, but take care to use an `--input-unit-system` that is\nconsistent with what your device provides (otherwise, your data will be very "off").\n\n### Overriding Units for Data Categories\n\nIf you wish, you can change the unit for individual data categories. For example, let\'s\nsay you wanted to use metric for the output unit system, but wanted to represent all\ntemperature data points in Kelvin – you would provide `--output-unit-system=metric` and\n`--output-unit-temperature=K` as config options. As expected, the value is properly\nconverted to the new unit.\n\n#### Accumulated Precipitation\n\nConfig Option: `--output-unit-accumulated-precipitation`\n\n- `in`\n- `mm`\n\n#### Absolute Humidity\n\nConfig Option: `--output-unit-humidity`\n\n- `g/m³`\n- `lbs/ft³`\n\n#### Illuminance\n\nConfig Option: `--output-unit-illuminance`\n\n- `fc`\n- `kfc`\n- `klx`\n- `lx`\n- `W/m²`\n\n#### Precipitation Rate\n\nConfig Option: `--output-unit-precipitation-rate`\n\n- `in/h`\n- `mm/h`\n\n#### Pressure\n\nConfig Option: `--output-unit-pressure`\n\n- `bar`\n- `cbar`\n- `hPa`\n- `inHg`\n- `kPa`\n- `mbar`\n- `mmHg`\n- `Pa`\n- `psi`\n\n#### Speed\n\nConfig Option: `--output-unit-speed`\n\n- `ft/s`\n- `in/d`\n- `in/h`\n- `km/h`\n- `kn`\n- `m/s`\n- `mph`\n- `mm/d`\n\n#### Temperature\n\nConfig Option: `--output-unit-temperature`\n\n- `°C`\n- `°F`\n- `K`\n\n## Raw Data\n\nIn some cases, it may be preferable to prevent `ecowitt2mqtt` from doing any data\ntranslation (converting values to a new unit system, changing binary values – such as\nmight be used by a battery – into "friendly" values, etc.). Passing the `--raw-data` flag\nwill accomplish this: data will flow directly from the Ecowitt device to the MQTT broker\nas-is.\n\nNote that the `--raw-data` flag supersedes any that might cause data translation (such as\n`--input-unit-system` or `--output-unit-system`).\n\n## Home Assistant\n\n### MQTT Discovery\n\n[Home Assistant][home-assistant] users can quickly add entities from an Ecowitt device\nby using [MQTT Discovery][home-assistant-mqtt-discovery]. Once Home Assistant is\nconfigured to accept MQTT Discovery, `ecowitt2mqtt` simply needs the `--hass-discovery`\nflag:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --hass-discovery\n```\n\n### Custom Entity ID Prefix\n\nYou can provide a custom prefix for all Home Assistant entities via the\n`--hass-entity-id-prefix` config parameter.\n\n### Home Assistant OS Add-on\n\nHome Assistant OS users can install the official `ecowitt2mqtt` add-on by clicking the\nlink below:\n\n[![Home Assistant Add-on][home-assistant-addon-badge]][home-assistant-addon]\n\n## Running in the Background\n\n`ecowitt2mqtt` doesn\'t, itself, provide any sort of daemonization mechanism. The suggested\nroute is to use a different application.\n\n### `supervisord`\n\nAn example `supervisord` configuration file might look like this:\n\n```\n[supervisord]\nnodaemon=true\nloglevel=info\nuser=root\n\n[program:ecowitt2mqtt]\ncommand=ecowitt2mqtt --mqtt-broker=192.168.1.101 --mqtt-username=user --mqtt-password=password\nstdout_logfile=/dev/stdout\nstdout_logfile_maxbytes=0\nredirect_stderr=true\n```\n\n### `systemd`\n\nAn example `systemd` service file in `/etc/systemd/system` might look like this:\n\n```\n[Unit]\nDescription=ECOWITT2MQTT daemon\nAfter=network.target\n\n[Service]\nType=simple\nExecStart=ecowitt2mqtt --mqtt-broker=192.168.1.101 --mqtt-username=user --mqtt-password=password\nExecReload=kill -HUP $MAINPID\nKillMode=process\nRestart=on-failure\nRestartSec=5s\n\n[Install]\nWantedBy=multi-user.target\n```\n\nTo enable the service:\n\n```bash\n$ systemctl enable ecowitt2mqtt\n```\n\n## Docker\n\nThe library is available via a Docker image from both [Docker Hub][docker-hub] and\n[ghcr.io][ghcr]. It is configured by using the same environment variables listed\n[above](#environment-variables).\n\nRunning the image is straightforward:\n\n```\ndocker run -it \\\n    -e ECOWITT2MQTT_MQTT_BROKER=192.168.1.101 \\\n    -e ECOWITT2MQTT_MQTT_USERNAME=user \\\n    -e ECOWITT2MQTT_MQTT_PASSWORD=password \\\n    -p 8080:8080 \\\n    bachya/ecowitt2mqtt:latest\n```\n\nNote the value of the `-p` flag: you must expose the port defined by the `PORT`\nenvironment variable. In the example above, the default port (`8080`) is used and is\nexposed via the same port on the host.\n\n[`docker-compose`][docker-compose] users can find an example configuration file at\n[`docker-compose.dev.yml`](docker-compose.dev.yml). Note that this is intended to be a dev\nenvironment for quickly testing the repo itself; in production, you should refer to one\nof the published images.\n\n# Diagnostics\n\nYou may run `ecowitt2mqtt` in diagnostics mode by providing the `--diagnostics` flag. In\nthis mode, the app will wait until it receives and publishes a single payload, then\nexit. This allows users to collect a small-but-complete payload for use in testing,\ndebugging, and issue reporting.\n\n# Contributing\n\nThanks to all of [our contributors][contributors] so far!\n\n1. [Check for open features/bugs][issues] or [initiate a discussion on one][new-issue].\n2. [Fork the repository][fork].\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./.venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix on a new branch.\n7. Write tests that cover your new functionality.\n8. Run tests and ensure 100% code coverage: `poetry run pytest --cov ecowitt2mqtt tests`\n9. Update `README.md` with any new documentation.\n10. Submit a pull request!\n\n[absolute-humidity]: https://en.wikipedia.org/wiki/Humidity#Absolute_humidity\n[ambient-weather]: https://ambientweather.com/\n[awnet-google-play]: https://play.google.com/store/apps/details?id=com.dtston.ambienttoolplus&hl=en_US&gl=US\n[awnet-ios]: https://apps.apple.com/us/app/awnet/id1341994564\n[awnet-upload-screen]: resources/awnet-upload-screen.jpeg?raw=true\n[beaufort-scale]: https://en.wikipedia.org/wiki/Beaufort_scale\n[ci-badge]: https://github.com/bachya/ecowitt2mqtt/workflows/CI/badge.svg\n[ci]: https://github.com/bachya/ecowitt2mqtt/actions\n[codecov-badge]: https://codecov.io/gh/bachya/ecowitt2mqtt/branch/dev/graph/badge.svg\n[codecov]: https://codecov.io/gh/bachya/ecowitt2mqtt\n[coffee-image]: https://cdn.buymeacoffee.com/buttons/default-orange.png\n[coffee]: https://www.buymeacoffee.com/bachya1208P\n[contributors]: https://github.com/bachya/ecowitt2mqtt/graphs/contributors\n[dew-point]: https://en.wikipedia.org/wiki/Dew_point\n[docker-compose]: https://docs.docker.com/compose/\n[docker-hub-badge]: https://img.shields.io/docker/pulls/bachya/ecowitt2mqtt\n[docker-hub]: https://hub.docker.com/r/bachya/ecowitt2mqtt\n[ecowitt]: https://www.ecowitt.com/\n[fitzpatrick-scale]: https://en.wikipedia.org/wiki/Fitzpatrick_scale\n[fork]: https://github.com/bachya/ecowitt2mqtt/fork\n[froggit]: https://www.froggit.de/Weather-Station/\n[frost-point]: https://en.wikipedia.org/wiki/Dew_point#Frost_point\n[ghcr]: https://ghcr.io/bachya/ecowitt2mqtt\n[heat-index]: https://en.wikipedia.org/wiki/Heat_index\n[home-assistant-addon-badge]: https://my.home-assistant.io/badges/supervisor_addon.svg\n[home-assistant-addon]: https://my.home-assistant.io/redirect/supervisor_addon/?addon=c35f0383_ecowitt2mqtt&repository_url=https%3A%2F%2Fgithub.com%2Fbachya%2Fhome-assistant-addons\n[home-assistant-mqtt-discovery]: https://www.home-assistant.io/docs/mqtt/discovery/\n[home-assistant]: https://home-assistant.io\n[humidex]: https://en.wikipedia.org/wiki/Humidex\n[issues]: https://github.com/bachya/ecowitt2mqtt/issues\n[license-badge]: https://img.shields.io/pypi/l/ecowitt2mqtt.svg\n[license]: https://github.com/bachya/ecowitt2mqtt/blob/main/LICENSE\n[logo]: resources/logo-full.png\n[maintainability-badge]: https://api.codeclimate.com/v1/badges/a03c9e96f19a3dc37f98/maintainability\n[maintainability]: https://codeclimate.com/github/bachya/ecowitt2mqtt/maintainability\n[new-issue]: https://github.com/bachya/ecowitt2mqtt/issues/new\n[pypi-badge]: https://img.shields.io/pypi/v/ecowitt2mqtt.svg\n[pypi]: https://pypi.python.org/pypi/ecowitt2mqtt\n[safe-exposure-times]: https://www.openuv.io/kb/skin-types-safe-exposure-time-calculation/\n[simmer-index]: http://summersimmer.com/ssi_page2.htm\n[thermal-comfort-library]: https://github.com/dolezsa/thermal_comfort\n[version-badge]: https://img.shields.io/pypi/pyversions/ecowitt2mqtt.svg\n[version]: https://pypi.python.org/pypi/ecowitt2mqtt\n[wind-chill]: https://en.wikipedia.org/wiki/Wind_chill\n[ws-view-google-play]: https://play.google.com/store/apps/details?id=com.ost.wsview&gl=US\n[ws-view-ios]: https://apps.apple.com/us/app/ws-view/id1362944193\n[ws-view-upload-screen]: resources/ws-view-upload-screen.jpeg?raw=true\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/bachya/ecowitt2mqtt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9.0,<4.0.0',
}


setup(**setup_kwargs)
