# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ResourceMetricSource(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'ResourceName',
        'target_average_utilization': 'int',
        'target_average_value': 'Quantity'
    }

    attribute_map = {
        'name': 'name',
        'target_average_utilization': 'targetAverageUtilization',
        'target_average_value': 'targetAverageValue'
    }

    def __init__(self, name=None, target_average_utilization=None, target_average_value=None):  # noqa: E501
        """ResourceMetricSource - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._target_average_utilization = None
        self._target_average_value = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if target_average_utilization is not None:
            self.target_average_utilization = target_average_utilization
        if target_average_value is not None:
            self.target_average_value = target_average_value

    @property
    def name(self):
        """Gets the name of this ResourceMetricSource.  # noqa: E501


        :return: The name of this ResourceMetricSource.  # noqa: E501
        :rtype: ResourceName
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ResourceMetricSource.


        :param name: The name of this ResourceMetricSource.  # noqa: E501
        :type: ResourceName
        """

        self._name = name

    @property
    def target_average_utilization(self):
        """Gets the target_average_utilization of this ResourceMetricSource.  # noqa: E501

        targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. +optional  # noqa: E501

        :return: The target_average_utilization of this ResourceMetricSource.  # noqa: E501
        :rtype: int
        """
        return self._target_average_utilization

    @target_average_utilization.setter
    def target_average_utilization(self, target_average_utilization):
        """Sets the target_average_utilization of this ResourceMetricSource.

        targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. +optional  # noqa: E501

        :param target_average_utilization: The target_average_utilization of this ResourceMetricSource.  # noqa: E501
        :type: int
        """

        self._target_average_utilization = target_average_utilization

    @property
    def target_average_value(self):
        """Gets the target_average_value of this ResourceMetricSource.  # noqa: E501


        :return: The target_average_value of this ResourceMetricSource.  # noqa: E501
        :rtype: Quantity
        """
        return self._target_average_value

    @target_average_value.setter
    def target_average_value(self, target_average_value):
        """Sets the target_average_value of this ResourceMetricSource.


        :param target_average_value: The target_average_value of this ResourceMetricSource.  # noqa: E501
        :type: Quantity
        """

        self._target_average_value = target_average_value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ResourceMetricSource, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceMetricSource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
