# Amphi ETL

![jupyterlab-amphi-screenshot](https://github.com/amphi-ai/jupyterlab-amphi/assets/15718239/1a7edcb9-ca43-4d44-867d-4535229c4ed6)

Amphi for JupyterLab is a Micro ETL designed for ingesting, cleansing, and processing data from files and databases.
Amphi addresses use cases such as data extraction from structured and unstructured data, data preparation and enrichment, and data processing for LLMs-based systems. 
Use Amphi within the Jupyterlab environment to design your data pipelines with a graphical user-interface and generate native Python code you can deploy anywhere.

 - 📚 [Documentation](https://docs.amphi.ai)
 - 🚀 [Getting Started](https://docs.amphi.ai/welcome) 

📣 **Beta release**

Amphi for Jupyterlab is currently in beta. To start with Amphi, see below for install instructions.

As Amphi is in beta version, we welcome feedback and suggestions. Join the [Slack community](https://join.slack.com/t/amphi-ai/shared_invite/zt-2ci2ptvoy-FENw8AW4ISDXUmz8wcd3bw) or reach out directly at hello@amphi.ai.

## Requirements

- JupyterLab >= 4.0

## Install Jupyterlab + Amphi

If you want to launch Jupyterlab + Amphi, you can run the following commands. It is recommended to a virtual environment (venv or conda for example).

To install perform the following steps, with _pip_:

```bash
pip install --upgrade jupyterlab jupyterlab-amphi
```

or with _conda_:

```bash
conda install -c conda-forge jupyterlab jupyterlab-amphi
```
## Install Amphi on an existing Jupyterlab instance

If you already have a Jupyterlab instance, just install the amphi package:

```bash
pip install --upgrade jupyterlab-amphi
```

Alternatively, you can search in the Extension Manager for Amphi.

For more information, see [docs](https://docs.amphi.ai).
