# lusid-drive-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.325
- Package version: 0.1.325
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lusid_drive
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_drive
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import lusid_drive
from lusid_drive.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://fbn-ci.lusid.com/drive
# See configuration.py for a list of all supported configuration parameters.
configuration = lusid_drive.Configuration(
    host = "https://fbn-ci.lusid.com/drive"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oauth2
configuration = lusid_drive.Configuration(
    host = "https://fbn-ci.lusid.com/drive"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with lusid_drive.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lusid_drive.ApplicationMetadataApi(api_client)
    
    try:
        # [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
        api_response = api_instance.list_access_controlled_resources()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationMetadataApi->list_access_controlled_resources: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/drive*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
*FilesApi* | [**create_file**](docs/FilesApi.md#create_file) | **POST** /api/files | [BETA] CreateFile: Uploads a file to Lusid Drive. If using an SDK, consider using the UploadAsStreamAsync function for larger files instead.
*FilesApi* | [**delete_file**](docs/FilesApi.md#delete_file) | **DELETE** /api/files/{id} | [BETA] DeleteFile: Deletes a file from Drive.
*FilesApi* | [**download_file**](docs/FilesApi.md#download_file) | **GET** /api/files/{id}/contents | [BETA] DownloadFile: Download the file from Drive.
*FilesApi* | [**get_file**](docs/FilesApi.md#get_file) | **GET** /api/files/{id} | [BETA] GetFile: Get a file stored in Drive.
*FilesApi* | [**update_file_contents**](docs/FilesApi.md#update_file_contents) | **PUT** /api/files/{id}/contents | [BETA] UpdateFileContents: Updates contents of a file in Drive.
*FilesApi* | [**update_file_metadata**](docs/FilesApi.md#update_file_metadata) | **PUT** /api/files/{id} | [BETA] UpdateFileMetadata: Updates metadata for a file in Drive.
*FoldersApi* | [**create_folder**](docs/FoldersApi.md#create_folder) | **POST** /api/folders | [BETA] CreateFolder: Create a new folder in LUSID Drive
*FoldersApi* | [**delete_folder**](docs/FoldersApi.md#delete_folder) | **DELETE** /api/folders/{id} | [BETA] DeleteFolder: Delete a specified folder and all subfolders
*FoldersApi* | [**get_folder**](docs/FoldersApi.md#get_folder) | **GET** /api/folders/{id} | [BETA] GetFolder: Get metadata of folder
*FoldersApi* | [**get_folder_contents**](docs/FoldersApi.md#get_folder_contents) | **GET** /api/folders/{id}/contents | [BETA] GetFolderContents: List contents of a folder
*FoldersApi* | [**get_root_folder**](docs/FoldersApi.md#get_root_folder) | **GET** /api/folders | [BETA] GetRootFolder: List contents of root folder
*FoldersApi* | [**move_folder**](docs/FoldersApi.md#move_folder) | **POST** /api/folders/{id} | [BETA] MoveFolder: Move files to specified folder
*FoldersApi* | [**update_folder**](docs/FoldersApi.md#update_folder) | **PUT** /api/folders/{id} | [BETA] UpdateFolder: Update an existing folder&#39;s name, path
*SearchApi* | [**search**](docs/SearchApi.md#search) | **POST** /api/search | [BETA] Search: Search for a file or folder with a given name and path


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionId](docs/ActionId.md)
 - [CreateFolder](docs/CreateFolder.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [PagedResourceListOfStorageObject](docs/PagedResourceListOfStorageObject.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [SearchBody](docs/SearchBody.md)
 - [StorageObject](docs/StorageObject.md)
 - [UpdateFile](docs/UpdateFile.md)
 - [UpdateFolder](docs/UpdateFolder.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


