# Permissions

Nautobot provides an object-based permissions framework, which replace's Django's built-in permissions model. Object-based permissions enable an administrator to grant users or groups the ability to perform an action on arbitrary subsets of objects in Nautobot, rather than all objects of a certain type. For example, it is possible to grant a user permission to view only sites within a particular region, or to modify only VLANs with a numeric ID within a certain range.

{%
    include-markdown "../models/users/objectpermission.md"
    heading-offset=1
%}

## Example Constraint Definitions

| Constraints | Description |
| ----------- | ----------- |
| `{"status": "active"}` | Status is active |
| `{"status__in": ["planned", "reserved"]}` | Status is active **OR** reserved |
| `{"status": "active", "role": "testing"}` | Status is active **OR** role is testing |
| `{"name__startswith": "Foo"}` | Name starts with "Foo" (case-sensitive) |
| `{"name__iendswith": "bar"}` | Name ends with "bar" (case-insensitive) |
| `{"vid__gte": 100, "vid__lt": 200}` | VLAN ID is greater than or equal to 100 **AND** less than 200 |
| `[{"vid__lt": 200}, {"status": "reserved"}]` | VLAN ID is less than 200 **OR** status is reserved |

## Permissions Enforcement

### Viewing Objects

Object-based permissions work by filtering the database query generated by a user's request to restrict the set of objects returned. When a request is received, Nautobot first determines whether the user is authenticated and has been granted to perform the requested action. For example, if the requested URL is `/dcim/devices/`, Nautobot will check for the `dcim.view_device` permission. If the user has not been assigned this permission (either directly or via a group assignment), Nautobot will return a 403 (forbidden) HTTP response.

If the permission _has_ been granted, Nautobot will compile any specified constraints for the model and action. For example, suppose two permissions have been assigned to the user granting view access to the device model, with the following constraints:

```json
[
    {"site__name__in":  ["NYC1", "NYC2"]},
    {"status":  "offline", "tenant__isnull":  true}
]
```

This grants the user access to view any device that is assigned to a site named NYC1 or NYC2, **or** which has a status of "offline" and has no tenant assigned. These constraints are equivalent to the following ORM query:

```no-highlight
Site.objects.filter(
    Q(site__name__in=['NYC1', 'NYC2']),
    Q(status='active', tenant__isnull=True)
)
```

### Creating and Modifying Objects

The same sort of logic is in play when a user attempts to create or modify an object in Nautobot, with a twist. Once validation has completed, Nautobot starts an atomic database transaction to facilitate the change, and the object is created or saved normally. Next, still within the transaction, Nautobot issues a second query to retrieve the newly created/updated object, filtering the restricted queryset with the object's primary key. If this query fails to return the object, Nautobot knows that the new revision does not match the constraints imposed by the permission. The transaction is then rolled back, leaving the database in its original state prior to the change, and the user is informed of the violation.
