# These IDs (and other very useful info for this project) came from the SSBM Data Sheet: https://docs.google.com/spreadsheets/d/1JX2w-r2fuvWuNgGb6D3Cs4wHQKLFegZe2jhbBuIhCG8

from slippi.util import *


class ActionState(IntEnum):
    DEAD_DOWN = 0
    DEAD_LEFT = 1
    DEAD_RIGHT = 2
    DEAD_UP = 3
    DEAD_UP_STAR = 4
    DEAD_UP_STAR_ICE = 5
    DEAD_UP_FALL = 6
    DEAD_UP_FALL_HIT_CAMERA = 7
    DEAD_UP_FALL_HIT_CAMERA_FLAT = 8
    DEAD_UP_FALL_ICE = 9
    DEAD_UP_FALL_HIT_CAMERA_ICE = 10
    SLEEP = 11
    REBIRTH = 12
    REBIRTH_WAIT = 13
    WAIT = 14
    WALK_SLOW = 15
    WALK_MIDDLE = 16
    WALK_FAST = 17
    TURN = 18
    TURN_RUN = 19
    DASH = 20
    RUN = 21
    RUN_DIRECT = 22
    RUN_BRAKE = 23
    KNEE_BEND = 24
    JUMP_F = 25
    JUMP_B = 26
    JUMP_AERIAL_F = 27
    JUMP_AERIAL_B = 28
    FALL = 29
    FALL_F = 30
    FALL_B = 31
    FALL_AERIAL = 32
    FALL_AERIAL_F = 33
    FALL_AERIAL_B = 34
    FALL_SPECIAL = 35
    FALL_SPECIAL_F = 36
    FALL_SPECIAL_B = 37
    DAMAGE_FALL = 38
    SQUAT = 39
    SQUAT_WAIT = 40
    SQUAT_RV = 41
    LANDING = 42
    LANDING_FALL_SPECIAL = 43
    ATTACK_11 = 44
    ATTACK_12 = 45
    ATTACK_13 = 46
    ATTACK_100_START = 47
    ATTACK_100_LOOP = 48
    ATTACK_100_END = 49
    ATTACK_DASH = 50
    ATTACK_S_3_HI = 51
    ATTACK_S_3_HI_S = 52
    ATTACK_S_3_S = 53
    ATTACK_S_3_LW_S = 54
    ATTACK_S_3_LW = 55
    ATTACK_HI_3 = 56
    ATTACK_LW_3 = 57
    ATTACK_S_4_HI = 58
    ATTACK_S_4_HI_S = 59
    ATTACK_S_4_S = 60
    ATTACK_S_4_LW_S = 61
    ATTACK_S_4_LW = 62
    ATTACK_HI_4 = 63
    ATTACK_LW_4 = 64
    ATTACK_AIR_N = 65
    ATTACK_AIR_F = 66
    ATTACK_AIR_B = 67
    ATTACK_AIR_HI = 68
    ATTACK_AIR_LW = 69
    LANDING_AIR_N = 70
    LANDING_AIR_F = 71
    LANDING_AIR_B = 72
    LANDING_AIR_HI = 73
    LANDING_AIR_LW = 74
    DAMAGE_HI_1 = 75
    DAMAGE_HI_2 = 76
    DAMAGE_HI_3 = 77
    DAMAGE_N_1 = 78
    DAMAGE_N_2 = 79
    DAMAGE_N_3 = 80
    DAMAGE_LW_1 = 81
    DAMAGE_LW_2 = 82
    DAMAGE_LW_3 = 83
    DAMAGE_AIR_1 = 84
    DAMAGE_AIR_2 = 85
    DAMAGE_AIR_3 = 86
    DAMAGE_FLY_HI = 87
    DAMAGE_FLY_N = 88
    DAMAGE_FLY_LW = 89
    DAMAGE_FLY_TOP = 90
    DAMAGE_FLY_ROLL = 91
    LIGHT_GET = 92
    HEAVY_GET = 93
    LIGHT_THROW_F = 94
    LIGHT_THROW_B = 95
    LIGHT_THROW_HI = 96
    LIGHT_THROW_LW = 97
    LIGHT_THROW_DASH = 98
    LIGHT_THROW_DROP = 99
    LIGHT_THROW_AIR_F = 100
    LIGHT_THROW_AIR_B = 101
    LIGHT_THROW_AIR_HI = 102
    LIGHT_THROW_AIR_LW = 103
    HEAVY_THROW_F = 104
    HEAVY_THROW_B = 105
    HEAVY_THROW_HI = 106
    HEAVY_THROW_LW = 107
    LIGHT_THROW_F_4 = 108
    LIGHT_THROW_B_4 = 109
    LIGHT_THROW_HI_4 = 110
    LIGHT_THROW_LW_4 = 111
    LIGHT_THROW_AIR_F_4 = 112
    LIGHT_THROW_AIR_B_4 = 113
    LIGHT_THROW_AIR_HI_4 = 114
    LIGHT_THROW_AIR_LW_4 = 115
    HEAVY_THROW_F_4 = 116
    HEAVY_THROW_B_4 = 117
    HEAVY_THROW_HI_4 = 118
    HEAVY_THROW_LW_4 = 119
    SWORD_SWING_1 = 120
    SWORD_SWING_3 = 121
    SWORD_SWING_4 = 122
    SWORD_SWING_DASH = 123
    BAT_SWING_1 = 124
    BAT_SWING_3 = 125
    BAT_SWING_4 = 126
    BAT_SWING_DASH = 127
    PARASOL_SWING_1 = 128
    PARASOL_SWING_3 = 129
    PARASOL_SWING_4 = 130
    PARASOL_SWING_DASH = 131
    HARISEN_SWING_1 = 132
    HARISEN_SWING_3 = 133
    HARISEN_SWING_4 = 134
    HARISEN_SWING_DASH = 135
    STAR_ROD_SWING_1 = 136
    STAR_ROD_SWING_3 = 137
    STAR_ROD_SWING_4 = 138
    STAR_ROD_SWING_DASH = 139
    LIP_STICK_SWING_1 = 140
    LIP_STICK_SWING_3 = 141
    LIP_STICK_SWING_4 = 142
    LIP_STICK_SWING_DASH = 143
    ITEM_PARASOL_OPEN = 144
    ITEM_PARASOL_FALL = 145
    ITEM_PARASOL_FALL_SPECIAL = 146
    ITEM_PARASOL_DAMAGE_FALL = 147
    L_GUN_SHOOT = 148
    L_GUN_SHOOT_AIR = 149
    L_GUN_SHOOT_EMPTY = 150
    L_GUN_SHOOT_AIR_EMPTY = 151
    FIRE_FLOWER_SHOOT = 152
    FIRE_FLOWER_SHOOT_AIR = 153
    ITEM_SCREW = 154
    ITEM_SCREW_AIR = 155
    DAMAGE_SCREW = 156
    DAMAGE_SCREW_AIR = 157
    ITEM_SCOPE_START = 158
    ITEM_SCOPE_RAPID = 159
    ITEM_SCOPE_FIRE = 160
    ITEM_SCOPE_END = 161
    ITEM_SCOPE_AIR_START = 162
    ITEM_SCOPE_AIR_RAPID = 163
    ITEM_SCOPE_AIR_FIRE = 164
    ITEM_SCOPE_AIR_END = 165
    ITEM_SCOPE_START_EMPTY = 166
    ITEM_SCOPE_RAPID_EMPTY = 167
    ITEM_SCOPE_FIRE_EMPTY = 168
    ITEM_SCOPE_END_EMPTY = 169
    ITEM_SCOPE_AIR_START_EMPTY = 170
    ITEM_SCOPE_AIR_RAPID_EMPTY = 171
    ITEM_SCOPE_AIR_FIRE_EMPTY = 172
    ITEM_SCOPE_AIR_END_EMPTY = 173
    LIFT_WAIT = 174
    LIFT_WALK_1 = 175
    LIFT_WALK_2 = 176
    LIFT_TURN = 177
    GUARD_ON = 178
    GUARD = 179
    GUARD_OFF = 180
    GUARD_SET_OFF = 181
    GUARD_REFLECT = 182
    DOWN_BOUND_U = 183
    DOWN_WAIT_U = 184
    DOWN_DAMAGE_U = 185
    DOWN_STAND_U = 186
    DOWN_ATTACK_U = 187
    DOWN_FOWARD_U = 188
    DOWN_BACK_U = 189
    DOWN_SPOT_U = 190
    DOWN_BOUND_D = 191
    DOWN_WAIT_D = 192
    DOWN_DAMAGE_D = 193
    DOWN_STAND_D = 194
    DOWN_ATTACK_D = 195
    DOWN_FOWARD_D = 196
    DOWN_BACK_D = 197
    DOWN_SPOT_D = 198
    PASSIVE = 199
    PASSIVE_STAND_F = 200
    PASSIVE_STAND_B = 201
    PASSIVE_WALL = 202
    PASSIVE_WALL_JUMP = 203
    PASSIVE_CEIL = 204
    SHIELD_BREAK_FLY = 205
    SHIELD_BREAK_FALL = 206
    SHIELD_BREAK_DOWN_U = 207
    SHIELD_BREAK_DOWN_D = 208
    SHIELD_BREAK_STAND_U = 209
    SHIELD_BREAK_STAND_D = 210
    FURA_FURA = 211
    CATCH = 212
    CATCH_PULL = 213
    CATCH_DASH = 214
    CATCH_DASH_PULL = 215
    CATCH_WAIT = 216
    CATCH_ATTACK = 217
    CATCH_CUT = 218
    THROW_F = 219
    THROW_B = 220
    THROW_HI = 221
    THROW_LW = 222
    CAPTURE_PULLED_HI = 223
    CAPTURE_WAIT_HI = 224
    CAPTURE_DAMAGE_HI = 225
    CAPTURE_PULLED_LW = 226
    CAPTURE_WAIT_LW = 227
    CAPTURE_DAMAGE_LW = 228
    CAPTURE_CUT = 229
    CAPTURE_JUMP = 230
    CAPTURE_NECK = 231
    CAPTURE_FOOT = 232
    ESCAPE_F = 233
    ESCAPE_B = 234
    ESCAPE = 235
    ESCAPE_AIR = 236
    REBOUND_STOP = 237
    REBOUND = 238
    THROWN_F = 239
    THROWN_B = 240
    THROWN_HI = 241
    THROWN_LW = 242
    THROWN_LW_WOMEN = 243
    PASS = 244
    OTTOTTO = 245
    OTTOTTO_WAIT = 246
    FLY_REFLECT_WALL = 247
    FLY_REFLECT_CEIL = 248
    STOP_WALL = 249
    STOP_CEIL = 250
    MISS_FOOT = 251
    CLIFF_CATCH = 252
    CLIFF_WAIT = 253
    CLIFF_CLIMB_SLOW = 254
    CLIFF_CLIMB_QUICK = 255
    CLIFF_ATTACK_SLOW = 256
    CLIFF_ATTACK_QUICK = 257
    CLIFF_ESCAPE_SLOW = 258
    CLIFF_ESCAPE_QUICK = 259
    CLIFF_JUMP_SLOW_1 = 260
    CLIFF_JUMP_SLOW_2 = 261
    CLIFF_JUMP_QUICK_1 = 262
    CLIFF_JUMP_QUICK_2 = 263
    APPEAL_R = 264
    APPEAL_L = 265
    SHOULDERED_WAIT = 266
    SHOULDERED_WALK_SLOW = 267
    SHOULDERED_WALK_MIDDLE = 268
    SHOULDERED_WALK_FAST = 269
    SHOULDERED_TURN = 270
    THROWN_F_F = 271
    THROWN_F_B = 272
    THROWN_F_HI = 273
    THROWN_F_LW = 274
    CAPTURE_CAPTAIN = 275
    CAPTURE_YOSHI = 276
    YOSHI_EGG = 277
    CAPTURE_KOOPA = 278
    CAPTURE_DAMAGE_KOOPA = 279
    CAPTURE_WAIT_KOOPA = 280
    THROWN_KOOPA_F = 281
    THROWN_KOOPA_B = 282
    CAPTURE_KOOPA_AIR = 283
    CAPTURE_DAMAGE_KOOPA_AIR = 284
    CAPTURE_WAIT_KOOPA_AIR = 285
    THROWN_KOOPA_AIR_F = 286
    THROWN_KOOPA_AIR_B = 287
    CAPTURE_KIRBY = 288
    CAPTURE_WAIT_KIRBY = 289
    THROWN_KIRBY_STAR = 290
    THROWN_COPY_STAR = 291
    THROWN_KIRBY = 292
    BARREL_WAIT = 293
    BURY = 294
    BURY_WAIT = 295
    BURY_JUMP = 296
    DAMAGE_SONG = 297
    DAMAGE_SONG_WAIT = 298
    DAMAGE_SONG_RV = 299
    DAMAGE_BIND = 300
    CAPTURE_MEWTWO = 301
    CAPTURE_MEWTWO_AIR = 302
    THROWN_MEWTWO = 303
    THROWN_MEWTWO_AIR = 304
    WARP_STAR_JUMP = 305
    WARP_STAR_FALL = 306
    HAMMER_WAIT = 307
    HAMMER_WALK = 308
    HAMMER_TURN = 309
    HAMMER_KNEE_BEND = 310
    HAMMER_FALL = 311
    HAMMER_JUMP = 312
    HAMMER_LANDING = 313
    KINOKO_GIANT_START = 314
    KINOKO_GIANT_START_AIR = 315
    KINOKO_GIANT_END = 316
    KINOKO_GIANT_END_AIR = 317
    KINOKO_SMALL_START = 318
    KINOKO_SMALL_START_AIR = 319
    KINOKO_SMALL_END = 320
    KINOKO_SMALL_END_AIR = 321
    ENTRY = 322
    ENTRY_START = 323
    ENTRY_END = 324
    DAMAGE_ICE = 325
    DAMAGE_ICE_JUMP = 326
    CAPTURE_MASTERHAND = 327
    CAPTUREDAMAGE_MASTERHAND = 328
    CAPTUREWAIT_MASTERHAND = 329
    THROWN_MASTERHAND = 330
    CAPTURE_KIRBY_YOSHI = 331
    KIRBY_YOSHI_EGG = 332
    CAPTURE_LEADEAD = 333
    CAPTURE_LIKELIKE = 334
    DOWN_REFLECT = 335
    CAPTURE_CRAZYHAND = 336
    CAPTUREDAMAGE_CRAZYHAND = 337
    CAPTUREWAIT_CRAZYHAND = 338
    THROWN_CRAZYHAND = 339
    BARREL_CANNON_WAIT = 340
    WAIT_1 = 341
    WAIT_2 = 342
    WAIT_3 = 343
    WAIT_4 = 344
    WAIT_ITEM = 345
    SQUAT_WAIT_1 = 346
    SQUAT_WAIT_2 = 347
    SQUAT_WAIT_ITEM = 348
    GUARD_DAMAGE = 349
    ESCAPE_N = 350
    ATTACK_S_4_HOLD = 351
    HEAVY_WALK_1 = 352
    HEAVY_WALK_2 = 353
    ITEM_HAMMER_WAIT = 354
    ITEM_HAMMER_MOVE = 355
    ITEM_BLIND = 356
    DAMAGE_ELEC = 357
    FURA_SLEEP_START = 358
    FURA_SLEEP_LOOP = 359
    FURA_SLEEP_END = 360
    WALL_DAMAGE = 361
    CLIFF_WAIT_1 = 362
    CLIFF_WAIT_2 = 363
    SLIP_DOWN = 364
    SLIP = 365
    SLIP_TURN = 366
    SLIP_DASH = 367
    SLIP_WAIT = 368
    SLIP_STAND = 369
    SLIP_ATTACK = 370
    SLIP_ESCAPE_F = 371
    SLIP_ESCAPE_B = 372
    APPEAL_S = 373
    ZITABATA = 374
    CAPTURE_KOOPA_HIT = 375
    THROWN_KOOPA_END_F = 376
    THROWN_KOOPA_END_B = 377
    CAPTURE_KOOPA_AIR_HIT = 378
    THROWN_KOOPA_AIR_END_F = 379
    THROWN_KOOPA_AIR_END_B = 380
    THROWN_KIRBY_DRINK_S_SHOT = 381
    THROWN_KIRBY_SPIT_S_SHOT = 382


class CSSCharacter(IntEnum):
    CAPTAIN_FALCON = 0
    DONKEY_KONG = 1
    FOX = 2
    GAME_AND_WATCH = 3
    KIRBY = 4
    BOWSER = 5
    LINK = 6
    LUIGI = 7
    MARIO = 8
    MARTH = 9
    MEWTWO = 10
    NESS = 11
    PEACH = 12
    PIKACHU = 13
    ICE_CLIMBERS = 14
    JIGGLYPUFF = 15
    SAMUS = 16
    YOSHI = 17
    ZELDA = 18
    SHEIK = 19
    FALCO = 20
    YOUNG_LINK = 21
    DR_MARIO = 22
    ROY = 23
    PICHU = 24
    GANONDORF = 25
    MASTER_HAND = 26
    WIREFRAME_MALE = 27
    WIREFRAME_FEMALE = 28
    GIGA_BOWSER = 29
    CRAZY_HAND = 30
    SANDBAG = 31
    POPO = 32

    @classmethod
    def from_internal_id(cls, internal_id):
        char = InGameCharacter(internal_id)
        if char is InGameCharacter.NANA or char is InGameCharacter.POPO:
            return cls.ICE_CLIMBERS
        else:
            return cls[char.name]


class InGameCharacter(IntEnum):
    MARIO = 0
    FOX = 1
    CAPTAIN_FALCON = 2
    DONKEY_KONG = 3
    KIRBY = 4
    BOWSER = 5
    LINK = 6
    SHEIK = 7
    NESS = 8
    PEACH = 9
    POPO = 10
    NANA = 11
    PIKACHU = 12
    SAMUS = 13
    YOSHI = 14
    JIGGLYPUFF = 15
    MEWTWO = 16
    LUIGI = 17
    MARTH = 18
    ZELDA = 19
    YOUNG_LINK = 20
    DR_MARIO = 21
    FALCO = 22
    PICHU = 23
    GAME_AND_WATCH = 24
    GANONDORF = 25
    ROY = 26
    MASTER_HAND = 27
    CRAZY_HAND = 28
    WIREFRAME_MALE = 29
    WIREFRAME_FEMALE = 30
    GIGA_BOWSER = 31
    SANDBAG = 32


class Stage(IntEnum):
    FOUNTAIN_OF_DREAMS = 2
    POKEMON_STADIUM = 3
    PRINCESS_PEACHS_CASTLE = 4
    KONGO_JUNGLE = 5
    BRINSTAR = 6
    CORNERIA = 7
    YOSHIS_STORY = 8
    ONETT = 9
    MUTE_CITY = 10
    RAINBOW_CRUISE = 11
    JUNGLE_JAPES = 12
    GREAT_BAY = 13
    HYRULE_TEMPLE = 14
    BRINSTAR_DEPTHS = 15
    YOSHIS_ISLAND = 16
    GREEN_GREENS = 17
    FOURSIDE = 18
    MUSHROOM_KINGDOM_I = 19
    MUSHROOM_KINGDOM_II = 20
    VENOM = 22
    POKE_FLOATS = 23
    BIG_BLUE = 24
    ICICLE_MOUNTAIN = 25
    ICETOP = 26
    FLAT_ZONE = 27
    DREAM_LAND_N64 = 28
    YOSHIS_ISLAND_N64 = 29
    KONGO_JUNGLE_N64 = 30
    BATTLEFIELD = 31
    FINAL_DESTINATION = 32
