import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-cdk.aws-logs",
    "version": "1.17.0",
    "description": "The CDK Construct Library for AWS::Logs",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_logs",
        "aws_cdk.aws_logs._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_logs._jsii": [
            "aws-logs@1.17.0.jsii.tgz"
        ],
        "aws_cdk.aws_logs": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii~=0.20.7",
        "publication>=0.0.3",
        "aws-cdk.aws-cloudwatch~=1.17,>=1.17.0",
        "aws-cdk.aws-iam~=1.17,>=1.17.0",
        "aws-cdk.core~=1.17,>=1.17.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
