# =============================================================================

# the outlines is given at
# http://ipcc-wg2.gov/SREX/images/uploads/SREX-Ch3-Supplement_FINAL.pdf

outlines = dict()
outlines[1] = (
    (-105.000, 60.000),
    (-168.022, 60.000),
    (-168.022, 72.554),
    (-105.000, 72.554),
)
outlines[7] = (
    (-66.377, -20.000),
    (-79.729, -1.239),
    (-68.800, 11.439),
    (-50.000, 11.439),
    (-50.000, -20.000),
)
outlines[6] = (
    (-68.800, 11.439),
    (-79.729, -1.239),
    (-118.323, 28.566),
    (-90.315, 28.566),
)
outlines[20] = ((60.000, 30.000), (60.000, 50.000), (75.000, 50.000), (75.000, 30.000))
outlines[12] = (
    (-10.000, 45.000),
    (-10.000, 48.000),
    (40.000, 61.320),
    (40.000, 45.000),
)
outlines[2] = (
    (-10.000, 50.000),
    (-105.000, 50.000),
    (-105.000, 85.000),
    (-10.000, 85.000),
)
outlines[4] = (
    (-85.000, 50.000),
    (-85.000, 28.566),
    (-105.000, 28.566),
    (-105.000, 50.000),
)
outlines[16] = (
    (25.000, -11.365),
    (25.000, 15.000),
    (51.990, 15.000),
    (51.990, -11.365),
)
outlines[22] = (
    (100.000, 20.000),
    (100.000, 50.000),
    (145.000, 50.000),
    (145.000, 20.000),
)
outlines[5] = (
    (-60.000, 25.000),
    (-85.000, 25.000),
    (-85.000, 50.000),
    (-60.000, 50.000),
)
outlines[13] = (
    (-10.000, 30.000),
    (-10.000, 45.000),
    (40.000, 45.000),
    (40.000, 30.000),
)
outlines[18] = (
    (40.000, 50.000),
    (40.000, 70.000),
    (180.000, 70.000),
    (180.000, 50.000),
)
outlines[25] = (
    (110.000, -30.000),
    (110.000, -10.000),
    (155.000, -10.000),
    (155.000, -30.000),
)
outlines[8] = (
    (-34.000, -20.000),
    (-50.000, -20.000),
    (-50.000, 0.000),
    (-34.000, 0.000),
)
outlines[11] = (
    (-10.000, 48.000),
    (-10.000, 75.000),
    (40.000, 75.000),
    (40.000, 61.320),
)
outlines[17] = (
    (-10.000, -35.000),
    (-10.000, -11.365),
    (51.990, -11.365),
    (51.990, -35.000),
)
outlines[14] = (
    (-20.000, 15.000),
    (-20.000, 30.000),
    (40.000, 30.000),
    (40.000, 15.000),
)
outlines[23] = (
    (60.000, 5.000),
    (60.000, 30.000),
    (100.000, 30.000),
    (100.000, 20.000),
    (95.000, 20.000),
    (95.000, 5.000),
)
outlines[26] = (
    (110.000, -50.000),
    (110.000, -30.000),
    (180.000, -30.000),
    (180.000, -50.000),
)
outlines[10] = (
    (-39.376, -20.000),
    (-39.376, -56.704),
    (-67.348, -56.704),
    (-72.141, -50.000),
    (-66.377, -20.000),
)
outlines[24] = (
    (95.000, -10.000),
    (95.000, 20.000),
    (155.000, 20.000),
    (155.000, -10.000),
)
outlines[21] = (
    (75.000, 30.000),
    (75.000, 50.000),
    (100.000, 50.000),
    (100.000, 30.000),
)
outlines[15] = (
    (-20.000, -11.365),
    (-20.000, 15.000),
    (25.000, 15.000),
    (25.000, -11.365),
)
outlines[19] = ((40.000, 15.000), (40.000, 50.000), (60.000, 50.000), (60.000, 15.000))
outlines[9] = (
    (-79.729, -1.239),
    (-66.377, -20.000),
    (-72.141, -50.000),
    (-67.348, -56.704),
    (-82.022, -56.704),
    (-82.022, 0.530),
)
outlines[3] = (
    (-105.000, 28.566),
    (-130.000, 28.566),
    (-130.000, 60.000),
    (-105.000, 60.000),
)

# -----------------------------------------------------------------------------

short_names = {
    1: "ALA",
    2: "CGI",
    3: "WNA",
    4: "CNA",
    5: "ENA",
    6: "CAM",
    7: "AMZ",
    8: "NEB",
    9: "WSA",
    10: "SSA",
    11: "NEU",
    12: "CEU",
    13: "MED",
    14: "SAH",
    15: "WAF",
    16: "EAF",
    17: "SAF",
    18: "NAS",
    19: "WAS",
    20: "CAS",
    21: "TIB",
    22: "EAS",
    23: "SAS",
    24: "SEA",
    25: "NAU",
    26: "SAU",
}


# -----------------------------------------------------------------------------

names = {
    1: "Alaska/N.W. Canada",
    2: "Canada/Greenl./Icel.",
    3: "W. North America",
    4: "C. North America",
    5: "E. North America",
    6: "Central America/Mexico",
    7: "Amazon",
    8: "N.E. Brazil",
    9: "Coast South America",
    10: "S.E. South America",
    11: "N. Europe",
    12: "C. Europe",
    13: "S. Europe/Mediterranean",
    14: "Sahara",
    15: "W. Africa",
    16: "E. Africa",
    17: "S. Africa",
    18: "N. Asia",
    19: "W. Asia",
    20: "C. Asia",
    21: "Tibetan Plateau",
    22: "E. Asia",
    23: "S. Asia",
    24: "S.E. Asia",
    25: "N. Australia",
    26: "S. Australia/New Zealand",
}

# =============================================================================

from ..core.regions import Regions

numbers = range(1, 27)
source = (
    "Seneviratne et al., 2012 "
    "(https://www.ipcc.ch/site/assets/uploads/2018/03/SREX-Ch3-Supplement_FINAL-1.pdf)"
)

srex = Regions(
    outlines,
    numbers=numbers,
    names=names,
    abbrevs=short_names,
    name="SREX",
    source=source,
)
