# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('..'))

import pyyc

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = 'pyYC \\pwik\\'
copyright = '2022, Yannick Copin'
author = 'Yannick Copin'

# The full version, including alpha/beta/rc tags
from pyyc import __version__
release = __version__

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    # Standard extensions
    'sphinx.ext.autodoc',       # automatic documentation
    'sphinx.ext.autosummary',   # automatic summary
    'sphinx.ext.intersphinx',   # link to external documentations
    'sphinx.ext.mathjax',       # (or pngmath) support for equations
    'sphinx.ext.viewcode',      # link to code source
    'sphinx.ext.extlinks',      # support for external links
    'sphinx.ext.autosectionlabel',  # automatic section label
    # 'sphinx.ext.doctest',
    # 'sphinx.ext.coverage',
    # Additional extensions
    'nbsphinx',                 # Support for Ipython Notebooks
    # 'matplotlib.sphinxext.plot_directive',  # Support for embedded plots
]

# Autodoc configuration
autoclass_content = "both"              # Insert class and __init__ docstrings
autodoc_member_order = "bysource"       # Keep source order

# Intersphinx configuration
intersphinx_mapping = {
    'python': ('https://docs.python.org/3/', None),
}

# Extlinks configuration
extlinks = {
    'pypi': ('https://pypi.org/project/%s', ''),     # PyPI
}

# Autosectionlabel configuration
autosectionlabel_prefix_document = True  # :ref:`fichier:section`

# nbsphinx  configuration
nbsphinx_prolog = r"""
{% set docname = env.doc2path(env.docname, base=False) %}
.. raw:: latex

   \nbsphinxstartnotebook{\scriptsize\noindent\strut
   \textcolor{gray}{The following section was generated from
   \sphinxcode{\sphinxupquote{\strut {{ docname | escape_latex }}}} \dotfill}}
"""

nbsphinx_epilog = r"""
{% set docname = env.doc2path(env.docname, base=False) %}
.. only:: html

   .. role:: raw-html(raw)
      :format: html

   .. nbinfo::

      This page was generated from `{{ docname }}`.

.. raw:: latex

   \nbsphinxstopnotebook{\scriptsize\noindent\strut
   \textcolor{gray}{\dotfill\ \sphinxcode{\sphinxupquote{\strut
   {{ docname | escape_latex }}}} ends here.}}
"""

# mathjax configuration
mathjax3_config = {
    'tex': {'tags': 'ams', 'useLabelIds': True},
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The master toctree document.
master_doc = 'index'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'
today_fmt = '%y-%m-%d, %H:%M'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store',
                    '**.ipynb_checkpoints',
                    '**.egg-info']

# The reST default role (used for this markup: `text`) to use for all
# documents.
default_role = 'literal'

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = True

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'emacs'

# If true, keep warnings as "system message" paragraphs in the built documents.
keep_warnings = True

# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

# https://www.sphinx-doc.org/en/master/usage/theming.html#builtin-themes
html_theme = 'bizstyle'
html_static_path = ['_static']

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    'papersize': 'a4paper',
    'pointsize': '10pt',
    'fontenc': r"\usepackage[LGR,T1]{fontenc}",
    'utf8extra': r"""
\DeclareUnicodeCharacter{212B}{\AA}    % Å
""",
    'preamble': r"""
\usepackage{alphalph}
\renewcommand{\thefootnote}{\alphalph{\value{footnote}}}
""",
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'pyyc.tex', u'PyYC Documentation',
     author, 'manual'),
]

# If true, show page references after internal links.
latex_show_pagerefs = True

# If true, show URL addresses after external links.
latex_show_urls = 'footnote'

# If false, no module index is generated.
latex_domain_indices = False
