import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApikeysKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-readable display name of this API key. Modifiable by user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#display_name ApikeysKey#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#id ApikeysKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the key. The name must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. In another word, the name must match the regular expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#name ApikeysKey#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#project ApikeysKey#project}
    */
    readonly project?: string;
    /**
    * restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#restrictions ApikeysKey#restrictions}
    */
    readonly restrictions?: ApikeysKeyRestrictions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#timeouts ApikeysKey#timeouts}
    */
    readonly timeouts?: ApikeysKeyTimeouts;
}
export interface ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications {
    /**
    * The package name of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#package_name ApikeysKey#package_name}
    */
    readonly packageName: string;
    /**
    * The SHA1 fingerprint of the application. For example, both sha1 formats are acceptable : DA:39:A3:EE:5E:6B:4B:0D:32:55:BF:EF:95:60:18:90:AF:D8:07:09 or DA39A3EE5E6B4B0D3255BFEF95601890AFD80709. Output format is the latter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#sha1_fingerprint ApikeysKey#sha1_fingerprint}
    */
    readonly sha1Fingerprint: string;
}
export declare function apikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsToTerraform(struct?: ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable): any;
export declare class ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable | undefined;
    set internalValue(value: ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable | undefined);
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    get packageNameInput(): string | undefined;
    private _sha1Fingerprint?;
    get sha1Fingerprint(): string;
    set sha1Fingerprint(value: string);
    get sha1FingerprintInput(): string | undefined;
}
export declare class ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsOutputReference;
}
export interface ApikeysKeyRestrictionsAndroidKeyRestrictions {
    /**
    * allowed_applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#allowed_applications ApikeysKey#allowed_applications}
    */
    readonly allowedApplications: ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable;
}
export declare function apikeysKeyRestrictionsAndroidKeyRestrictionsToTerraform(struct?: ApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference | ApikeysKeyRestrictionsAndroidKeyRestrictions): any;
export declare class ApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyRestrictionsAndroidKeyRestrictions | undefined;
    set internalValue(value: ApikeysKeyRestrictionsAndroidKeyRestrictions | undefined);
    private _allowedApplications;
    get allowedApplications(): ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsList;
    putAllowedApplications(value: ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable): void;
    get allowedApplicationsInput(): cdktf.IResolvable | ApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | undefined;
}
export interface ApikeysKeyRestrictionsApiTargets {
    /**
    * Optional. List of one or more methods that can be called. If empty, all methods for the service are allowed. A wildcard (*) can be used as the last symbol. Valid examples: `google.cloud.translate.v2.TranslateService.GetSupportedLanguage` `TranslateText` `Get*` `translate.googleapis.com.Get*`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#methods ApikeysKey#methods}
    */
    readonly methods?: string[];
    /**
    * The service for this restriction. It should be the canonical service name, for example: `translate.googleapis.com`. You can use `gcloud services list` to get a list of services that are enabled in the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#service ApikeysKey#service}
    */
    readonly service: string;
}
export declare function apikeysKeyRestrictionsApiTargetsToTerraform(struct?: ApikeysKeyRestrictionsApiTargets | cdktf.IResolvable): any;
export declare class ApikeysKeyRestrictionsApiTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApikeysKeyRestrictionsApiTargets | cdktf.IResolvable | undefined;
    set internalValue(value: ApikeysKeyRestrictionsApiTargets | cdktf.IResolvable | undefined);
    private _methods?;
    get methods(): string[];
    set methods(value: string[]);
    resetMethods(): void;
    get methodsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class ApikeysKeyRestrictionsApiTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApikeysKeyRestrictionsApiTargetsOutputReference;
}
export interface ApikeysKeyRestrictionsBrowserKeyRestrictions {
    /**
    * A list of regular expressions for the referrer URLs that are allowed to make API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#allowed_referrers ApikeysKey#allowed_referrers}
    */
    readonly allowedReferrers: string[];
}
export declare function apikeysKeyRestrictionsBrowserKeyRestrictionsToTerraform(struct?: ApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference | ApikeysKeyRestrictionsBrowserKeyRestrictions): any;
export declare class ApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyRestrictionsBrowserKeyRestrictions | undefined;
    set internalValue(value: ApikeysKeyRestrictionsBrowserKeyRestrictions | undefined);
    private _allowedReferrers?;
    get allowedReferrers(): string[];
    set allowedReferrers(value: string[]);
    get allowedReferrersInput(): string[] | undefined;
}
export interface ApikeysKeyRestrictionsIosKeyRestrictions {
    /**
    * A list of bundle IDs that are allowed when making API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#allowed_bundle_ids ApikeysKey#allowed_bundle_ids}
    */
    readonly allowedBundleIds: string[];
}
export declare function apikeysKeyRestrictionsIosKeyRestrictionsToTerraform(struct?: ApikeysKeyRestrictionsIosKeyRestrictionsOutputReference | ApikeysKeyRestrictionsIosKeyRestrictions): any;
export declare class ApikeysKeyRestrictionsIosKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyRestrictionsIosKeyRestrictions | undefined;
    set internalValue(value: ApikeysKeyRestrictionsIosKeyRestrictions | undefined);
    private _allowedBundleIds?;
    get allowedBundleIds(): string[];
    set allowedBundleIds(value: string[]);
    get allowedBundleIdsInput(): string[] | undefined;
}
export interface ApikeysKeyRestrictionsServerKeyRestrictions {
    /**
    * A list of the caller IP addresses that are allowed to make API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#allowed_ips ApikeysKey#allowed_ips}
    */
    readonly allowedIps: string[];
}
export declare function apikeysKeyRestrictionsServerKeyRestrictionsToTerraform(struct?: ApikeysKeyRestrictionsServerKeyRestrictionsOutputReference | ApikeysKeyRestrictionsServerKeyRestrictions): any;
export declare class ApikeysKeyRestrictionsServerKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyRestrictionsServerKeyRestrictions | undefined;
    set internalValue(value: ApikeysKeyRestrictionsServerKeyRestrictions | undefined);
    private _allowedIps?;
    get allowedIps(): string[];
    set allowedIps(value: string[]);
    get allowedIpsInput(): string[] | undefined;
}
export interface ApikeysKeyRestrictions {
    /**
    * android_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#android_key_restrictions ApikeysKey#android_key_restrictions}
    */
    readonly androidKeyRestrictions?: ApikeysKeyRestrictionsAndroidKeyRestrictions;
    /**
    * api_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#api_targets ApikeysKey#api_targets}
    */
    readonly apiTargets?: ApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable;
    /**
    * browser_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#browser_key_restrictions ApikeysKey#browser_key_restrictions}
    */
    readonly browserKeyRestrictions?: ApikeysKeyRestrictionsBrowserKeyRestrictions;
    /**
    * ios_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#ios_key_restrictions ApikeysKey#ios_key_restrictions}
    */
    readonly iosKeyRestrictions?: ApikeysKeyRestrictionsIosKeyRestrictions;
    /**
    * server_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#server_key_restrictions ApikeysKey#server_key_restrictions}
    */
    readonly serverKeyRestrictions?: ApikeysKeyRestrictionsServerKeyRestrictions;
}
export declare function apikeysKeyRestrictionsToTerraform(struct?: ApikeysKeyRestrictionsOutputReference | ApikeysKeyRestrictions): any;
export declare class ApikeysKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyRestrictions | undefined;
    set internalValue(value: ApikeysKeyRestrictions | undefined);
    private _androidKeyRestrictions;
    get androidKeyRestrictions(): ApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference;
    putAndroidKeyRestrictions(value: ApikeysKeyRestrictionsAndroidKeyRestrictions): void;
    resetAndroidKeyRestrictions(): void;
    get androidKeyRestrictionsInput(): ApikeysKeyRestrictionsAndroidKeyRestrictions | undefined;
    private _apiTargets;
    get apiTargets(): ApikeysKeyRestrictionsApiTargetsList;
    putApiTargets(value: ApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable): void;
    resetApiTargets(): void;
    get apiTargetsInput(): cdktf.IResolvable | ApikeysKeyRestrictionsApiTargets[] | undefined;
    private _browserKeyRestrictions;
    get browserKeyRestrictions(): ApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference;
    putBrowserKeyRestrictions(value: ApikeysKeyRestrictionsBrowserKeyRestrictions): void;
    resetBrowserKeyRestrictions(): void;
    get browserKeyRestrictionsInput(): ApikeysKeyRestrictionsBrowserKeyRestrictions | undefined;
    private _iosKeyRestrictions;
    get iosKeyRestrictions(): ApikeysKeyRestrictionsIosKeyRestrictionsOutputReference;
    putIosKeyRestrictions(value: ApikeysKeyRestrictionsIosKeyRestrictions): void;
    resetIosKeyRestrictions(): void;
    get iosKeyRestrictionsInput(): ApikeysKeyRestrictionsIosKeyRestrictions | undefined;
    private _serverKeyRestrictions;
    get serverKeyRestrictions(): ApikeysKeyRestrictionsServerKeyRestrictionsOutputReference;
    putServerKeyRestrictions(value: ApikeysKeyRestrictionsServerKeyRestrictions): void;
    resetServerKeyRestrictions(): void;
    get serverKeyRestrictionsInput(): ApikeysKeyRestrictionsServerKeyRestrictions | undefined;
}
export interface ApikeysKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#create ApikeysKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#delete ApikeysKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apikeys_key#update ApikeysKey#update}
    */
    readonly update?: string;
}
export declare function apikeysKeyTimeoutsToTerraform(struct?: ApikeysKeyTimeoutsOutputReference | ApikeysKeyTimeouts | cdktf.IResolvable): any;
export declare class ApikeysKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApikeysKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApikeysKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apikeys_key google_apikeys_key}
*/
export declare class ApikeysKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apikeys_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apikeys_key google_apikeys_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApikeysKeyConfig
    */
    constructor(scope: Construct, id: string, config: ApikeysKeyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyString(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    private _restrictions;
    get restrictions(): ApikeysKeyRestrictionsOutputReference;
    putRestrictions(value: ApikeysKeyRestrictions): void;
    resetRestrictions(): void;
    get restrictionsInput(): ApikeysKeyRestrictions | undefined;
    private _timeouts;
    get timeouts(): ApikeysKeyTimeoutsOutputReference;
    putTimeouts(value: ApikeysKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApikeysKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
