import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineServiceSplitTrafficConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#id AppEngineServiceSplitTraffic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If set to true traffic will be migrated to this version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#migrate_traffic AppEngineServiceSplitTraffic#migrate_traffic}
    */
    readonly migrateTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#project AppEngineServiceSplitTraffic#project}
    */
    readonly project?: string;
    /**
    * The name of the service these settings apply to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#service AppEngineServiceSplitTraffic#service}
    */
    readonly service: string;
    /**
    * split block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#split AppEngineServiceSplitTraffic#split}
    */
    readonly split: AppEngineServiceSplitTrafficSplit;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#timeouts AppEngineServiceSplitTraffic#timeouts}
    */
    readonly timeouts?: AppEngineServiceSplitTrafficTimeouts;
}
export interface AppEngineServiceSplitTrafficSplit {
    /**
    * Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#allocations AppEngineServiceSplitTraffic#allocations}
    */
    readonly allocations: {
        [key: string]: string;
    };
    /**
    * Mechanism used to determine which version a request is sent to. The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#shard_by AppEngineServiceSplitTraffic#shard_by}
    */
    readonly shardBy?: string;
}
export declare function appEngineServiceSplitTrafficSplitToTerraform(struct?: AppEngineServiceSplitTrafficSplitOutputReference | AppEngineServiceSplitTrafficSplit): any;
export declare class AppEngineServiceSplitTrafficSplitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineServiceSplitTrafficSplit | undefined;
    set internalValue(value: AppEngineServiceSplitTrafficSplit | undefined);
    private _allocations?;
    get allocations(): {
        [key: string]: string;
    };
    set allocations(value: {
        [key: string]: string;
    });
    get allocationsInput(): {
        [key: string]: string;
    } | undefined;
    private _shardBy?;
    get shardBy(): string;
    set shardBy(value: string);
    resetShardBy(): void;
    get shardByInput(): string | undefined;
}
export interface AppEngineServiceSplitTrafficTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#create AppEngineServiceSplitTraffic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#delete AppEngineServiceSplitTraffic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#update AppEngineServiceSplitTraffic#update}
    */
    readonly update?: string;
}
export declare function appEngineServiceSplitTrafficTimeoutsToTerraform(struct?: AppEngineServiceSplitTrafficTimeoutsOutputReference | AppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable): any;
export declare class AppEngineServiceSplitTrafficTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic google_app_engine_service_split_traffic}
*/
export declare class AppEngineServiceSplitTraffic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_service_split_traffic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic google_app_engine_service_split_traffic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppEngineServiceSplitTrafficConfig
    */
    constructor(scope: Construct, id: string, config: AppEngineServiceSplitTrafficConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _migrateTraffic?;
    get migrateTraffic(): boolean | cdktf.IResolvable;
    set migrateTraffic(value: boolean | cdktf.IResolvable);
    resetMigrateTraffic(): void;
    get migrateTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _split;
    get split(): AppEngineServiceSplitTrafficSplitOutputReference;
    putSplit(value: AppEngineServiceSplitTrafficSplit): void;
    get splitInput(): AppEngineServiceSplitTrafficSplit | undefined;
    private _timeouts;
    get timeouts(): AppEngineServiceSplitTrafficTimeoutsOutputReference;
    putTimeouts(value: AppEngineServiceSplitTrafficTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppEngineServiceSplitTrafficTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
