import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies column names to use for data clustering. Up to four top-level columns are allowed, and should be specified in descending priority order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#clustering BigqueryTable#clustering}
    */
    readonly clustering?: string[];
    /**
    * The dataset ID to create the table in. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#dataset_id BigqueryTable#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Whether or not to allow Terraform to destroy the instance. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#deletion_protection BigqueryTable#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * The field description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#description BigqueryTable#description}
    */
    readonly description?: string;
    /**
    * The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#expiration_time BigqueryTable#expiration_time}
    */
    readonly expirationTime?: number;
    /**
    * A descriptive name for the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#friendly_name BigqueryTable#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#id BigqueryTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A mapping of labels to assign to the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#labels BigqueryTable#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The ID of the project in which the resource belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#project BigqueryTable#project}
    */
    readonly project?: string;
    /**
    * A JSON schema for the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#schema BigqueryTable#schema}
    */
    readonly schema?: string;
    /**
    * A unique ID for the resource. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#table_id BigqueryTable#table_id}
    */
    readonly tableId: string;
    /**
    * encryption_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#encryption_configuration BigqueryTable#encryption_configuration}
    */
    readonly encryptionConfiguration?: BigqueryTableEncryptionConfiguration;
    /**
    * external_data_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#external_data_configuration BigqueryTable#external_data_configuration}
    */
    readonly externalDataConfiguration?: BigqueryTableExternalDataConfiguration;
    /**
    * materialized_view block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#materialized_view BigqueryTable#materialized_view}
    */
    readonly materializedView?: BigqueryTableMaterializedView;
    /**
    * range_partitioning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#range_partitioning BigqueryTable#range_partitioning}
    */
    readonly rangePartitioning?: BigqueryTableRangePartitioning;
    /**
    * time_partitioning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#time_partitioning BigqueryTable#time_partitioning}
    */
    readonly timePartitioning?: BigqueryTableTimePartitioning;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#view BigqueryTable#view}
    */
    readonly view?: BigqueryTableView;
}
export interface BigqueryTableEncryptionConfiguration {
    /**
    * The self link or full name of a key which should be used to encrypt this table. Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#kms_key_name BigqueryTable#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function bigqueryTableEncryptionConfigurationToTerraform(struct?: BigqueryTableEncryptionConfigurationOutputReference | BigqueryTableEncryptionConfiguration): any;
export declare class BigqueryTableEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableEncryptionConfiguration | undefined;
    set internalValue(value: BigqueryTableEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersion(): string;
}
export interface BigqueryTableExternalDataConfigurationCsvOptions {
    /**
    * Indicates if BigQuery should accept rows that are missing trailing optional columns.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#allow_jagged_rows BigqueryTable#allow_jagged_rows}
    */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
    * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#allow_quoted_newlines BigqueryTable#allow_quoted_newlines}
    */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
    * The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#encoding BigqueryTable#encoding}
    */
    readonly encoding?: string;
    /**
    * The separator for fields in a CSV file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#field_delimiter BigqueryTable#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * The value that is used to quote data sections in a CSV file. If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as \". Due to limitations with Terraform default values, this value is required to be explicitly set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#quote BigqueryTable#quote}
    */
    readonly quote: string;
    /**
    * The number of rows at the top of a CSV file that BigQuery will skip when reading the data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#skip_leading_rows BigqueryTable#skip_leading_rows}
    */
    readonly skipLeadingRows?: number;
}
export declare function bigqueryTableExternalDataConfigurationCsvOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationCsvOptionsOutputReference | BigqueryTableExternalDataConfigurationCsvOptions): any;
export declare class BigqueryTableExternalDataConfigurationCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableExternalDataConfigurationCsvOptions | undefined;
    set internalValue(value: BigqueryTableExternalDataConfigurationCsvOptions | undefined);
    private _allowJaggedRows?;
    get allowJaggedRows(): boolean | cdktf.IResolvable;
    set allowJaggedRows(value: boolean | cdktf.IResolvable);
    resetAllowJaggedRows(): void;
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    get allowQuotedNewlines(): boolean | cdktf.IResolvable;
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable);
    resetAllowQuotedNewlines(): void;
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _quote?;
    get quote(): string;
    set quote(value: string);
    get quoteInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number;
    set skipLeadingRows(value: number);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface BigqueryTableExternalDataConfigurationGoogleSheetsOptions {
    /**
    * Range of a sheet to query from. Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#range BigqueryTable#range}
    */
    readonly range?: string;
    /**
    * The number of rows at the top of the sheet that BigQuery will skip when reading the data. At least one of range or skip_leading_rows must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#skip_leading_rows BigqueryTable#skip_leading_rows}
    */
    readonly skipLeadingRows?: number;
}
export declare function bigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference | BigqueryTableExternalDataConfigurationGoogleSheetsOptions): any;
export declare class BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    set internalValue(value: BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined);
    private _range?;
    get range(): string;
    set range(value: string);
    resetRange(): void;
    get rangeInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number;
    set skipLeadingRows(value: number);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface BigqueryTableExternalDataConfigurationHivePartitioningOptions {
    /**
    * When set, what mode of hive partitioning to use when reading data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#mode BigqueryTable#mode}
    */
    readonly mode?: string;
    /**
    * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#require_partition_filter BigqueryTable#require_partition_filter}
    */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
    * When hive partition detection is requested, a common for all source uris must be required. The prefix must end immediately before the partition key encoding begins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#source_uri_prefix BigqueryTable#source_uri_prefix}
    */
    readonly sourceUriPrefix?: string;
}
export declare function bigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform(struct?: BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference | BigqueryTableExternalDataConfigurationHivePartitioningOptions): any;
export declare class BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
    set internalValue(value: BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceUriPrefix?;
    get sourceUriPrefix(): string;
    set sourceUriPrefix(value: string);
    resetSourceUriPrefix(): void;
    get sourceUriPrefixInput(): string | undefined;
}
export interface BigqueryTableExternalDataConfiguration {
    /**
    * Let BigQuery try to autodetect the schema and format of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#autodetect BigqueryTable#autodetect}
    */
    readonly autodetect: boolean | cdktf.IResolvable;
    /**
    * The compression type of the data source. Valid values are "NONE" or "GZIP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#compression BigqueryTable#compression}
    */
    readonly compression?: string;
    /**
    * The connection specifying the credentials to be used to read external storage, such as Azure Blob, Cloud Storage, or S3. The connectionId can have the form "{{project}}.{{location}}.{{connection_id}}" or "projects/{{project}}/locations/{{location}}/connections/{{connection_id}}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#connection_id BigqueryTable#connection_id}
    */
    readonly connectionId?: string;
    /**
    * Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#ignore_unknown_values BigqueryTable#ignore_unknown_values}
    */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of bad records that BigQuery can ignore when reading data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#max_bad_records BigqueryTable#max_bad_records}
    */
    readonly maxBadRecords?: number;
    /**
    * A JSON schema for the external table. Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#schema BigqueryTable#schema}
    */
    readonly schema?: string;
    /**
    * The data format. Supported values are: "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET", "ORC" and "DATASTORE_BACKUP". To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#source_format BigqueryTable#source_format}
    */
    readonly sourceFormat: string;
    /**
    * A list of the fully-qualified URIs that point to your data in Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#source_uris BigqueryTable#source_uris}
    */
    readonly sourceUris: string[];
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#csv_options BigqueryTable#csv_options}
    */
    readonly csvOptions?: BigqueryTableExternalDataConfigurationCsvOptions;
    /**
    * google_sheets_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#google_sheets_options BigqueryTable#google_sheets_options}
    */
    readonly googleSheetsOptions?: BigqueryTableExternalDataConfigurationGoogleSheetsOptions;
    /**
    * hive_partitioning_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#hive_partitioning_options BigqueryTable#hive_partitioning_options}
    */
    readonly hivePartitioningOptions?: BigqueryTableExternalDataConfigurationHivePartitioningOptions;
}
export declare function bigqueryTableExternalDataConfigurationToTerraform(struct?: BigqueryTableExternalDataConfigurationOutputReference | BigqueryTableExternalDataConfiguration): any;
export declare class BigqueryTableExternalDataConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableExternalDataConfiguration | undefined;
    set internalValue(value: BigqueryTableExternalDataConfiguration | undefined);
    private _autodetect?;
    get autodetect(): boolean | cdktf.IResolvable;
    set autodetect(value: boolean | cdktf.IResolvable);
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _connectionId?;
    get connectionId(): string;
    set connectionId(value: string);
    resetConnectionId(): void;
    get connectionIdInput(): string | undefined;
    private _ignoreUnknownValues?;
    get ignoreUnknownValues(): boolean | cdktf.IResolvable;
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable);
    resetIgnoreUnknownValues(): void;
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    get maxBadRecords(): number;
    set maxBadRecords(value: number);
    resetMaxBadRecords(): void;
    get maxBadRecordsInput(): number | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    get sourceUris(): string[];
    set sourceUris(value: string[]);
    get sourceUrisInput(): string[] | undefined;
    private _csvOptions;
    get csvOptions(): BigqueryTableExternalDataConfigurationCsvOptionsOutputReference;
    putCsvOptions(value: BigqueryTableExternalDataConfigurationCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): BigqueryTableExternalDataConfigurationCsvOptions | undefined;
    private _googleSheetsOptions;
    get googleSheetsOptions(): BigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference;
    putGoogleSheetsOptions(value: BigqueryTableExternalDataConfigurationGoogleSheetsOptions): void;
    resetGoogleSheetsOptions(): void;
    get googleSheetsOptionsInput(): BigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    private _hivePartitioningOptions;
    get hivePartitioningOptions(): BigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference;
    putHivePartitioningOptions(value: BigqueryTableExternalDataConfigurationHivePartitioningOptions): void;
    resetHivePartitioningOptions(): void;
    get hivePartitioningOptionsInput(): BigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
}
export interface BigqueryTableMaterializedView {
    /**
    * Specifies if BigQuery should automatically refresh materialized view when the base table is updated. The default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#enable_refresh BigqueryTable#enable_refresh}
    */
    readonly enableRefresh?: boolean | cdktf.IResolvable;
    /**
    * A query whose result is persisted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#query BigqueryTable#query}
    */
    readonly query: string;
    /**
    * Specifies maximum frequency at which this materialized view will be refreshed. The default is 1800000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#refresh_interval_ms BigqueryTable#refresh_interval_ms}
    */
    readonly refreshIntervalMs?: number;
}
export declare function bigqueryTableMaterializedViewToTerraform(struct?: BigqueryTableMaterializedViewOutputReference | BigqueryTableMaterializedView): any;
export declare class BigqueryTableMaterializedViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableMaterializedView | undefined;
    set internalValue(value: BigqueryTableMaterializedView | undefined);
    private _enableRefresh?;
    get enableRefresh(): boolean | cdktf.IResolvable;
    set enableRefresh(value: boolean | cdktf.IResolvable);
    resetEnableRefresh(): void;
    get enableRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _refreshIntervalMs?;
    get refreshIntervalMs(): number;
    set refreshIntervalMs(value: number);
    resetRefreshIntervalMs(): void;
    get refreshIntervalMsInput(): number | undefined;
}
export interface BigqueryTableRangePartitioningRange {
    /**
    * End of the range partitioning, exclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#end BigqueryTable#end}
    */
    readonly end: number;
    /**
    * The width of each range within the partition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#interval BigqueryTable#interval}
    */
    readonly interval: number;
    /**
    * Start of the range partitioning, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#start BigqueryTable#start}
    */
    readonly start: number;
}
export declare function bigqueryTableRangePartitioningRangeToTerraform(struct?: BigqueryTableRangePartitioningRangeOutputReference | BigqueryTableRangePartitioningRange): any;
export declare class BigqueryTableRangePartitioningRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableRangePartitioningRange | undefined;
    set internalValue(value: BigqueryTableRangePartitioningRange | undefined);
    private _end?;
    get end(): number;
    set end(value: number);
    get endInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    get startInput(): number | undefined;
}
export interface BigqueryTableRangePartitioning {
    /**
    * The field used to determine how to create a range-based partition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#field BigqueryTable#field}
    */
    readonly field: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#range BigqueryTable#range}
    */
    readonly range: BigqueryTableRangePartitioningRange;
}
export declare function bigqueryTableRangePartitioningToTerraform(struct?: BigqueryTableRangePartitioningOutputReference | BigqueryTableRangePartitioning): any;
export declare class BigqueryTableRangePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableRangePartitioning | undefined;
    set internalValue(value: BigqueryTableRangePartitioning | undefined);
    private _field?;
    get field(): string;
    set field(value: string);
    get fieldInput(): string | undefined;
    private _range;
    get range(): BigqueryTableRangePartitioningRangeOutputReference;
    putRange(value: BigqueryTableRangePartitioningRange): void;
    get rangeInput(): BigqueryTableRangePartitioningRange | undefined;
}
export interface BigqueryTableTimePartitioning {
    /**
    * Number of milliseconds for which to keep the storage for a partition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#expiration_ms BigqueryTable#expiration_ms}
    */
    readonly expirationMs?: number;
    /**
    * The field used to determine how to create a time-based partition. If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#field BigqueryTable#field}
    */
    readonly field?: string;
    /**
    * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#require_partition_filter BigqueryTable#require_partition_filter}
    */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
    * The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#type BigqueryTable#type}
    */
    readonly type: string;
}
export declare function bigqueryTableTimePartitioningToTerraform(struct?: BigqueryTableTimePartitioningOutputReference | BigqueryTableTimePartitioning): any;
export declare class BigqueryTableTimePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableTimePartitioning | undefined;
    set internalValue(value: BigqueryTableTimePartitioning | undefined);
    private _expirationMs?;
    get expirationMs(): number;
    set expirationMs(value: number);
    resetExpirationMs(): void;
    get expirationMsInput(): number | undefined;
    private _field?;
    get field(): string;
    set field(value: string);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BigqueryTableView {
    /**
    * A query that BigQuery executes when the view is referenced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#query BigqueryTable#query}
    */
    readonly query: string;
    /**
    * Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table#use_legacy_sql BigqueryTable#use_legacy_sql}
    */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
}
export declare function bigqueryTableViewToTerraform(struct?: BigqueryTableViewOutputReference | BigqueryTableView): any;
export declare class BigqueryTableViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableView | undefined;
    set internalValue(value: BigqueryTableView | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _useLegacySql?;
    get useLegacySql(): boolean | cdktf.IResolvable;
    set useLegacySql(value: boolean | cdktf.IResolvable);
    resetUseLegacySql(): void;
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table google_bigquery_table}
*/
export declare class BigqueryTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table google_bigquery_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryTableConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryTableConfig);
    private _clustering?;
    get clustering(): string[];
    set clustering(value: string[]);
    resetClustering(): void;
    get clusteringInput(): string[] | undefined;
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _expirationTime?;
    get expirationTime(): number;
    set expirationTime(value: number);
    resetExpirationTime(): void;
    get expirationTimeInput(): number | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastModifiedTime(): number;
    get location(): string;
    get numBytes(): number;
    get numLongTermBytes(): number;
    get numRows(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    get selfLink(): string;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
    get type(): string;
    private _encryptionConfiguration;
    get encryptionConfiguration(): BigqueryTableEncryptionConfigurationOutputReference;
    putEncryptionConfiguration(value: BigqueryTableEncryptionConfiguration): void;
    resetEncryptionConfiguration(): void;
    get encryptionConfigurationInput(): BigqueryTableEncryptionConfiguration | undefined;
    private _externalDataConfiguration;
    get externalDataConfiguration(): BigqueryTableExternalDataConfigurationOutputReference;
    putExternalDataConfiguration(value: BigqueryTableExternalDataConfiguration): void;
    resetExternalDataConfiguration(): void;
    get externalDataConfigurationInput(): BigqueryTableExternalDataConfiguration | undefined;
    private _materializedView;
    get materializedView(): BigqueryTableMaterializedViewOutputReference;
    putMaterializedView(value: BigqueryTableMaterializedView): void;
    resetMaterializedView(): void;
    get materializedViewInput(): BigqueryTableMaterializedView | undefined;
    private _rangePartitioning;
    get rangePartitioning(): BigqueryTableRangePartitioningOutputReference;
    putRangePartitioning(value: BigqueryTableRangePartitioning): void;
    resetRangePartitioning(): void;
    get rangePartitioningInput(): BigqueryTableRangePartitioning | undefined;
    private _timePartitioning;
    get timePartitioning(): BigqueryTableTimePartitioningOutputReference;
    putTimePartitioning(value: BigqueryTableTimePartitioning): void;
    resetTimePartitioning(): void;
    get timePartitioningInput(): BigqueryTableTimePartitioning | undefined;
    private _view;
    get view(): BigqueryTableViewOutputReference;
    putView(value: BigqueryTableView): void;
    resetView(): void;
    get viewInput(): BigqueryTableView | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
