import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BinaryAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A descriptive comment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#description BinaryAuthorizationPolicy#description}
    */
    readonly description?: string;
    /**
    * Controls the evaluation of a Google-maintained global admission policy
  for common system-level images. Images not covered by the global
  policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#global_policy_evaluation_mode BinaryAuthorizationPolicy#global_policy_evaluation_mode}
    */
    readonly globalPolicyEvaluationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#id BinaryAuthorizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#project BinaryAuthorizationPolicy#project}
    */
    readonly project?: string;
    /**
    * admission_whitelist_patterns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#admission_whitelist_patterns BinaryAuthorizationPolicy#admission_whitelist_patterns}
    */
    readonly admissionWhitelistPatterns?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable;
    /**
    * cluster_admission_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#cluster_admission_rules BinaryAuthorizationPolicy#cluster_admission_rules}
    */
    readonly clusterAdmissionRules?: BinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable;
    /**
    * default_admission_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#default_admission_rule BinaryAuthorizationPolicy#default_admission_rule}
    */
    readonly defaultAdmissionRule: BinaryAuthorizationPolicyDefaultAdmissionRule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#timeouts BinaryAuthorizationPolicy#timeouts}
    */
    readonly timeouts?: BinaryAuthorizationPolicyTimeouts;
}
export interface BinaryAuthorizationPolicyAdmissionWhitelistPatterns {
    /**
    * An image name pattern to whitelist, in the form
  'registry/path/to/image'. This supports a trailing * as a
  wildcard, but this is allowed only in text after the registry/
  part.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#name_pattern BinaryAuthorizationPolicy#name_pattern}
    */
    readonly namePattern: string;
}
export declare function binaryAuthorizationPolicyAdmissionWhitelistPatternsToTerraform(struct?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable): any;
export declare class BinaryAuthorizationPolicyAdmissionWhitelistPatternsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable | undefined;
    set internalValue(value: BinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable | undefined);
    private _namePattern?;
    get namePattern(): string;
    set namePattern(value: string);
    get namePatternInput(): string | undefined;
}
export declare class BinaryAuthorizationPolicyAdmissionWhitelistPatternsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BinaryAuthorizationPolicyAdmissionWhitelistPatternsOutputReference;
}
export interface BinaryAuthorizationPolicyClusterAdmissionRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#cluster BinaryAuthorizationPolicy#cluster}
    */
    readonly cluster: string;
    /**
    * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
    */
    readonly enforcementMode: string;
    /**
    * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
    */
    readonly evaluationMode: string;
    /**
    * The resource names of the attestors that must attest to a
  container image. If the attestor is in a different project from the
  policy, it should be specified in the format 'projects/*\/attestors/*'.
  Each attestor must exist before a policy can reference it. To add an
  attestor to a policy the principal issuing the policy change
  request must be able to read the attestor resource.
  
  Note: this field must be non-empty when the evaluation_mode field
  specifies REQUIRE_ATTESTATION, otherwise it must be empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
    */
    readonly requireAttestationsBy?: string[];
}
export declare function binaryAuthorizationPolicyClusterAdmissionRulesToTerraform(struct?: BinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable): any;
export declare class BinaryAuthorizationPolicyClusterAdmissionRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable | undefined;
    set internalValue(value: BinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    get requireAttestationsBy(): string[];
    set requireAttestationsBy(value: string[]);
    resetRequireAttestationsBy(): void;
    get requireAttestationsByInput(): string[] | undefined;
}
export declare class BinaryAuthorizationPolicyClusterAdmissionRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BinaryAuthorizationPolicyClusterAdmissionRulesOutputReference;
}
export interface BinaryAuthorizationPolicyDefaultAdmissionRule {
    /**
    * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#enforcement_mode BinaryAuthorizationPolicy#enforcement_mode}
    */
    readonly enforcementMode: string;
    /**
    * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#evaluation_mode BinaryAuthorizationPolicy#evaluation_mode}
    */
    readonly evaluationMode: string;
    /**
    * The resource names of the attestors that must attest to a
  container image. If the attestor is in a different project from the
  policy, it should be specified in the format 'projects/*\/attestors/*'.
  Each attestor must exist before a policy can reference it. To add an
  attestor to a policy the principal issuing the policy change
  request must be able to read the attestor resource.
  
  Note: this field must be non-empty when the evaluation_mode field
  specifies REQUIRE_ATTESTATION, otherwise it must be empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#require_attestations_by BinaryAuthorizationPolicy#require_attestations_by}
    */
    readonly requireAttestationsBy?: string[];
}
export declare function binaryAuthorizationPolicyDefaultAdmissionRuleToTerraform(struct?: BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference | BinaryAuthorizationPolicyDefaultAdmissionRule): any;
export declare class BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    set internalValue(value: BinaryAuthorizationPolicyDefaultAdmissionRule | undefined);
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    get requireAttestationsBy(): string[];
    set requireAttestationsBy(value: string[]);
    resetRequireAttestationsBy(): void;
    get requireAttestationsByInput(): string[] | undefined;
}
export interface BinaryAuthorizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#create BinaryAuthorizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#delete BinaryAuthorizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy#update BinaryAuthorizationPolicy#update}
    */
    readonly update?: string;
}
export declare function binaryAuthorizationPolicyTimeoutsToTerraform(struct?: BinaryAuthorizationPolicyTimeoutsOutputReference | BinaryAuthorizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class BinaryAuthorizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BinaryAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BinaryAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy google_binary_authorization_policy}
*/
export declare class BinaryAuthorizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_binary_authorization_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_policy google_binary_authorization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BinaryAuthorizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalPolicyEvaluationMode?;
    get globalPolicyEvaluationMode(): string;
    set globalPolicyEvaluationMode(value: string);
    resetGlobalPolicyEvaluationMode(): void;
    get globalPolicyEvaluationModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _admissionWhitelistPatterns;
    get admissionWhitelistPatterns(): BinaryAuthorizationPolicyAdmissionWhitelistPatternsList;
    putAdmissionWhitelistPatterns(value: BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable): void;
    resetAdmissionWhitelistPatterns(): void;
    get admissionWhitelistPatternsInput(): cdktf.IResolvable | BinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    private _clusterAdmissionRules;
    get clusterAdmissionRules(): BinaryAuthorizationPolicyClusterAdmissionRulesList;
    putClusterAdmissionRules(value: BinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable): void;
    resetClusterAdmissionRules(): void;
    get clusterAdmissionRulesInput(): cdktf.IResolvable | BinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    private _defaultAdmissionRule;
    get defaultAdmissionRule(): BinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference;
    putDefaultAdmissionRule(value: BinaryAuthorizationPolicyDefaultAdmissionRule): void;
    get defaultAdmissionRuleInput(): BinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    private _timeouts;
    get timeouts(): BinaryAuthorizationPolicyTimeoutsOutputReference;
    putTimeouts(value: BinaryAuthorizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BinaryAuthorizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
