import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface Cloudfunctions2FunctionIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#cloud_function Cloudfunctions2FunctionIamBinding#cloud_function}
    */
    readonly cloudFunction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#id Cloudfunctions2FunctionIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#location Cloudfunctions2FunctionIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#members Cloudfunctions2FunctionIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#project Cloudfunctions2FunctionIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#role Cloudfunctions2FunctionIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#condition Cloudfunctions2FunctionIamBinding#condition}
    */
    readonly condition?: Cloudfunctions2FunctionIamBindingCondition;
}
export interface Cloudfunctions2FunctionIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#description Cloudfunctions2FunctionIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#expression Cloudfunctions2FunctionIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding#title Cloudfunctions2FunctionIamBinding#title}
    */
    readonly title: string;
}
export declare function cloudfunctions2FunctionIamBindingConditionToTerraform(struct?: Cloudfunctions2FunctionIamBindingConditionOutputReference | Cloudfunctions2FunctionIamBindingCondition): any;
export declare class Cloudfunctions2FunctionIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionIamBindingCondition | undefined;
    set internalValue(value: Cloudfunctions2FunctionIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding google_cloudfunctions2_function_iam_binding}
*/
export declare class Cloudfunctions2FunctionIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions2_function_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_binding google_cloudfunctions2_function_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Cloudfunctions2FunctionIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: Cloudfunctions2FunctionIamBindingConfig);
    private _cloudFunction?;
    get cloudFunction(): string;
    set cloudFunction(value: string);
    get cloudFunctionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): Cloudfunctions2FunctionIamBindingConditionOutputReference;
    putCondition(value: Cloudfunctions2FunctionIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): Cloudfunctions2FunctionIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
