import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface Cloudfunctions2FunctionIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#cloud_function Cloudfunctions2FunctionIamMember#cloud_function}
    */
    readonly cloudFunction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#id Cloudfunctions2FunctionIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#location Cloudfunctions2FunctionIamMember#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#member Cloudfunctions2FunctionIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#project Cloudfunctions2FunctionIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#role Cloudfunctions2FunctionIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#condition Cloudfunctions2FunctionIamMember#condition}
    */
    readonly condition?: Cloudfunctions2FunctionIamMemberCondition;
}
export interface Cloudfunctions2FunctionIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#description Cloudfunctions2FunctionIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#expression Cloudfunctions2FunctionIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member#title Cloudfunctions2FunctionIamMember#title}
    */
    readonly title: string;
}
export declare function cloudfunctions2FunctionIamMemberConditionToTerraform(struct?: Cloudfunctions2FunctionIamMemberConditionOutputReference | Cloudfunctions2FunctionIamMemberCondition): any;
export declare class Cloudfunctions2FunctionIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionIamMemberCondition | undefined;
    set internalValue(value: Cloudfunctions2FunctionIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member google_cloudfunctions2_function_iam_member}
*/
export declare class Cloudfunctions2FunctionIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions2_function_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function_iam_member google_cloudfunctions2_function_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Cloudfunctions2FunctionIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: Cloudfunctions2FunctionIamMemberConfig);
    private _cloudFunction?;
    get cloudFunction(): string;
    set cloudFunction(value: string);
    get cloudFunctionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): Cloudfunctions2FunctionIamMemberConditionOutputReference;
    putCondition(value: Cloudfunctions2FunctionIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): Cloudfunctions2FunctionIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
