import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface Cloudfunctions2FunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description of a function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#description Cloudfunctions2Function#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#id Cloudfunctions2Function#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs associated with this Cloud Function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#labels Cloudfunctions2Function#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of this cloud function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#location Cloudfunctions2Function#location}
    */
    readonly location?: string;
    /**
    * A user-defined name of the function. Function names must
  be unique globally and match pattern 'projects/*\/locations/*\/functions/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#name Cloudfunctions2Function#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#project Cloudfunctions2Function#project}
    */
    readonly project?: string;
    /**
    * build_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#build_config Cloudfunctions2Function#build_config}
    */
    readonly buildConfig?: Cloudfunctions2FunctionBuildConfig;
    /**
    * event_trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#event_trigger Cloudfunctions2Function#event_trigger}
    */
    readonly eventTrigger?: Cloudfunctions2FunctionEventTrigger;
    /**
    * service_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#service_config Cloudfunctions2Function#service_config}
    */
    readonly serviceConfig?: Cloudfunctions2FunctionServiceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#timeouts Cloudfunctions2Function#timeouts}
    */
    readonly timeouts?: Cloudfunctions2FunctionTimeouts;
}
export interface Cloudfunctions2FunctionBuildConfigSourceRepoSource {
    /**
    * Regex matching branches to build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#branch_name Cloudfunctions2Function#branch_name}
    */
    readonly branchName?: string;
    /**
    * Regex matching tags to build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#commit_sha Cloudfunctions2Function#commit_sha}
    */
    readonly commitSha?: string;
    /**
    * Directory, relative to the source root, in which to run the build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#dir Cloudfunctions2Function#dir}
    */
    readonly dir?: string;
    /**
    * Only trigger a build if the revision regex does
  NOT match the revision regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#invert_regex Cloudfunctions2Function#invert_regex}
    */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
    * ID of the project that owns the Cloud Source Repository. If omitted, the
  project ID requesting the build is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#project_id Cloudfunctions2Function#project_id}
    */
    readonly projectId?: string;
    /**
    * Name of the Cloud Source Repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#repo_name Cloudfunctions2Function#repo_name}
    */
    readonly repoName?: string;
    /**
    * Regex matching tags to build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#tag_name Cloudfunctions2Function#tag_name}
    */
    readonly tagName?: string;
}
export declare function cloudfunctions2FunctionBuildConfigSourceRepoSourceToTerraform(struct?: Cloudfunctions2FunctionBuildConfigSourceRepoSourceOutputReference | Cloudfunctions2FunctionBuildConfigSourceRepoSource): any;
export declare class Cloudfunctions2FunctionBuildConfigSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionBuildConfigSourceRepoSource | undefined;
    set internalValue(value: Cloudfunctions2FunctionBuildConfigSourceRepoSource | undefined);
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    resetBranchName(): void;
    get branchNameInput(): string | undefined;
    private _commitSha?;
    get commitSha(): string;
    set commitSha(value: string);
    resetCommitSha(): void;
    get commitShaInput(): string | undefined;
    private _dir?;
    get dir(): string;
    set dir(value: string);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable;
    set invertRegex(value: boolean | cdktf.IResolvable);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _repoName?;
    get repoName(): string;
    set repoName(value: string);
    resetRepoName(): void;
    get repoNameInput(): string | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    resetTagName(): void;
    get tagNameInput(): string | undefined;
}
export interface Cloudfunctions2FunctionBuildConfigSourceStorageSource {
    /**
    * Google Cloud Storage bucket containing the source
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#bucket Cloudfunctions2Function#bucket}
    */
    readonly bucket?: string;
    /**
    * Google Cloud Storage generation for the object. If the generation
  is omitted, the latest generation will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#generation Cloudfunctions2Function#generation}
    */
    readonly generation?: number;
    /**
    * Google Cloud Storage object containing the source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#object Cloudfunctions2Function#object}
    */
    readonly object?: string;
}
export declare function cloudfunctions2FunctionBuildConfigSourceStorageSourceToTerraform(struct?: Cloudfunctions2FunctionBuildConfigSourceStorageSourceOutputReference | Cloudfunctions2FunctionBuildConfigSourceStorageSource): any;
export declare class Cloudfunctions2FunctionBuildConfigSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionBuildConfigSourceStorageSource | undefined;
    set internalValue(value: Cloudfunctions2FunctionBuildConfigSourceStorageSource | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    resetObject(): void;
    get objectInput(): string | undefined;
}
export interface Cloudfunctions2FunctionBuildConfigSource {
    /**
    * repo_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#repo_source Cloudfunctions2Function#repo_source}
    */
    readonly repoSource?: Cloudfunctions2FunctionBuildConfigSourceRepoSource;
    /**
    * storage_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#storage_source Cloudfunctions2Function#storage_source}
    */
    readonly storageSource?: Cloudfunctions2FunctionBuildConfigSourceStorageSource;
}
export declare function cloudfunctions2FunctionBuildConfigSourceToTerraform(struct?: Cloudfunctions2FunctionBuildConfigSourceOutputReference | Cloudfunctions2FunctionBuildConfigSource): any;
export declare class Cloudfunctions2FunctionBuildConfigSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionBuildConfigSource | undefined;
    set internalValue(value: Cloudfunctions2FunctionBuildConfigSource | undefined);
    private _repoSource;
    get repoSource(): Cloudfunctions2FunctionBuildConfigSourceRepoSourceOutputReference;
    putRepoSource(value: Cloudfunctions2FunctionBuildConfigSourceRepoSource): void;
    resetRepoSource(): void;
    get repoSourceInput(): Cloudfunctions2FunctionBuildConfigSourceRepoSource | undefined;
    private _storageSource;
    get storageSource(): Cloudfunctions2FunctionBuildConfigSourceStorageSourceOutputReference;
    putStorageSource(value: Cloudfunctions2FunctionBuildConfigSourceStorageSource): void;
    resetStorageSource(): void;
    get storageSourceInput(): Cloudfunctions2FunctionBuildConfigSourceStorageSource | undefined;
}
export interface Cloudfunctions2FunctionBuildConfig {
    /**
    * User managed repository created in Artifact Registry optionally with a customer managed encryption key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#docker_repository Cloudfunctions2Function#docker_repository}
    */
    readonly dockerRepository?: string;
    /**
    * The name of the function (as defined in source code) that will be executed.
  Defaults to the resource name suffix, if not specified. For backward
  compatibility, if function with given name is not found, then the system
  will try to use function named "function". For Node.js this is name of a
  function exported by the module specified in source_location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#entry_point Cloudfunctions2Function#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * User-provided build-time environment variables for the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#environment_variables Cloudfunctions2Function#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * The runtime in which to run the function. Required when deploying a new
  function, optional when updating an existing function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#runtime Cloudfunctions2Function#runtime}
    */
    readonly runtime?: string;
    /**
    * Name of the Cloud Build Custom Worker Pool that should be used to build the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#worker_pool Cloudfunctions2Function#worker_pool}
    */
    readonly workerPool?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#source Cloudfunctions2Function#source}
    */
    readonly source?: Cloudfunctions2FunctionBuildConfigSource;
}
export declare function cloudfunctions2FunctionBuildConfigToTerraform(struct?: Cloudfunctions2FunctionBuildConfigOutputReference | Cloudfunctions2FunctionBuildConfig): any;
export declare class Cloudfunctions2FunctionBuildConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionBuildConfig | undefined;
    set internalValue(value: Cloudfunctions2FunctionBuildConfig | undefined);
    get buildAttribute(): string;
    private _dockerRepository?;
    get dockerRepository(): string;
    set dockerRepository(value: string);
    resetDockerRepository(): void;
    get dockerRepositoryInput(): string | undefined;
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    resetRuntime(): void;
    get runtimeInput(): string | undefined;
    private _workerPool?;
    get workerPool(): string;
    set workerPool(value: string);
    resetWorkerPool(): void;
    get workerPoolInput(): string | undefined;
    private _source;
    get source(): Cloudfunctions2FunctionBuildConfigSourceOutputReference;
    putSource(value: Cloudfunctions2FunctionBuildConfigSource): void;
    resetSource(): void;
    get sourceInput(): Cloudfunctions2FunctionBuildConfigSource | undefined;
}
export interface Cloudfunctions2FunctionEventTriggerEventFilters {
    /**
    * 'Required. The name of a CloudEvents attribute.
  Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
  Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#attribute Cloudfunctions2Function#attribute}
    */
    readonly attribute: string;
    /**
    * Optional. The operator used for matching the events with the value of
  the filter. If not specified, only events that have an exact key-value
  pair specified in the filter are matched.
  The only allowed value is 'match-path-pattern'.
  [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#operator Cloudfunctions2Function#operator}
    */
    readonly operator?: string;
    /**
    * Required. The value for the attribute.
  If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#value Cloudfunctions2Function#value}
    */
    readonly value: string;
}
export declare function cloudfunctions2FunctionEventTriggerEventFiltersToTerraform(struct?: Cloudfunctions2FunctionEventTriggerEventFilters | cdktf.IResolvable): any;
export declare class Cloudfunctions2FunctionEventTriggerEventFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Cloudfunctions2FunctionEventTriggerEventFilters | cdktf.IResolvable | undefined;
    set internalValue(value: Cloudfunctions2FunctionEventTriggerEventFilters | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class Cloudfunctions2FunctionEventTriggerEventFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: Cloudfunctions2FunctionEventTriggerEventFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Cloudfunctions2FunctionEventTriggerEventFiltersOutputReference;
}
export interface Cloudfunctions2FunctionEventTrigger {
    /**
    * Required. The type of event to observe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#event_type Cloudfunctions2Function#event_type}
    */
    readonly eventType?: string;
    /**
    * The name of a Pub/Sub topic in the same project that will be used
  as the transport topic for the event delivery.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#pubsub_topic Cloudfunctions2Function#pubsub_topic}
    */
    readonly pubsubTopic?: string;
    /**
    * Describes the retry policy in case of function's execution failure.
  Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#retry_policy Cloudfunctions2Function#retry_policy}
    */
    readonly retryPolicy?: string;
    /**
    * The email of the service account for this function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#service_account_email Cloudfunctions2Function#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * The region that the trigger will be in. The trigger will only receive
  events originating in this region. It can be the same
  region as the function, a different region or multi-region, or the global
  region. If not provided, defaults to the same region as the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#trigger_region Cloudfunctions2Function#trigger_region}
    */
    readonly triggerRegion?: string;
    /**
    * event_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#event_filters Cloudfunctions2Function#event_filters}
    */
    readonly eventFilters?: Cloudfunctions2FunctionEventTriggerEventFilters[] | cdktf.IResolvable;
}
export declare function cloudfunctions2FunctionEventTriggerToTerraform(struct?: Cloudfunctions2FunctionEventTriggerOutputReference | Cloudfunctions2FunctionEventTrigger): any;
export declare class Cloudfunctions2FunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionEventTrigger | undefined;
    set internalValue(value: Cloudfunctions2FunctionEventTrigger | undefined);
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    resetEventType(): void;
    get eventTypeInput(): string | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    resetPubsubTopic(): void;
    get pubsubTopicInput(): string | undefined;
    private _retryPolicy?;
    get retryPolicy(): string;
    set retryPolicy(value: string);
    resetRetryPolicy(): void;
    get retryPolicyInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    get trigger(): string;
    private _triggerRegion?;
    get triggerRegion(): string;
    set triggerRegion(value: string);
    resetTriggerRegion(): void;
    get triggerRegionInput(): string | undefined;
    private _eventFilters;
    get eventFilters(): Cloudfunctions2FunctionEventTriggerEventFiltersList;
    putEventFilters(value: Cloudfunctions2FunctionEventTriggerEventFilters[] | cdktf.IResolvable): void;
    resetEventFilters(): void;
    get eventFiltersInput(): cdktf.IResolvable | Cloudfunctions2FunctionEventTriggerEventFilters[] | undefined;
}
export interface Cloudfunctions2FunctionServiceConfig {
    /**
    * Whether 100% of traffic is routed to the latest revision. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#all_traffic_on_latest_revision Cloudfunctions2Function#all_traffic_on_latest_revision}
    */
    readonly allTrafficOnLatestRevision?: boolean | cdktf.IResolvable;
    /**
    * The amount of memory available for a function.
  Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
  supplied the value is interpreted as bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#available_memory Cloudfunctions2Function#available_memory}
    */
    readonly availableMemory?: string;
    /**
    * Environment variables that shall be available during function execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#environment_variables Cloudfunctions2Function#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#ingress_settings Cloudfunctions2Function#ingress_settings}
    */
    readonly ingressSettings?: string;
    /**
    * The limit on the maximum number of function instances that may coexist at a
  given time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#max_instance_count Cloudfunctions2Function#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * The limit on the minimum number of function instances that may coexist at a
  given time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#min_instance_count Cloudfunctions2Function#min_instance_count}
    */
    readonly minInstanceCount?: number;
    /**
    * Name of the service associated with a Function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#service Cloudfunctions2Function#service}
    */
    readonly service?: string;
    /**
    * The email of the service account for this function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#service_account_email Cloudfunctions2Function#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * The function execution timeout. Execution is considered failed and
  can be terminated if the function is not completed at the end of the
  timeout period. Defaults to 60 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#timeout_seconds Cloudfunctions2Function#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * The Serverless VPC Access connector that this cloud function can connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#vpc_connector Cloudfunctions2Function#vpc_connector}
    */
    readonly vpcConnector?: string;
    /**
    * Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#vpc_connector_egress_settings Cloudfunctions2Function#vpc_connector_egress_settings}
    */
    readonly vpcConnectorEgressSettings?: string;
}
export declare function cloudfunctions2FunctionServiceConfigToTerraform(struct?: Cloudfunctions2FunctionServiceConfigOutputReference | Cloudfunctions2FunctionServiceConfig): any;
export declare class Cloudfunctions2FunctionServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionServiceConfig | undefined;
    set internalValue(value: Cloudfunctions2FunctionServiceConfig | undefined);
    private _allTrafficOnLatestRevision?;
    get allTrafficOnLatestRevision(): boolean | cdktf.IResolvable;
    set allTrafficOnLatestRevision(value: boolean | cdktf.IResolvable);
    resetAllTrafficOnLatestRevision(): void;
    get allTrafficOnLatestRevisionInput(): boolean | cdktf.IResolvable | undefined;
    private _availableMemory?;
    get availableMemory(): string;
    set availableMemory(value: string);
    resetAvailableMemory(): void;
    get availableMemoryInput(): string | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    get gcfUri(): string;
    private _ingressSettings?;
    get ingressSettings(): string;
    set ingressSettings(value: string);
    resetIngressSettings(): void;
    get ingressSettingsInput(): string | undefined;
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    get uri(): string;
    private _vpcConnector?;
    get vpcConnector(): string;
    set vpcConnector(value: string);
    resetVpcConnector(): void;
    get vpcConnectorInput(): string | undefined;
    private _vpcConnectorEgressSettings?;
    get vpcConnectorEgressSettings(): string;
    set vpcConnectorEgressSettings(value: string);
    resetVpcConnectorEgressSettings(): void;
    get vpcConnectorEgressSettingsInput(): string | undefined;
}
export interface Cloudfunctions2FunctionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#create Cloudfunctions2Function#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#delete Cloudfunctions2Function#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function#update Cloudfunctions2Function#update}
    */
    readonly update?: string;
}
export declare function cloudfunctions2FunctionTimeoutsToTerraform(struct?: Cloudfunctions2FunctionTimeoutsOutputReference | Cloudfunctions2FunctionTimeouts | cdktf.IResolvable): any;
export declare class Cloudfunctions2FunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Cloudfunctions2FunctionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: Cloudfunctions2FunctionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function google_cloudfunctions2_function}
*/
export declare class Cloudfunctions2Function extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions2_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions2_function google_cloudfunctions2_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Cloudfunctions2FunctionConfig
    */
    constructor(scope: Construct, id: string, config: Cloudfunctions2FunctionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get environment(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get updateTime(): string;
    private _buildConfig;
    get buildConfig(): Cloudfunctions2FunctionBuildConfigOutputReference;
    putBuildConfig(value: Cloudfunctions2FunctionBuildConfig): void;
    resetBuildConfig(): void;
    get buildConfigInput(): Cloudfunctions2FunctionBuildConfig | undefined;
    private _eventTrigger;
    get eventTrigger(): Cloudfunctions2FunctionEventTriggerOutputReference;
    putEventTrigger(value: Cloudfunctions2FunctionEventTrigger): void;
    resetEventTrigger(): void;
    get eventTriggerInput(): Cloudfunctions2FunctionEventTrigger | undefined;
    private _serviceConfig;
    get serviceConfig(): Cloudfunctions2FunctionServiceConfigOutputReference;
    putServiceConfig(value: Cloudfunctions2FunctionServiceConfig): void;
    resetServiceConfig(): void;
    get serviceConfigInput(): Cloudfunctions2FunctionServiceConfig | undefined;
    private _timeouts;
    get timeouts(): Cloudfunctions2FunctionTimeoutsOutputReference;
    putTimeouts(value: Cloudfunctions2FunctionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | Cloudfunctions2FunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
