import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to allow sending and receiving of packets with non-matching source or destination IPs. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#can_ip_forward ComputeInstanceTemplate#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * A brief description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#description ComputeInstanceTemplate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#id ComputeInstanceTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A description of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#instance_description ComputeInstanceTemplate#instance_description}
    */
    readonly instanceDescription?: string;
    /**
    * A set of key/value label pairs to assign to instances created from this template,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#labels ComputeInstanceTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create. To create a machine with a custom type (such as extended memory), format the value like custom-VCPUS-MEM_IN_MB like custom-6-20480 for 6 vCPU and 20GB of RAM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#machine_type ComputeInstanceTemplate#machine_type}
    */
    readonly machineType: string;
    /**
    * Metadata key/value pairs to make available from within instances created from this template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#metadata ComputeInstanceTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * An alternative to using the startup-script metadata key, mostly to match the compute_instance resource. This replaces the startup-script metadata key on the created instance and thus the two mechanisms are not allowed to be used simultaneously.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#metadata_startup_script ComputeInstanceTemplate#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell or Intel Skylake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#min_cpu_platform ComputeInstanceTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#name ComputeInstanceTemplate#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#name_prefix ComputeInstanceTemplate#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#project ComputeInstanceTemplate#project}
    */
    readonly project?: string;
    /**
    * An instance template is a global resource that is not bound to a zone or a region. However, you can still specify some regional resources in an instance template, which restricts the template to the region where that resource resides. For example, a custom subnetwork resource is tied to a specific region. Defaults to the region of the Provider if no value is given.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#region ComputeInstanceTemplate#region}
    */
    readonly region?: string;
    /**
    * Tags to attach to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#tags ComputeInstanceTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#advanced_machine_features ComputeInstanceTemplate#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: ComputeInstanceTemplateAdvancedMachineFeatures;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#confidential_instance_config ComputeInstanceTemplate#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: ComputeInstanceTemplateConfidentialInstanceConfig;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk ComputeInstanceTemplate#disk}
    */
    readonly disk: ComputeInstanceTemplateDisk[] | cdktf.IResolvable;
    /**
    * guest_accelerator block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#guest_accelerator ComputeInstanceTemplate#guest_accelerator}
    */
    readonly guestAccelerator?: ComputeInstanceTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_interface ComputeInstanceTemplate#network_interface}
    */
    readonly networkInterface?: ComputeInstanceTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#reservation_affinity ComputeInstanceTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: ComputeInstanceTemplateReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#scheduling ComputeInstanceTemplate#scheduling}
    */
    readonly scheduling?: ComputeInstanceTemplateScheduling;
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#service_account ComputeInstanceTemplate#service_account}
    */
    readonly serviceAccount?: ComputeInstanceTemplateServiceAccount;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#shielded_instance_config ComputeInstanceTemplate#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ComputeInstanceTemplateShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#timeouts ComputeInstanceTemplate#timeouts}
    */
    readonly timeouts?: ComputeInstanceTemplateTimeouts;
}
export interface ComputeInstanceTemplateAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_nested_virtualization ComputeInstanceTemplate#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#threads_per_core ComputeInstanceTemplate#threads_per_core}
    */
    readonly threadsPerCore?: number;
}
export declare function computeInstanceTemplateAdvancedMachineFeaturesToTerraform(struct?: ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference | ComputeInstanceTemplateAdvancedMachineFeatures): any;
export declare class ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: ComputeInstanceTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
}
export interface ComputeInstanceTemplateConfidentialInstanceConfig {
    /**
    * Defines whether the instance should have confidential compute enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_confidential_compute ComputeInstanceTemplate#enable_confidential_compute}
    */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare function computeInstanceTemplateConfidentialInstanceConfigToTerraform(struct?: ComputeInstanceTemplateConfidentialInstanceConfigOutputReference | ComputeInstanceTemplateConfidentialInstanceConfig): any;
export declare class ComputeInstanceTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceTemplateConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceTemplateDiskDiskEncryptionKey {
    /**
    * The self link of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#kms_key_self_link ComputeInstanceTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink: string;
}
export declare function computeInstanceTemplateDiskDiskEncryptionKeyToTerraform(struct?: ComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference | ComputeInstanceTemplateDiskDiskEncryptionKey): any;
export declare class ComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateDiskDiskEncryptionKey | undefined;
    set internalValue(value: ComputeInstanceTemplateDiskDiskEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    get kmsKeySelfLinkInput(): string | undefined;
}
export interface ComputeInstanceTemplateDisk {
    /**
    * Whether or not the disk should be auto-deleted. This defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#auto_delete ComputeInstanceTemplate#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Indicates that this is a boot disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#boot ComputeInstanceTemplate#boot}
    */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
    * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance. If not specified, the server chooses a default device name to apply to this disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#device_name ComputeInstanceTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * Name of the disk. When not provided, this defaults to the name of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_name ComputeInstanceTemplate#disk_name}
    */
    readonly diskName?: string;
    /**
    * The size of the image in gigabytes. If not specified, it will inherit the size of its base image. For SCRATCH disks, the size must be exactly 375GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_size_gb ComputeInstanceTemplate#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The Google Compute Engine disk type. Such as "pd-ssd", "local-ssd", "pd-balanced" or "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_type ComputeInstanceTemplate#disk_type}
    */
    readonly diskType?: string;
    /**
    * Specifies the disk interface to use for attaching this disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#interface ComputeInstanceTemplate#interface}
    */
    readonly interface?: string;
    /**
    * A set of key/value label pairs to assign to disks,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#labels ComputeInstanceTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If you are attaching or creating a boot disk, this must read-write mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#mode ComputeInstanceTemplate#mode}
    */
    readonly mode?: string;
    /**
    * A list (short name or id) of resource policies to attach to this disk. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#resource_policies ComputeInstanceTemplate#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The name (not self_link) of the disk (such as those managed by google_compute_disk) to attach. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#source ComputeInstanceTemplate#source}
    */
    readonly source?: string;
    /**
    * The image from which to initialize this disk. This can be one of: the image's self_link, projects/{project}/global/images/{image}, projects/{project}/global/images/family/{family}, global/images/{image}, global/images/family/{family}, family/{family}, {project}/{family}, {project}/{image}, {family}, or {image}. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#source_image ComputeInstanceTemplate#source_image}
    */
    readonly sourceImage?: string;
    /**
    * The type of Google Compute Engine disk, can be either "SCRATCH" or "PERSISTENT".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
    */
    readonly type?: string;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#disk_encryption_key ComputeInstanceTemplate#disk_encryption_key}
    */
    readonly diskEncryptionKey?: ComputeInstanceTemplateDiskDiskEncryptionKey;
}
export declare function computeInstanceTemplateDiskToTerraform(struct?: ComputeInstanceTemplateDisk | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateDisk | cdktf.IResolvable | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _boot?;
    get boot(): boolean | cdktf.IResolvable;
    set boot(value: boolean | cdktf.IResolvable);
    resetBoot(): void;
    get bootInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    resetDiskName(): void;
    get diskNameInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): ComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ComputeInstanceTemplateDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ComputeInstanceTemplateDiskDiskEncryptionKey | undefined;
}
export declare class ComputeInstanceTemplateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateDiskOutputReference;
}
export interface ComputeInstanceTemplateGuestAccelerator {
    /**
    * The number of the guest accelerator cards exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#count ComputeInstanceTemplate#count}
    */
    readonly count: number;
    /**
    * The accelerator type resource to expose to this instance. E.g. nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
    */
    readonly type: string;
}
export declare function computeInstanceTemplateGuestAcceleratorToTerraform(struct?: ComputeInstanceTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ComputeInstanceTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateGuestAcceleratorOutputReference;
}
export interface ComputeInstanceTemplateNetworkInterfaceAccessConfig {
    /**
    * The IP address that will be 1:1 mapped to the instance's network ip. If not given, one will be generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#nat_ip ComputeInstanceTemplate#nat_ip}
    */
    readonly natIp?: string;
    /**
    * The networking tier used for configuring this instance template. This field can take the following values: PREMIUM, STANDARD, FIXED_STANDARD. If this field is not specified, it is assumed to be PREMIUM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_tier ComputeInstanceTemplate#network_tier}
    */
    readonly networkTier?: string;
}
export declare function computeInstanceTemplateNetworkInterfaceAccessConfigToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    get publicPtrDomainName(): string;
}
export declare class ComputeInstanceTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface ComputeInstanceTemplateNetworkInterfaceAliasIpRange {
    /**
    * The IP CIDR range represented by this alias IP range. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. At the time of writing only a netmask (e.g. /24) may be supplied, with a CIDR format resulting in an API error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#ip_cidr_range ComputeInstanceTemplate#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range. If left unspecified, the primary range of the subnetwork will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork_range_name ComputeInstanceTemplate#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function computeInstanceTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class ComputeInstanceTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig {
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_tier ComputeInstanceTemplate#network_tier}
    */
    readonly networkTier: string;
}
export declare function computeInstanceTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    get publicPtrDomainName(): string;
}
export declare class ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface ComputeInstanceTemplateNetworkInterface {
    /**
    * The name or self_link of the network to attach this interface to. Use network attribute for Legacy or Auto subnetted networks and subnetwork for custom subnetted networks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network ComputeInstanceTemplate#network}
    */
    readonly network?: string;
    /**
    * The private IP address to assign to the instance. If empty, the address will be automatically assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#network_ip ComputeInstanceTemplate#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#nic_type ComputeInstanceTemplate#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#queue_count ComputeInstanceTemplate#queue_count}
    */
    readonly queueCount?: number;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#stack_type ComputeInstanceTemplate#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name of the subnetwork to attach this interface to. The subnetwork must exist in the same region this instance will be created in. Either network or subnetwork must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork ComputeInstanceTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The ID of the project in which the subnetwork belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#subnetwork_project ComputeInstanceTemplate#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#access_config ComputeInstanceTemplate#access_config}
    */
    readonly accessConfig?: ComputeInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * alias_ip_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#alias_ip_range ComputeInstanceTemplate#alias_ip_range}
    */
    readonly aliasIpRange?: ComputeInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#ipv6_access_config ComputeInstanceTemplate#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function computeInstanceTemplateNetworkInterfaceToTerraform(struct?: ComputeInstanceTemplateNetworkInterface | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateNetworkInterface | cdktf.IResolvable | undefined);
    get ipv6AccessType(): string;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _accessConfig;
    get accessConfig(): ComputeInstanceTemplateNetworkInterfaceAccessConfigList;
    putAccessConfig(value: ComputeInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | ComputeInstanceTemplateNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): ComputeInstanceTemplateNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: ComputeInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | ComputeInstanceTemplateNetworkInterfaceAliasIpRange[] | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | ComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class ComputeInstanceTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateNetworkInterfaceOutputReference;
}
export interface ComputeInstanceTemplateReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#key ComputeInstanceTemplate#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#values ComputeInstanceTemplate#values}
    */
    readonly values: string[];
}
export declare function computeInstanceTemplateReservationAffinitySpecificReservationToTerraform(struct?: ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference | ComputeInstanceTemplateReservationAffinitySpecificReservation): any;
export declare class ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ComputeInstanceTemplateReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#type ComputeInstanceTemplate#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#specific_reservation ComputeInstanceTemplate#specific_reservation}
    */
    readonly specificReservation?: ComputeInstanceTemplateReservationAffinitySpecificReservation;
}
export declare function computeInstanceTemplateReservationAffinityToTerraform(struct?: ComputeInstanceTemplateReservationAffinityOutputReference | ComputeInstanceTemplateReservationAffinity): any;
export declare class ComputeInstanceTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateReservationAffinity | undefined;
    set internalValue(value: ComputeInstanceTemplateReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): ComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: ComputeInstanceTemplateReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): ComputeInstanceTemplateReservationAffinitySpecificReservation | undefined;
}
export interface ComputeInstanceTemplateSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#key ComputeInstanceTemplate#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#operator ComputeInstanceTemplate#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#values ComputeInstanceTemplate#values}
    */
    readonly values: string[];
}
export declare function computeInstanceTemplateSchedulingNodeAffinitiesToTerraform(struct?: ComputeInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ComputeInstanceTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface ComputeInstanceTemplateScheduling {
    /**
    * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). This defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#automatic_restart ComputeInstanceTemplate#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#instance_termination_action ComputeInstanceTemplate#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Minimum number of cpus for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#min_node_cpus ComputeInstanceTemplate#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Defines the maintenance behavior for this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#on_host_maintenance ComputeInstanceTemplate#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Allows instance to be preempted. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#preemptible ComputeInstanceTemplate#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#provisioning_model ComputeInstanceTemplate#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#node_affinities ComputeInstanceTemplate#node_affinities}
    */
    readonly nodeAffinities?: ComputeInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function computeInstanceTemplateSchedulingToTerraform(struct?: ComputeInstanceTemplateSchedulingOutputReference | ComputeInstanceTemplateScheduling): any;
export declare class ComputeInstanceTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateScheduling | undefined;
    set internalValue(value: ComputeInstanceTemplateScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _nodeAffinities;
    get nodeAffinities(): ComputeInstanceTemplateSchedulingNodeAffinitiesList;
    putNodeAffinities(value: ComputeInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | ComputeInstanceTemplateSchedulingNodeAffinities[] | undefined;
}
export interface ComputeInstanceTemplateServiceAccount {
    /**
    * The service account e-mail address. If not given, the default Google Compute Engine service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#email ComputeInstanceTemplate#email}
    */
    readonly email?: string;
    /**
    * A list of service scopes. Both OAuth2 URLs and gcloud short names are supported. To allow full access to all Cloud APIs, use the cloud-platform scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#scopes ComputeInstanceTemplate#scopes}
    */
    readonly scopes: string[];
}
export declare function computeInstanceTemplateServiceAccountToTerraform(struct?: ComputeInstanceTemplateServiceAccountOutputReference | ComputeInstanceTemplateServiceAccount): any;
export declare class ComputeInstanceTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateServiceAccount | undefined;
    set internalValue(value: ComputeInstanceTemplateServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
}
export interface ComputeInstanceTemplateShieldedInstanceConfig {
    /**
    * Compare the most recent boot measurements to the integrity policy baseline and return a pair of pass/fail results depending on whether they match or not. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_integrity_monitoring ComputeInstanceTemplate#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Verify the digital signature of all boot components, and halt the boot process if signature verification fails. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_secure_boot ComputeInstanceTemplate#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Use a virtualized trusted platform module, which is a specialized computer chip you can use to encrypt objects like keys and certificates. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#enable_vtpm ComputeInstanceTemplate#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function computeInstanceTemplateShieldedInstanceConfigToTerraform(struct?: ComputeInstanceTemplateShieldedInstanceConfigOutputReference | ComputeInstanceTemplateShieldedInstanceConfig): any;
export declare class ComputeInstanceTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: ComputeInstanceTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#create ComputeInstanceTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template#delete ComputeInstanceTemplate#delete}
    */
    readonly delete?: string;
}
export declare function computeInstanceTemplateTimeoutsToTerraform(struct?: ComputeInstanceTemplateTimeoutsOutputReference | ComputeInstanceTemplateTimeouts | cdktf.IResolvable): any;
export declare class ComputeInstanceTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template google_compute_instance_template}
*/
export declare class ComputeInstanceTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_template google_compute_instance_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeInstanceTemplateConfig
    */
    constructor(scope: Construct, id: string, config: ComputeInstanceTemplateConfig);
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceDescription?;
    get instanceDescription(): string;
    set instanceDescription(value: string);
    resetInstanceDescription(): void;
    get instanceDescriptionInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): ComputeInstanceTemplateAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: ComputeInstanceTemplateAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): ComputeInstanceTemplateAdvancedMachineFeatures | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): ComputeInstanceTemplateConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: ComputeInstanceTemplateConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): ComputeInstanceTemplateConfidentialInstanceConfig | undefined;
    private _disk;
    get disk(): ComputeInstanceTemplateDiskList;
    putDisk(value: ComputeInstanceTemplateDisk[] | cdktf.IResolvable): void;
    get diskInput(): cdktf.IResolvable | ComputeInstanceTemplateDisk[] | undefined;
    private _guestAccelerator;
    get guestAccelerator(): ComputeInstanceTemplateGuestAcceleratorList;
    putGuestAccelerator(value: ComputeInstanceTemplateGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ComputeInstanceTemplateGuestAccelerator[] | undefined;
    private _networkInterface;
    get networkInterface(): ComputeInstanceTemplateNetworkInterfaceList;
    putNetworkInterface(value: ComputeInstanceTemplateNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ComputeInstanceTemplateNetworkInterface[] | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ComputeInstanceTemplateReservationAffinityOutputReference;
    putReservationAffinity(value: ComputeInstanceTemplateReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ComputeInstanceTemplateReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): ComputeInstanceTemplateSchedulingOutputReference;
    putScheduling(value: ComputeInstanceTemplateScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): ComputeInstanceTemplateScheduling | undefined;
    private _serviceAccount;
    get serviceAccount(): ComputeInstanceTemplateServiceAccountOutputReference;
    putServiceAccount(value: ComputeInstanceTemplateServiceAccount): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): ComputeInstanceTemplateServiceAccount | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ComputeInstanceTemplateShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ComputeInstanceTemplateShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ComputeInstanceTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): ComputeInstanceTemplateTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeInstanceTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
