import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to export the custom routes to the peer network. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#export_custom_routes ComputeNetworkPeering#export_custom_routes}
    */
    readonly exportCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#export_subnet_routes_with_public_ip ComputeNetworkPeering#export_subnet_routes_with_public_ip}
    */
    readonly exportSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#id ComputeNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether to export the custom routes from the peer network. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#import_custom_routes ComputeNetworkPeering#import_custom_routes}
    */
    readonly importCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#import_subnet_routes_with_public_ip ComputeNetworkPeering#import_subnet_routes_with_public_ip}
    */
    readonly importSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Name of the peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#name ComputeNetworkPeering#name}
    */
    readonly name: string;
    /**
    * The primary network of the peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#network ComputeNetworkPeering#network}
    */
    readonly network: string;
    /**
    * The peer network in the peering. The peer network may belong to a different project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#peer_network ComputeNetworkPeering#peer_network}
    */
    readonly peerNetwork: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#timeouts ComputeNetworkPeering#timeouts}
    */
    readonly timeouts?: ComputeNetworkPeeringTimeouts;
}
export interface ComputeNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#create ComputeNetworkPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#delete ComputeNetworkPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering#update ComputeNetworkPeering#update}
    */
    readonly update?: string;
}
export declare function computeNetworkPeeringTimeoutsToTerraform(struct?: ComputeNetworkPeeringTimeoutsOutputReference | ComputeNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering google_compute_network_peering}
*/
export declare class ComputeNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering google_compute_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringConfig);
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    resetExportCustomRoutes(): void;
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _exportSubnetRoutesWithPublicIp?;
    get exportSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set exportSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetExportSubnetRoutesWithPublicIp(): void;
    get exportSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    resetImportCustomRoutes(): void;
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _importSubnetRoutesWithPublicIp?;
    get importSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set importSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetImportSubnetRoutesWithPublicIp(): void;
    get importSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peerNetwork?;
    get peerNetwork(): string;
    set peerNetwork(value: string);
    get peerNetworkInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    private _timeouts;
    get timeouts(): ComputeNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
