import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional textual description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#description ComputeNodeGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#id ComputeNodeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The initial number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#initial_size ComputeNodeGroup#initial_size}
    */
    readonly initialSize?: number;
    /**
    * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#maintenance_policy ComputeNodeGroup#maintenance_policy}
    */
    readonly maintenancePolicy?: string;
    /**
    * Name of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#name ComputeNodeGroup#name}
    */
    readonly name?: string;
    /**
    * The URL of the node template to which this node group belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#node_template ComputeNodeGroup#node_template}
    */
    readonly nodeTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#project ComputeNodeGroup#project}
    */
    readonly project?: string;
    /**
    * The total number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#size ComputeNodeGroup#size}
    */
    readonly size?: number;
    /**
    * Zone where this node group is located
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#zone ComputeNodeGroup#zone}
    */
    readonly zone?: string;
    /**
    * autoscaling_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#autoscaling_policy ComputeNodeGroup#autoscaling_policy}
    */
    readonly autoscalingPolicy?: ComputeNodeGroupAutoscalingPolicy;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#maintenance_window ComputeNodeGroup#maintenance_window}
    */
    readonly maintenanceWindow?: ComputeNodeGroupMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#timeouts ComputeNodeGroup#timeouts}
    */
    readonly timeouts?: ComputeNodeGroupTimeouts;
}
export interface ComputeNodeGroupAutoscalingPolicy {
    /**
    * Maximum size of the node group. Set to a value less than or equal
  to 100 and greater than or equal to min-nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#max_nodes ComputeNodeGroup#max_nodes}
    */
    readonly maxNodes?: number;
    /**
    * Minimum size of the node group. Must be less
  than or equal to max-nodes. The default value is 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#min_nodes ComputeNodeGroup#min_nodes}
    */
    readonly minNodes?: number;
    /**
    * The autoscaling mode. Set to one of the following:
    - OFF: Disables the autoscaler.
    - ON: Enables scaling in and scaling out.
    - ONLY_SCALE_OUT: Enables only scaling out.
    You must use this mode if your node groups are configured to
    restart their hosted VMs on minimal servers. Possible values: ["OFF", "ON", "ONLY_SCALE_OUT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#mode ComputeNodeGroup#mode}
    */
    readonly mode?: string;
}
export declare function computeNodeGroupAutoscalingPolicyToTerraform(struct?: ComputeNodeGroupAutoscalingPolicyOutputReference | ComputeNodeGroupAutoscalingPolicy): any;
export declare class ComputeNodeGroupAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeGroupAutoscalingPolicy | undefined;
    set internalValue(value: ComputeNodeGroupAutoscalingPolicy | undefined);
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    resetMaxNodes(): void;
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    resetMinNodes(): void;
    get minNodesInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface ComputeNodeGroupMaintenanceWindow {
    /**
    * instances.start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#start_time ComputeNodeGroup#start_time}
    */
    readonly startTime: string;
}
export declare function computeNodeGroupMaintenanceWindowToTerraform(struct?: ComputeNodeGroupMaintenanceWindowOutputReference | ComputeNodeGroupMaintenanceWindow): any;
export declare class ComputeNodeGroupMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeGroupMaintenanceWindow | undefined;
    set internalValue(value: ComputeNodeGroupMaintenanceWindow | undefined);
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ComputeNodeGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#create ComputeNodeGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#delete ComputeNodeGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group#update ComputeNodeGroup#update}
    */
    readonly update?: string;
}
export declare function computeNodeGroupTimeoutsToTerraform(struct?: ComputeNodeGroupTimeoutsOutputReference | ComputeNodeGroupTimeouts | cdktf.IResolvable): any;
export declare class ComputeNodeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNodeGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNodeGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_group google_compute_node_group}
*/
export declare class ComputeNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_node_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_group google_compute_node_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNodeGroupConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNodeGroupConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialSize?;
    get initialSize(): number;
    set initialSize(value: number);
    resetInitialSize(): void;
    get initialSizeInput(): number | undefined;
    private _maintenancePolicy?;
    get maintenancePolicy(): string;
    set maintenancePolicy(value: string);
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeTemplate?;
    get nodeTemplate(): string;
    set nodeTemplate(value: string);
    get nodeTemplateInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy;
    get autoscalingPolicy(): ComputeNodeGroupAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: ComputeNodeGroupAutoscalingPolicy): void;
    resetAutoscalingPolicy(): void;
    get autoscalingPolicyInput(): ComputeNodeGroupAutoscalingPolicy | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): ComputeNodeGroupMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: ComputeNodeGroupMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): ComputeNodeGroupMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): ComputeNodeGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeNodeGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNodeGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
