import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionPerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#id ComputeRegionPerInstanceConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#minimal_action ComputeRegionPerInstanceConfig#minimal_action}
    */
    readonly minimalAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#most_disruptive_allowed_action ComputeRegionPerInstanceConfig#most_disruptive_allowed_action}
    */
    readonly mostDisruptiveAllowedAction?: string;
    /**
    * The name for this per-instance config and its corresponding instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#name ComputeRegionPerInstanceConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#project ComputeRegionPerInstanceConfig#project}
    */
    readonly project?: string;
    /**
    * Region where the containing instance group manager is located
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#region ComputeRegionPerInstanceConfig#region}
    */
    readonly region?: string;
    /**
    * The region instance group manager this instance config is part of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#region_instance_group_manager ComputeRegionPerInstanceConfig#region_instance_group_manager}
    */
    readonly regionInstanceGroupManager: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#remove_instance_state_on_destroy ComputeRegionPerInstanceConfig#remove_instance_state_on_destroy}
    */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * preserved_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#preserved_state ComputeRegionPerInstanceConfig#preserved_state}
    */
    readonly preservedState?: ComputeRegionPerInstanceConfigPreservedState;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#timeouts ComputeRegionPerInstanceConfig#timeouts}
    */
    readonly timeouts?: ComputeRegionPerInstanceConfigTimeouts;
}
export interface ComputeRegionPerInstanceConfigPreservedStateDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
  The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
  'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
  'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
  deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#delete_rule ComputeRegionPerInstanceConfig#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#device_name ComputeRegionPerInstanceConfig#device_name}
    */
    readonly deviceName: string;
    /**
    * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#mode ComputeRegionPerInstanceConfig#mode}
    */
    readonly mode?: string;
    /**
    * The URI of an existing persistent disk to attach under the specified device-name in the format
  'projects/project-id/zones/zone/disks/disk-name'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#source ComputeRegionPerInstanceConfig#source}
    */
    readonly source: string;
}
export declare function computeRegionPerInstanceConfigPreservedStateDiskToTerraform(struct?: ComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable): any;
export declare class ComputeRegionPerInstanceConfigPreservedStateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export declare class ComputeRegionPerInstanceConfigPreservedStateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionPerInstanceConfigPreservedStateDiskOutputReference;
}
export interface ComputeRegionPerInstanceConfigPreservedState {
    /**
    * Preserved metadata defined for this instance. This is a list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#metadata ComputeRegionPerInstanceConfig#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#disk ComputeRegionPerInstanceConfig#disk}
    */
    readonly disk?: ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
}
export declare function computeRegionPerInstanceConfigPreservedStateToTerraform(struct?: ComputeRegionPerInstanceConfigPreservedStateOutputReference | ComputeRegionPerInstanceConfigPreservedState): any;
export declare class ComputeRegionPerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionPerInstanceConfigPreservedState | undefined;
    set internalValue(value: ComputeRegionPerInstanceConfigPreservedState | undefined);
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _disk;
    get disk(): ComputeRegionPerInstanceConfigPreservedStateDiskList;
    putDisk(value: ComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable): void;
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | ComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined;
}
export interface ComputeRegionPerInstanceConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#create ComputeRegionPerInstanceConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#delete ComputeRegionPerInstanceConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config#update ComputeRegionPerInstanceConfig#update}
    */
    readonly update?: string;
}
export declare function computeRegionPerInstanceConfigTimeoutsToTerraform(struct?: ComputeRegionPerInstanceConfigTimeoutsOutputReference | ComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionPerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config google_compute_region_per_instance_config}
*/
export declare class ComputeRegionPerInstanceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_per_instance_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config google_compute_region_per_instance_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionPerInstanceConfigConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionPerInstanceConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    resetMinimalAction(): void;
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string;
    set mostDisruptiveAllowedAction(value: string);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _regionInstanceGroupManager?;
    get regionInstanceGroupManager(): string;
    set regionInstanceGroupManager(value: string);
    get regionInstanceGroupManagerInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable;
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable);
    resetRemoveInstanceStateOnDestroy(): void;
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _preservedState;
    get preservedState(): ComputeRegionPerInstanceConfigPreservedStateOutputReference;
    putPreservedState(value: ComputeRegionPerInstanceConfigPreservedState): void;
    resetPreservedState(): void;
    get preservedStateInput(): ComputeRegionPerInstanceConfigPreservedState | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionPerInstanceConfigTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionPerInstanceConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionPerInstanceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
