import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this security policy. Max size is 2048.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#description ComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#id ComputeSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the security policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#name ComputeSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#project ComputeSecurityPolicy#project}
    */
    readonly project?: string;
    /**
    * The type indicates the intended use of the security policy. CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#type ComputeSecurityPolicy#type}
    */
    readonly type?: string;
    /**
    * adaptive_protection_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#adaptive_protection_config ComputeSecurityPolicy#adaptive_protection_config}
    */
    readonly adaptiveProtectionConfig?: ComputeSecurityPolicyAdaptiveProtectionConfig;
    /**
    * advanced_options_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#advanced_options_config ComputeSecurityPolicy#advanced_options_config}
    */
    readonly advancedOptionsConfig?: ComputeSecurityPolicyAdvancedOptionsConfig;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#rule ComputeSecurityPolicy#rule}
    */
    readonly rule?: ComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#timeouts ComputeSecurityPolicy#timeouts}
    */
    readonly timeouts?: ComputeSecurityPolicyTimeouts;
}
export interface ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig {
    /**
    * If set to true, enables CAAP for L7 DDoS detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#enable ComputeSecurityPolicy#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Rule visibility. Supported values include: "STANDARD", "PREMIUM".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#rule_visibility ComputeSecurityPolicy#rule_visibility}
    */
    readonly ruleVisibility?: string;
}
export declare function computeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigToTerraform(struct?: ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference | ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): any;
export declare class ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
    set internalValue(value: ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleVisibility?;
    get ruleVisibility(): string;
    set ruleVisibility(value: string);
    resetRuleVisibility(): void;
    get ruleVisibilityInput(): string | undefined;
}
export interface ComputeSecurityPolicyAdaptiveProtectionConfig {
    /**
    * layer_7_ddos_defense_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#layer_7_ddos_defense_config ComputeSecurityPolicy#layer_7_ddos_defense_config}
    */
    readonly layer7DdosDefenseConfig?: ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig;
}
export declare function computeSecurityPolicyAdaptiveProtectionConfigToTerraform(struct?: ComputeSecurityPolicyAdaptiveProtectionConfigOutputReference | ComputeSecurityPolicyAdaptiveProtectionConfig): any;
export declare class ComputeSecurityPolicyAdaptiveProtectionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    set internalValue(value: ComputeSecurityPolicyAdaptiveProtectionConfig | undefined);
    private _layer7DdosDefenseConfig;
    get layer7DdosDefenseConfig(): ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference;
    putLayer7DdosDefenseConfig(value: ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): void;
    resetLayer7DdosDefenseConfig(): void;
    get layer7DdosDefenseConfigInput(): ComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
}
export interface ComputeSecurityPolicyAdvancedOptionsConfig {
    /**
    * JSON body parsing. Supported values include: "DISABLED", "STANDARD".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#json_parsing ComputeSecurityPolicy#json_parsing}
    */
    readonly jsonParsing?: string;
    /**
    * Logging level. Supported values include: "NORMAL", "VERBOSE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#log_level ComputeSecurityPolicy#log_level}
    */
    readonly logLevel?: string;
}
export declare function computeSecurityPolicyAdvancedOptionsConfigToTerraform(struct?: ComputeSecurityPolicyAdvancedOptionsConfigOutputReference | ComputeSecurityPolicyAdvancedOptionsConfig): any;
export declare class ComputeSecurityPolicyAdvancedOptionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    set internalValue(value: ComputeSecurityPolicyAdvancedOptionsConfig | undefined);
    private _jsonParsing?;
    get jsonParsing(): string;
    set jsonParsing(value: string);
    resetJsonParsing(): void;
    get jsonParsingInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
}
export interface ComputeSecurityPolicyRuleMatchConfig {
    /**
    * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic. There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#src_ip_ranges ComputeSecurityPolicy#src_ip_ranges}
    */
    readonly srcIpRanges: string[];
}
export declare function computeSecurityPolicyRuleMatchConfigToTerraform(struct?: ComputeSecurityPolicyRuleMatchConfigOutputReference | ComputeSecurityPolicyRuleMatchConfig): any;
export declare class ComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    get srcIpRangesInput(): string[] | undefined;
}
export interface ComputeSecurityPolicyRuleMatchExpr {
    /**
    * Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#expression ComputeSecurityPolicy#expression}
    */
    readonly expression: string;
}
export declare function computeSecurityPolicyRuleMatchExprToTerraform(struct?: ComputeSecurityPolicyRuleMatchExprOutputReference | ComputeSecurityPolicyRuleMatchExpr): any;
export declare class ComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatchExpr | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatchExpr | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export interface ComputeSecurityPolicyRuleMatch {
    /**
    * Predefined rule expression. If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#versioned_expr ComputeSecurityPolicy#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#config ComputeSecurityPolicy#config}
    */
    readonly config?: ComputeSecurityPolicyRuleMatchConfig;
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#expr ComputeSecurityPolicy#expr}
    */
    readonly expr?: ComputeSecurityPolicyRuleMatchExpr;
}
export declare function computeSecurityPolicyRuleMatchToTerraform(struct?: ComputeSecurityPolicyRuleMatchOutputReference | ComputeSecurityPolicyRuleMatch): any;
export declare class ComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleMatch | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): ComputeSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: ComputeSecurityPolicyRuleMatchConfig): void;
    resetConfig(): void;
    get configInput(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr;
    get expr(): ComputeSecurityPolicyRuleMatchExprOutputReference;
    putExpr(value: ComputeSecurityPolicyRuleMatchExpr): void;
    resetExpr(): void;
    get exprInput(): ComputeSecurityPolicyRuleMatchExpr | undefined;
}
export interface ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#count ComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#interval_sec ComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function computeSecurityPolicyRuleRateLimitOptionsBanThresholdToTerraform(struct?: ComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference | ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): any;
export declare class ComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#target ComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#type ComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function computeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsToTerraform(struct?: ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference | ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): any;
export declare class ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#count ComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#interval_sec ComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function computeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdToTerraform(struct?: ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference | ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): any;
export declare class ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface ComputeSecurityPolicyRuleRateLimitOptions {
    /**
    * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#ban_duration_sec ComputeSecurityPolicy#ban_duration_sec}
    */
    readonly banDurationSec?: number;
    /**
    * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#conform_action ComputeSecurityPolicy#conform_action}
    */
    readonly conformAction: string;
    /**
    * Determines the key to enforce the rateLimitThreshold on
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#enforce_on_key ComputeSecurityPolicy#enforce_on_key}
    */
    readonly enforceOnKey?: string;
    /**
    * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#enforce_on_key_name ComputeSecurityPolicy#enforce_on_key_name}
    */
    readonly enforceOnKeyName?: string;
    /**
    * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceedRedirectOptions below.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#exceed_action ComputeSecurityPolicy#exceed_action}
    */
    readonly exceedAction: string;
    /**
    * ban_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#ban_threshold ComputeSecurityPolicy#ban_threshold}
    */
    readonly banThreshold?: ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold;
    /**
    * exceed_redirect_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#exceed_redirect_options ComputeSecurityPolicy#exceed_redirect_options}
    */
    readonly exceedRedirectOptions?: ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions;
    /**
    * rate_limit_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#rate_limit_threshold ComputeSecurityPolicy#rate_limit_threshold}
    */
    readonly rateLimitThreshold: ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold;
}
export declare function computeSecurityPolicyRuleRateLimitOptionsToTerraform(struct?: ComputeSecurityPolicyRuleRateLimitOptionsOutputReference | ComputeSecurityPolicyRuleRateLimitOptions): any;
export declare class ComputeSecurityPolicyRuleRateLimitOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleRateLimitOptions | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleRateLimitOptions | undefined);
    private _banDurationSec?;
    get banDurationSec(): number;
    set banDurationSec(value: number);
    resetBanDurationSec(): void;
    get banDurationSecInput(): number | undefined;
    private _conformAction?;
    get conformAction(): string;
    set conformAction(value: string);
    get conformActionInput(): string | undefined;
    private _enforceOnKey?;
    get enforceOnKey(): string;
    set enforceOnKey(value: string);
    resetEnforceOnKey(): void;
    get enforceOnKeyInput(): string | undefined;
    private _enforceOnKeyName?;
    get enforceOnKeyName(): string;
    set enforceOnKeyName(value: string);
    resetEnforceOnKeyName(): void;
    get enforceOnKeyNameInput(): string | undefined;
    private _exceedAction?;
    get exceedAction(): string;
    set exceedAction(value: string);
    get exceedActionInput(): string | undefined;
    private _banThreshold;
    get banThreshold(): ComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference;
    putBanThreshold(value: ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): void;
    resetBanThreshold(): void;
    get banThresholdInput(): ComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    private _exceedRedirectOptions;
    get exceedRedirectOptions(): ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference;
    putExceedRedirectOptions(value: ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): void;
    resetExceedRedirectOptions(): void;
    get exceedRedirectOptionsInput(): ComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    private _rateLimitThreshold;
    get rateLimitThreshold(): ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference;
    putRateLimitThreshold(value: ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): void;
    get rateLimitThresholdInput(): ComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
}
export interface ComputeSecurityPolicyRuleRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#target ComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action. Available options: EXTERNAL_302: Must specify the corresponding target field in config. GOOGLE_RECAPTCHA: Cannot specify target field in config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#type ComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function computeSecurityPolicyRuleRedirectOptionsToTerraform(struct?: ComputeSecurityPolicyRuleRedirectOptionsOutputReference | ComputeSecurityPolicyRuleRedirectOptions): any;
export declare class ComputeSecurityPolicyRuleRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyRuleRedirectOptions | undefined;
    set internalValue(value: ComputeSecurityPolicyRuleRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ComputeSecurityPolicyRule {
    /**
    * Action to take when match matches the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#action ComputeSecurityPolicy#action}
    */
    readonly action: string;
    /**
    * An optional description of this rule. Max size is 64.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#description ComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * When set to true, the action specified above is not enforced. Stackdriver logs for requests that trigger a preview action are annotated as such.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#preview ComputeSecurityPolicy#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An unique positive integer indicating the priority of evaluation for a rule. Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#priority ComputeSecurityPolicy#priority}
    */
    readonly priority: number;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#match ComputeSecurityPolicy#match}
    */
    readonly match: ComputeSecurityPolicyRuleMatch;
    /**
    * rate_limit_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#rate_limit_options ComputeSecurityPolicy#rate_limit_options}
    */
    readonly rateLimitOptions?: ComputeSecurityPolicyRuleRateLimitOptions;
    /**
    * redirect_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#redirect_options ComputeSecurityPolicy#redirect_options}
    */
    readonly redirectOptions?: ComputeSecurityPolicyRuleRedirectOptions;
}
export declare function computeSecurityPolicyRuleToTerraform(struct?: ComputeSecurityPolicyRule | cdktf.IResolvable): any;
export declare class ComputeSecurityPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeSecurityPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeSecurityPolicyRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _match;
    get match(): ComputeSecurityPolicyRuleMatchOutputReference;
    putMatch(value: ComputeSecurityPolicyRuleMatch): void;
    get matchInput(): ComputeSecurityPolicyRuleMatch | undefined;
    private _rateLimitOptions;
    get rateLimitOptions(): ComputeSecurityPolicyRuleRateLimitOptionsOutputReference;
    putRateLimitOptions(value: ComputeSecurityPolicyRuleRateLimitOptions): void;
    resetRateLimitOptions(): void;
    get rateLimitOptionsInput(): ComputeSecurityPolicyRuleRateLimitOptions | undefined;
    private _redirectOptions;
    get redirectOptions(): ComputeSecurityPolicyRuleRedirectOptionsOutputReference;
    putRedirectOptions(value: ComputeSecurityPolicyRuleRedirectOptions): void;
    resetRedirectOptions(): void;
    get redirectOptionsInput(): ComputeSecurityPolicyRuleRedirectOptions | undefined;
}
export declare class ComputeSecurityPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeSecurityPolicyRuleOutputReference;
}
export interface ComputeSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#create ComputeSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#delete ComputeSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy#update ComputeSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function computeSecurityPolicyTimeoutsToTerraform(struct?: ComputeSecurityPolicyTimeoutsOutputReference | ComputeSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class ComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy google_compute_security_policy}
*/
export declare class ComputeSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_security_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy google_compute_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _adaptiveProtectionConfig;
    get adaptiveProtectionConfig(): ComputeSecurityPolicyAdaptiveProtectionConfigOutputReference;
    putAdaptiveProtectionConfig(value: ComputeSecurityPolicyAdaptiveProtectionConfig): void;
    resetAdaptiveProtectionConfig(): void;
    get adaptiveProtectionConfigInput(): ComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    private _advancedOptionsConfig;
    get advancedOptionsConfig(): ComputeSecurityPolicyAdvancedOptionsConfigOutputReference;
    putAdvancedOptionsConfig(value: ComputeSecurityPolicyAdvancedOptionsConfig): void;
    resetAdvancedOptionsConfig(): void;
    get advancedOptionsConfigInput(): ComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    private _rule;
    get rule(): ComputeSecurityPolicyRuleList;
    putRule(value: ComputeSecurityPolicyRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | ComputeSecurityPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): ComputeSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
