import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}
    */
    readonly clusterIpv4Cidr?: string;
    /**
    * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#datapath_provider ContainerCluster#datapath_provider}
    */
    readonly datapathProvider?: string;
    /**
    * The default maximum number of pods per node in this cluster. This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}
    */
    readonly defaultMaxPodsPerNode?: number;
    /**
    *  Description of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#description ContainerCluster#description}
    */
    readonly description?: string;
    /**
    * Enable Autopilot for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_autopilot ContainerCluster#enable_autopilot}
    */
    readonly enableAutopilot?: boolean | cdktf.IResolvable;
    /**
    * Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_binary_authorization ContainerCluster#enable_binary_authorization}
    */
    readonly enableBinaryAuthorization?: boolean | cdktf.IResolvable;
    /**
    * Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}
    */
    readonly enableIntranodeVisibility?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Kubernetes Alpha features for this cluster. Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}
    */
    readonly enableKubernetesAlpha?: boolean | cdktf.IResolvable;
    /**
    * Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_legacy_abac ContainerCluster#enable_legacy_abac}
    */
    readonly enableLegacyAbac?: boolean | cdktf.IResolvable;
    /**
    * Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}
    */
    readonly enableShieldedNodes?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Cloud TPU resources in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_tpu ContainerCluster#enable_tpu}
    */
    readonly enableTpu?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#id ContainerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of nodes to create in this cluster's default node pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#location ContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The logging service that the cluster should write logs to. Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_service ContainerCluster#logging_service}
    */
    readonly loggingService?: string;
    /**
    * The minimum version of the master. GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_master_version ContainerCluster#min_master_version}
    */
    readonly minMasterVersion?: string;
    /**
    * The monitoring service that the cluster should write metrics to. Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_service ContainerCluster#monitoring_service}
    */
    readonly monitoringService?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}
    */
    readonly name: string;
    /**
    * The name or self_link of the Google Compute Engine network to which the cluster is connected. For Shared VPC, set this to the self link of the shared network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network ContainerCluster#network}
    */
    readonly network?: string;
    /**
    * Determines whether alias IPs or routes will be used for pod IPs in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#networking_mode ContainerCluster#networking_mode}
    */
    readonly networkingMode?: string;
    /**
    * The list of zones in which the cluster's nodes are located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version on the nodes. Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_version ContainerCluster#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#project ContainerCluster#project}
    */
    readonly project?: string;
    /**
    * If true, deletes the default node pool upon cluster creation. If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#remove_default_node_pool ContainerCluster#remove_default_node_pool}
    */
    readonly removeDefaultNodePool?: boolean | cdktf.IResolvable;
    /**
    * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}
    */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#subnetwork ContainerCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * addons_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#addons_config ContainerCluster#addons_config}
    */
    readonly addonsConfig?: ContainerClusterAddonsConfig;
    /**
    * authenticator_groups_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#authenticator_groups_config ContainerCluster#authenticator_groups_config}
    */
    readonly authenticatorGroupsConfig?: ContainerClusterAuthenticatorGroupsConfig;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#binary_authorization ContainerCluster#binary_authorization}
    */
    readonly binaryAuthorization?: ContainerClusterBinaryAuthorization;
    /**
    * cluster_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_autoscaling ContainerCluster#cluster_autoscaling}
    */
    readonly clusterAutoscaling?: ContainerClusterClusterAutoscaling;
    /**
    * confidential_nodes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#confidential_nodes ContainerCluster#confidential_nodes}
    */
    readonly confidentialNodes?: ContainerClusterConfidentialNodes;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#database_encryption ContainerCluster#database_encryption}
    */
    readonly databaseEncryption?: ContainerClusterDatabaseEncryption;
    /**
    * default_snat_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_snat_status ContainerCluster#default_snat_status}
    */
    readonly defaultSnatStatus?: ContainerClusterDefaultSnatStatus;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dns_config ContainerCluster#dns_config}
    */
    readonly dnsConfig?: ContainerClusterDnsConfig;
    /**
    * ip_allocation_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ip_allocation_policy ContainerCluster#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: ContainerClusterIpAllocationPolicy;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_config ContainerCluster#logging_config}
    */
    readonly loggingConfig?: ContainerClusterLoggingConfig;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_policy ContainerCluster#maintenance_policy}
    */
    readonly maintenancePolicy?: ContainerClusterMaintenancePolicy;
    /**
    * master_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_auth ContainerCluster#master_auth}
    */
    readonly masterAuth?: ContainerClusterMasterAuth;
    /**
    * master_authorized_networks_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}
    */
    readonly masterAuthorizedNetworksConfig?: ContainerClusterMasterAuthorizedNetworksConfig;
    /**
    * mesh_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mesh_certificates ContainerCluster#mesh_certificates}
    */
    readonly meshCertificates?: ContainerClusterMeshCertificates;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_config ContainerCluster#monitoring_config}
    */
    readonly monitoringConfig?: ContainerClusterMonitoringConfig;
    /**
    * network_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy ContainerCluster#network_policy}
    */
    readonly networkPolicy?: ContainerClusterNetworkPolicy;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}
    */
    readonly nodeConfig?: ContainerClusterNodeConfig;
    /**
    * node_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool ContainerCluster#node_pool}
    */
    readonly nodePool?: ContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#notification_config ContainerCluster#notification_config}
    */
    readonly notificationConfig?: ContainerClusterNotificationConfig;
    /**
    * private_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_cluster_config ContainerCluster#private_cluster_config}
    */
    readonly privateClusterConfig?: ContainerClusterPrivateClusterConfig;
    /**
    * release_channel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#release_channel ContainerCluster#release_channel}
    */
    readonly releaseChannel?: ContainerClusterReleaseChannel;
    /**
    * resource_usage_export_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_usage_export_config ContainerCluster#resource_usage_export_config}
    */
    readonly resourceUsageExportConfig?: ContainerClusterResourceUsageExportConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#timeouts ContainerCluster#timeouts}
    */
    readonly timeouts?: ContainerClusterTimeouts;
    /**
    * vertical_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}
    */
    readonly verticalPodAutoscaling?: ContainerClusterVerticalPodAutoscaling;
    /**
    * workload_identity_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_identity_config ContainerCluster#workload_identity_config}
    */
    readonly workloadIdentityConfig?: ContainerClusterWorkloadIdentityConfig;
}
export interface ContainerClusterAddonsConfigCloudrunConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#load_balancer_type ContainerCluster#load_balancer_type}
    */
    readonly loadBalancerType?: string;
}
export declare function containerClusterAddonsConfigCloudrunConfigToTerraform(struct?: ContainerClusterAddonsConfigCloudrunConfigOutputReference | ContainerClusterAddonsConfigCloudrunConfig): any;
export declare class ContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigCloudrunConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfigCloudrunConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    resetLoadBalancerType(): void;
    get loadBalancerTypeInput(): string | undefined;
}
export interface ContainerClusterAddonsConfigDnsCacheConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigDnsCacheConfigToTerraform(struct?: ContainerClusterAddonsConfigDnsCacheConfigOutputReference | ContainerClusterAddonsConfigDnsCacheConfig): any;
export declare class ContainerClusterAddonsConfigDnsCacheConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigDnsCacheConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfigDnsCacheConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigGcePersistentDiskCsiDriverConfigToTerraform(struct?: ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference | ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): any;
export declare class ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigGcpFilestoreCsiDriverConfigToTerraform(struct?: ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference | ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): any;
export declare class ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigHorizontalPodAutoscalingToTerraform(struct?: ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference | ContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
export declare class ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    set internalValue(value: ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigHttpLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigHttpLoadBalancingToTerraform(struct?: ContainerClusterAddonsConfigHttpLoadBalancingOutputReference | ContainerClusterAddonsConfigHttpLoadBalancing): any;
export declare class ContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    set internalValue(value: ContainerClusterAddonsConfigHttpLoadBalancing | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigNetworkPolicyConfigToTerraform(struct?: ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference | ContainerClusterAddonsConfigNetworkPolicyConfig): any;
export declare class ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfigNetworkPolicyConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfig {
    /**
    * cloudrun_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cloudrun_config ContainerCluster#cloudrun_config}
    */
    readonly cloudrunConfig?: ContainerClusterAddonsConfigCloudrunConfig;
    /**
    * dns_cache_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dns_cache_config ContainerCluster#dns_cache_config}
    */
    readonly dnsCacheConfig?: ContainerClusterAddonsConfigDnsCacheConfig;
    /**
    * gce_persistent_disk_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gce_persistent_disk_csi_driver_config ContainerCluster#gce_persistent_disk_csi_driver_config}
    */
    readonly gcePersistentDiskCsiDriverConfig?: ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig;
    /**
    * gcp_filestore_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcp_filestore_csi_driver_config ContainerCluster#gcp_filestore_csi_driver_config}
    */
    readonly gcpFilestoreCsiDriverConfig?: ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig;
    /**
    * horizontal_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#horizontal_pod_autoscaling ContainerCluster#horizontal_pod_autoscaling}
    */
    readonly horizontalPodAutoscaling?: ContainerClusterAddonsConfigHorizontalPodAutoscaling;
    /**
    * http_load_balancing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#http_load_balancing ContainerCluster#http_load_balancing}
    */
    readonly httpLoadBalancing?: ContainerClusterAddonsConfigHttpLoadBalancing;
    /**
    * network_policy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy_config ContainerCluster#network_policy_config}
    */
    readonly networkPolicyConfig?: ContainerClusterAddonsConfigNetworkPolicyConfig;
}
export declare function containerClusterAddonsConfigToTerraform(struct?: ContainerClusterAddonsConfigOutputReference | ContainerClusterAddonsConfig): any;
export declare class ContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAddonsConfig | undefined;
    set internalValue(value: ContainerClusterAddonsConfig | undefined);
    private _cloudrunConfig;
    get cloudrunConfig(): ContainerClusterAddonsConfigCloudrunConfigOutputReference;
    putCloudrunConfig(value: ContainerClusterAddonsConfigCloudrunConfig): void;
    resetCloudrunConfig(): void;
    get cloudrunConfigInput(): ContainerClusterAddonsConfigCloudrunConfig | undefined;
    private _dnsCacheConfig;
    get dnsCacheConfig(): ContainerClusterAddonsConfigDnsCacheConfigOutputReference;
    putDnsCacheConfig(value: ContainerClusterAddonsConfigDnsCacheConfig): void;
    resetDnsCacheConfig(): void;
    get dnsCacheConfigInput(): ContainerClusterAddonsConfigDnsCacheConfig | undefined;
    private _gcePersistentDiskCsiDriverConfig;
    get gcePersistentDiskCsiDriverConfig(): ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference;
    putGcePersistentDiskCsiDriverConfig(value: ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): void;
    resetGcePersistentDiskCsiDriverConfig(): void;
    get gcePersistentDiskCsiDriverConfigInput(): ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    private _gcpFilestoreCsiDriverConfig;
    get gcpFilestoreCsiDriverConfig(): ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference;
    putGcpFilestoreCsiDriverConfig(value: ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): void;
    resetGcpFilestoreCsiDriverConfig(): void;
    get gcpFilestoreCsiDriverConfigInput(): ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    private _horizontalPodAutoscaling;
    get horizontalPodAutoscaling(): ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
    putHorizontalPodAutoscaling(value: ContainerClusterAddonsConfigHorizontalPodAutoscaling): void;
    resetHorizontalPodAutoscaling(): void;
    get horizontalPodAutoscalingInput(): ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    private _httpLoadBalancing;
    get httpLoadBalancing(): ContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
    putHttpLoadBalancing(value: ContainerClusterAddonsConfigHttpLoadBalancing): void;
    resetHttpLoadBalancing(): void;
    get httpLoadBalancingInput(): ContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    private _networkPolicyConfig;
    get networkPolicyConfig(): ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
    putNetworkPolicyConfig(value: ContainerClusterAddonsConfigNetworkPolicyConfig): void;
    resetNetworkPolicyConfig(): void;
    get networkPolicyConfigInput(): ContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
}
export interface ContainerClusterAuthenticatorGroupsConfig {
    /**
    * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. Group name must be in format gke-security-groups@yourdomain.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#security_group ContainerCluster#security_group}
    */
    readonly securityGroup: string;
}
export declare function containerClusterAuthenticatorGroupsConfigToTerraform(struct?: ContainerClusterAuthenticatorGroupsConfigOutputReference | ContainerClusterAuthenticatorGroupsConfig): any;
export declare class ContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterAuthenticatorGroupsConfig | undefined;
    set internalValue(value: ContainerClusterAuthenticatorGroupsConfig | undefined);
    private _securityGroup?;
    get securityGroup(): string;
    set securityGroup(value: string);
    get securityGroupInput(): string | undefined;
}
export interface ContainerClusterBinaryAuthorization {
    /**
    * Enable Binary Authorization for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Mode of operation for Binary Authorization policy evaluation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#evaluation_mode ContainerCluster#evaluation_mode}
    */
    readonly evaluationMode?: string;
}
export declare function containerClusterBinaryAuthorizationToTerraform(struct?: ContainerClusterBinaryAuthorizationOutputReference | ContainerClusterBinaryAuthorization): any;
export declare class ContainerClusterBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterBinaryAuthorization | undefined;
    set internalValue(value: ContainerClusterBinaryAuthorization | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    resetEvaluationMode(): void;
    get evaluationModeInput(): string | undefined;
}
export interface ContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * The default image type used by NAP once a new node pool is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * Scopes that are used by NAP when creating node pools.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
}
export declare function containerClusterClusterAutoscalingAutoProvisioningDefaultsToTerraform(struct?: ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference | ContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
export declare class ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    set internalValue(value: ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
}
export interface ContainerClusterClusterAutoscalingResourceLimits {
    /**
    * Maximum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maximum ContainerCluster#maximum}
    */
    readonly maximum?: number;
    /**
    * Minimum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#minimum ContainerCluster#minimum}
    */
    readonly minimum?: number;
    /**
    * The type of the resource. For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_type ContainerCluster#resource_type}
    */
    readonly resourceType: string;
}
export declare function containerClusterClusterAutoscalingResourceLimitsToTerraform(struct?: ContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable): any;
export declare class ContainerClusterClusterAutoscalingResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined);
    private _maximum?;
    get maximum(): number;
    set maximum(value: number);
    resetMaximum(): void;
    get maximumInput(): number | undefined;
    private _minimum?;
    get minimum(): number;
    set minimum(value: number);
    resetMinimum(): void;
    get minimumInput(): number | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
}
export declare class ContainerClusterClusterAutoscalingResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterClusterAutoscalingResourceLimitsOutputReference;
}
export interface ContainerClusterClusterAutoscaling {
    /**
    * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * auto_provisioning_defaults block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_provisioning_defaults ContainerCluster#auto_provisioning_defaults}
    */
    readonly autoProvisioningDefaults?: ContainerClusterClusterAutoscalingAutoProvisioningDefaults;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_limits ContainerCluster#resource_limits}
    */
    readonly resourceLimits?: ContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
}
export declare function containerClusterClusterAutoscalingToTerraform(struct?: ContainerClusterClusterAutoscalingOutputReference | ContainerClusterClusterAutoscaling): any;
export declare class ContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterClusterAutoscaling | undefined;
    set internalValue(value: ContainerClusterClusterAutoscaling | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoProvisioningDefaults;
    get autoProvisioningDefaults(): ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
    putAutoProvisioningDefaults(value: ContainerClusterClusterAutoscalingAutoProvisioningDefaults): void;
    resetAutoProvisioningDefaults(): void;
    get autoProvisioningDefaultsInput(): ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    private _resourceLimits;
    get resourceLimits(): ContainerClusterClusterAutoscalingResourceLimitsList;
    putResourceLimits(value: ContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | ContainerClusterClusterAutoscalingResourceLimits[] | undefined;
}
export interface ContainerClusterConfidentialNodes {
    /**
    * Whether Confidential Nodes feature is enabled for all nodes in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterConfidentialNodesToTerraform(struct?: ContainerClusterConfidentialNodesOutputReference | ContainerClusterConfidentialNodes): any;
export declare class ContainerClusterConfidentialNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterConfidentialNodes | undefined;
    set internalValue(value: ContainerClusterConfidentialNodes | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterDatabaseEncryption {
    /**
    * The key to use to encrypt/decrypt secrets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key_name ContainerCluster#key_name}
    */
    readonly keyName?: string;
    /**
    * ENCRYPTED or DECRYPTED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#state ContainerCluster#state}
    */
    readonly state: string;
}
export declare function containerClusterDatabaseEncryptionToTerraform(struct?: ContainerClusterDatabaseEncryptionOutputReference | ContainerClusterDatabaseEncryption): any;
export declare class ContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterDatabaseEncryption | undefined;
    set internalValue(value: ContainerClusterDatabaseEncryption | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface ContainerClusterDefaultSnatStatus {
    /**
    * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterDefaultSnatStatusToTerraform(struct?: ContainerClusterDefaultSnatStatusOutputReference | ContainerClusterDefaultSnatStatus): any;
export declare class ContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterDefaultSnatStatus | undefined;
    set internalValue(value: ContainerClusterDefaultSnatStatus | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterDnsConfig {
    /**
    * Which in-cluster DNS provider should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns ContainerCluster#cluster_dns}
    */
    readonly clusterDns?: string;
    /**
    * The suffix used for all cluster service records.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns_domain ContainerCluster#cluster_dns_domain}
    */
    readonly clusterDnsDomain?: string;
    /**
    * The scope of access to cluster DNS records.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns_scope ContainerCluster#cluster_dns_scope}
    */
    readonly clusterDnsScope?: string;
}
export declare function containerClusterDnsConfigToTerraform(struct?: ContainerClusterDnsConfigOutputReference | ContainerClusterDnsConfig): any;
export declare class ContainerClusterDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterDnsConfig | undefined;
    set internalValue(value: ContainerClusterDnsConfig | undefined);
    private _clusterDns?;
    get clusterDns(): string;
    set clusterDns(value: string);
    resetClusterDns(): void;
    get clusterDnsInput(): string | undefined;
    private _clusterDnsDomain?;
    get clusterDnsDomain(): string;
    set clusterDnsDomain(value: string);
    resetClusterDnsDomain(): void;
    get clusterDnsDomainInput(): string | undefined;
    private _clusterDnsScope?;
    get clusterDnsScope(): string;
    set clusterDnsScope(value: string);
    resetClusterDnsScope(): void;
    get clusterDnsScopeInput(): string | undefined;
}
export interface ContainerClusterIpAllocationPolicy {
    /**
    * The IP address range for the cluster pod IPs. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr_block ContainerCluster#cluster_ipv4_cidr_block}
    */
    readonly clusterIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses. Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_secondary_range_name ContainerCluster#cluster_secondary_range_name}
    */
    readonly clusterSecondaryRangeName?: string;
    /**
    * The IP address range of the services IPs in this cluster. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_ipv4_cidr_block ContainerCluster#services_ipv4_cidr_block}
    */
    readonly servicesIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs. Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_secondary_range_name ContainerCluster#services_secondary_range_name}
    */
    readonly servicesSecondaryRangeName?: string;
}
export declare function containerClusterIpAllocationPolicyToTerraform(struct?: ContainerClusterIpAllocationPolicyOutputReference | ContainerClusterIpAllocationPolicy): any;
export declare class ContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterIpAllocationPolicy | undefined;
    set internalValue(value: ContainerClusterIpAllocationPolicy | undefined);
    private _clusterIpv4CidrBlock?;
    get clusterIpv4CidrBlock(): string;
    set clusterIpv4CidrBlock(value: string);
    resetClusterIpv4CidrBlock(): void;
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    get clusterSecondaryRangeName(): string;
    set clusterSecondaryRangeName(value: string);
    resetClusterSecondaryRangeName(): void;
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    get servicesIpv4CidrBlock(): string;
    set servicesIpv4CidrBlock(value: string);
    resetServicesIpv4CidrBlock(): void;
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    get servicesSecondaryRangeName(): string;
    set servicesSecondaryRangeName(value: string);
    resetServicesSecondaryRangeName(): void;
    get servicesSecondaryRangeNameInput(): string | undefined;
}
export interface ContainerClusterLoggingConfig {
    /**
    * GKE components exposing logs. Valid values include SYSTEM_COMPONENTS and WORKLOADS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}
    */
    readonly enableComponents: string[];
}
export declare function containerClusterLoggingConfigToTerraform(struct?: ContainerClusterLoggingConfigOutputReference | ContainerClusterLoggingConfig): any;
export declare class ContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterLoggingConfig | undefined;
    set internalValue(value: ContainerClusterLoggingConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface ContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function containerClusterMaintenancePolicyDailyMaintenanceWindowToTerraform(struct?: ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference | ContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
export declare class ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    set internalValue(value: ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined);
    get duration(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions {
    /**
    * The scope of automatic upgrades to restrict in the exclusion window.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#scope ContainerCluster#scope}
    */
    readonly scope: string;
}
export declare function containerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsToTerraform(struct?: ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference | ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): any;
export declare class ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
    set internalValue(value: ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined);
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
}
export interface ContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_name ContainerCluster#exclusion_name}
    */
    readonly exclusionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}
    */
    readonly startTime: string;
    /**
    * exclusion_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_options ContainerCluster#exclusion_options}
    */
    readonly exclusionOptions?: ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions;
}
export declare function containerClusterMaintenancePolicyMaintenanceExclusionToTerraform(struct?: ContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable): any;
export declare class ContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _exclusionName?;
    get exclusionName(): string;
    set exclusionName(value: string);
    get exclusionNameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _exclusionOptions;
    get exclusionOptions(): ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference;
    putExclusionOptions(value: ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): void;
    resetExclusionOptions(): void;
    get exclusionOptionsInput(): ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
}
export declare class ContainerClusterMaintenancePolicyMaintenanceExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference;
}
export interface ContainerClusterMaintenancePolicyRecurringWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurrence ContainerCluster#recurrence}
    */
    readonly recurrence: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function containerClusterMaintenancePolicyRecurringWindowToTerraform(struct?: ContainerClusterMaintenancePolicyRecurringWindowOutputReference | ContainerClusterMaintenancePolicyRecurringWindow): any;
export declare class ContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMaintenancePolicyRecurringWindow | undefined;
    set internalValue(value: ContainerClusterMaintenancePolicyRecurringWindow | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    get recurrenceInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ContainerClusterMaintenancePolicy {
    /**
    * daily_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#daily_maintenance_window ContainerCluster#daily_maintenance_window}
    */
    readonly dailyMaintenanceWindow?: ContainerClusterMaintenancePolicyDailyMaintenanceWindow;
    /**
    * maintenance_exclusion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_exclusion ContainerCluster#maintenance_exclusion}
    */
    readonly maintenanceExclusion?: ContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * recurring_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurring_window ContainerCluster#recurring_window}
    */
    readonly recurringWindow?: ContainerClusterMaintenancePolicyRecurringWindow;
}
export declare function containerClusterMaintenancePolicyToTerraform(struct?: ContainerClusterMaintenancePolicyOutputReference | ContainerClusterMaintenancePolicy): any;
export declare class ContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMaintenancePolicy | undefined;
    set internalValue(value: ContainerClusterMaintenancePolicy | undefined);
    private _dailyMaintenanceWindow;
    get dailyMaintenanceWindow(): ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
    putDailyMaintenanceWindow(value: ContainerClusterMaintenancePolicyDailyMaintenanceWindow): void;
    resetDailyMaintenanceWindow(): void;
    get dailyMaintenanceWindowInput(): ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    private _maintenanceExclusion;
    get maintenanceExclusion(): ContainerClusterMaintenancePolicyMaintenanceExclusionList;
    putMaintenanceExclusion(value: ContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable): void;
    resetMaintenanceExclusion(): void;
    get maintenanceExclusionInput(): cdktf.IResolvable | ContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    private _recurringWindow;
    get recurringWindow(): ContainerClusterMaintenancePolicyRecurringWindowOutputReference;
    putRecurringWindow(value: ContainerClusterMaintenancePolicyRecurringWindow): void;
    resetRecurringWindow(): void;
    get recurringWindowInput(): ContainerClusterMaintenancePolicyRecurringWindow | undefined;
}
export interface ContainerClusterMasterAuthClientCertificateConfig {
    /**
    * Whether client certificate authorization is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#issue_client_certificate ContainerCluster#issue_client_certificate}
    */
    readonly issueClientCertificate: boolean | cdktf.IResolvable;
}
export declare function containerClusterMasterAuthClientCertificateConfigToTerraform(struct?: ContainerClusterMasterAuthClientCertificateConfigOutputReference | ContainerClusterMasterAuthClientCertificateConfig): any;
export declare class ContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMasterAuthClientCertificateConfig | undefined;
    set internalValue(value: ContainerClusterMasterAuthClientCertificateConfig | undefined);
    private _issueClientCertificate?;
    get issueClientCertificate(): boolean | cdktf.IResolvable;
    set issueClientCertificate(value: boolean | cdktf.IResolvable);
    get issueClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterMasterAuth {
    /**
    * client_certificate_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#client_certificate_config ContainerCluster#client_certificate_config}
    */
    readonly clientCertificateConfig: ContainerClusterMasterAuthClientCertificateConfig;
}
export declare function containerClusterMasterAuthToTerraform(struct?: ContainerClusterMasterAuthOutputReference | ContainerClusterMasterAuth): any;
export declare class ContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMasterAuth | undefined;
    set internalValue(value: ContainerClusterMasterAuth | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    private _clientCertificateConfig;
    get clientCertificateConfig(): ContainerClusterMasterAuthClientCertificateConfigOutputReference;
    putClientCertificateConfig(value: ContainerClusterMasterAuthClientCertificateConfig): void;
    get clientCertificateConfigInput(): ContainerClusterMasterAuthClientCertificateConfig | undefined;
}
export interface ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
    * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_block ContainerCluster#cidr_block}
    */
    readonly cidrBlock: string;
    /**
    * Field for users to identify CIDR blocks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#display_name ContainerCluster#display_name}
    */
    readonly displayName?: string;
}
export declare function containerClusterMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable): any;
export declare class ContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined);
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    get cidrBlockInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
}
export declare class ContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface ContainerClusterMasterAuthorizedNetworksConfig {
    /**
    * cidr_blocks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_blocks ContainerCluster#cidr_blocks}
    */
    readonly cidrBlocks?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
}
export declare function containerClusterMasterAuthorizedNetworksConfigToTerraform(struct?: ContainerClusterMasterAuthorizedNetworksConfigOutputReference | ContainerClusterMasterAuthorizedNetworksConfig): any;
export declare class ContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: ContainerClusterMasterAuthorizedNetworksConfig | undefined);
    private _cidrBlocks;
    get cidrBlocks(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList;
    putCidrBlocks(value: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable): void;
    resetCidrBlocks(): void;
    get cidrBlocksInput(): cdktf.IResolvable | ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
export interface ContainerClusterMeshCertificates {
    /**
    * When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_certificates ContainerCluster#enable_certificates}
    */
    readonly enableCertificates: boolean | cdktf.IResolvable;
}
export declare function containerClusterMeshCertificatesToTerraform(struct?: ContainerClusterMeshCertificatesOutputReference | ContainerClusterMeshCertificates): any;
export declare class ContainerClusterMeshCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMeshCertificates | undefined;
    set internalValue(value: ContainerClusterMeshCertificates | undefined);
    private _enableCertificates?;
    get enableCertificates(): boolean | cdktf.IResolvable;
    set enableCertificates(value: boolean | cdktf.IResolvable);
    get enableCertificatesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterMonitoringConfig {
    /**
    * GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, and SCHEDULER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}
    */
    readonly enableComponents: string[];
}
export declare function containerClusterMonitoringConfigToTerraform(struct?: ContainerClusterMonitoringConfigOutputReference | ContainerClusterMonitoringConfig): any;
export declare class ContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterMonitoringConfig | undefined;
    set internalValue(value: ContainerClusterMonitoringConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface ContainerClusterNetworkPolicy {
    /**
    * Whether network policy is enabled on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#provider ContainerCluster#provider}
    */
    readonly provider?: string;
}
export declare function containerClusterNetworkPolicyToTerraform(struct?: ContainerClusterNetworkPolicyOutputReference | ContainerClusterNetworkPolicy): any;
export declare class ContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNetworkPolicy | undefined;
    set internalValue(value: ContainerClusterNetworkPolicy | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    resetProvider(): void;
    get providerInput(): string | undefined;
}
export interface ContainerClusterNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}
    */
    readonly type?: string;
}
export declare function containerClusterNodeConfigGuestAcceleratorToTerraform(struct?: ContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class ContainerClusterNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ContainerClusterNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterNodeConfigGuestAcceleratorOutputReference;
}
export interface ContainerClusterNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}
    */
    readonly value?: string;
}
export declare function containerClusterNodeConfigTaintToTerraform(struct?: ContainerClusterNodeConfigTaint | cdktf.IResolvable): any;
export declare class ContainerClusterNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerClusterNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterNodeConfigTaintOutputReference;
}
export interface ContainerClusterNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodeConfigGcfsConfigToTerraform(struct?: ContainerClusterNodeConfigGcfsConfigOutputReference | ContainerClusterNodeConfigGcfsConfig): any;
export declare class ContainerClusterNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfigGcfsConfig | undefined;
    set internalValue(value: ContainerClusterNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodeConfigGvnicToTerraform(struct?: ContainerClusterNodeConfigGvnicOutputReference | ContainerClusterNodeConfigGvnic): any;
export declare class ContainerClusterNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfigGvnic | undefined;
    set internalValue(value: ContainerClusterNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#consume_reservation_type ContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#values ContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function containerClusterNodeConfigReservationAffinityToTerraform(struct?: ContainerClusterNodeConfigReservationAffinityOutputReference | ContainerClusterNodeConfigReservationAffinity): any;
export declare class ContainerClusterNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfigReservationAffinity | undefined;
    set internalValue(value: ContainerClusterNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface ContainerClusterNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodeConfigShieldedInstanceConfigToTerraform(struct?: ContainerClusterNodeConfigShieldedInstanceConfigOutputReference | ContainerClusterNodeConfigShieldedInstanceConfig): any;
export declare class ContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: ContainerClusterNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function containerClusterNodeConfigWorkloadMetadataConfigToTerraform(struct?: ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference | ContainerClusterNodeConfigWorkloadMetadataConfig): any;
export declare class ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: ContainerClusterNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface ContainerClusterNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: ContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_group ContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#spot ContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}
    */
    readonly taint?: ContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcfs_config ContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: ContainerClusterNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gvnic ContainerCluster#gvnic}
    */
    readonly gvnic?: ContainerClusterNodeConfigGvnic;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#reservation_affinity ContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: ContainerClusterNodeConfigReservationAffinity;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ContainerClusterNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: ContainerClusterNodeConfigWorkloadMetadataConfig;
}
export declare function containerClusterNodeConfigToTerraform(struct?: ContainerClusterNodeConfigOutputReference | ContainerClusterNodeConfig): any;
export declare class ContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodeConfig | undefined;
    set internalValue(value: ContainerClusterNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): ContainerClusterNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: ContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ContainerClusterNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): ContainerClusterNodeConfigTaintList;
    putTaint(value: ContainerClusterNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | ContainerClusterNodeConfigTaint[] | undefined;
    private _gcfsConfig;
    get gcfsConfig(): ContainerClusterNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: ContainerClusterNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): ContainerClusterNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): ContainerClusterNodeConfigGvnicOutputReference;
    putGvnic(value: ContainerClusterNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): ContainerClusterNodeConfigGvnic | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ContainerClusterNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: ContainerClusterNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ContainerClusterNodeConfigReservationAffinity | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerClusterNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerClusterNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerClusterNodePoolAutoscaling {
    /**
    * Maximum number of nodes in the NodePool. Must be >= min_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_node_count ContainerCluster#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_node_count ContainerCluster#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function containerClusterNodePoolAutoscalingToTerraform(struct?: ContainerClusterNodePoolAutoscalingOutputReference | ContainerClusterNodePoolAutoscaling): any;
export declare class ContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolAutoscaling | undefined;
    set internalValue(value: ContainerClusterNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface ContainerClusterNodePoolManagement {
    /**
    * Whether the nodes will be automatically repaired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_repair ContainerCluster#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Whether the nodes will be automatically upgraded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_upgrade ContainerCluster#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolManagementToTerraform(struct?: ContainerClusterNodePoolManagementOutputReference | ContainerClusterNodePoolManagement): any;
export declare class ContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolManagement | undefined;
    set internalValue(value: ContainerClusterNodePoolManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}
    */
    readonly type?: string;
}
export declare function containerClusterNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: ContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class ContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ContainerClusterNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface ContainerClusterNodePoolNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}
    */
    readonly value?: string;
}
export declare function containerClusterNodePoolNodeConfigTaintToTerraform(struct?: ContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare class ContainerClusterNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerClusterNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterNodePoolNodeConfigTaintOutputReference;
}
export interface ContainerClusterNodePoolNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolNodeConfigGcfsConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigGcfsConfigOutputReference | ContainerClusterNodePoolNodeConfigGcfsConfig): any;
export declare class ContainerClusterNodePoolNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolNodeConfigGvnicToTerraform(struct?: ContainerClusterNodePoolNodeConfigGvnicOutputReference | ContainerClusterNodePoolNodeConfigGvnic): any;
export declare class ContainerClusterNodePoolNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfigGvnic | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#consume_reservation_type ContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#values ContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function containerClusterNodePoolNodeConfigReservationAffinityToTerraform(struct?: ContainerClusterNodePoolNodeConfigReservationAffinityOutputReference | ContainerClusterNodePoolNodeConfigReservationAffinity): any;
export declare class ContainerClusterNodePoolNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface ContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference | ContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function containerClusterNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference | ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface ContainerClusterNodePoolNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: ContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_group ContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#spot ContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}
    */
    readonly taint?: ContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcfs_config ContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: ContainerClusterNodePoolNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gvnic ContainerCluster#gvnic}
    */
    readonly gvnic?: ContainerClusterNodePoolNodeConfigGvnic;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#reservation_affinity ContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: ContainerClusterNodePoolNodeConfigReservationAffinity;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function containerClusterNodePoolNodeConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigOutputReference | ContainerClusterNodePoolNodeConfig): any;
export declare class ContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolNodeConfig | undefined;
    set internalValue(value: ContainerClusterNodePoolNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): ContainerClusterNodePoolNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: ContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | ContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): ContainerClusterNodePoolNodeConfigTaintList;
    putTaint(value: ContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | ContainerClusterNodePoolNodeConfigTaint[] | undefined;
    private _gcfsConfig;
    get gcfsConfig(): ContainerClusterNodePoolNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: ContainerClusterNodePoolNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): ContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): ContainerClusterNodePoolNodeConfigGvnicOutputReference;
    putGvnic(value: ContainerClusterNodePoolNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): ContainerClusterNodePoolNodeConfigGvnic | undefined;
    private _reservationAffinity;
    get reservationAffinity(): ContainerClusterNodePoolNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: ContainerClusterNodePoolNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerClusterNodePoolUpgradeSettings {
    /**
    * The number of additional nodes that can be added to the node pool during an upgrade. Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_surge ContainerCluster#max_surge}
    */
    readonly maxSurge: number;
    /**
    * The number of nodes that can be simultaneously unavailable during an upgrade. Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_unavailable ContainerCluster#max_unavailable}
    */
    readonly maxUnavailable: number;
}
export declare function containerClusterNodePoolUpgradeSettingsToTerraform(struct?: ContainerClusterNodePoolUpgradeSettingsOutputReference | ContainerClusterNodePoolUpgradeSettings): any;
export declare class ContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: ContainerClusterNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
export interface ContainerClusterNodePool {
    /**
    * The initial number of nodes for the pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The maximum number of pods per node in this node pool. Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_pods_per_node ContainerCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name_prefix ContainerCluster#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The number of nodes per instance group. This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_count ContainerCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * The list of zones in which the node pool's nodes should be located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version for the nodes in this pool. Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#version ContainerCluster#version}
    */
    readonly version?: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#autoscaling ContainerCluster#autoscaling}
    */
    readonly autoscaling?: ContainerClusterNodePoolAutoscaling;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#management ContainerCluster#management}
    */
    readonly management?: ContainerClusterNodePoolManagement;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}
    */
    readonly nodeConfig?: ContainerClusterNodePoolNodeConfig;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#upgrade_settings ContainerCluster#upgrade_settings}
    */
    readonly upgradeSettings?: ContainerClusterNodePoolUpgradeSettings;
}
export declare function containerClusterNodePoolToTerraform(struct?: ContainerClusterNodePool | cdktf.IResolvable): any;
export declare class ContainerClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerClusterNodePool | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterNodePool | cdktf.IResolvable | undefined);
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    get managedInstanceGroupUrls(): string[];
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): ContainerClusterNodePoolAutoscalingOutputReference;
    putAutoscaling(value: ContainerClusterNodePoolAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): ContainerClusterNodePoolAutoscaling | undefined;
    private _management;
    get management(): ContainerClusterNodePoolManagementOutputReference;
    putManagement(value: ContainerClusterNodePoolManagement): void;
    resetManagement(): void;
    get managementInput(): ContainerClusterNodePoolManagement | undefined;
    private _nodeConfig;
    get nodeConfig(): ContainerClusterNodePoolNodeConfigOutputReference;
    putNodeConfig(value: ContainerClusterNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ContainerClusterNodePoolNodeConfig | undefined;
    private _upgradeSettings;
    get upgradeSettings(): ContainerClusterNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: ContainerClusterNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): ContainerClusterNodePoolUpgradeSettings | undefined;
}
export declare class ContainerClusterNodePoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerClusterNodePoolOutputReference;
}
export interface ContainerClusterNotificationConfigPubsub {
    /**
    * Whether or not the notification config is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The pubsub topic to push upgrade notifications to. Must be in the same project as the cluster. Must be in the format: projects/{project}/topics/{topic}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#topic ContainerCluster#topic}
    */
    readonly topic?: string;
}
export declare function containerClusterNotificationConfigPubsubToTerraform(struct?: ContainerClusterNotificationConfigPubsubOutputReference | ContainerClusterNotificationConfigPubsub): any;
export declare class ContainerClusterNotificationConfigPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNotificationConfigPubsub | undefined;
    set internalValue(value: ContainerClusterNotificationConfigPubsub | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface ContainerClusterNotificationConfig {
    /**
    * pubsub block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pubsub ContainerCluster#pubsub}
    */
    readonly pubsub: ContainerClusterNotificationConfigPubsub;
}
export declare function containerClusterNotificationConfigToTerraform(struct?: ContainerClusterNotificationConfigOutputReference | ContainerClusterNotificationConfig): any;
export declare class ContainerClusterNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterNotificationConfig | undefined;
    set internalValue(value: ContainerClusterNotificationConfig | undefined);
    private _pubsub;
    get pubsub(): ContainerClusterNotificationConfigPubsubOutputReference;
    putPubsub(value: ContainerClusterNotificationConfigPubsub): void;
    get pubsubInput(): ContainerClusterNotificationConfigPubsub | undefined;
}
export interface ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
    * Whether the cluster master is accessible globally or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterPrivateClusterConfigMasterGlobalAccessConfigToTerraform(struct?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference | ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
export declare class ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
    set internalValue(value: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterPrivateClusterConfig {
    /**
    * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled. When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_endpoint ContainerCluster#enable_private_endpoint}
    */
    readonly enablePrivateEndpoint: boolean | cdktf.IResolvable;
    /**
    * Enables the private cluster feature, creating a private endpoint on the cluster. In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_nodes ContainerCluster#enable_private_nodes}
    */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
    * The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_ipv4_cidr_block ContainerCluster#master_ipv4_cidr_block}
    */
    readonly masterIpv4CidrBlock?: string;
    /**
    * master_global_access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_global_access_config ContainerCluster#master_global_access_config}
    */
    readonly masterGlobalAccessConfig?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;
}
export declare function containerClusterPrivateClusterConfigToTerraform(struct?: ContainerClusterPrivateClusterConfigOutputReference | ContainerClusterPrivateClusterConfig): any;
export declare class ContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterPrivateClusterConfig | undefined;
    set internalValue(value: ContainerClusterPrivateClusterConfig | undefined);
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    get enablePrivateNodes(): boolean | cdktf.IResolvable;
    set enablePrivateNodes(value: boolean | cdktf.IResolvable);
    resetEnablePrivateNodes(): void;
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string;
    set masterIpv4CidrBlock(value: string);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    get peeringName(): string;
    get privateEndpoint(): string;
    get publicEndpoint(): string;
    private _masterGlobalAccessConfig;
    get masterGlobalAccessConfig(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
    putMasterGlobalAccessConfig(value: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): void;
    resetMasterGlobalAccessConfig(): void;
    get masterGlobalAccessConfigInput(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
}
export interface ContainerClusterReleaseChannel {
    /**
    * The selected release channel. Accepted values are:
  * UNSPECIFIED: Not set.
  * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
  * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
  * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#channel ContainerCluster#channel}
    */
    readonly channel: string;
}
export declare function containerClusterReleaseChannelToTerraform(struct?: ContainerClusterReleaseChannelOutputReference | ContainerClusterReleaseChannel): any;
export declare class ContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterReleaseChannel | undefined;
    set internalValue(value: ContainerClusterReleaseChannel | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
}
export interface ContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
    * The ID of a BigQuery Dataset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dataset_id ContainerCluster#dataset_id}
    */
    readonly datasetId: string;
}
export declare function containerClusterResourceUsageExportConfigBigqueryDestinationToTerraform(struct?: ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference | ContainerClusterResourceUsageExportConfigBigqueryDestination): any;
export declare class ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
    set internalValue(value: ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
}
export interface ContainerClusterResourceUsageExportConfig {
    /**
    * Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_network_egress_metering ContainerCluster#enable_network_egress_metering}
    */
    readonly enableNetworkEgressMetering?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable resource consumption metering on this cluster. When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_resource_consumption_metering ContainerCluster#enable_resource_consumption_metering}
    */
    readonly enableResourceConsumptionMetering?: boolean | cdktf.IResolvable;
    /**
    * bigquery_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#bigquery_destination ContainerCluster#bigquery_destination}
    */
    readonly bigqueryDestination: ContainerClusterResourceUsageExportConfigBigqueryDestination;
}
export declare function containerClusterResourceUsageExportConfigToTerraform(struct?: ContainerClusterResourceUsageExportConfigOutputReference | ContainerClusterResourceUsageExportConfig): any;
export declare class ContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterResourceUsageExportConfig | undefined;
    set internalValue(value: ContainerClusterResourceUsageExportConfig | undefined);
    private _enableNetworkEgressMetering?;
    get enableNetworkEgressMetering(): boolean | cdktf.IResolvable;
    set enableNetworkEgressMetering(value: boolean | cdktf.IResolvable);
    resetEnableNetworkEgressMetering(): void;
    get enableNetworkEgressMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableResourceConsumptionMetering?;
    get enableResourceConsumptionMetering(): boolean | cdktf.IResolvable;
    set enableResourceConsumptionMetering(value: boolean | cdktf.IResolvable);
    resetEnableResourceConsumptionMetering(): void;
    get enableResourceConsumptionMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _bigqueryDestination;
    get bigqueryDestination(): ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
    putBigqueryDestination(value: ContainerClusterResourceUsageExportConfigBigqueryDestination): void;
    get bigqueryDestinationInput(): ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
}
export interface ContainerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#create ContainerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#delete ContainerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#read ContainerCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#update ContainerCluster#update}
    */
    readonly update?: string;
}
export declare function containerClusterTimeoutsToTerraform(struct?: ContainerClusterTimeoutsOutputReference | ContainerClusterTimeouts | cdktf.IResolvable): any;
export declare class ContainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerClusterVerticalPodAutoscaling {
    /**
    * Enables vertical pod autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterVerticalPodAutoscalingToTerraform(struct?: ContainerClusterVerticalPodAutoscalingOutputReference | ContainerClusterVerticalPodAutoscaling): any;
export declare class ContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterVerticalPodAutoscaling | undefined;
    set internalValue(value: ContainerClusterVerticalPodAutoscaling | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterWorkloadIdentityConfig {
    /**
    * The workload pool to attach all Kubernetes service accounts to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_pool ContainerCluster#workload_pool}
    */
    readonly workloadPool?: string;
}
export declare function containerClusterWorkloadIdentityConfigToTerraform(struct?: ContainerClusterWorkloadIdentityConfigOutputReference | ContainerClusterWorkloadIdentityConfig): any;
export declare class ContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: ContainerClusterWorkloadIdentityConfig | undefined);
    private _workloadPool?;
    get workloadPool(): string;
    set workloadPool(value: string);
    resetWorkloadPool(): void;
    get workloadPoolInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_cluster google_container_cluster}
*/
export declare class ContainerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_cluster google_container_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: ContainerClusterConfig);
    private _clusterIpv4Cidr?;
    get clusterIpv4Cidr(): string;
    set clusterIpv4Cidr(value: string);
    resetClusterIpv4Cidr(): void;
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    get datapathProvider(): string;
    set datapathProvider(value: string);
    resetDatapathProvider(): void;
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    get defaultMaxPodsPerNode(): number;
    set defaultMaxPodsPerNode(value: number);
    resetDefaultMaxPodsPerNode(): void;
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    get enableAutopilot(): boolean | cdktf.IResolvable;
    set enableAutopilot(value: boolean | cdktf.IResolvable);
    resetEnableAutopilot(): void;
    get enableAutopilotInput(): boolean | cdktf.IResolvable | undefined;
    private _enableBinaryAuthorization?;
    get enableBinaryAuthorization(): boolean | cdktf.IResolvable;
    set enableBinaryAuthorization(value: boolean | cdktf.IResolvable);
    resetEnableBinaryAuthorization(): void;
    get enableBinaryAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIntranodeVisibility?;
    get enableIntranodeVisibility(): boolean | cdktf.IResolvable;
    set enableIntranodeVisibility(value: boolean | cdktf.IResolvable);
    resetEnableIntranodeVisibility(): void;
    get enableIntranodeVisibilityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableKubernetesAlpha?;
    get enableKubernetesAlpha(): boolean | cdktf.IResolvable;
    set enableKubernetesAlpha(value: boolean | cdktf.IResolvable);
    resetEnableKubernetesAlpha(): void;
    get enableKubernetesAlphaInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLegacyAbac?;
    get enableLegacyAbac(): boolean | cdktf.IResolvable;
    set enableLegacyAbac(value: boolean | cdktf.IResolvable);
    resetEnableLegacyAbac(): void;
    get enableLegacyAbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableShieldedNodes?;
    get enableShieldedNodes(): boolean | cdktf.IResolvable;
    set enableShieldedNodes(value: boolean | cdktf.IResolvable);
    resetEnableShieldedNodes(): void;
    get enableShieldedNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTpu?;
    get enableTpu(): boolean | cdktf.IResolvable;
    set enableTpu(value: boolean | cdktf.IResolvable);
    resetEnableTpu(): void;
    get enableTpuInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingService?;
    get loggingService(): string;
    set loggingService(value: string);
    resetLoggingService(): void;
    get loggingServiceInput(): string | undefined;
    get masterVersion(): string;
    private _minMasterVersion?;
    get minMasterVersion(): string;
    set minMasterVersion(value: string);
    resetMinMasterVersion(): void;
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    get monitoringService(): string;
    set monitoringService(value: string);
    resetMonitoringService(): void;
    get monitoringServiceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkingMode?;
    get networkingMode(): string;
    set networkingMode(value: string);
    resetNetworkingMode(): void;
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    get removeDefaultNodePool(): boolean | cdktf.IResolvable;
    set removeDefaultNodePool(value: boolean | cdktf.IResolvable);
    resetRemoveDefaultNodePool(): void;
    get removeDefaultNodePoolInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    };
    set resourceLabels(value: {
        [key: string]: string;
    });
    resetResourceLabels(): void;
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig;
    get addonsConfig(): ContainerClusterAddonsConfigOutputReference;
    putAddonsConfig(value: ContainerClusterAddonsConfig): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): ContainerClusterAddonsConfig | undefined;
    private _authenticatorGroupsConfig;
    get authenticatorGroupsConfig(): ContainerClusterAuthenticatorGroupsConfigOutputReference;
    putAuthenticatorGroupsConfig(value: ContainerClusterAuthenticatorGroupsConfig): void;
    resetAuthenticatorGroupsConfig(): void;
    get authenticatorGroupsConfigInput(): ContainerClusterAuthenticatorGroupsConfig | undefined;
    private _binaryAuthorization;
    get binaryAuthorization(): ContainerClusterBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: ContainerClusterBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): ContainerClusterBinaryAuthorization | undefined;
    private _clusterAutoscaling;
    get clusterAutoscaling(): ContainerClusterClusterAutoscalingOutputReference;
    putClusterAutoscaling(value: ContainerClusterClusterAutoscaling): void;
    resetClusterAutoscaling(): void;
    get clusterAutoscalingInput(): ContainerClusterClusterAutoscaling | undefined;
    private _confidentialNodes;
    get confidentialNodes(): ContainerClusterConfidentialNodesOutputReference;
    putConfidentialNodes(value: ContainerClusterConfidentialNodes): void;
    resetConfidentialNodes(): void;
    get confidentialNodesInput(): ContainerClusterConfidentialNodes | undefined;
    private _databaseEncryption;
    get databaseEncryption(): ContainerClusterDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: ContainerClusterDatabaseEncryption): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): ContainerClusterDatabaseEncryption | undefined;
    private _defaultSnatStatus;
    get defaultSnatStatus(): ContainerClusterDefaultSnatStatusOutputReference;
    putDefaultSnatStatus(value: ContainerClusterDefaultSnatStatus): void;
    resetDefaultSnatStatus(): void;
    get defaultSnatStatusInput(): ContainerClusterDefaultSnatStatus | undefined;
    private _dnsConfig;
    get dnsConfig(): ContainerClusterDnsConfigOutputReference;
    putDnsConfig(value: ContainerClusterDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): ContainerClusterDnsConfig | undefined;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): ContainerClusterIpAllocationPolicyOutputReference;
    putIpAllocationPolicy(value: ContainerClusterIpAllocationPolicy): void;
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): ContainerClusterIpAllocationPolicy | undefined;
    private _loggingConfig;
    get loggingConfig(): ContainerClusterLoggingConfigOutputReference;
    putLoggingConfig(value: ContainerClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): ContainerClusterLoggingConfig | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): ContainerClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: ContainerClusterMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): ContainerClusterMaintenancePolicy | undefined;
    private _masterAuth;
    get masterAuth(): ContainerClusterMasterAuthOutputReference;
    putMasterAuth(value: ContainerClusterMasterAuth): void;
    resetMasterAuth(): void;
    get masterAuthInput(): ContainerClusterMasterAuth | undefined;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): ContainerClusterMasterAuthorizedNetworksConfigOutputReference;
    putMasterAuthorizedNetworksConfig(value: ContainerClusterMasterAuthorizedNetworksConfig): void;
    resetMasterAuthorizedNetworksConfig(): void;
    get masterAuthorizedNetworksConfigInput(): ContainerClusterMasterAuthorizedNetworksConfig | undefined;
    private _meshCertificates;
    get meshCertificates(): ContainerClusterMeshCertificatesOutputReference;
    putMeshCertificates(value: ContainerClusterMeshCertificates): void;
    resetMeshCertificates(): void;
    get meshCertificatesInput(): ContainerClusterMeshCertificates | undefined;
    private _monitoringConfig;
    get monitoringConfig(): ContainerClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: ContainerClusterMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): ContainerClusterMonitoringConfig | undefined;
    private _networkPolicy;
    get networkPolicy(): ContainerClusterNetworkPolicyOutputReference;
    putNetworkPolicy(value: ContainerClusterNetworkPolicy): void;
    resetNetworkPolicy(): void;
    get networkPolicyInput(): ContainerClusterNetworkPolicy | undefined;
    private _nodeConfig;
    get nodeConfig(): ContainerClusterNodeConfigOutputReference;
    putNodeConfig(value: ContainerClusterNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ContainerClusterNodeConfig | undefined;
    private _nodePool;
    get nodePool(): ContainerClusterNodePoolList;
    putNodePool(value: ContainerClusterNodePool[] | cdktf.IResolvable): void;
    resetNodePool(): void;
    get nodePoolInput(): cdktf.IResolvable | ContainerClusterNodePool[] | undefined;
    private _notificationConfig;
    get notificationConfig(): ContainerClusterNotificationConfigOutputReference;
    putNotificationConfig(value: ContainerClusterNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): ContainerClusterNotificationConfig | undefined;
    private _privateClusterConfig;
    get privateClusterConfig(): ContainerClusterPrivateClusterConfigOutputReference;
    putPrivateClusterConfig(value: ContainerClusterPrivateClusterConfig): void;
    resetPrivateClusterConfig(): void;
    get privateClusterConfigInput(): ContainerClusterPrivateClusterConfig | undefined;
    private _releaseChannel;
    get releaseChannel(): ContainerClusterReleaseChannelOutputReference;
    putReleaseChannel(value: ContainerClusterReleaseChannel): void;
    resetReleaseChannel(): void;
    get releaseChannelInput(): ContainerClusterReleaseChannel | undefined;
    private _resourceUsageExportConfig;
    get resourceUsageExportConfig(): ContainerClusterResourceUsageExportConfigOutputReference;
    putResourceUsageExportConfig(value: ContainerClusterResourceUsageExportConfig): void;
    resetResourceUsageExportConfig(): void;
    get resourceUsageExportConfigInput(): ContainerClusterResourceUsageExportConfig | undefined;
    private _timeouts;
    get timeouts(): ContainerClusterTimeoutsOutputReference;
    putTimeouts(value: ContainerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerClusterTimeouts | undefined;
    private _verticalPodAutoscaling;
    get verticalPodAutoscaling(): ContainerClusterVerticalPodAutoscalingOutputReference;
    putVerticalPodAutoscaling(value: ContainerClusterVerticalPodAutoscaling): void;
    resetVerticalPodAutoscaling(): void;
    get verticalPodAutoscalingInput(): ContainerClusterVerticalPodAutoscaling | undefined;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): ContainerClusterWorkloadIdentityConfigOutputReference;
    putWorkloadIdentityConfig(value: ContainerClusterWorkloadIdentityConfig): void;
    resetWorkloadIdentityConfig(): void;
    get workloadIdentityConfigInput(): ContainerClusterWorkloadIdentityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
