import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Group to get memberships from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships#group DataGoogleCloudIdentityGroupMemberships#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships#id DataGoogleCloudIdentityGroupMemberships#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey {
}
export declare function dataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKeyToTerraform(struct?: DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey): any;
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey | undefined);
    get id(): string;
    get namespace(): string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKeyOutputReference;
}
export interface DataGoogleCloudIdentityGroupMembershipsMembershipsRoles {
}
export declare function dataGoogleCloudIdentityGroupMembershipsMembershipsRolesToTerraform(struct?: DataGoogleCloudIdentityGroupMembershipsMembershipsRoles): any;
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupMembershipsMembershipsRoles | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupMembershipsMembershipsRoles | undefined);
    get name(): string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupMembershipsMembershipsRolesOutputReference;
}
export interface DataGoogleCloudIdentityGroupMembershipsMemberships {
}
export declare function dataGoogleCloudIdentityGroupMembershipsMembershipsToTerraform(struct?: DataGoogleCloudIdentityGroupMembershipsMemberships): any;
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupMembershipsMemberships | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupMembershipsMemberships | undefined);
    get createTime(): string;
    get group(): string;
    get name(): string;
    private _preferredMemberKey;
    get preferredMemberKey(): DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKeyList;
    private _roles;
    get roles(): DataGoogleCloudIdentityGroupMembershipsMembershipsRolesList;
    get type(): string;
    get updateTime(): string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupMembershipsMembershipsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships google_cloud_identity_group_memberships}
*/
export declare class DataGoogleCloudIdentityGroupMemberships extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_identity_group_memberships";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships google_cloud_identity_group_memberships} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudIdentityGroupMembershipsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupMembershipsConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberships;
    get memberships(): DataGoogleCloudIdentityGroupMembershipsMembershipsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
