import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#id DataGoogleCloudRunService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#location DataGoogleCloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#name DataGoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service#project DataGoogleCloudRunService#project}
    */
    readonly project?: string;
}
export interface DataGoogleCloudRunServiceMetadata {
}
export declare function dataGoogleCloudRunServiceMetadataToTerraform(struct?: DataGoogleCloudRunServiceMetadata): any;
export declare class DataGoogleCloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceMetadata | undefined;
    set internalValue(value: DataGoogleCloudRunServiceMetadata | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get generation(): number;
    private _labels;
    get labels(): cdktf.StringMap;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceMetadataOutputReference;
}
export interface DataGoogleCloudRunServiceStatusConditions {
}
export declare function dataGoogleCloudRunServiceStatusConditionsToTerraform(struct?: DataGoogleCloudRunServiceStatusConditions): any;
export declare class DataGoogleCloudRunServiceStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceStatusConditions | undefined;
    set internalValue(value: DataGoogleCloudRunServiceStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunServiceStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceStatusConditionsOutputReference;
}
export interface DataGoogleCloudRunServiceStatus {
}
export declare function dataGoogleCloudRunServiceStatusToTerraform(struct?: DataGoogleCloudRunServiceStatus): any;
export declare class DataGoogleCloudRunServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceStatus | undefined;
    set internalValue(value: DataGoogleCloudRunServiceStatus | undefined);
    private _conditions;
    get conditions(): DataGoogleCloudRunServiceStatusConditionsList;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceStatusOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateMetadata {
}
export declare function dataGoogleCloudRunServiceTemplateMetadataToTerraform(struct?: DataGoogleCloudRunServiceTemplateMetadata): any;
export declare class DataGoogleCloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateMetadata | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateMetadata | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get generation(): number;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceTemplateMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateMetadataOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined);
    get key(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined);
    private _secretKeyRef;
    get secretKeyRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnv {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnv): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnv | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnv | undefined);
    get name(): string;
    get value(): string;
    private _valueFrom;
    get valueFrom(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined);
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined);
    private _localObjectReference;
    get localObjectReference(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceList;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined);
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined);
    private _localObjectReference;
    get localObjectReference(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceList;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom | undefined);
    private _configMapRef;
    get configMapRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefList;
    get prefix(): string;
    private _secretRef;
    get secretRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersPorts {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersPortsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersPorts): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersPorts | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersPorts | undefined);
    get containerPort(): number;
    get name(): string;
    get protocol(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersPortsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersResources {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersResourcesToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersResources): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersResources | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersResources | undefined);
    private _limits;
    get limits(): cdktf.StringMap;
    private _requests;
    get requests(): cdktf.StringMap;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts | undefined);
    get mountPath(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainers {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainers): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainers | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainers | undefined);
    get args(): string[];
    get command(): string[];
    private _env;
    get env(): DataGoogleCloudRunServiceTemplateSpecContainersEnvList;
    private _envFrom;
    get envFrom(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromList;
    get image(): string;
    private _ports;
    get ports(): DataGoogleCloudRunServiceTemplateSpecContainersPortsList;
    private _resources;
    get resources(): DataGoogleCloudRunServiceTemplateSpecContainersResourcesList;
    private _volumeMounts;
    get volumeMounts(): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsList;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems | undefined);
    get key(): string;
    get mode(): number;
    get path(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesSecret {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecret): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesSecret | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesSecret | undefined);
    get defaultMode(): number;
    private _items;
    get items(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsList;
    get secretName(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumes {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumes): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumes | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumes | undefined);
    get name(): string;
    private _secret;
    get secret(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpec {
}
export declare function dataGoogleCloudRunServiceTemplateSpecToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpec): any;
export declare class DataGoogleCloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpec | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpec | undefined);
    get containerConcurrency(): number;
    private _containers;
    get containers(): DataGoogleCloudRunServiceTemplateSpecContainersList;
    get serviceAccountName(): string;
    get servingState(): string;
    get timeoutSeconds(): number;
    private _volumes;
    get volumes(): DataGoogleCloudRunServiceTemplateSpecVolumesList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecOutputReference;
}
export interface DataGoogleCloudRunServiceTemplate {
}
export declare function dataGoogleCloudRunServiceTemplateToTerraform(struct?: DataGoogleCloudRunServiceTemplate): any;
export declare class DataGoogleCloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplate | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplate | undefined);
    private _metadata;
    get metadata(): DataGoogleCloudRunServiceTemplateMetadataList;
    private _spec;
    get spec(): DataGoogleCloudRunServiceTemplateSpecList;
}
export declare class DataGoogleCloudRunServiceTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateOutputReference;
}
export interface DataGoogleCloudRunServiceTraffic {
}
export declare function dataGoogleCloudRunServiceTrafficToTerraform(struct?: DataGoogleCloudRunServiceTraffic): any;
export declare class DataGoogleCloudRunServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTraffic | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTraffic | undefined);
    get latestRevision(): cdktf.IResolvable;
    get percent(): number;
    get revisionName(): string;
    get tag(): string;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTrafficOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service google_cloud_run_service}
*/
export declare class DataGoogleCloudRunService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_run_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service google_cloud_run_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunServiceConfig);
    get autogenerateRevisionName(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metadata;
    get metadata(): DataGoogleCloudRunServiceMetadataList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): DataGoogleCloudRunServiceStatusList;
    private _template;
    get template(): DataGoogleCloudRunServiceTemplateList;
    private _traffic;
    get traffic(): DataGoogleCloudRunServiceTrafficList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
