import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image#family DataGoogleComputeImage#family}
    */
    readonly family?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image#filter DataGoogleComputeImage#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image#id DataGoogleComputeImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image#name DataGoogleComputeImage#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image#project DataGoogleComputeImage#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_image google_compute_image}
*/
export declare class DataGoogleComputeImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_image google_compute_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeImageConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeImageConfig);
    get archiveSizeBytes(): number;
    get creationTimestamp(): string;
    get description(): string;
    get diskSizeGb(): number;
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageEncryptionKeySha256(): string;
    get imageId(): string;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get licenses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get sourceDisk(): string;
    get sourceDiskEncryptionKeySha256(): string;
    get sourceDiskId(): string;
    get sourceImageId(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
