import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext#crypto_key DataGoogleKmsSecretCiphertext#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext#id DataGoogleKmsSecretCiphertext#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext#plaintext DataGoogleKmsSecretCiphertext#plaintext}
    */
    readonly plaintext: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext google_kms_secret_ciphertext}
*/
export declare class DataGoogleKmsSecretCiphertext extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_secret_ciphertext";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext google_kms_secret_ciphertext} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsSecretCiphertextConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretCiphertextConfig);
    get ciphertext(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
