import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization#domain DataGoogleOrganization#domain}
    */
    readonly domain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization#id DataGoogleOrganization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization#organization DataGoogleOrganization#organization}
    */
    readonly organization?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/organization google_organization}
*/
export declare class DataGoogleOrganization extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_organization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/organization google_organization} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleOrganizationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleOrganizationConfig);
    get createTime(): string;
    get directoryCustomerId(): string;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    get name(): string;
    get orgId(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
