import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleRedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#id DataGoogleRedisInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#name DataGoogleRedisInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#project DataGoogleRedisInstance#project}
    */
    readonly project?: string;
    /**
    * The name of the Redis region of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance#region DataGoogleRedisInstance#region}
    */
    readonly region?: string;
}
export interface DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime {
}
export declare function dataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeToTerraform(struct?: DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): any;
export declare class DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
    set internalValue(value: DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined);
    get hours(): number;
    get minutes(): number;
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference;
}
export interface DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow {
}
export declare function dataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowToTerraform(struct?: DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow): any;
export declare class DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | undefined);
    get day(): string;
    get duration(): string;
    private _startTime;
    get startTime(): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeList;
}
export declare class DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference;
}
export interface DataGoogleRedisInstanceMaintenancePolicy {
}
export declare function dataGoogleRedisInstanceMaintenancePolicyToTerraform(struct?: DataGoogleRedisInstanceMaintenancePolicy): any;
export declare class DataGoogleRedisInstanceMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceMaintenancePolicy | undefined;
    set internalValue(value: DataGoogleRedisInstanceMaintenancePolicy | undefined);
    get createTime(): string;
    get description(): string;
    get updateTime(): string;
    private _weeklyMaintenanceWindow;
    get weeklyMaintenanceWindow(): DataGoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowList;
}
export declare class DataGoogleRedisInstanceMaintenancePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceMaintenancePolicyOutputReference;
}
export interface DataGoogleRedisInstanceMaintenanceSchedule {
}
export declare function dataGoogleRedisInstanceMaintenanceScheduleToTerraform(struct?: DataGoogleRedisInstanceMaintenanceSchedule): any;
export declare class DataGoogleRedisInstanceMaintenanceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceMaintenanceSchedule | undefined;
    set internalValue(value: DataGoogleRedisInstanceMaintenanceSchedule | undefined);
    get endTime(): string;
    get scheduleDeadlineTime(): string;
    get startTime(): string;
}
export declare class DataGoogleRedisInstanceMaintenanceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceMaintenanceScheduleOutputReference;
}
export interface DataGoogleRedisInstanceNodes {
}
export declare function dataGoogleRedisInstanceNodesToTerraform(struct?: DataGoogleRedisInstanceNodes): any;
export declare class DataGoogleRedisInstanceNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceNodes | undefined;
    set internalValue(value: DataGoogleRedisInstanceNodes | undefined);
    get id(): string;
    get zone(): string;
}
export declare class DataGoogleRedisInstanceNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceNodesOutputReference;
}
export interface DataGoogleRedisInstanceServerCaCerts {
}
export declare function dataGoogleRedisInstanceServerCaCertsToTerraform(struct?: DataGoogleRedisInstanceServerCaCerts): any;
export declare class DataGoogleRedisInstanceServerCaCertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleRedisInstanceServerCaCerts | undefined;
    set internalValue(value: DataGoogleRedisInstanceServerCaCerts | undefined);
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleRedisInstanceServerCaCertsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleRedisInstanceServerCaCertsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance}
*/
export declare class DataGoogleRedisInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_redis_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/redis_instance google_redis_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleRedisInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleRedisInstanceConfig);
    get alternativeLocationId(): string;
    get authEnabled(): cdktf.IResolvable;
    get authString(): string;
    get authorizedNetwork(): string;
    get connectMode(): string;
    get createTime(): string;
    get currentLocationId(): string;
    get customerManagedKey(): string;
    get displayName(): string;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    get locationId(): string;
    private _maintenancePolicy;
    get maintenancePolicy(): DataGoogleRedisInstanceMaintenancePolicyList;
    private _maintenanceSchedule;
    get maintenanceSchedule(): DataGoogleRedisInstanceMaintenanceScheduleList;
    get memorySizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodes;
    get nodes(): DataGoogleRedisInstanceNodesList;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get readEndpoint(): string;
    get readEndpointPort(): number;
    get readReplicasMode(): string;
    private _redisConfigs;
    get redisConfigs(): cdktf.StringMap;
    get redisVersion(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get replicaCount(): number;
    get reservedIpRange(): string;
    get secondaryIpRange(): string;
    private _serverCaCerts;
    get serverCaCerts(): DataGoogleRedisInstanceServerCaCertsList;
    get tier(): string;
    get transitEncryptionMode(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
