import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocMetastoreServiceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#id DataprocMetastoreServiceIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#location DataprocMetastoreServiceIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#members DataprocMetastoreServiceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#project DataprocMetastoreServiceIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#role DataprocMetastoreServiceIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#service_id DataprocMetastoreServiceIamBinding#service_id}
    */
    readonly serviceId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#condition DataprocMetastoreServiceIamBinding#condition}
    */
    readonly condition?: DataprocMetastoreServiceIamBindingCondition;
}
export interface DataprocMetastoreServiceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#description DataprocMetastoreServiceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#expression DataprocMetastoreServiceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding#title DataprocMetastoreServiceIamBinding#title}
    */
    readonly title: string;
}
export declare function dataprocMetastoreServiceIamBindingConditionToTerraform(struct?: DataprocMetastoreServiceIamBindingConditionOutputReference | DataprocMetastoreServiceIamBindingCondition): any;
export declare class DataprocMetastoreServiceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceIamBindingCondition | undefined;
    set internalValue(value: DataprocMetastoreServiceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding google_dataproc_metastore_service_iam_binding}
*/
export declare class DataprocMetastoreServiceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_metastore_service_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service_iam_binding google_dataproc_metastore_service_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocMetastoreServiceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: DataprocMetastoreServiceIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _condition;
    get condition(): DataprocMetastoreServiceIamBindingConditionOutputReference;
    putCondition(value: DataprocMetastoreServiceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): DataprocMetastoreServiceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
