import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeploymentManagerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set the policy to use for creating new resources. Only used on
  create and update. Valid values are 'CREATE_OR_ACQUIRE' (default) or
  'ACQUIRE'. If set to 'ACQUIRE' and resources do not already exist,
  the deployment will fail. Note that updating this field does not
  actually affect the deployment, just how it is updated. Default value: "CREATE_OR_ACQUIRE" Possible values: ["ACQUIRE", "CREATE_OR_ACQUIRE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create_policy DeploymentManagerDeployment#create_policy}
    */
    readonly createPolicy?: string;
    /**
    * Set the policy to use for deleting new resources on update/delete.
  Valid values are 'DELETE' (default) or 'ABANDON'. If 'DELETE',
  resource is deleted after removal from Deployment Manager. If
  'ABANDON', the resource is only removed from Deployment Manager
  and is not actually deleted. Note that updating this field does not
  actually change the deployment, just how it is updated. Default value: "DELETE" Possible values: ["ABANDON", "DELETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete_policy DeploymentManagerDeployment#delete_policy}
    */
    readonly deletePolicy?: string;
    /**
    * Optional user-provided description of deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#description DeploymentManagerDeployment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#id DeploymentManagerDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for the deployment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
    */
    readonly name: string;
    /**
    * If set to true, a deployment is created with "shell" resources
  that are not actually instantiated. This allows you to preview a
  deployment. It can be updated to false to actually deploy
  with real resources.
   ~>**NOTE:** Deployment Manager does not allow update
  of a deployment in preview (unless updating to preview=false). Thus,
  Terraform will force-recreate deployments if either preview is updated
  to true or if other fields are updated while preview is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#preview DeploymentManagerDeployment#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#project DeploymentManagerDeployment#project}
    */
    readonly project?: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#labels DeploymentManagerDeployment#labels}
    */
    readonly labels?: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    /**
    * target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#target DeploymentManagerDeployment#target}
    */
    readonly target: DeploymentManagerDeploymentTarget;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#timeouts DeploymentManagerDeployment#timeouts}
    */
    readonly timeouts?: DeploymentManagerDeploymentTimeouts;
}
export interface DeploymentManagerDeploymentLabels {
    /**
    * Key for label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#key DeploymentManagerDeployment#key}
    */
    readonly key?: string;
    /**
    * Value of label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#value DeploymentManagerDeployment#value}
    */
    readonly value?: string;
}
export declare function deploymentManagerDeploymentLabelsToTerraform(struct?: DeploymentManagerDeploymentLabels | cdktf.IResolvable): any;
export declare class DeploymentManagerDeploymentLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DeploymentManagerDeploymentLabels | cdktf.IResolvable | undefined;
    set internalValue(value: DeploymentManagerDeploymentLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DeploymentManagerDeploymentLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DeploymentManagerDeploymentLabelsOutputReference;
}
export interface DeploymentManagerDeploymentTargetConfig {
    /**
    * The full YAML contents of your configuration file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
    */
    readonly content: string;
}
export declare function deploymentManagerDeploymentTargetConfigToTerraform(struct?: DeploymentManagerDeploymentTargetConfigOutputReference | DeploymentManagerDeploymentTargetConfig): any;
export declare class DeploymentManagerDeploymentTargetConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DeploymentManagerDeploymentTargetConfig | undefined;
    set internalValue(value: DeploymentManagerDeploymentTargetConfig | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
}
export interface DeploymentManagerDeploymentTargetImports {
    /**
    * The full contents of the template that you want to import.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
    */
    readonly content?: string;
    /**
    * The name of the template to import, as declared in the YAML
  configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
    */
    readonly name?: string;
}
export declare function deploymentManagerDeploymentTargetImportsToTerraform(struct?: DeploymentManagerDeploymentTargetImports | cdktf.IResolvable): any;
export declare class DeploymentManagerDeploymentTargetImportsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DeploymentManagerDeploymentTargetImports | cdktf.IResolvable | undefined;
    set internalValue(value: DeploymentManagerDeploymentTargetImports | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class DeploymentManagerDeploymentTargetImportsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DeploymentManagerDeploymentTargetImportsOutputReference;
}
export interface DeploymentManagerDeploymentTarget {
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#config DeploymentManagerDeployment#config}
    */
    readonly config: DeploymentManagerDeploymentTargetConfig;
    /**
    * imports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#imports DeploymentManagerDeployment#imports}
    */
    readonly imports?: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
}
export declare function deploymentManagerDeploymentTargetToTerraform(struct?: DeploymentManagerDeploymentTargetOutputReference | DeploymentManagerDeploymentTarget): any;
export declare class DeploymentManagerDeploymentTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DeploymentManagerDeploymentTarget | undefined;
    set internalValue(value: DeploymentManagerDeploymentTarget | undefined);
    private _config;
    get config(): DeploymentManagerDeploymentTargetConfigOutputReference;
    putConfig(value: DeploymentManagerDeploymentTargetConfig): void;
    get configInput(): DeploymentManagerDeploymentTargetConfig | undefined;
    private _imports;
    get imports(): DeploymentManagerDeploymentTargetImportsList;
    putImports(value: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable): void;
    resetImports(): void;
    get importsInput(): cdktf.IResolvable | DeploymentManagerDeploymentTargetImports[] | undefined;
}
export interface DeploymentManagerDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create DeploymentManagerDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete DeploymentManagerDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#update DeploymentManagerDeployment#update}
    */
    readonly update?: string;
}
export declare function deploymentManagerDeploymentTimeoutsToTerraform(struct?: DeploymentManagerDeploymentTimeoutsOutputReference | DeploymentManagerDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DeploymentManagerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DeploymentManagerDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DeploymentManagerDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment}
*/
export declare class DeploymentManagerDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_deployment_manager_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeploymentManagerDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DeploymentManagerDeploymentConfig);
    private _createPolicy?;
    get createPolicy(): string;
    set createPolicy(value: string);
    resetCreatePolicy(): void;
    get createPolicyInput(): string | undefined;
    private _deletePolicy?;
    get deletePolicy(): string;
    set deletePolicy(value: string);
    resetDeletePolicy(): void;
    get deletePolicyInput(): string | undefined;
    get deploymentId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get manifest(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _labels;
    get labels(): DeploymentManagerDeploymentLabelsList;
    putLabels(value: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | DeploymentManagerDeploymentLabels[] | undefined;
    private _target;
    get target(): DeploymentManagerDeploymentTargetOutputReference;
    putTarget(value: DeploymentManagerDeploymentTarget): void;
    get targetInput(): DeploymentManagerDeploymentTarget | undefined;
    private _timeouts;
    get timeouts(): DeploymentManagerDeploymentTimeoutsOutputReference;
    putTimeouts(value: DeploymentManagerDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DeploymentManagerDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
