import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable description of the environment. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#description DialogflowCxEnvironment#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the environment (unique in an agent). Limit of 64 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#display_name DialogflowCxEnvironment#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#id DialogflowCxEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Agent to create an Environment for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#parent DialogflowCxEnvironment#parent}
    */
    readonly parent?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#timeouts DialogflowCxEnvironment#timeouts}
    */
    readonly timeouts?: DialogflowCxEnvironmentTimeouts;
    /**
    * version_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#version_configs DialogflowCxEnvironment#version_configs}
    */
    readonly versionConfigs: DialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable;
}
export interface DialogflowCxEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#create DialogflowCxEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#delete DialogflowCxEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#update DialogflowCxEnvironment#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxEnvironmentTimeoutsToTerraform(struct?: DialogflowCxEnvironmentTimeoutsOutputReference | DialogflowCxEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxEnvironmentVersionConfigs {
    /**
    * Format: projects/{{project}}/locations/{{location}}/agents/{{agent}}/flows/{{flow}}/versions/{{version}}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment#version DialogflowCxEnvironment#version}
    */
    readonly version: string;
}
export declare function dialogflowCxEnvironmentVersionConfigsToTerraform(struct?: DialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable): any;
export declare class DialogflowCxEnvironmentVersionConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class DialogflowCxEnvironmentVersionConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DialogflowCxEnvironmentVersionConfigsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment google_dialogflow_cx_environment}
*/
export declare class DialogflowCxEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment google_dialogflow_cx_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxEnvironmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): DialogflowCxEnvironmentTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DialogflowCxEnvironmentTimeouts | undefined;
    private _versionConfigs;
    get versionConfigs(): DialogflowCxEnvironmentVersionConfigsList;
    putVersionConfigs(value: DialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable): void;
    get versionConfigsInput(): cdktf.IResolvable | DialogflowCxEnvironmentVersionConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
