import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirebaserulesRulesetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#id FirebaserulesRuleset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#project FirebaserulesRuleset#project}
    */
    readonly project?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#source FirebaserulesRuleset#source}
    */
    readonly source: FirebaserulesRulesetSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#timeouts FirebaserulesRuleset#timeouts}
    */
    readonly timeouts?: FirebaserulesRulesetTimeouts;
}
export interface FirebaserulesRulesetMetadata {
}
export declare function firebaserulesRulesetMetadataToTerraform(struct?: FirebaserulesRulesetMetadata): any;
export declare class FirebaserulesRulesetMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirebaserulesRulesetMetadata | undefined;
    set internalValue(value: FirebaserulesRulesetMetadata | undefined);
    get services(): string[];
}
export declare class FirebaserulesRulesetMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirebaserulesRulesetMetadataOutputReference;
}
export interface FirebaserulesRulesetSourceFiles {
    /**
    * Textual Content.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#content FirebaserulesRuleset#content}
    */
    readonly content: string;
    /**
    * Fingerprint (e.g. github sha) associated with the `File`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#fingerprint FirebaserulesRuleset#fingerprint}
    */
    readonly fingerprint?: string;
    /**
    * File name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#name FirebaserulesRuleset#name}
    */
    readonly name: string;
}
export declare function firebaserulesRulesetSourceFilesToTerraform(struct?: FirebaserulesRulesetSourceFiles | cdktf.IResolvable): any;
export declare class FirebaserulesRulesetSourceFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirebaserulesRulesetSourceFiles | cdktf.IResolvable | undefined;
    set internalValue(value: FirebaserulesRulesetSourceFiles | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _fingerprint?;
    get fingerprint(): string;
    set fingerprint(value: string);
    resetFingerprint(): void;
    get fingerprintInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class FirebaserulesRulesetSourceFilesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirebaserulesRulesetSourceFilesOutputReference;
}
export interface FirebaserulesRulesetSource {
    /**
    * `Language` of the `Source` bundle. If unspecified, the language will default to `FIREBASE_RULES`. Possible values: LANGUAGE_UNSPECIFIED, FIREBASE_RULES, EVENT_FLOW_TRIGGERS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#language FirebaserulesRuleset#language}
    */
    readonly language?: string;
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#files FirebaserulesRuleset#files}
    */
    readonly files: FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
}
export declare function firebaserulesRulesetSourceToTerraform(struct?: FirebaserulesRulesetSourceOutputReference | FirebaserulesRulesetSource): any;
export declare class FirebaserulesRulesetSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirebaserulesRulesetSource | undefined;
    set internalValue(value: FirebaserulesRulesetSource | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _files;
    get files(): FirebaserulesRulesetSourceFilesList;
    putFiles(value: FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable): void;
    get filesInput(): cdktf.IResolvable | FirebaserulesRulesetSourceFiles[] | undefined;
}
export interface FirebaserulesRulesetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#create FirebaserulesRuleset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#delete FirebaserulesRuleset#delete}
    */
    readonly delete?: string;
}
export declare function firebaserulesRulesetTimeoutsToTerraform(struct?: FirebaserulesRulesetTimeoutsOutputReference | FirebaserulesRulesetTimeouts | cdktf.IResolvable): any;
export declare class FirebaserulesRulesetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirebaserulesRulesetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirebaserulesRulesetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset google_firebaserules_ruleset}
*/
export declare class FirebaserulesRuleset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebaserules_ruleset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset google_firebaserules_ruleset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirebaserulesRulesetConfig
    */
    constructor(scope: Construct, id: string, config: FirebaserulesRulesetConfig);
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): FirebaserulesRulesetMetadataList;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _source;
    get source(): FirebaserulesRulesetSourceOutputReference;
    putSource(value: FirebaserulesRulesetSource): void;
    get sourceInput(): FirebaserulesRulesetSource | undefined;
    private _timeouts;
    get timeouts(): FirebaserulesRulesetTimeoutsOutputReference;
    putTimeouts(value: FirebaserulesRulesetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirebaserulesRulesetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
