import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IamWorkloadIdentityPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the pool. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#description IamWorkloadIdentityPool#description}
    */
    readonly description?: string;
    /**
    * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
  existing tokens to access resources. If the pool is re-enabled, existing tokens grant
  access again.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#disabled IamWorkloadIdentityPool#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A display name for the pool. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#display_name IamWorkloadIdentityPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#id IamWorkloadIdentityPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#project IamWorkloadIdentityPool#project}
    */
    readonly project?: string;
    /**
    * The ID to use for the pool, which becomes the final component of the resource name. This
  value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
  'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#workload_identity_pool_id IamWorkloadIdentityPool#workload_identity_pool_id}
    */
    readonly workloadIdentityPoolId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#timeouts IamWorkloadIdentityPool#timeouts}
    */
    readonly timeouts?: IamWorkloadIdentityPoolTimeouts;
}
export interface IamWorkloadIdentityPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#create IamWorkloadIdentityPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#delete IamWorkloadIdentityPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool#update IamWorkloadIdentityPool#update}
    */
    readonly update?: string;
}
export declare function iamWorkloadIdentityPoolTimeoutsToTerraform(struct?: IamWorkloadIdentityPoolTimeoutsOutputReference | IamWorkloadIdentityPoolTimeouts | cdktf.IResolvable): any;
export declare class IamWorkloadIdentityPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkloadIdentityPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IamWorkloadIdentityPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool google_iam_workload_identity_pool}
*/
export declare class IamWorkloadIdentityPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workload_identity_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool google_iam_workload_identity_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamWorkloadIdentityPoolConfig
    */
    constructor(scope: Construct, id: string, config: IamWorkloadIdentityPoolConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _workloadIdentityPoolId?;
    get workloadIdentityPoolId(): string;
    set workloadIdentityPoolId(value: string);
    get workloadIdentityPoolIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): IamWorkloadIdentityPoolTimeoutsOutputReference;
    putTimeouts(value: IamWorkloadIdentityPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IamWorkloadIdentityPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
