import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringMonitoredProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#id MonitoringMonitoredProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Required. The resource name of the existing Metrics Scope that will monitor this project. Example: locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#metrics_scope MonitoringMonitoredProject#metrics_scope}
    */
    readonly metricsScope: string;
    /**
    * Immutable. The resource name of the `MonitoredProject`. On input, the resource name includes the scoping project ID and monitored project ID. On output, it contains the equivalent project numbers. Example: `locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}/projects/{MONITORED_PROJECT_ID_OR_NUMBER}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#name MonitoringMonitoredProject#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#timeouts MonitoringMonitoredProject#timeouts}
    */
    readonly timeouts?: MonitoringMonitoredProjectTimeouts;
}
export interface MonitoringMonitoredProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#create MonitoringMonitoredProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project#delete MonitoringMonitoredProject#delete}
    */
    readonly delete?: string;
}
export declare function monitoringMonitoredProjectTimeoutsToTerraform(struct?: MonitoringMonitoredProjectTimeoutsOutputReference | MonitoringMonitoredProjectTimeouts | cdktf.IResolvable): any;
export declare class MonitoringMonitoredProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringMonitoredProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitoringMonitoredProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project google_monitoring_monitored_project}
*/
export declare class MonitoringMonitoredProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_monitored_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_monitored_project google_monitoring_monitored_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringMonitoredProjectConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringMonitoredProjectConfig);
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metricsScope?;
    get metricsScope(): string;
    set metricsScope(value: string);
    get metricsScopeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): MonitoringMonitoredProjectTimeoutsOutputReference;
    putTimeouts(value: MonitoringMonitoredProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitoringMonitoredProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
